/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.rename.AbstractRenameRefactoringTest;
import org.eclipse.php.refactoring.core.rename.RenameClassMemberProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameClassMemberProcessorTest3
extends AbstractRenameRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1");
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file = folder.getFile("test23.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php class Item { public $title;} class ItemEx extends Item{public $title;} $a=new ItemEx(); $a->title;?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Test
    public void testRename1() throws Exception {
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 102;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        RenameClassMemberProcessor processor = new RenameClassMemberProcessor(this.file, selectedNode);
        processor.setNewElementName("title1");
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        try {
            String content = FileUtils.getContents(this.file);
            Assert.assertEquals((Object)"<?php class Item { public $title1;} class ItemEx extends Item{public $title1;} $a=new ItemEx(); $a->title1;?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

