/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.refactoring.core.rename.AbstractRenameRefactoringTest;
import org.eclipse.php.refactoring.core.rename.RenameFolderProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameFolderTestCase1
extends AbstractRenameRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1");
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file = folder.getFile("RenameFolderTest1.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php class TestRenameClass{}?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file = this.project1.getFile("RenameFolderTest2.php");
        source = new ByteArrayInputStream("<?php include 'src/RenameFolderTest1.php'; ?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Test
    public void testRename() {
        RenameFolderProcessor processor = new RenameFolderProcessor((IContainer)this.project1.getFolder("src"));
        processor.setNewElementName("src1");
        processor.setUpdateRefernces(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        IFolder folder = this.project1.getFolder("src1");
        Assert.assertTrue((boolean)folder.exists());
        try {
            String content = FileUtils.getContents(this.file);
            Assert.assertEquals((Object)"<?php include 'src1/RenameFolderTest1.php'; ?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

