/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.manager;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesReader;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesWriter;
import org.eclipse.php.internal.server.core.Activator;
import org.eclipse.php.internal.server.core.Logger;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.IServersManagerListener;
import org.eclipse.php.internal.server.core.manager.Messages;
import org.eclipse.php.internal.server.core.manager.ServerManagerEvent;
import org.osgi.service.prefs.BackingStoreException;

public class ServersManager
implements PropertyChangeListener,
IAdaptable {
    public static final String SERVERS_PREFERENCES_KEY = "phpServers";
    public static final String DEFAULT_SERVER_PREFERENCES_KEY = "defaultPHPServer";
    private Map<IProject, Server> defaultServersMap = new HashMap<IProject, Server>();
    private HashMap<String, Server> servers = new HashMap();
    private List<IServersManagerListener> listeners = new ArrayList<IServersManagerListener>();
    private static ServersManager instance;
    private static final String NODE_QUALIFIER = "org.eclipse.php.server.core.phpServersPrefs";
    private static final String BASE_URL = "http://localhost";
    public static final String Default_Server_Name = "Default PHP Web Server";

    public static ServersManager getInstance() {
        if (instance == null) {
            instance = new ServersManager();
        }
        return instance;
    }

    private ServersManager() {
        this.loadServers();
    }

    public static void addManagerListener(IServersManagerListener listener) {
        List<IServersManagerListener> listeners = ServersManager.getInstance().listeners;
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeManagerListener(IServersManagerListener listener) {
        ServersManager.getInstance().listeners.remove(listener);
    }

    public static void addServer(Server server) {
        ServerManagerEvent event;
        if (server == null) {
            return;
        }
        ServersManager manager = ServersManager.getInstance();
        Server oldValue = ServersManager.getServer(server);
        if (server != oldValue) {
            manager.servers.remove(oldValue.getName());
            oldValue.removePropertyChangeListener(manager);
            event = new ServerManagerEvent(2, oldValue);
            manager.fireEvent(event);
        }
        if ((oldValue = manager.servers.put(server.getName(), server)) != null) {
            oldValue.removePropertyChangeListener(manager);
            event = new ServerManagerEvent(2, oldValue);
            manager.fireEvent(event);
        }
        event = new ServerManagerEvent(0, server);
        manager.fireEvent(event);
        server.addPropertyChangeListener(manager);
    }

    public static Server removeServer(String serverName) {
        Object[] keys;
        Server[] servers;
        ServersManager manager = ServersManager.getInstance();
        Server removedServer = manager.servers.remove(serverName);
        Server workspaceDefault = ServersManager.getDefaultServer(null);
        if (removedServer == null) {
            return null;
        }
        if (workspaceDefault == removedServer && (servers = ServersManager.getServers()).length > 0) {
            workspaceDefault = servers[0];
            ServersManager.setDefaultServer(null, workspaceDefault);
        }
        Object[] objectArray = keys = manager.defaultServersMap.keySet().toArray();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (removedServer == manager.defaultServersMap.get(element)) {
                ServersManager.setDefaultServer((IProject)element, workspaceDefault);
            }
            ++n2;
        }
        removedServer.removePropertyChangeListener(manager);
        ServerManagerEvent event = new ServerManagerEvent(2, removedServer);
        manager.fireEvent(event);
        return removedServer;
    }

    public static Server getServer(String serverName) {
        ServersManager manager = ServersManager.getInstance();
        return manager.servers.get(serverName);
    }

    public static Server getServer(Server oldServer) {
        ServersManager manager = ServersManager.getInstance();
        for (Server server : manager.servers.values()) {
            if (!server.getBaseURL().equals(oldServer.getBaseURL())) continue;
            return server;
        }
        return oldServer;
    }

    public static Server findServer(String serverId) {
        ServersManager manager = ServersManager.getInstance();
        for (Server server : manager.servers.values()) {
            if (!server.getUniqueId().equals(serverId)) continue;
            return server;
        }
        return null;
    }

    public static Server findServer(URL url, boolean perfectMatch) {
        String urlHostAddress = url.getHost();
        try {
            InetAddress urlHostInetAddress = InetAddress.getByName(urlHostAddress);
            urlHostAddress = urlHostInetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
        Server[] serverArray = ServersManager.getServers();
        int n = serverArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                URL serverURL;
                Server server = serverArray[n2];
                try {
                    serverURL = new URL(server.getBaseURL());
                }
                catch (MalformedURLException malformedURLException) {
                    break block10;
                }
                String serverHost = serverURL.getHost();
                try {
                    InetAddress serverHostAddress = InetAddress.getByName(serverHost);
                    if (urlHostAddress.equals(serverHostAddress.getHostAddress())) {
                        if (!perfectMatch) {
                            return server;
                        }
                        if (url.getPort() == serverURL.getPort() && url.getProtocol().equals(serverURL.getProtocol())) {
                            return server;
                        }
                    }
                }
                catch (UnknownHostException unknownHostException) {}
            }
            ++n2;
        }
        return null;
    }

    public static Server[] getServers() {
        ServersManager manager = ServersManager.getInstance();
        Collection<Server> values = manager.servers.values();
        Server[] servers = new Server[values.size()];
        values.toArray(servers);
        return servers;
    }

    public static Server getDefaultServer(IProject project) {
        IScopeContext[] preferenceScopes;
        String projectSpecificServer;
        ServersManager manager = ServersManager.getInstance();
        Server server = manager.defaultServersMap.get(project);
        if (project != null && (projectSpecificServer = (preferenceScopes = ServersManager.createPreferenceScopes(project))[0].getNode(NODE_QUALIFIER).get(DEFAULT_SERVER_PREFERENCES_KEY, null)) == null) {
            manager.defaultServersMap.put(project, manager.defaultServersMap.get(null));
            server = manager.defaultServersMap.get(null);
        }
        if (server == null) {
            String serverName = null;
            if (project == null) {
                Preferences prefs = Activator.getDefault().getPluginPreferences();
                serverName = prefs.getString(DEFAULT_SERVER_PREFERENCES_KEY);
            } else {
                IScopeContext[] preferenceScopes2 = ServersManager.createPreferenceScopes(project);
                serverName = preferenceScopes2[0].getNode(NODE_QUALIFIER).get(DEFAULT_SERVER_PREFERENCES_KEY, null);
                if (serverName == null) {
                    Preferences prefs = Activator.getDefault().getPluginPreferences();
                    serverName = prefs.getString(DEFAULT_SERVER_PREFERENCES_KEY);
                }
            }
            if (serverName != null && !"".equals(serverName)) {
                server = manager.servers.get(serverName);
                manager.defaultServersMap.put(project, server);
            } else {
                try {
                    server = ServersManager.createServer(Default_Server_Name, BASE_URL);
                }
                catch (MalformedURLException malformedURLException) {}
                manager.defaultServersMap.put(null, server);
                manager.defaultServersMap.put(project, server);
                manager.innerSaveDefaultServer(project, server);
                ServersManager.save();
            }
        }
        if (server == null && manager.servers.size() > 0) {
            server = manager.servers.values().iterator().next();
            ServersManager.setDefaultServer(null, server);
        }
        return server;
    }

    public static void setDefaultServer(IProject project, Server server) {
        ServersManager manager = ServersManager.getInstance();
        Server defaultProjectServer = manager.defaultServersMap.get(project);
        if (server != defaultProjectServer) {
            manager.defaultServersMap.put(project, server);
            manager.innerSaveDefaultServer(project, server);
        }
    }

    public static void setDefaultServer(IProject project, String serverName) {
        ServersManager manager = ServersManager.getInstance();
        Server server = manager.servers.get(serverName);
        ServersManager.setDefaultServer(project, server);
    }

    public static Server createServer(String name, String baseURL) throws MalformedURLException {
        Server server = new Server(name, "localhost", baseURL, "");
        server = ServersManager.getServer(server);
        ServersManager.addServer(server);
        return server;
    }

    public static void save() {
        Server[] servers = ServersManager.getServers();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.php.server.core");
        XMLPreferencesWriter.write((IEclipsePreferences)preferences, (String)SERVERS_PREFERENCES_KEY, Arrays.asList(servers));
    }

    public static final Server getLocalServer(IProject project) {
        Server[] serverArray = ServersManager.getServers();
        int n = serverArray.length;
        int n2 = 0;
        while (n2 < n) {
            Server server = serverArray[n2];
            String documentRoot = server.getDocumentRoot();
            if (documentRoot != null && documentRoot.length() > 0) {
                Path path = new Path(documentRoot);
                IPath fullPath = project.getLocation();
                if (fullPath != null && path.isPrefixOf(fullPath)) {
                    return server;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Server server = (Server)evt.getSource();
        String oldValue = (String)evt.getOldValue();
        String newValue = (String)evt.getNewValue();
        if (evt.getPropertyName().equals("name")) {
            ServersManager.getInstance().servers.remove(oldValue);
            ServersManager.getInstance().servers.put(newValue, server);
        }
        ServerManagerEvent event = new ServerManagerEvent(4, server, evt.getPropertyName(), oldValue, newValue);
        this.fireEvent(event);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void fireEvent(ServerManagerEvent event) {
        IServersManagerListener[] allListeners = new IServersManagerListener[this.listeners.size()];
        this.listeners.toArray(allListeners);
        if (event.getType() == 0) {
            this.fireAddEvent(event, allListeners);
        } else if (event.getType() == 2) {
            this.fireRemoveEvent(event, allListeners);
        } else if (event.getType() == 4) {
            this.fireModifiedEvent(event, allListeners);
        }
    }

    private static IScopeContext[] createPreferenceScopes(IProject project) {
        if (project != null) {
            return new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        }
        return new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    }

    private void innerSaveDefaultServer(IProject project, Server server) {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        if (project == null && server != null) {
            prefs.setValue(DEFAULT_SERVER_PREFERENCES_KEY, server.getName());
            Activator.getDefault().savePluginPreferences();
        } else if (project != null) {
            String defaultWorkspaceServer = prefs.getString(DEFAULT_SERVER_PREFERENCES_KEY);
            IScopeContext[] scopeContexts = ServersManager.createPreferenceScopes(project);
            IEclipsePreferences prefsNode = scopeContexts[0].getNode(NODE_QUALIFIER);
            if (server != null && !defaultWorkspaceServer.equals(server.getName())) {
                prefsNode.put(DEFAULT_SERVER_PREFERENCES_KEY, server.getName());
            } else {
                prefsNode.remove(DEFAULT_SERVER_PREFERENCES_KEY);
            }
            try {
                prefsNode.flush();
            }
            catch (BackingStoreException e) {
                Logger.logException(e);
            }
        }
    }

    private void loadServers() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.php.server.core");
        List serversConfigs = XMLPreferencesReader.read((IEclipsePreferences)preferences, (String)SERVERS_PREFERENCES_KEY, (boolean)true);
        ServersUpgrade upgrader = new ServersUpgrade();
        for (Map serverMap : serversConfigs) {
            Server server = new Server();
            server.restoreFromMap(serverMap);
            String serverName = server.getName();
            this.servers.put(serverName, server);
            server.addPropertyChangeListener(this);
            upgrader.check(serverMap);
        }
        upgrader.perform();
    }

    private void fireAddEvent(ServerManagerEvent event, IServersManagerListener[] allListeners) {
        IServersManagerListener[] iServersManagerListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IServersManagerListener element = iServersManagerListenerArray[n2];
            element.serverAdded(event);
            ++n2;
        }
    }

    private void fireRemoveEvent(ServerManagerEvent event, IServersManagerListener[] allListeners) {
        IServersManagerListener[] iServersManagerListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IServersManagerListener element = iServersManagerListenerArray[n2];
            element.serverRemoved(event);
            ++n2;
        }
    }

    private void fireModifiedEvent(ServerManagerEvent event, IServersManagerListener[] allListeners) {
        IServersManagerListener[] iServersManagerListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IServersManagerListener element = iServersManagerListenerArray[n2];
            element.serverModified(event);
            ++n2;
        }
    }

    private class ServersUpgrade
    extends Job {
        private boolean upgraded;

        private ServersUpgrade() {
            super(Messages.ServersManager_Upgrading_server_configurations);
            this.upgraded = true;
        }

        void check(Map<String, Object> serverMap) {
            Map attributes = (Map)serverMap.get("server");
            if (!attributes.containsKey("id")) {
                this.upgraded = false;
            }
        }

        void perform() {
            if (!this.upgraded) {
                this.schedule();
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.ServersManager_Saving_upgraded_configurations, -1);
            ServersManager.save();
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

