/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php5;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import java_cup.sym;
import org.eclipse.php.internal.core.ast.nodes.AST;
import java_cup.runtime.Symbol;
import org.eclipse.php.internal.core.ast.scanner.StateStack;
import org.eclipse.php.internal.core.PHPVersion;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>ast_scanner.flex</tt>
 */
public class PhpAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SCRIPTING = 2;
  public static final int ST_DOUBLE_QUOTES = 4;
  public static final int ST_SINGLE_QUOTE = 6;
  public static final int ST_BACKQUOTE = 8;
  public static final int ST_HEREDOC = 10;
  public static final int ST_START_HEREDOC = 12;
  public static final int ST_END_HEREDOC = 14;
  public static final int ST_LOOKING_FOR_PROPERTY = 16;
  public static final int ST_LOOKING_FOR_VARNAME = 18;
  public static final int ST_VAR_OFFSET = 20;
  public static final int ST_COMMENT = 22;
  public static final int ST_DOCBLOCK = 24;
  public static final int ST_ONE_LINE_COMMENT = 26;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\13\2\0\1\11\22\0\1\12\1\57\1\15\1\100"+
    "\1\14\1\63\1\64\1\77\1\50\1\52\1\61\1\4\1\67\1\44"+
    "\1\2\1\62\1\5\11\1\1\46\1\21\1\60\1\56\1\45\1\73"+
    "\1\74\1\35\1\7\1\30\1\24\1\3\1\25\1\51\1\36\1\22"+
    "\1\53\1\41\1\40\1\43\1\27\1\31\1\42\1\55\1\33\1\32"+
    "\1\23\1\26\1\47\1\37\1\6\1\34\1\10\1\70\1\16\1\71"+
    "\1\66\1\54\1\17\1\35\1\7\1\30\1\24\1\3\1\25\1\51"+
    "\1\36\1\22\1\53\1\41\1\40\1\43\1\27\1\31\1\42\1\55"+
    "\1\33\1\76\1\23\1\26\1\47\1\37\1\6\1\34\1\10\1\20"+
    "\1\65\1\75\1\72\261\10\2\22\115\10\1\32\u1faa\10\1\41\uded5\10"+
    "\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\10\0\2\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\4\3\6\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\16\6\1\16\1\17\1\20\1\6\1\21\1\6"+
    "\1\22\1\6\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\1\1\3\1\45\2\3"+
    "\1\46\1\3\1\47\1\1\2\3\1\50\1\3\2\1"+
    "\3\3\2\51\1\52\1\53\1\54\1\53\1\55\1\56"+
    "\1\57\1\5\1\7\1\57\1\60\1\61\1\62\1\63"+
    "\1\16\1\17\1\20\1\21\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\64\1\40\1\65"+
    "\1\10\1\66\3\10\3\67\2\66\1\0\1\70\1\71"+
    "\1\2\1\72\1\0\1\73\6\6\1\74\1\75\1\0"+
    "\2\6\2\0\1\76\2\0\1\77\2\0\1\100\7\6"+
    "\1\101\11\6\1\102\5\6\1\103\5\6\1\104\1\105"+
    "\1\106\1\107\1\110\1\111\1\6\12\0\2\6\1\112"+
    "\1\113\2\114\1\115\1\116\1\0\1\117\1\120\1\121"+
    "\1\122\1\123\1\124\1\125\1\126\1\127\1\130\1\131"+
    "\4\0\1\76\2\132\1\133\1\134\1\132\1\0\1\135"+
    "\3\0\3\136\3\0\1\1\2\132\1\0\1\137\1\0"+
    "\1\140\1\141\1\0\1\142\1\143\1\144\1\145\2\0"+
    "\1\72\1\0\7\6\1\72\1\146\1\6\1\0\5\6"+
    "\1\147\3\6\1\150\2\6\1\151\1\6\1\152\1\153"+
    "\12\6\1\154\6\6\1\155\1\156\12\0\6\6\1\157"+
    "\1\160\1\161\3\0\1\162\1\0\2\122\2\131\1\0"+
    "\1\163\1\164\1\1\1\141\2\0\6\6\1\165\1\166"+
    "\1\6\1\167\21\6\1\170\11\6\1\171\4\6\12\0"+
    "\7\6\2\0\1\172\4\0\1\6\1\173\5\6\1\174"+
    "\1\175\3\6\1\176\1\6\1\177\3\6\1\200\2\6"+
    "\1\201\1\6\1\202\1\203\1\204\1\205\5\6\1\206"+
    "\1\207\1\6\1\210\2\6\4\0\1\211\7\0\7\6"+
    "\2\212\2\0\1\213\2\214\1\0\2\6\1\215\2\6"+
    "\1\216\4\6\1\217\5\6\1\220\1\221\1\222\2\6"+
    "\1\223\2\6\3\0\1\224\5\0\1\225\1\0\1\226"+
    "\6\6\3\0\1\227\5\6\1\230\2\6\1\231\1\232"+
    "\1\6\1\233\1\6\1\234\1\6\1\235\1\6\3\0"+
    "\1\236\1\0\1\237\6\6\3\0\3\6\1\240\4\6"+
    "\1\241\1\242\1\6\1\243\1\6\1\244\1\245\1\246"+
    "\3\6\1\247\1\6\5\0\2\6\1\250\1\251\4\6"+
    "\1\252\1\6\1\253\2\6\3\0\1\254\1\255\1\6"+
    "\1\256\1\257\3\6\1\260\3\0\4\6\4\0\1\261"+
    "\1\262\1\263\1\6\3\0\1\6\1\264\1\0\1\6"+
    "\1\0\1\265\14\0\1\71\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[641];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\101\0\202\0\303\0\u0104\0\u0145\0\u0186\0\u01c7"+
    "\0\u0208\0\u0249\0\u028a\0\u02cb\0\u030c\0\u034d\0\u038e\0\u03cf"+
    "\0\u0410\0\u0451\0\u0492\0\u04d3\0\u0514\0\u0555\0\u0596\0\u05d7"+
    "\0\u0618\0\u0659\0\u069a\0\u06db\0\u0410\0\u0410\0\u0410\0\u071c"+
    "\0\u075d\0\u079e\0\u07df\0\u0820\0\u0861\0\u08a2\0\u08e3\0\u0924"+
    "\0\u0965\0\u09a6\0\u09e7\0\u0a28\0\u0a69\0\u0aaa\0\u0aeb\0\u0b2c"+
    "\0\u0b6d\0\u0bae\0\u0bef\0\u0410\0\u0c30\0\u0c71\0\u0cb2\0\u0cf3"+
    "\0\u0d34\0\u0d75\0\u0db6\0\u0df7\0\u0e38\0\u0e79\0\u0410\0\u0410"+
    "\0\u0410\0\u0410\0\u0eba\0\u0410\0\u0410\0\u0efb\0\u0410\0\u0f3c"+
    "\0\u0f7d\0\u0410\0\u0fbe\0\u0fff\0\u1040\0\u1081\0\u0410\0\u10c2"+
    "\0\u1103\0\u1144\0\u0410\0\u1185\0\u11c6\0\u1207\0\u1248\0\u1289"+
    "\0\u12ca\0\u0410\0\u130b\0\u0410\0\u0410\0\u134c\0\u138d\0\u0410"+
    "\0\u13ce\0\u140f\0\u0410\0\u0410\0\u1450\0\u0410\0\u0410\0\u0410"+
    "\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410"+
    "\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410"+
    "\0\u0410\0\u1491\0\u14d2\0\u0410\0\u1513\0\u1554\0\u1595\0\u15d6"+
    "\0\u0410\0\u0410\0\u1617\0\u1658\0\u1699\0\u16da\0\u171b\0\u175c"+
    "\0\u179d\0\u0410\0\u17de\0\u181f\0\u1860\0\u18a1\0\u18e2\0\u1923"+
    "\0\u0410\0\u0410\0\u1964\0\u19a5\0\u19e6\0\u1a27\0\u0efb\0\u1a68"+
    "\0\u06db\0\u1aa9\0\u0410\0\u1aea\0\u1b2b\0\u0618\0\u1b6c\0\u1bad"+
    "\0\u1bee\0\u1c2f\0\u1c70\0\u1cb1\0\u1cf2\0\u0618\0\u1d33\0\u1d74"+
    "\0\u1db5\0\u1df6\0\u1e37\0\u1e78\0\u1eb9\0\u1efa\0\u1f3b\0\u0618"+
    "\0\u1f7c\0\u1fbd\0\u1ffe\0\u203f\0\u2080\0\u0618\0\u20c1\0\u2102"+
    "\0\u2143\0\u2184\0\u21c5\0\u0410\0\u0410\0\u0410\0\u2206\0\u0410"+
    "\0\u0410\0\u2247\0\u2288\0\u0bae\0\u22c9\0\u230a\0\u234b\0\u238c"+
    "\0\u23cd\0\u240e\0\u244f\0\u2490\0\u24d1\0\u2512\0\u0410\0\u2553"+
    "\0\u2594\0\u0410\0\u0410\0\u25d5\0\u2616\0\u0410\0\u0410\0\u2657"+
    "\0\u2698\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u26d9"+
    "\0\u271a\0\u275b\0\u0fbe\0\u279c\0\u27dd\0\u275b\0\u0410\0\u0410"+
    "\0\u0410\0\u279c\0\u281e\0\u0410\0\u285f\0\u1144\0\u28a0\0\u285f"+
    "\0\u0410\0\u28a0\0\u28e1\0\u1289\0\u2922\0\u2963\0\u28e1\0\u2922"+
    "\0\u130b\0\u0410\0\u29a4\0\u0410\0\u29e5\0\u2a26\0\u0410\0\u0410"+
    "\0\u0410\0\u0410\0\u2a67\0\u2aa8\0\u2ae9\0\u2ae9\0\u2b2a\0\u2b6b"+
    "\0\u2bac\0\u2bed\0\u2c2e\0\u2c6f\0\u2cb0\0\u1964\0\u0618\0\u2cf1"+
    "\0\u2d32\0\u2d73\0\u2db4\0\u2df5\0\u2e36\0\u2e77\0\u0618\0\u2eb8"+
    "\0\u2ef9\0\u2f3a\0\u0618\0\u2f7b\0\u2fbc\0\u2ffd\0\u303e\0\u0618"+
    "\0\u0618\0\u307f\0\u30c0\0\u3101\0\u3142\0\u3183\0\u31c4\0\u3205"+
    "\0\u3246\0\u3287\0\u32c8\0\u0618\0\u3309\0\u334a\0\u338b\0\u33cc"+
    "\0\u340d\0\u344e\0\u0410\0\u0618\0\u348f\0\u34d0\0\u3511\0\u3552"+
    "\0\u3593\0\u35d4\0\u3615\0\u3656\0\u3697\0\u36d8\0\u3719\0\u375a"+
    "\0\u379b\0\u37dc\0\u381d\0\u385e\0\u0410\0\u0410\0\u0410\0\u389f"+
    "\0\u38e0\0\u3921\0\u3962\0\u39a3\0\u39e4\0\u0410\0\u3a25\0\u0410"+
    "\0\u3a66\0\u0410\0\u0410\0\u3aa7\0\u2a26\0\u3ae8\0\u3b29\0\u3b6a"+
    "\0\u3bab\0\u3bec\0\u3c2d\0\u3c6e\0\u3caf\0\u0618\0\u3cf0\0\u3d31"+
    "\0\u0618\0\u3d72\0\u3db3\0\u3df4\0\u3e35\0\u3e76\0\u3eb7\0\u3ef8"+
    "\0\u3f39\0\u3f7a\0\u3fbb\0\u3ffc\0\u403d\0\u407e\0\u40bf\0\u4100"+
    "\0\u4141\0\u4182\0\u0618\0\u41c3\0\u4204\0\u4245\0\u4286\0\u42c7"+
    "\0\u4308\0\u4349\0\u438a\0\u43cb\0\u0618\0\u440c\0\u444d\0\u448e"+
    "\0\u44cf\0\u4510\0\u4551\0\u4592\0\u45d3\0\u4614\0\u4655\0\u4696"+
    "\0\u46d7\0\u4718\0\u4759\0\u479a\0\u47db\0\u481c\0\u485d\0\u489e"+
    "\0\u48df\0\u4920\0\u4961\0\u49a2\0\u0410\0\u49e3\0\u4a24\0\u4a65"+
    "\0\u4aa6\0\u4ae7\0\u0618\0\u4b28\0\u4b69\0\u4baa\0\u4beb\0\u4c2c"+
    "\0\u0618\0\u0618\0\u4c6d\0\u4cae\0\u4cef\0\u0618\0\u4d30\0\u0618"+
    "\0\u4d71\0\u4db2\0\u4df3\0\u0618\0\u4e34\0\u4e75\0\u0618\0\u4eb6"+
    "\0\u0618\0\u0618\0\u0618\0\u0618\0\u4ef7\0\u4f38\0\u4f79\0\u4fba"+
    "\0\u4ffb\0\u0618\0\u0618\0\u503c\0\u0618\0\u507d\0\u50be\0\u50ff"+
    "\0\u5140\0\u5181\0\u51c2\0\u0410\0\u5203\0\u5244\0\u5285\0\u52c6"+
    "\0\u5307\0\u5348\0\u5389\0\u53ca\0\u540b\0\u544c\0\u548d\0\u54ce"+
    "\0\u550f\0\u5550\0\u5591\0\u0410\0\u55d2\0\u5613\0\u0410\0\u5654"+
    "\0\u0410\0\u5695\0\u56d6\0\u5717\0\u5758\0\u5799\0\u57da\0\u0618"+
    "\0\u581b\0\u585c\0\u589d\0\u58de\0\u0618\0\u591f\0\u5960\0\u59a1"+
    "\0\u59e2\0\u5a23\0\u0618\0\u0618\0\u0618\0\u5a64\0\u5aa5\0\u0618"+
    "\0\u5ae6\0\u5b27\0\u5b68\0\u5ba9\0\u5bea\0\u0410\0\u5c2b\0\u5c6c"+
    "\0\u5cad\0\u5cee\0\u5d2f\0\u0410\0\u5d70\0\u0618\0\u5db1\0\u5df2"+
    "\0\u5e33\0\u5e74\0\u5eb5\0\u5ef6\0\u5f37\0\u5f78\0\u5fb9\0\u0618"+
    "\0\u5ffa\0\u603b\0\u607c\0\u60bd\0\u60fe\0\u613f\0\u6180\0\u61c1"+
    "\0\u0618\0\u0618\0\u6202\0\u0618\0\u6243\0\u6284\0\u62c5\0\u0618"+
    "\0\u6306\0\u6347\0\u6388\0\u63c9\0\u0410\0\u640a\0\u0410\0\u644b"+
    "\0\u648c\0\u64cd\0\u650e\0\u654f\0\u6590\0\u65d1\0\u6612\0\u6653"+
    "\0\u6694\0\u66d5\0\u6716\0\u0618\0\u6757\0\u6798\0\u67d9\0\u681a"+
    "\0\u0618\0\u0618\0\u685b\0\u0618\0\u689c\0\u0410\0\u0410\0\u0618"+
    "\0\u68dd\0\u691e\0\u695f\0\u0618\0\u69a0\0\u69e1\0\u6a22\0\u6a63"+
    "\0\u6aa4\0\u6ae5\0\u6b26\0\u6b67\0\u0618\0\u0618\0\u6ba8\0\u6be9"+
    "\0\u6c2a\0\u6c6b\0\u0618\0\u6cac\0\u0618\0\u6ced\0\u6d2e\0\u6d6f"+
    "\0\u6db0\0\u6df1\0\u0618\0\u0618\0\u6e32\0\u0618\0\u0618\0\u6e73"+
    "\0\u6eb4\0\u6ef5\0\u0618\0\u6f36\0\u6f77\0\u6fb8\0\u6ff9\0\u703a"+
    "\0\u707b\0\u70bc\0\u70fd\0\u713e\0\u717f\0\u71c0\0\u0618\0\u0618"+
    "\0\u0618\0\u7201\0\u7242\0\u7283\0\u72c4\0\u7305\0\u0410\0\u7346"+
    "\0\u7387\0\u73c8\0\u0618\0\u7409\0\u744a\0\u748b\0\u74cc\0\u750d"+
    "\0\u754e\0\u758f\0\u75d0\0\u7611\0\u7652\0\u7693\0\u76d4\0\u0410"+
    "\0\u7715";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[641];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\60\17\1\20\20\17\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\3\32\1\33\1\34\1\21"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\31\1\52\1\31"+
    "\1\53\1\54\1\31\1\55\1\31\1\56\1\57\1\60"+
    "\1\61\1\62\1\63\1\64\1\31\1\65\1\31\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\1\100\1\101\1\102\1\103\1\104\1\105\1\50"+
    "\1\106\1\107\14\110\1\111\1\112\1\113\1\110\1\114"+
    "\60\110\16\115\1\116\60\115\1\117\1\115\14\120\1\121"+
    "\1\120\1\122\1\123\1\124\60\120\11\125\1\126\1\125"+
    "\1\126\1\127\1\125\1\130\1\125\1\131\60\125\3\132"+
    "\1\133\2\132\3\133\11\132\22\133\3\132\1\133\1\132"+
    "\1\133\1\132\3\133\20\132\1\133\2\132\101\134\3\135"+
    "\1\136\2\135\3\136\11\135\22\136\1\137\2\135\1\136"+
    "\1\135\1\136\1\135\3\136\20\135\1\136\2\135\3\140"+
    "\1\141\2\140\3\141\11\140\22\141\3\140\1\141\1\140"+
    "\1\141\1\140\3\141\20\140\1\141\2\140\1\21\1\142"+
    "\1\143\1\31\1\144\1\145\3\31\3\146\1\33\1\147"+
    "\1\146\1\150\1\151\1\37\22\31\1\152\1\153\1\154"+
    "\1\31\1\155\1\31\1\64\3\31\1\156\1\157\1\160"+
    "\1\161\1\162\1\163\1\164\1\165\1\166\1\77\1\100"+
    "\1\167\1\102\1\170\1\104\1\171\1\31\2\146\61\172"+
    "\1\173\17\172\11\174\1\175\47\174\1\176\17\174\11\177"+
    "\1\200\1\177\1\201\31\177\1\202\15\177\1\203\7\177"+
    "\1\203\5\177\60\17\1\204\100\17\1\0\2\17\1\205"+
    "\7\17\1\206\2\17\1\207\2\17\102\0\1\22\1\210"+
    "\1\211\1\0\1\22\74\0\1\210\3\0\1\210\50\0"+
    "\1\212\23\0\1\31\1\0\1\31\1\0\1\31\1\213"+
    "\2\31\11\0\5\31\1\214\1\215\7\31\1\216\2\31"+
    "\1\217\3\0\1\220\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\6\0\1\221\51\0\1\222\23\0\1\22\1\210"+
    "\1\211\1\0\1\22\1\223\73\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\7\31\1\224\12\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\4\0\1\34\4\0\11\31"+
    "\1\225\10\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\2\0\1\226\15\0\1\31\1\227\2\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\13\0\3\32\70\0"+
    "\1\230\2\0\3\230\11\0\22\230\3\0\1\230\1\0"+
    "\1\230\1\0\3\230\20\0\1\230\2\0\14\231\1\232"+
    "\1\233\1\234\1\231\1\235\60\231\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\3\31\1\236\1\31\1\237"+
    "\2\31\1\240\10\31\1\241\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\240\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\11\31\1\242\2\31\1\243\5\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\244\1\0\4\31\11\0\1\245"+
    "\6\31\1\246\12\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\247\3\31\1\250\2\31\1\251\12\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\5\31"+
    "\1\252\2\31\1\253\11\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\253\3\0\1\31\1\0\1\254"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\7\31\1\255\3\31\1\256\2\31"+
    "\1\257\3\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\11\31\1\260\10\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\31\1\261\13\31\1\262\4\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\263\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\2\31\1\264\1\31"+
    "\11\0\5\31\1\265\2\31\1\266\1\267\10\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\266\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\14\31\1\270"+
    "\5\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\271\21\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\4\31\1\272\4\31\1\273\10\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\46\0\1\274"+
    "\1\275\10\0\1\276\67\0\1\277\10\0\1\300\70\0"+
    "\1\301\33\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\13\31\1\302\6\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\11\0\1\303\2\0\1\304\7\0"+
    "\1\305\1\0\1\306\1\307\1\310\2\0\1\311\1\312"+
    "\1\313\1\0\1\314\40\0\1\312\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\16\31\1\315\3\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\1\31\1\316\1\31\20\0"+
    "\1\31\47\0\1\317\10\0\1\320\100\0\1\321\67\0"+
    "\1\322\10\0\1\323\1\0\1\324\1\0\1\325\74\0"+
    "\1\326\100\0\1\327\2\0\1\330\1\107\63\0\1\331"+
    "\10\0\1\332\100\0\1\333\5\0\1\334\72\0\1\335"+
    "\6\0\1\336\71\0\1\337\67\0\1\340\33\0\16\227"+
    "\1\341\60\227\1\233\1\227\14\110\1\342\1\0\1\343"+
    "\1\110\1\344\63\110\1\345\2\110\3\345\3\110\1\346"+
    "\1\347\1\343\1\110\1\350\1\110\22\345\3\110\1\345"+
    "\1\110\1\345\1\110\3\345\20\110\1\345\117\110\1\351"+
    "\1\347\1\343\1\110\1\352\60\110\16\115\1\353\60\115"+
    "\1\0\17\115\1\354\60\115\1\354\1\115\14\120\1\355"+
    "\1\120\1\356\1\0\1\357\63\120\1\345\2\120\3\345"+
    "\3\120\1\360\1\120\1\356\1\361\1\350\1\120\22\345"+
    "\3\120\1\345\1\120\1\345\1\120\3\345\20\120\1\345"+
    "\117\120\1\351\1\120\1\356\1\361\1\362\60\120\11\125"+
    "\1\126\1\125\1\126\1\363\1\125\1\364\1\125\1\365"+
    "\63\125\1\366\2\125\3\366\1\126\1\125\1\126\1\363"+
    "\1\125\1\364\1\125\1\365\1\125\22\366\3\125\1\366"+
    "\1\125\1\366\1\125\3\366\20\125\1\366\5\125\1\345"+
    "\2\125\3\345\1\126\1\125\1\126\1\367\1\125\1\364"+
    "\1\125\1\350\1\125\22\345\3\125\1\345\1\125\1\345"+
    "\1\125\3\345\20\125\1\345\13\125\1\126\1\125\1\126"+
    "\76\125\1\126\1\125\1\126\1\351\1\125\1\364\1\125"+
    "\1\370\60\125\1\0\1\371\1\0\1\371\1\0\4\371"+
    "\1\372\1\0\1\372\5\0\1\373\22\371\3\0\1\371"+
    "\1\0\1\371\1\0\3\371\20\0\1\371\3\0\1\136"+
    "\1\0\1\136\1\0\4\136\11\0\22\136\3\0\1\136"+
    "\1\0\1\136\1\0\3\136\20\0\1\136\47\0\1\374"+
    "\34\0\1\141\1\0\1\141\1\0\4\141\11\0\22\141"+
    "\3\0\1\141\1\0\1\141\1\0\3\141\20\0\1\141"+
    "\3\0\1\142\3\0\1\142\74\0\1\375\3\0\1\375"+
    "\1\376\72\0\61\172\1\0\17\172\62\0\1\377\31\0"+
    "\1\174\147\0\1\u0100\16\0\11\177\1\200\1\177\1\201"+
    "\31\177\1\201\15\177\1\201\7\177\1\201\5\177\13\0"+
    "\1\201\132\0\1\u0101\33\0\60\17\1\0\2\17\1\0"+
    "\7\17\1\0\2\17\1\0\2\17\56\0\1\u0102\64\0"+
    "\1\u0103\13\0\1\u0102\52\0\1\u0104\51\0\1\210\1\0"+
    "\1\211\1\0\1\210\74\0\1\u0105\2\0\1\u0106\1\u0105"+
    "\36\0\1\u0106\35\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\1\u0107\1\u0108\20\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\2\31\1\u0109\17\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\14\31\1\u010a\5\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\10\31"+
    "\1\u010b\11\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\u010b\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\20\31\1\u010c\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\13\31\1\u010d\6\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\u010e"+
    "\1\0\1\u010e\1\0\1\u010e\1\0\1\u010e\14\0\2\u010e"+
    "\2\0\1\u010e\4\0\1\u010e\44\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\11\31\1\u010f\10\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\u0110\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\62\0\1\u0111"+
    "\21\0\1\230\1\0\1\230\1\0\4\230\11\0\22\230"+
    "\3\0\1\230\1\0\1\230\1\0\3\230\20\0\1\230"+
    "\2\0\3\231\1\0\2\231\3\0\3\231\1\232\1\233"+
    "\1\234\1\231\1\0\1\231\22\0\3\231\1\0\1\231"+
    "\1\0\1\231\3\0\20\231\1\0\117\231\1\0\1\233"+
    "\1\234\1\231\1\235\60\231\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\31\1\u0112\4\31\1\u0113\1\31"+
    "\1\u0114\11\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\u0114\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\10\31\1\u0115\11\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\u0115\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\20\31\1\u0116\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\12\31\1\u0117\7\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\11\31"+
    "\1\u0118\10\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\3\31\1\u0119\2\31\1\u011a\13\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\u011b\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\5\31\1\u011c\14\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\5\31"+
    "\1\u011d\14\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\11\31\1\u011e\10\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\10\31\1\u011f\11\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\u011f\3\0\1\31"+
    "\1\0\1\u0120\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\15\31\1\u0121\4\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\5\31"+
    "\1\u0122\14\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\1\31\1\u0123\6\31\1\u0124\11\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\u0124\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\7\31\1\u0125\3\31"+
    "\1\u0126\6\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\13\31\1\u0127\6\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\u0128\21\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\31\1\u0129\20\31\3\0"+
    "\1\31\1\0\1\31\1\0\2\31\1\u012a\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\10\31"+
    "\1\u012b\11\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\u012b\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\2\31\1\u012c\17\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\11\31\1\u012d\10\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\u012e\21\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\10\31\1\u012f"+
    "\11\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\u012f\3\0\1\31\1\0\1\31\1\0\2\31\1\u0130"+
    "\1\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\u0131\6\31\1\u0132\12\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\60\0\1\u0133"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\11\31"+
    "\1\u0134\10\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\24\0\1\u0135\6\0\1\u0136\76\0\1\u0137"+
    "\102\0\1\u0138\107\0\1\u0139\67\0\1\u013a\60\0\1\u013b"+
    "\114\0\1\u013c\60\0\1\u013d\130\0\1\u013e\46\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\7\31\1\u013f\12\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\3\31"+
    "\1\u0140\2\31\1\u0141\5\31\1\u0142\1\31\1\u0143\2\31"+
    "\1\u0144\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\60\0\1\u0145\100\0\1\u0146\100\0\1\u0147\1\0"+
    "\1\u0148\52\0\1\u0149\43\0\1\u0149\13\0\3\u014a\45\0"+
    "\1\u014b\12\0\1\u014c\15\0\1\u014d\1\0\1\u014e\76\0"+
    "\1\u014f\1\0\1\u0150\65\0\101\227\3\110\1\0\2\110"+
    "\3\0\3\110\1\346\1\347\1\343\1\110\1\0\1\110"+
    "\22\0\3\110\1\0\1\110\1\0\1\110\3\0\20\110"+
    "\1\0\16\110\1\0\1\347\1\343\1\110\1\352\60\110"+
    "\1\0\1\345\1\0\1\345\1\0\4\345\11\0\22\345"+
    "\1\u0151\2\0\1\345\1\0\1\345\1\0\3\345\12\0"+
    "\1\u0152\5\0\1\345\2\0\16\115\1\0\60\115\1\0"+
    "\1\115\3\120\1\0\2\120\3\0\3\120\1\360\1\120"+
    "\1\356\1\361\1\0\1\120\22\0\3\120\1\0\1\120"+
    "\1\0\1\120\3\0\20\120\1\0\16\120\1\0\1\120"+
    "\1\356\1\361\1\362\60\120\3\125\1\0\2\125\3\0"+
    "\1\126\1\125\1\126\1\367\1\125\1\364\1\125\1\0"+
    "\1\125\22\0\3\125\1\0\1\125\1\0\1\125\3\0"+
    "\20\125\1\0\13\125\1\126\1\125\1\126\1\0\1\125"+
    "\1\364\1\125\1\370\61\125\1\366\1\125\1\366\1\125"+
    "\4\366\1\u0153\1\125\1\u0153\1\363\1\125\1\364\1\125"+
    "\1\365\1\u0154\22\366\3\125\1\366\1\125\1\366\1\125"+
    "\3\366\20\125\1\366\2\125\11\0\1\372\1\0\1\372"+
    "\66\0\1\375\3\0\1\375\74\0\1\u0155\1\0\1\u0155"+
    "\1\0\1\u0155\1\0\1\u0155\14\0\2\u0155\2\0\1\u0155"+
    "\4\0\1\u0155\101\0\1\u0156\75\0\1\u0157\46\0\1\u0105"+
    "\3\0\1\u0105\74\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\1\31\1\u011b\20\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\u0158"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\u0159\1\31\1\u015a\1\u015b\4\31"+
    "\1\u015c\4\31\1\u015d\4\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\u015c\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\7\31\1\u015e\12\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\u015f\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\31\1\u0160\20\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\16\31"+
    "\1\u0161\3\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\13\31\1\u0162\6\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\62\0\1\u0148\21\0\1\31"+
    "\1\0\1\u0163\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\16\31\1\u0164\3\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\1\31"+
    "\1\u0165\20\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u0166\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\16\31\1\u0167\3\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\7\31\1\u0168\12\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\u0169\12\31\1\u016a"+
    "\6\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\16\31\1\u016b\3\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\13\31\1\u016c\6\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\6\31\1\u016d\13\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\u016e\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\u016f\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\31\1\u0170"+
    "\6\31\1\u0171\11\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\u0171\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\6\31\1\u0172\13\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u0173\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\5\31\1\u0174\14\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\10\31\1\u0175"+
    "\11\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\u0175\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\31\1\u0176\20\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\31\1\u0177\20\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\4\31\1\u0178\15\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\4\31\1\u0179"+
    "\15\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\31\1\u017a\20\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\13\31\1\u017b\6\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\16\31\1\u017c\3\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\31\1\u017d"+
    "\20\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\16\31\1\u017e\3\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\5\31\1\u017f\14\31\3\0\1\u0180\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\31\1\u0181\20\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\31\0"+
    "\1\u0182\102\0\1\u0183\72\0\1\u0184\103\0\1\u0185\103\0"+
    "\1\u0186\101\0\1\u0187\43\0\1\u0187\55\0\1\u0188\60\0"+
    "\1\u0189\102\0\1\u018a\76\0\1\u018b\46\0\1\31\1\0"+
    "\1\31\1\0\2\31\1\u018c\1\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\u018d\3\31"+
    "\1\u018e\15\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\16\31\1\u018f\3\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\13\31\1\u0190\6\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\u0191\21\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\u0192\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\5\0"+
    "\1\u0193\2\0\3\u0193\1\0\1\u0148\7\0\22\u0193\3\0"+
    "\1\u0193\1\0\1\u0193\1\0\3\u0193\20\0\1\u0193\32\0"+
    "\1\u0194\61\0\3\u014a\60\0\1\u014c\66\0\1\u0195\65\0"+
    "\1\u0196\44\0\1\u014e\100\0\1\u0150\132\0\1\u0197\33\0"+
    "\11\125\1\u0153\1\125\1\u0153\1\363\1\125\1\364\1\125"+
    "\1\365\60\125\42\0\1\u0198\60\0\1\u0199\57\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\5\31\1\u019a\14\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\3\31"+
    "\1\u019b\16\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u019c\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\7\31\1\u019d\12\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\15\31\1\u019e\4\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\14\31\1\u019f\5\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\1\u01a0"+
    "\21\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\12\31\1\u01a1\7\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\17\31\1\u01a2\2\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\11\31\1\u01a3\10\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\4\31\1\u01a4"+
    "\15\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\13\31\1\u01a5\6\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\31\1\u01a6\20\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u01a7\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\15\31\1\u01a8\4\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\5\31\1\u01a9"+
    "\14\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\4\31\1\u01aa\15\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\13\31\1\u01ab\6\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\16\31\1\u01ac\3\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\31\1\u01ad"+
    "\20\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\13\31\1\u01ae\6\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\31\1\u01af\20\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\u01b0\21\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\31\1\u01b1\20\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\14\31"+
    "\1\u01b2\5\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u01b3\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\10\31\1\u01b4\11\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\u01b4\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\u01b5\21\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\6\31\1\u01b6\13\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\11\31\1\u01b7"+
    "\10\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\u01b8\21\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\11\31\1\u01b9\10\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\12\31\1\u01ba\7\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\u01bb\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\u01bc\21\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\31\1\u01bd"+
    "\20\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\13\31\1\u01be\6\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\u01bf\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\37\0\1\u01c0\103\0\1\u01c1\43\0"+
    "\1\u01c2\6\0\1\u01c3\37\0\1\u01c4\35\0\1\u01c5\126\0"+
    "\1\u01c6\46\0\1\u01c7\100\0\1\u01c8\117\0\1\u01c9\116\0"+
    "\1\u01ca\75\0\1\u01cb\44\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\13\31\1\u01cc\6\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\16\31\1\u01cd\3\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\5\31\1\u01ce"+
    "\14\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\13\31\1\u01cf\6\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\16\31\1\u01d0\3\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\5\31\1\u01d1\14\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\31\1\u01d2"+
    "\20\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\u0193\1\0\1\u0193\1\0\4\u0193\1\u01d3"+
    "\1\0\1\u01d4\6\0\22\u0193\3\0\1\u0193\1\0\1\u0193"+
    "\1\0\3\u0193\20\0\1\u0193\35\0\1\u01d5\102\0\1\u01d6"+
    "\46\0\1\u01d7\2\0\3\u01d7\11\0\22\u01d7\3\0\1\u01d7"+
    "\1\0\1\u01d7\1\0\3\u01d7\20\0\1\u01d7\13\0\1\u01d8"+
    "\2\u01d9\127\0\1\u01da\37\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\2\31\1\u01db\17\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\6\31\1\u01dc\13\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\11\31\1\u01dd"+
    "\10\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\u01de\21\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\1\u01df\21\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\3\31\1\u01e0\16\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\3\31\1\u01e1\16\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\2\31\1\u01e2"+
    "\17\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\5\31\1\u01e3\14\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\21\31\1\u01e4\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\u01e5"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\16\31\1\u01e6\3\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\11\31\1\u01e7\10\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\1\u01e8"+
    "\21\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\6\31\1\u01e9\13\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\5\31\1\u01ea\14\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\6\31\1\u01eb\13\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\14\31\1\u01ec"+
    "\5\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\5\31\1\u01ed\14\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\11\31\1\u01ee\10\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\13\31\1\u01ef\6\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\6\31\1\u01f0"+
    "\13\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\31\1\u01f1\20\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\6\31\1\u01f2\13\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\35\0\1\u01f3\50\0"+
    "\1\u01f4\6\0\1\u01f5\37\0\1\u01f6\77\0\1\u01f7\41\0"+
    "\1\u01c3\37\0\1\u01c4\66\0\1\u01f8\63\0\1\u01ca\100\0"+
    "\1\u01f9\105\0\1\u01fa\77\0\1\u01fb\63\0\1\u01ca\37\0"+
    "\1\u01fc\62\0\1\u01fd\45\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\16\31\1\u01fe\3\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u01ff\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\6\31\1\u0200\13\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\10\31\1\u0201"+
    "\11\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\u0201\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\31\1\u0202\20\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\u0203\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\14\31\1\u0204\5\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\15\0\1\u01d4\107\0"+
    "\1\u0205\111\0\1\u0206\60\0\1\u01d9\110\0\1\u0207\56\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\10\31\1\u0208"+
    "\11\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\u0208\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\16\31\1\u0209\3\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\u020a\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\31\1\u020b\20\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\16\31\1\u020c\3\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\13\31\1\u020d"+
    "\6\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\u020e\1\0\4\31\11\0"+
    "\22\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\6\31\1\u020f\13\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\u0210\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\31\1\u0211\20\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u0212\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\7\31\1\u0213\12\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\14\31\1\u0214"+
    "\5\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\4\31\1\u0215\15\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\u0216\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\6\31\1\u0217\13\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u0218\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\31\1\u0219\20\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\36\0"+
    "\1\u021a\101\0\1\u021b\55\0\1\u01f5\37\0\1\u01f6\31\0"+
    "\1\u021c\100\0\1\u01ca\107\0\1\u01f9\37\0\1\u021d\51\0"+
    "\1\u021e\126\0\1\u021a\41\0\1\u01fd\37\0\1\u021f\27\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\1\31\1\u0220\1\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\31\1\u0221\20\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\10\31\1\u0222\11\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\u0222\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\1\31\1\u0223\1\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\1\31\1\u0224\1\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\7\31\1\u0225\12\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\44\0\1\u0226\47\0\3\u0227\76\0"+
    "\3\u0228\66\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\13\31\1\u0229\6\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\13\31\1\u022a\6\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\6\31\1\u022b\13\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\u022c\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\6\31\1\u022d"+
    "\13\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\22\31\3\0\1\31\1\0\1\31\1\0\1\31\1\u022e"+
    "\1\31\20\0\1\31\3\0\1\31\1\0\1\u022f\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\5\31\1\u0230\14\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\5\31\1\u0231\14\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\u0232\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\1\31\1\u0233\1\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\31\1\u0234\20\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\u0235\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\14\0\1\u021a\37\0\1\u0236\55\0"+
    "\1\u01f5\104\0\1\u01c3\57\0\1\u021e\37\0\1\u0237\27\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\1\31\1\u0238\1\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\u0239\21\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\1\31"+
    "\1\u023a\1\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\6\31\1\u023b\13\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\1\31\1\u023c\1\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\2\31"+
    "\1\u023d\17\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\25\0\1\u023e\60\0\1\u023f\2\0\3\u023f"+
    "\3\u0227\1\u0240\5\0\22\u023f\3\0\1\u023f\1\0\1\u023f"+
    "\1\0\3\u023f\7\0\1\u0241\2\0\2\u0241\4\0\1\u023f"+
    "\13\0\3\u0228\24\0\1\u0242\41\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\11\31\1\u0243\10\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\6\31\1\u0244\13\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\14\31"+
    "\1\u0245\5\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u0246\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\7\31\1\u0247\12\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\7\31\1\u0248\12\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\31\1\u0249\20\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\7\31"+
    "\1\u024a\12\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\2\31\1\u024b\17\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\7\31\1\u024c\12\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\1\31\1\u024d\1\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\7\31"+
    "\1\u024e\12\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\1\31"+
    "\1\u024f\1\31\20\0\1\31\13\0\3\u023e\31\0\1\340"+
    "\34\0\1\u023f\1\0\1\u023f\1\0\4\u023f\3\u0250\6\0"+
    "\22\u023f\3\0\1\u023f\1\0\1\u023f\1\0\3\u023f\7\0"+
    "\1\u0241\2\0\2\u0241\4\0\1\u023f\5\0\1\u0251\2\0"+
    "\3\u0251\11\0\22\u0251\3\0\1\u0251\1\0\1\u0251\1\0"+
    "\3\u0251\20\0\1\u0251\5\0\1\u023f\2\0\3\u023f\3\u0250"+
    "\6\0\22\u023f\3\0\1\u023f\1\0\1\u023f\1\0\3\u023f"+
    "\7\0\1\u0241\2\0\2\u0241\4\0\1\u023f\37\0\1\u0252"+
    "\44\0\1\31\1\0\1\u0253\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\14\31"+
    "\1\u0254\5\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\5\31\1\u0255\14\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\3\31\1\u0256\16\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\10\31\1\u0257\11\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\u0257"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\5\31"+
    "\1\u0258\14\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\5\31\1\u0259\14\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\21\31\1\u025a\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\1\31\1\u025b\1\31\20\0\1\31\13\0"+
    "\3\u0250\1\u025c\65\0\1\u0251\1\0\1\u0251\1\0\4\u0251"+
    "\3\u025d\6\0\22\u0251\3\0\1\u0251\1\0\1\u0251\1\0"+
    "\3\u0251\20\0\1\u0251\31\0\1\u025e\52\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\6\31\1\u025f\13\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\6\31\1\u0260"+
    "\13\31\3\0\1\31\1\0\1\31\1\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\22\31\3\0\1\31\1\0\1\31\1\0\1\31\1\u0261"+
    "\1\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\20\31\1\u0262\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\20\0\1\31\5\0\1\u0263\2\0"+
    "\3\u0263\11\0\22\u0263\3\0\1\u0263\1\0\1\u0263\1\0"+
    "\3\u0263\20\0\1\u0263\5\0\1\u0264\2\0\3\u0264\3\u025d"+
    "\6\0\22\u0264\3\0\1\u0264\1\0\1\u0264\1\0\3\u0264"+
    "\7\0\1\u0265\2\0\2\u0265\4\0\1\u0264\53\0\1\u0266"+
    "\30\0\1\31\1\0\1\u0267\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\u0268\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\1\31\1\u0269\1\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\1\u026a\21\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\20\0\1\31\3\0\1\u0263\1\0\1\u0263\1\0"+
    "\4\u0263\3\u026b\6\0\22\u0263\3\0\1\u0263\1\0\1\u0263"+
    "\1\0\3\u0263\3\0\1\u026c\14\0\1\u0263\3\0\1\u0264"+
    "\1\0\1\u0264\1\0\4\u0264\3\u026b\6\0\22\u0264\3\0"+
    "\1\u0264\1\0\1\u0264\1\0\3\u0264\3\0\1\u026c\3\0"+
    "\1\u0265\2\0\2\u0265\4\0\1\u0264\5\0\1\u0264\2\0"+
    "\3\u0264\3\u026b\6\0\22\u0264\3\0\1\u0264\1\0\1\u0264"+
    "\1\0\3\u0264\3\0\1\u026c\3\0\1\u0265\2\0\2\u0265"+
    "\4\0\1\u0264\30\0\1\u026d\53\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\16\31\1\u026e\3\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\13\0\3\u026b"+
    "\45\0\1\u026c\101\0\1\u026f\53\0\1\u0270\44\0\1\31"+
    "\1\0\1\u0271\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\20\0\1\31\53\0\1\u0272"+
    "\30\0\1\31\1\0\1\31\1\0\4\31\11\0\11\31"+
    "\1\u0273\10\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\20\0\1\31\5\0\1\u0274\106\0\3\u0274\42\0\1\u0275"+
    "\33\0\3\u0275\1\0\1\u0276\24\0\1\u0277\34\0\1\u0278"+
    "\43\0\1\u0279\74\0\1\u027a\104\0\1\u027b\74\0\1\u027c"+
    "\104\0\1\u027d\74\0\1\u027e\104\0\1\u027f\47\0\3\u027d"+
    "\31\0\1\u0280\75\0\1\u0281\53\0\1\u027d\162\0\1\u027d"+
    "\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[30550];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"		//$NON-NLS-1$
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\1\10\0\2\1\1\11\13\1\3\11\24\1"+
    "\1\11\12\1\4\11\1\1\2\11\1\1\1\11\2\1"+
    "\1\11\4\1\1\11\3\1\1\11\6\1\1\11\1\1"+
    "\2\11\2\1\1\11\2\1\2\11\1\1\24\11\2\1"+
    "\1\11\4\1\2\11\1\1\1\0\4\1\1\0\1\11"+
    "\6\1\2\11\1\0\2\1\2\0\1\1\2\0\1\11"+
    "\2\0\36\1\3\11\1\1\2\11\1\1\12\0\2\1"+
    "\1\11\2\1\2\11\1\1\1\0\2\11\2\1\6\11"+
    "\1\1\4\0\2\1\3\11\1\1\1\0\1\11\3\0"+
    "\1\1\1\11\1\1\3\0\3\1\1\0\1\11\1\0"+
    "\1\11\1\1\1\0\4\11\2\0\1\1\1\0\12\1"+
    "\1\0\41\1\1\11\1\1\12\0\6\1\3\11\3\0"+
    "\1\1\1\0\1\1\1\11\1\1\1\11\1\0\2\11"+
    "\2\1\2\0\52\1\12\0\7\1\2\0\1\11\4\0"+
    "\46\1\4\0\1\11\7\0\10\1\1\11\2\0\1\11"+
    "\1\1\1\11\1\0\30\1\3\0\1\11\5\0\1\11"+
    "\1\0\7\1\3\0\22\1\3\0\1\11\1\0\1\11"+
    "\6\1\3\0\15\1\2\11\6\1\5\0\15\1\3\0"+
    "\11\1\3\0\4\1\4\0\4\1\3\0\1\1\1\11"+
    "\1\0\1\1\1\0\1\1\14\0\1\11\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[641];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
	private final LinkedList commentList = new LinkedList();
	private String heredoc = null;
    private boolean asp_tags = false;
    private boolean short_tags_allowed = true;
    private StateStack stack = new StateStack();
    protected int commentStartPosition;

	private AST ast;

    public void setAST(AST ast) {
    	this.ast = ast;
    }
    
	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP5;
	}
    
	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	public void resetCommentList() {
		commentList.clear();
	}
	
	/**
	 * Will only be filled when ast != null
	 */
	public LinkedList getCommentList() {
		return commentList;
	}
	
	/**
	 * Will only be added when ast != null
	 */
	protected void addComment(int type) {
		if (ast != null) {
			int leftPosition = getTokenStartPosition();
			Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), ast, type);
			commentList.add(comment);
		}
	}
	
	public void setUseAspTagsAsPhp(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}
	
	public void setUseShortTags(boolean useShortTags) {
		short_tags_allowed = useShortTags;
	}
	
    private void pushState(int state) {
        stack.pushStack(zzLexicalState);
        yybegin(state);
    }

    private void popState() {
        yybegin(stack.popStack());
    }

    public int getCurrentLine() {
        return yyline;
    }

    protected int getTokenStartPosition() {
        return zzStartRead - _zzPushbackPos;
    }

    protected int getTokenLength() {
        return zzMarkedPos - zzStartRead;
    }

    public int getLength() {
        return zzEndRead - _zzPushbackPos;
    }
    
    private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}
	
	private void handleLineCommentEnd() {
         addComment(Comment.TYPE_SINGLE_LINE);
    }
    
    private void handleMultilineCommentEnd() {
    	addComment(Comment.TYPE_MULTILINE);
    }

    private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
    }
    
    protected void handleVarComment() {
    	commentStartPosition = zzStartRead;
    	addComment(Comment.TYPE_MULTILINE);
    }
        
    private Symbol createFullSymbol(int symbolNumber) {
        Symbol symbol = createSymbol(symbolNumber);
        symbol.value = yytext();
        return symbol;
    }

    protected Symbol createSymbol(int symbolNumber) {
        int leftPosition = getTokenStartPosition();
        return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
    }

	public int[] getParamenters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
				zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
				zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}
    
	/**
	 * Parses a PHPDoc block comment. Underlying reader (zzReader) can be closed
	 * in the process (when EOF is reached).
	 * 
	 * @return true when PHPDoc was parsed, false otherwise (false also implies
	 *         that this scanner wasn't resetted)
	 */
	protected boolean parsePHPDoc() {
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if(documentorLexer == null) {
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParamenters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParamenters());
		return true;
	}
	
	protected IDocumentorLexer getDocumentorLexer(java.io.Reader  reader) {
		return null;
	}
	
	/**
	 * Resets the {@code PhpAstLexer} properties to previous values, but leaves
	 * the lexical state unchanged. Be careful, method {@link #next_token()}
	 * also caches those properties using internal variables (zzCurrentPosL,
	 * zzMarkedPosL, zzBufferL, zzEndReadL) that should be accordingly resetted
	 * by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 * 
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		this.yychar = this.zzStartRead - this._zzPushbackPos;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];
		// XXX: check if there's no side-effect to reset zzAtBOL
		// when zzAtEOF is false and zzMarkedPos is equal to zzStartRead.
		// One possible case would be that IDocumentorLexer#parse() matches
		// no text at all without being at EOF (i.e. the document lexer returns
		// a zero-length token), which of course would be totally broken...
		this.zzAtBOL = this.zzAtEOF ? false : (parameters[6] != 0);
	}


  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 234) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (zzRefill()) {
        return YYEOF;
    }

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
    oldString = null;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		startPos = zzMarkedPos;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
          {     return createSymbol(sym.EOF);
 }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 182: break;
          case 2: 
            { return createSymbol(ParserConstants.T_INLINE_HTML);
            }
          case 183: break;
          case 3: 
            { // do nothing
            }
          case 184: break;
          case 4: 
            { return createFullSymbol(ParserConstants.T_LNUMBER);
            }
          case 185: break;
          case 5: 
            { return createSymbol(ParserConstants.T_NEKUDA);
            }
          case 186: break;
          case 6: 
            { return createFullSymbol(ParserConstants.T_STRING);
            }
          case 187: break;
          case 7: 
            { return createSymbol(ParserConstants.T_PLUS);
            }
          case 188: break;
          case 8: 
            { 
            }
          case 189: break;
          case 9: 
            { return createSymbol(ParserConstants.T_DOLLAR);
            }
          case 190: break;
          case 10: 
            { yybegin(ST_DOUBLE_QUOTES);
    return createSymbol(ParserConstants.T_QUATE);
            }
          case 191: break;
          case 11: 
            { yybegin(ST_BACKQUOTE);
    return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 192: break;
          case 12: 
            { pushState(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          case 193: break;
          case 13: 
            { return createSymbol(ParserConstants.T_SEMICOLON);
            }
          case 194: break;
          case 14: 
            { return createSymbol(ParserConstants.T_MINUS);
            }
          case 195: break;
          case 15: 
            { return createSymbol(ParserConstants.T_LGREATER);
            }
          case 196: break;
          case 16: 
            { return createSymbol(ParserConstants.T_NEKUDOTAIM);
            }
          case 197: break;
          case 17: 
            { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
            }
          case 198: break;
          case 18: 
            { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
            }
          case 199: break;
          case 19: 
            { return createSymbol(ParserConstants.T_EQUAL);
            }
          case 200: break;
          case 20: 
            { return createSymbol(ParserConstants.T_NOT);
            }
          case 201: break;
          case 21: 
            { return createSymbol(ParserConstants.T_RGREATER);
            }
          case 202: break;
          case 22: 
            { return createSymbol(ParserConstants.T_TIMES);
            }
          case 203: break;
          case 23: 
            { return createSymbol(ParserConstants.T_DIV);
            }
          case 204: break;
          case 24: 
            { return createSymbol(ParserConstants.T_PRECENT);
            }
          case 205: break;
          case 25: 
            { return createSymbol(ParserConstants.T_REFERENCE);
            }
          case 206: break;
          case 26: 
            { return createSymbol(ParserConstants.T_OR);
            }
          case 207: break;
          case 27: 
            { return createSymbol(ParserConstants.T_KOVA);
            }
          case 208: break;
          case 28: 
            { return createSymbol(ParserConstants.T_COMMA);
            }
          case 209: break;
          case 29: 
            { return createSymbol(ParserConstants.T_OPEN_RECT);
            }
          case 210: break;
          case 30: 
            { return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          case 211: break;
          case 31: 
            { return createSymbol(ParserConstants.T_TILDA);
            }
          case 212: break;
          case 32: 
            { return createSymbol(ParserConstants.T_QUESTION_MARK);
            }
          case 213: break;
          case 33: 
            { return createSymbol(ParserConstants.T_AT);
            }
          case 214: break;
          case 34: 
            { /* This is a temporary fix which is dependant on flex and it's implementation */
    if (!stack.isEmpty()) {
        popState();
    }
    return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          case 215: break;
          case 35: 
            { yybegin(ST_SINGLE_QUOTE);
    return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          case 216: break;
          case 36: 
            { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
//	yymore();
            }
          case 217: break;
          case 37: 
            { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_QUATE);
            }
          case 218: break;
          case 38: 
            { return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 219: break;
          case 39: 
            { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          case 220: break;
          case 40: 
            { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 221: break;
          case 41: 
            { yypushback(1);
	yybegin(ST_HEREDOC);
            }
          case 222: break;
          case 42: 
            { heredoc = null;
	yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_END_HEREDOC);
            }
          case 223: break;
          case 43: 
            { yypushback(yylength());
    popState();
            }
          case 224: break;
          case 44: 
            { popState();
    return createFullSymbol(ParserConstants.T_STRING);
            }
          case 225: break;
          case 45: 
            { yypushback(yylength());
    popState();
    pushState(ST_IN_SCRIPTING);
            }
          case 226: break;
          case 46: 
            { popState();
    pushState(ST_IN_SCRIPTING);
    return createFullSymbol(ParserConstants.T_STRING_VARNAME);
            }
          case 227: break;
          case 47: 
            { return createFullSymbol(ParserConstants.T_NUM_STRING);
            }
          case 228: break;
          case 48: 
            { yypushback(1);
	popState();
	return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 229: break;
          case 49: 
            { return createSymbol(ParserConstants.T_QUATE);
            }
          case 230: break;
          case 50: 
            { return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 231: break;
          case 51: 
            { return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          case 232: break;
          case 52: 
            { popState();
	return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          case 233: break;
          case 53: 
            { return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          case 234: break;
          case 54: 
            { //	yymore();
            }
          case 235: break;
          case 55: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
//	yymore();
            }
          case 236: break;
          case 56: 
            { if (asp_tags) {
        yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
            }
          case 237: break;
          case 57: 
            { if (short_tags_allowed || yylength()>2) { /* yyleng>2 means it's not <? but <script> */
        yybegin(ST_IN_SCRIPTING);
        //return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
            }
          case 238: break;
          case 58: 
            { return createFullSymbol(ParserConstants.T_DNUMBER);
            }
          case 239: break;
          case 59: 
            { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
            }
          case 240: break;
          case 60: 
            { return createSymbol(ParserConstants.T_INC);
            }
          case 241: break;
          case 61: 
            { return createSymbol(ParserConstants.T_PLUS_EQUAL);
            }
          case 242: break;
          case 62: 
            { return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 243: break;
          case 63: 
            { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
            }
          case 244: break;
          case 64: 
            { return createSymbol(ParserConstants.T_IF);
            }
          case 245: break;
          case 65: 
            { return createSymbol(ParserConstants.T_DO);
            }
          case 246: break;
          case 66: 
            { return createSymbol(ParserConstants.T_LOGICAL_OR);
            }
          case 247: break;
          case 67: 
            { return createSymbol(ParserConstants.T_AS);
            }
          case 248: break;
          case 68: 
            { return createSymbol(ParserConstants.T_DEC);
            }
          case 249: break;
          case 69: 
            { pushState(ST_LOOKING_FOR_PROPERTY);
    return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          case 250: break;
          case 70: 
            { return createSymbol(ParserConstants.T_MINUS_EQUAL);
            }
          case 251: break;
          case 71: 
            { return createSymbol(ParserConstants.T_SR);
            }
          case 252: break;
          case 72: 
            { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
            }
          case 253: break;
          case 73: 
            { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
            }
          case 254: break;
          case 74: 
            { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
            }
          case 255: break;
          case 75: 
            { return createSymbol(ParserConstants.T_IS_EQUAL);
            }
          case 256: break;
          case 76: 
            { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
            }
          case 257: break;
          case 77: 
            { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
            }
          case 258: break;
          case 78: 
            { return createSymbol(ParserConstants.T_SL);
            }
          case 259: break;
          case 79: 
            { return createSymbol(ParserConstants.T_MUL_EQUAL);
            }
          case 260: break;
          case 80: 
            { return createSymbol(ParserConstants.T_DIV_EQUAL);
            }
          case 261: break;
          case 81: 
            { handleCommentStart();
    yybegin(ST_COMMENT);
            }
          case 262: break;
          case 82: 
            { if (asp_tags) {
        yybegin(YYINITIAL);
        return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
            }
          case 263: break;
          case 83: 
            { return createSymbol(ParserConstants.T_MOD_EQUAL);
            }
          case 264: break;
          case 84: 
            { return createSymbol(ParserConstants.T_AND_EQUAL);
            }
          case 265: break;
          case 85: 
            { return createSymbol(ParserConstants.T_BOOLEAN_AND);
            }
          case 266: break;
          case 86: 
            { return createSymbol(ParserConstants.T_OR_EQUAL);
            }
          case 267: break;
          case 87: 
            { return createSymbol(ParserConstants.T_BOOLEAN_OR);
            }
          case 268: break;
          case 88: 
            { return createSymbol(ParserConstants.T_XOR_EQUAL);
            }
          case 269: break;
          case 89: 
            { yybegin(YYINITIAL);
    return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
            }
          case 270: break;
          case 90: 
            { yypushback(1);
    return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 271: break;
          case 91: 
            { pushState(ST_LOOKING_FOR_VARNAME);
    return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
            }
          case 272: break;
          case 92: 
            { pushState(ST_IN_SCRIPTING);
    yypushback(yylength()-1);
    return createSymbol(ParserConstants.T_CURLY_OPEN_WITH_DOLAR);
            }
          case 273: break;
          case 93: 
            { return createSymbol(ParserConstants.T_CHARACTER);
            }
          case 274: break;
          case 94: 
            { yypushback(1);
	return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 275: break;
          case 95: 
            { String text = yytext();
    int length = text.length() - 1;
    text = text.trim();
    
    yypushback(1);
    
    if (text.endsWith(";")) {
        text = text.substring(0, text.length() - 1);
        yypushback(1);
    }
    if (text.equals(heredoc)) {
        heredoc = null;
        yybegin(ST_IN_SCRIPTING);
        return createSymbol(ParserConstants.T_END_HEREDOC);
    } else {
    	   yybegin(ST_HEREDOC);
    }
            }
          case 276: break;
          case 96: 
            { return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          case 277: break;
          case 97: 
            { /* treat numbers (almost) as strings inside encapsulated strings */
    return createFullSymbol(ParserConstants.T_NUM_STRING);
            }
          case 278: break;
          case 98: 
            { handleMultilineCommentEnd();
    yybegin(ST_IN_SCRIPTING);
            }
          case 279: break;
          case 99: 
            { handlePHPDocEnd();
     yybegin(ST_IN_SCRIPTING);
            }
          case 280: break;
          case 100: 
            { if (asp_tags || yytext().charAt(0)!='%') { /* asp comment? */
	    handleLineCommentEnd();
        yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
	}
            }
          case 281: break;
          case 101: 
            { String text = yytext();
    if ((text.charAt(1)=='%' && asp_tags)
        || (text.charAt(1)=='?' && short_tags_allowed)) {
        yybegin(ST_IN_SCRIPTING);
        return createSymbol(ParserConstants.T_OPEN_TAG_WITH_ECHO);
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
            }
          case 282: break;
          case 102: 
            { return createSymbol(ParserConstants.T_LOGICAL_XOR);
            }
          case 283: break;
          case 103: 
            { return createSymbol(ParserConstants.T_TRY);
            }
          case 284: break;
          case 104: 
            { return createFullSymbol(ParserConstants.T_EXIT);
            }
          case 285: break;
          case 105: 
            { return createSymbol(ParserConstants.T_FOR);
            }
          case 286: break;
          case 106: 
            { return createSymbol(ParserConstants.T_USE);
            }
          case 287: break;
          case 107: 
            { return createSymbol(ParserConstants.T_NEW);
            }
          case 288: break;
          case 108: 
            { return createSymbol(ParserConstants.T_LOGICAL_AND);
            }
          case 289: break;
          case 109: 
            { return createSymbol(ParserConstants.T_SR_EQUAL);
            }
          case 290: break;
          case 110: 
            { return createSymbol(ParserConstants.T_VAR);
            }
          case 291: break;
          case 111: 
            { return createSymbol(ParserConstants.T_IS_IDENTICAL);
            }
          case 292: break;
          case 112: 
            { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
            }
          case 293: break;
          case 113: 
            { return createSymbol(ParserConstants.T_SL_EQUAL);
            }
          case 294: break;
          case 114: 
            { if (parsePHPDoc()) {
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=316077
	// Reset the internal variables caching the values
	// previously resetted by parsePHPDoc().
	// Actually it would be enough to only reset zzEndReadL,
	// but do it cleanly...
	// Also be careful that those internal variables could
	// change from one version of JFlex to another.
	zzCurrentPosL = zzCurrentPos;
	zzMarkedPosL = zzMarkedPos;
	zzBufferL = zzBuffer;
	zzEndReadL = zzEndRead;
} else {
	handleCommentStart();
	yybegin(ST_DOCBLOCK);
}
            }
          case 295: break;
          case 115: 
            { yypushback(1);
	pushState(ST_VAR_OFFSET);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 296: break;
          case 116: 
            { String text = yytext();

    if (text.charAt(text.length() - 2)== ';') {
		text = text.substring(0, text.length() - 2);
        	yypushback(1);
    } else {
		text = text.substring(0, text.length() - 1);
    }
	
	int textLength = text.length();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && text.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		yypushback(2);
        	yybegin(ST_END_HEREDOC);
        	// we need to remove the closing label from the symbol value.
        	Symbol sym = createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
        	String value = (String)sym.value;
        	sym.value = value.substring(0, value.length() - heredocLength + 1);
	   	return sym;
	}
	yypushback(1);
            }
          case 297: break;
          case 117: 
            { return createSymbol(ParserConstants.T_ECHO);
            }
          case 298: break;
          case 118: 
            { return createSymbol(ParserConstants.T_ELSE);
            }
          case 299: break;
          case 119: 
            { return createSymbol(ParserConstants.T_EVAL);
            }
          case 300: break;
          case 120: 
            { return createSymbol(ParserConstants.T_CASE);
            }
          case 301: break;
          case 121: 
            { return createSymbol(ParserConstants.T_LIST);
            }
          case 302: break;
          case 122: 
            { handleCommentStart();
	handleMultilineCommentEnd();
            }
          case 303: break;
          case 123: 
            { return createSymbol(ParserConstants.T_ENDIF);
            }
          case 304: break;
          case 124: 
            { return createSymbol(ParserConstants.T_EMPTY);
            }
          case 305: break;
          case 125: 
            { return createSymbol(ParserConstants.T_BREAK);
            }
          case 306: break;
          case 126: 
            { return createSymbol(ParserConstants.T_ISSET);
            }
          case 307: break;
          case 127: 
            { return createSymbol(ParserConstants.T_THROW);
            }
          case 308: break;
          case 128: 
            { return createSymbol(ParserConstants.T_FINAL);
            }
          case 309: break;
          case 129: 
            { return createSymbol(ParserConstants.T_UNSET);
            }
          case 310: break;
          case 130: 
            { return createSymbol(ParserConstants.T_CONST);
            }
          case 311: break;
          case 131: 
            { return createSymbol(ParserConstants.T_CATCH);
            }
          case 312: break;
          case 132: 
            { return createSymbol(ParserConstants.T_CLONE);
            }
          case 313: break;
          case 133: 
            { return createSymbol(ParserConstants.T_CLASS);
            }
          case 314: break;
          case 134: 
            { return createSymbol(ParserConstants.T_ARRAY);
            }
          case 315: break;
          case 135: 
            { return createSymbol(ParserConstants.T_WHILE);
            }
          case 316: break;
          case 136: 
            { return createSymbol(ParserConstants.T_PRINT);
            }
          case 317: break;
          case 137: 
            { return createSymbol(ParserConstants.T_INT_CAST);
            }
          case 318: break;
          case 138: 
            { int removeChars = (yytext().charAt(0) == 'b')?4:3;
    heredoc = yytext().substring(removeChars).trim();    // for 'b<<<' or '<<<'
    yybegin(ST_START_HEREDOC);
    return createSymbol(ParserConstants.T_START_HEREDOC);
            }
          case 319: break;
          case 139: 
            { yypushback(3);
	pushState(ST_LOOKING_FOR_PROPERTY);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 320: break;
          case 140: 
            { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
            }
          case 321: break;
          case 141: 
            { return createSymbol(ParserConstants.T_ENDFOR);
            }
          case 322: break;
          case 142: 
            { return createSymbol(ParserConstants.T_ELSEIF);
            }
          case 323: break;
          case 143: 
            { /* not a keyword, hust for recognize constans.*/
    return createFullSymbol(ParserConstants.T_DEFINE);
            }
          case 324: break;
          case 144: 
            { return createSymbol(ParserConstants.T_STATIC);
            }
          case 325: break;
          case 145: 
            { return createSymbol(ParserConstants.T_SWITCH);
            }
          case 326: break;
          case 146: 
            { return createSymbol(ParserConstants.T_RETURN);
            }
          case 327: break;
          case 147: 
            { return createSymbol(ParserConstants.T_PUBLIC);
            }
          case 328: break;
          case 148: 
            { return createSymbol(ParserConstants.T_BOOL_CAST);
            }
          case 329: break;
          case 149: 
            { return createSymbol(ParserConstants.T_DOUBLE_CAST);
            }
          case 330: break;
          case 150: 
            { return createSymbol(ParserConstants.T_GLOBAL);
            }
          case 331: break;
          case 151: 
            { return createSymbol(ParserConstants.T_EXTENDS);
            }
          case 332: break;
          case 152: 
            { return createSymbol(ParserConstants.T_INCLUDE);
            }
          case 333: break;
          case 153: 
            { return createSymbol(ParserConstants.T_DEFAULT);
            }
          case 334: break;
          case 154: 
            { return createSymbol(ParserConstants.T_DECLARE);
            }
          case 335: break;
          case 155: 
            { return createSymbol(ParserConstants.T_FOREACH);
            }
          case 336: break;
          case 156: 
            { return createSymbol(ParserConstants.T_REQUIRE);
            }
          case 337: break;
          case 157: 
            { return createSymbol(ParserConstants.T_PRIVATE);
            }
          case 338: break;
          case 158: 
            { return createSymbol(ParserConstants.T_UNSET_CAST);
            }
          case 339: break;
          case 159: 
            { return createSymbol(ParserConstants.T_ARRAY_CAST);
            }
          case 340: break;
          case 160: 
            { return createSymbol(ParserConstants.T_ENDWHILE);
            }
          case 341: break;
          case 161: 
            { return createSymbol(ParserConstants.T_FUNCTION);
            }
          case 342: break;
          case 162: 
            { return createSymbol(ParserConstants.T_CONTINUE);
            }
          case 343: break;
          case 163: 
            { return createSymbol(ParserConstants.T_ABSTRACT);
            }
          case 344: break;
          case 164: 
            { return createSymbol(ParserConstants.T_STRING_CAST);
            }
          case 345: break;
          case 165: 
            { return createSymbol(ParserConstants.T_OBJECT_CAST);
            }
          case 346: break;
          case 166: 
            { return createSymbol(ParserConstants.T_FILE);
            }
          case 347: break;
          case 167: 
            { return createSymbol(ParserConstants.T_LINE);
            }
          case 348: break;
          case 168: 
            { return createSymbol(ParserConstants.T_ENDSWITCH);
            }
          case 349: break;
          case 169: 
            { return createSymbol(ParserConstants.T_INTERFACE);
            }
          case 350: break;
          case 170: 
            { return createSymbol(ParserConstants.T_PROTECTED);
            }
          case 351: break;
          case 171: 
            { return createSymbol(ParserConstants.T_CLASS_C);
            }
          case 352: break;
          case 172: 
            { return createSymbol(ParserConstants.T_ENDDECLARE);
            }
          case 353: break;
          case 173: 
            { return createSymbol(ParserConstants.T_ENDFOREACH);
            }
          case 354: break;
          case 174: 
            { return createSymbol(ParserConstants.T_INSTANCEOF);
            }
          case 355: break;
          case 175: 
            { return createSymbol(ParserConstants.T_IMPLEMENTS);
            }
          case 356: break;
          case 176: 
            { return createSymbol(ParserConstants.T_METHOD_C);
            }
          case 357: break;
          case 177: 
            { return createSymbol(ParserConstants.T_INCLUDE_ONCE);
            }
          case 358: break;
          case 178: 
            { return createSymbol(ParserConstants.T_REQUIRE_ONCE);
            }
          case 359: break;
          case 179: 
            { return createSymbol(ParserConstants.T_FUNC_C);
            }
          case 360: break;
          case 180: 
            { handleVarComment();
    //return createFullSymbol(ParserConstants.T_VAR_COMMENT);
            }
          case 361: break;
          case 181: 
            { return createSymbol(ParserConstants.T_HALT_COMPILER);
            }
          case 362: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java PhpAstLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          java.nio.charset.Charset.forName(encodingName); // Side-effect: is encodingName valid? 
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        PhpAstLexer scanner = null;
        try {
          java.io.FileInputStream stream = new java.io.FileInputStream(argv[i]);
          java.io.Reader reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new PhpAstLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
