/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;

public class UsePart
extends ASTNode {
    private FullyQualifiedReference namespace;
    private SimpleReference alias;
    private int statementType;

    public UsePart(FullyQualifiedReference namespace, SimpleReference alias) {
        this(namespace, alias, 0);
    }

    public UsePart(FullyQualifiedReference namespace, SimpleReference alias, int statementType) {
        this.setNamespace(namespace);
        this.setAlias(alias);
        this.statementType = statementType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[USE: ").append(this.getNamespace().getFullyQualifiedName());
        if (this.getAlias() != null) {
            buf.append(" AS ").append(this.getAlias().getName());
        }
        buf.append("]");
        return buf.toString();
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            this.getNamespace().traverse(visitor);
            if (this.getAlias() != null) {
                this.getAlias().traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public void setAlias(SimpleReference alias) {
        this.alias = alias;
    }

    public SimpleReference getAlias() {
        return this.alias;
    }

    public void setNamespace(FullyQualifiedReference namespace) {
        this.namespace = namespace;
    }

    public FullyQualifiedReference getNamespace() {
        return this.namespace;
    }

    public void setStatementType(int statementType) {
        this.statementType = statementType;
    }

    public int getStatementType() {
        return this.statementType;
    }
}

