/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.goals.ClassVariableDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;

public class FieldAccessEvaluator
extends GoalEvaluator {
    private static final int STATE_INIT = 0;
    private static final int STATE_WAITING_RECEIVER = 1;
    private static final int STATE_GOT_RECEIVER = 2;
    private static final int STATE_WAITING_FIELD_PHPDOC = 3;
    private static final int STATE_WAITING_FIELD = 4;
    private int state = 0;
    private IEvaluatedType receiverType;
    private IEvaluatedType result;

    public FieldAccessEvaluator(IGoal goal) {
        super(goal);
    }

    private IGoal[] produceNextSubgoal(IGoal previousGoal, IEvaluatedType previousResult, GoalState goalState) {
        String variableName;
        Expression field;
        Expression receiver;
        Expression fieldAccess;
        ExpressionTypeGoal typedGoal = (ExpressionTypeGoal)this.goal;
        Expression expression = (Expression)typedGoal.getExpression();
        if (expression instanceof FieldAccess) {
            fieldAccess = (FieldAccess)expression;
            receiver = fieldAccess.getDispatcher();
            field = fieldAccess.getField();
        } else if (expression instanceof StaticFieldAccess) {
            fieldAccess = (StaticFieldAccess)expression;
            receiver = fieldAccess.getDispatcher();
            field = fieldAccess.getField();
        } else {
            return null;
        }
        int offset = 0;
        if (field instanceof VariableReference) {
            variableName = ((VariableReference)field).getName();
            offset = ((VariableReference)field).sourceStart();
        } else if (field instanceof SimpleReference) {
            variableName = String.valueOf('$') + ((SimpleReference)field).getName();
            offset = ((SimpleReference)field).sourceStart();
        } else {
            return null;
        }
        if (this.state == 0) {
            if (receiver == null) {
                this.state = 2;
            } else {
                this.state = 1;
                return new IGoal[]{new ExpressionTypeGoal(this.goal.getContext(), (ASTNode)receiver)};
            }
        }
        if (this.state == 1) {
            this.receiverType = previousResult;
            if (this.receiverType == null) {
                return null;
            }
            this.state = 2;
        }
        if (this.state == 2) {
            this.state = 3;
            TypeContext typeContext = new TypeContext((ISourceModuleContext)this.goal.getContext(), this.receiverType);
            if (this.goal.getContext() instanceof IModelCacheContext) {
                typeContext.setCache(((IModelCacheContext)this.goal.getContext()).getCache());
            }
            return new IGoal[]{new PHPDocClassVariableGoal(typeContext, variableName, offset)};
        }
        if (this.state == 3) {
            if (goalState != GoalState.PRUNED && previousResult != null && previousResult != UnknownType.INSTANCE) {
                this.result = previousResult;
                return null;
            }
            this.state = 4;
            TypeContext typeContext = new TypeContext((ISourceModuleContext)this.goal.getContext(), this.receiverType);
            if (this.goal.getContext() instanceof IModelCacheContext) {
                typeContext.setCache(((IModelCacheContext)this.goal.getContext()).getCache());
            }
            return new IGoal[]{new ClassVariableDeclarationGoal(typeContext, variableName)};
        }
        if (this.state == 4 && goalState != GoalState.PRUNED && previousResult != null && previousResult != UnknownType.INSTANCE) {
            this.result = previousResult;
        }
        return null;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] init() {
        IGoal[] goals = this.produceNextSubgoal(null, null, null);
        if (goals != null) {
            return goals;
        }
        return IGoal.NO_GOALS;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        IGoal[] goals = this.produceNextSubgoal(subgoal, (IEvaluatedType)result, state);
        if (goals != null) {
            return goals;
        }
        return IGoal.NO_GOALS;
    }
}

