/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;

public class PHPDocClassVariableEvaluator
extends AbstractPHPGoalEvaluator {
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocClassVariableEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        int n;
        int n2;
        Object[] objectArray;
        int index;
        PHPDocClassVariableGoal typedGoal = (PHPDocClassVariableGoal)this.goal;
        TypeContext context = (TypeContext)typedGoal.getContext();
        String variableName = typedGoal.getVariableName();
        int offset = typedGoal.getOffset();
        IModelAccessCache cache = context.getCache();
        IType[] types = PHPTypeInferenceUtils.getModelElements(context.getInstanceType(), (ISourceModuleContext)context, offset, cache);
        HashMap<PHPDocBlock, IField> docs = new HashMap<PHPDocBlock, IField>();
        if (variableName.endsWith("]") && (index = variableName.indexOf("[")) != -1) {
            variableName = variableName.substring(0, index);
        }
        if (types != null) {
            IType[] iTypeArray = types;
            int n3 = types.length;
            int n4 = 0;
            while (n4 < n3) {
                block10: {
                    IType type = iTypeArray[n4];
                    try {
                        IType[] superTypes;
                        ITypeHierarchy superHierarchy = cache != null ? cache.getSuperTypeHierarchy(type, null) : type.newSupertypeHierarchy(null);
                        objectArray = superTypes = superHierarchy.getAllTypes();
                        n2 = superTypes.length;
                        n = 0;
                        while (n < n2) {
                            PHPDocBlock docBlock;
                            IType superType = objectArray[n];
                            IField[] typeField = PHPModelUtils.getTypeField(superType, variableName, true);
                            if (typeField.length > 0 && (docBlock = PHPModelUtils.getDocBlock(typeField[0])) != null) {
                                docs.put(docBlock, typeField[0]);
                            }
                            ++n;
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block10;
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
        }
        for (Map.Entry entry : docs.entrySet()) {
            PHPDocBlock doc = (PHPDocBlock)((Object)entry.getKey());
            IField typeField = (IField)entry.getValue();
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)typeField);
            IType space = currentNamespace != null ? currentNamespace : typeField.getSourceModule();
            objectArray = doc.getTags(12);
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IType tag = objectArray[n];
                if (tag.getVariableReference() == null || tag.getVariableReference().getName().equals(variableName)) {
                    this.evaluated.addAll(Arrays.asList(PHPEvaluationUtils.evaluatePHPDocType(tag.getTypeReferences(), (IModelElement)space, tag.sourceStart(), null)));
                }
                ++n;
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    public static MultiTypeType getArrayType(String type, IType currentNamespace, int offset) {
        return PHPEvaluationUtils.getArrayType(type, currentNamespace, offset);
    }
}

