/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.internal.core.IUniqueIdentityElement;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.UniqueIdentityElementUtil;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPExeException;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.preferences.IPHPexeItemListener;
import org.eclipse.php.internal.debug.core.preferences.IPHPexeItemProperties;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItemEvent;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;

public class PHPexeItem
implements IUniqueIdentityElement,
IPHPexeItemProperties {
    public static final String SAPI_CLI = "CLI";
    public static final String SAPI_CGI = "CGI";
    public static final String ID_PREFIX = "php-exe";
    private String uniqueId;
    private boolean editable = true;
    private List<PHPVersion> defaultForPHPVersionList = new ArrayList<PHPVersion>();
    private final Map<String, Object> properties;
    private final ListenerList listeners = new ListenerList();
    private final EventNotifier notifier;

    public PHPexeItem() {
        this.setUniqueId(UniqueIdentityElementUtil.generateId((String)ID_PREFIX));
        this.properties = new HashMap<String, Object>();
        this.notifier = new EventNotifier();
        this.setDebuggerID("org.eclipse.php.debug.core.noneDebugger");
    }

    public PHPexeItem(String name, File executable, File iniLocation, String debuggerID, boolean editable) {
        this();
        this.editable = editable;
        this.setName(name);
        this.setExecutable(executable);
        this.setINILocation(iniLocation);
        this.setDebuggerID(debuggerID);
        this.detectFromPHPExe();
    }

    PHPexeItem(String name, String executable, String config, String debuggerID, boolean loadDefaultINI) {
        this();
        this.setName(name);
        this.setDebuggerID(debuggerID);
        this.setExecutable(new File(executable));
        if (config != null && config.length() > 0) {
            this.setINILocation(new File(config));
        }
        this.setLoadDefaultINI(loadDefaultINI);
        this.detectFromPHPExe();
    }

    final void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void addPHPexeListener(IPHPexeItemListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePHPexeListener(IPHPexeItemListener listener) {
        this.listeners.remove((Object)listener);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getName() {
        return (String)this.properties.get("name");
    }

    public File getExecutable() {
        return (File)this.properties.get("exe-location");
    }

    public File getINILocation() {
        return (File)this.properties.get("ini-location");
    }

    public File getDetectedINILocation() {
        return (File)this.properties.get("ini-detected-location");
    }

    public String getDebuggerID() {
        return (String)this.properties.get("debugger-id");
    }

    public String getSapiType() {
        return (String)this.properties.get("sapi-type");
    }

    public String getVersion() {
        return (String)this.properties.get("version");
    }

    public void setDebuggerID(String debuggerID) {
        this.setProperty("debugger-id", debuggerID);
    }

    public void setDetectedINILocation(File location) {
        this.setProperty("ini-detected-location", location);
    }

    public void setINILocation(File location) {
        this.setProperty("ini-location", location);
    }

    public void setLoadDefaultINI(boolean loadDefaultINI) {
        this.setProperty("use-default-ini", loadDefaultINI);
    }

    public void setSapiType(String sapiType) {
        this.setProperty("sapi-type", sapiType);
    }

    public void setName(String name) {
        this.setProperty("name", name);
    }

    public void setExecutable(File executable) {
        if (executable != null && executable.equals(this.getExecutable())) {
            return;
        }
        this.setProperty("exe-location", executable);
        this.setProperty("ini-location", null);
    }

    public void setVersion(String version) {
        this.setProperty("version", version);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDefault() {
        return this.getName().equals(InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").get(PHPDebugCorePreferenceNames.DEFAULT_PHP, null));
    }

    public boolean isLoadDefaultINI() {
        Boolean isLoadDefaultINI = (Boolean)this.properties.get("use-default-ini");
        return isLoadDefaultINI != null ? isLoadDefaultINI : false;
    }

    public PHPexeItem makeCopy() {
        PHPexeItem copy = new PHPexeItem();
        copy.uniqueId = this.uniqueId;
        copy.editable = this.editable;
        copy.defaultForPHPVersionList = new ArrayList<PHPVersion>(this.defaultForPHPVersionList);
        copy.setSapiType(this.getSapiType());
        copy.setName(this.getName());
        copy.setINILocation(this.getINILocation());
        copy.setDetectedINILocation(this.getDetectedINILocation());
        copy.setExecutable(this.getExecutable());
        copy.setVersion(this.getVersion());
        copy.setLoadDefaultINI(this.isLoadDefaultINI());
        copy.setDebuggerID(this.getDebuggerID());
        return copy;
    }

    void addPHPVersionToDefaultList(PHPVersion phpVersion) {
        this.defaultForPHPVersionList.add(phpVersion);
    }

    void removePHPVersionToDefaultList(PHPVersion phpVersion) {
        this.defaultForPHPVersionList.remove(phpVersion);
    }

    int geDefaultForPHPVersionSize() {
        return this.defaultForPHPVersionList.size();
    }

    PHPVersion getPHPVersionAtDefaultList(int index) {
        assert (this.geDefaultForPHPVersionSize() > index);
        return this.defaultForPHPVersionList.get(index);
    }

    void setDefaultForPHPVersion(PHPexes phpexes, PHPVersion phpVersion) {
        phpexes.setItemDefaultForPHPVersion(this, phpVersion);
    }

    protected void detectFromPHPExe() {
        PHPExeUtil.PHPExeInfo phpInfo;
        try {
            phpInfo = PHPExeUtil.getPHPInfo(this.getExecutable(), false);
            if (phpInfo == null) {
                return;
            }
        }
        catch (PHPExeException e) {
            Logger.logException("Could not obtain PHP executable info.", e);
            return;
        }
        if (this.getName() == null) {
            this.setName(phpInfo.getName());
        }
        if (this.getSapiType() == null) {
            this.setSapiType(phpInfo.getSapiType());
        }
        if (this.getDetectedINILocation() == null) {
            this.setDetectedINILocation(phpInfo.getSystemINIFile());
        }
        if (this.getVersion() == null) {
            this.setVersion(phpInfo.getVersion());
        }
    }

    private void setProperty(String key, Object newValue) {
        Object oldValue = this.properties.put(key, newValue);
        if (oldValue == null && newValue == null) {
            return;
        }
        if (oldValue == null && newValue != null || oldValue != null && newValue == null || !oldValue.equals(newValue)) {
            this.fireEvent(key, oldValue, newValue);
        }
    }

    private void fireEvent(String key, Object oldValue, Object newValue) {
        this.notifier.notify(key, oldValue, newValue);
    }

    private final class EventNotifier {
        private EventNotifier() {
        }

        void notify(String key, Object oldValue, Object newValue) {
            PHPexeItemEvent event = new PHPexeItemEvent(PHPexeItem.this, key, oldValue, newValue);
            Object[] objectArray = PHPexeItem.this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPHPexeItemListener)listener).phpExeChanged(event);
                ++n2;
            }
        }
    }
}

