/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;

public abstract class AbstractDBGpBaseVariable
extends DBGpElement
implements IVariable,
IVariableFacet {
    private String stackLevel;
    private String fullName;
    private String address;
    private final Set<IVariableFacet.Facet> facets = new HashSet<IVariableFacet.Facet>();

    public AbstractDBGpBaseVariable(IDebugTarget target, String stackLevel, String fullName, IVariableFacet.Facet ... facets) {
        super(target);
        this.stackLevel = stackLevel;
        this.fullName = fullName;
        this.addFacets(facets);
    }

    public AbstractDBGpBaseVariable(IDebugTarget target, String stackLevel, IVariableFacet.Facet ... facets) {
        super(target);
        this.stackLevel = stackLevel;
        this.addFacets(facets);
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    @Override
    public void addFacets(IVariableFacet.Facet ... facets) {
        IVariableFacet.Facet[] facetArray = facets;
        int n = facets.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableFacet.Facet facet = facetArray[n2];
            this.facets.add(facet);
            ++n2;
        }
    }

    @Override
    public boolean hasFacet(IVariableFacet.Facet facet) {
        return this.facets.contains((Object)facet);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getStackLevel() {
        return this.stackLevel;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

