/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.parameters;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.debug.core.debugger.parameters.IWebDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.zend.debugger.parameters.AbstractDebugParametersInitializer;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class DefaultDebugParametersInitializer
extends AbstractDebugParametersInitializer
implements IWebDebugParametersInitializer {
    @Override
    public Hashtable<String, String> getDebugParameters(ILaunch launch) {
        String sessID;
        String url;
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        parameters.put("start_debug", "1");
        String port = launch.getAttribute("port");
        if (port != null) {
            parameters.put("debug_port", port);
        } else {
            PHPDebugPlugin.logErrorMessage("A port was not defined for the DefaultDebugParametersInitializer.");
        }
        if (this.getBooleanValue(launch.getAttribute("passiveDebug"))) {
            parameters.put("debug_passive", "1");
        }
        parameters.put("send_sess_end", "1");
        if (this.getBooleanValue(launch.getAttribute("webServerDebugger"))) {
            String debugHosts = PHPDebugPlugin.getDebugHosts();
            if (launchConfiguration != null) {
                try {
                    Server server = ServersManager.getServer((String)launchConfiguration.getAttribute("name", ""));
                    String customHosts = ZendDebuggerSettingsUtil.getDebugHosts(server.getUniqueId());
                    if (!customHosts.isEmpty()) {
                        debugHosts = customHosts;
                    }
                }
                catch (CoreException ce) {
                    Logger.logException(ce);
                }
            }
            parameters.put("debug_host", debugHosts);
            parameters.put("debug_no_cache", Long.toString(System.currentTimeMillis()));
        }
        if ("debug".equals(launch.getLaunchMode()) && this.getBooleanValue(launch.getAttribute("firstLineBreakpoint"))) {
            parameters.put("debug_stop", "1");
        }
        if ((url = launch.getAttribute("uriginalURL")) != null) {
            parameters.put("original_url", url);
        }
        if (launchConfiguration != null) {
            try {
                String sessionSetting = launchConfiguration.getAttribute("debugPages", "debugAllPages");
                if ("debugAllPages".equals(sessionSetting)) {
                    parameters.put("debug_start_session", "1");
                } else if ("debugFirstPage".equals(sessionSetting)) {
                    parameters.put("debug_new_session", "1");
                } else if ("debugFrom".equals(sessionSetting)) {
                    parameters.put("debug_start_url", launchConfiguration.getAttribute("debugContinue", ""));
                    if (launchConfiguration.getAttribute("debugFromURL", false)) {
                        parameters.put("debug_cont_session", "1");
                    }
                }
            }
            catch (CoreException ce) {
                Logger.logException(ce);
            }
        }
        if ((sessID = launch.getAttribute("debugSessionID")) != null) {
            parameters.put("debug_session_id", sessID);
        }
        return parameters;
    }

    @Override
    public URL getRequestURL(ILaunch launch) {
        String url = launch.getAttribute("uriginalURL");
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            Logger.logException("Malformed URL: " + url, e);
            return null;
        }
    }

    public boolean getBooleanValue(String value) {
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    @Override
    public Hashtable<String, String> getRequestCookies(ILaunch launch) {
        return null;
    }

    @Override
    public Hashtable<String, String> getRequestHeaders(ILaunch launch) {
        return null;
    }

    @Override
    public String getRequestMethod(ILaunch launch) {
        return null;
    }

    @Override
    public Hashtable<String, String> getRequestParameters(ILaunch launch) {
        return null;
    }

    @Override
    public String getRequestRawData(ILaunch launch) {
        return null;
    }
}

