/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandlersManager;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPExeVerifier;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPsSearchResultDialog;
import org.eclipse.php.internal.debug.ui.wizards.ClosableWizardDialog;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeEditDialog;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeWizard;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class InstalledPHPsBlock {
    private static final String[] PHP_CANDIDATE_BIN = new String[]{"php", "php-cli", "php-cgi", "php.exe", "php-cli.exe", "php-cgi.exe"};
    private Button fAddButton;
    private Composite fControl;
    private Button fEditButton;
    private TableViewer fPHPExeList;
    private final List<PHPexeItem> fPHPexes = new ArrayList<PHPexeItem>();
    private Button fRemoveButton;
    private boolean fResizingTable = false;
    private Button fSearchButton;
    private Button fSetDefaultButton;
    private final ListenerList fSelectionListeners = new ListenerList(1);
    private int fSortColumn = 0;
    private float fWeight1 = 0.375f;
    private float fWeight2 = 0.25f;
    private float fWeight3 = 0.375f;

    private void addPHPexe() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor monitor = new NullProgressMonitor();
        PHPexeItem phpExeItem = null;
        PHPExeWizard wizard = new PHPExeWizard(PHPexes.getInstance().getAllItems());
        ClosableWizardDialog dialog = new ClosableWizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 1) {
            monitor.setCanceled(true);
            return;
        }
        phpExeItem = (PHPexeItem)wizard.getRootFragment().getWizardModel().getObject("phpExe");
        this.fPHPexes.add(phpExeItem);
        PHPexes.getInstance().addItem(phpExeItem);
        this.fPHPExeList.refresh();
        this.commitChanges();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    protected void configureTableResizing(final Composite parent, final Composite buttons, final Table table, final TableColumn column1, final TableColumn column2, final TableColumn column3) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                InstalledPHPsBlock.this.resizeTable(parent, buttons, table, column1, column2, column3);
            }
        });
        table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                table.removeListener(9, (Listener)this);
                InstalledPHPsBlock.this.resizeTable(parent, buttons, table, column1, column2, column3);
            }
        });
        column1.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (column1.getWidth() > 0 && !InstalledPHPsBlock.this.fResizingTable) {
                    InstalledPHPsBlock.this.fWeight1 = InstalledPHPsBlock.this.getColumnWeight(0);
                }
            }
        });
        column2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (column2.getWidth() > 0 && !InstalledPHPsBlock.this.fResizingTable) {
                    InstalledPHPsBlock.this.fWeight2 = InstalledPHPsBlock.this.getColumnWeight(1);
                }
            }
        });
        column3.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (column3.getWidth() > 0 && !InstalledPHPsBlock.this.fResizingTable) {
                    InstalledPHPsBlock.this.fWeight3 = InstalledPHPsBlock.this.getColumnWeight(2);
                }
            }
        });
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        this.fControl = parent;
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText(PHPDebugUIMessages.InstalledPHPsBlock_15);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)data);
        tableLabel.setFont(font);
        Table table = new Table(parent, 67586);
        data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(PHPDebugUIMessages.InstalledPHPsBlock_0);
        column1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledPHPsBlock.this.sortByName();
            }
        });
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(PHPDebugUIMessages.InstalledPHPsBlock_17);
        column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledPHPsBlock.this.sortByDebugger();
            }
        });
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(PHPDebugUIMessages.InstalledPHPsBlock_1);
        column3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledPHPsBlock.this.sortByLocation();
            }
        });
        this.fPHPExeList = new CheckboxTableViewer(table);
        this.fPHPExeList.setLabelProvider((IBaseLabelProvider)new PHPExeLabelProvider());
        this.fPHPExeList.setContentProvider((IContentProvider)new PHPsContentProvider());
        this.fPHPExeList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InstalledPHPsBlock.this.enableButtons();
            }
        });
        this.fPHPExeList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!InstalledPHPsBlock.this.fPHPExeList.getSelection().isEmpty()) {
                    InstalledPHPsBlock.this.editPHPexe();
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (InstalledPHPsBlock.this.fRemoveButton != null && !InstalledPHPsBlock.this.fRemoveButton.isDisposed() && !InstalledPHPsBlock.this.fRemoveButton.isEnabled()) {
                    return;
                }
                if (event.character == '\u007f' && event.stateMask == 0) {
                    InstalledPHPsBlock.this.removePHPexes();
                }
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setFont(font);
        this.fAddButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_3);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledPHPsBlock.this.addPHPexe();
            }
        });
        this.fEditButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_4);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledPHPsBlock.this.editPHPexe();
            }
        });
        this.fRemoveButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_5);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledPHPsBlock.this.removePHPexes();
            }
        });
        this.fSetDefaultButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_setDefault);
        this.fSetDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPexeItem defaultItem = (PHPexeItem)((IStructuredSelection)InstalledPHPsBlock.this.fPHPExeList.getSelection()).getFirstElement();
                PHPexes.getInstance().setDefaultItem(defaultItem);
                InstalledPHPsBlock.this.commitChanges();
                InstalledPHPsBlock.this.setPHPs(PHPexes.getInstance().getAllItems());
            }
        });
        Label separator = new Label(buttons, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fSearchButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_6);
        this.fSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledPHPsBlock.this.search();
            }
        });
        this.configureTableResizing(parent, buttons, table, column1, column2, column3);
        this.fillWithWorkspacePHPs();
        this.sortByDebugger();
        this.enableButtons();
    }

    protected Button createPushButton(Composite parent, String label) {
        return SWTUtil.createPushButton((Composite)parent, (String)label, null);
    }

    private void editPHPexe() {
        IStructuredSelection selection = (IStructuredSelection)this.fPHPExeList.getSelection();
        PHPexeItem phpExe = (PHPexeItem)selection.getFirstElement();
        if (phpExe == null) {
            return;
        }
        PHPExeEditDialog dialog = new PHPExeEditDialog(this.getShell(), phpExe, PHPexes.getInstance().getAllItems());
        if (dialog.open() != 0) {
            return;
        }
        this.fPHPExeList.refresh();
        this.commitChanges();
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fPHPExeList.getSelection();
        Object[] elements = selection.toArray();
        boolean canRemoveOrEdit = true;
        int i = 0;
        while (canRemoveOrEdit && i < elements.length) {
            PHPexeItem item = (PHPexeItem)elements[i];
            canRemoveOrEdit &= item.isEditable();
            ++i;
        }
        int selectionCount = selection.size();
        this.fRemoveButton.setEnabled(canRemoveOrEdit && selectionCount > 0);
        PHPexeItem selectedItem = (PHPexeItem)((IStructuredSelection)this.fPHPExeList.getSelection()).getFirstElement();
        this.fSetDefaultButton.setEnabled(selectionCount == 1 && selectedItem != null && !selectedItem.isDefault());
    }

    protected void fillWithWorkspacePHPs() {
        PHPexeItem[] items = PHPexes.getInstance().getAllItems();
        this.setPHPs(items);
    }

    private float getColumnWeight(int col) {
        Table table;
        int tableWidth = table.getSize().x;
        table = this.fPHPExeList.getTable();
        int columnWidth = table.getColumn(col).getWidth();
        if (tableWidth > columnWidth) {
            return (float)columnWidth / (float)tableWidth;
        }
        return 0.33333334f;
    }

    public Control getControl() {
        return this.fControl;
    }

    public PHPexeItem[] getPHPs() {
        return this.fPHPexes.toArray(new PHPexeItem[this.fPHPexes.size()]);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public boolean isDuplicateName(String name) {
        int i = 0;
        while (i < this.fPHPexes.size()) {
            PHPexeItem phpExe = this.fPHPexes.get(i);
            if (phpExe.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removePHPexes() {
        IStructuredSelection selection = (IStructuredSelection)this.fPHPExeList.getSelection();
        PHPexeItem[] phpExes = new PHPexeItem[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            phpExes[i] = (PHPexeItem)iter.next();
            ++i;
        }
        this.removePHPs(phpExes);
        this.commitChanges();
    }

    public void commitChanges() {
        PHPexes.getInstance().save();
    }

    public void removePHPs(PHPexeItem[] phpExes) {
        PHPexeItem[] pHPexeItemArray = phpExes;
        int n = phpExes.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem element = pHPexeItemArray[n2];
            this.fPHPexes.remove(element);
            PHPexes.getInstance().removeItem(element);
            ++n2;
        }
        this.fPHPExeList.refresh();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    private void resizeTable(Composite parent, Composite buttons, Table table, TableColumn column1, TableColumn column2, TableColumn column3) {
        this.fResizingTable = true;
        int parentWidth = -1;
        int parentHeight = -1;
        if (parent.isVisible()) {
            Rectangle area = parent.getClientArea();
            parentWidth = area.width;
            parentHeight = area.height;
        } else {
            Point parentSize = parent.computeSize(-1, -1);
            parentWidth = parentSize.x;
            parentHeight = parentSize.y;
        }
        Point preferredSize = table.computeSize(-1, -1);
        int width = parentWidth - 2 * table.getBorderWidth();
        if (preferredSize.y > parentHeight) {
            Point vBarSize = table.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = table.getSize();
        if (oldSize.x > (width -= buttons.getSize().x)) {
            column1.setWidth(Math.round((float)width * this.fWeight1));
            column2.setWidth(Math.round((float)width * this.fWeight2));
            column3.setWidth(Math.round((float)width * this.fWeight3));
            table.setSize(width, parentHeight);
        } else {
            table.setSize(width, parentHeight);
            column1.setWidth(Math.round((float)width * this.fWeight1));
            column2.setWidth(Math.round((float)width * this.fWeight2));
            column3.setWidth(Math.round((float)width * this.fWeight3));
        }
        this.fResizingTable = false;
    }

    public void restoreColumnSettings(IDialogSettings settings, String qualifier) {
        this.fWeight1 = this.restoreColumnWeight(settings, qualifier, 0);
        this.fWeight2 = this.restoreColumnWeight(settings, qualifier, 1);
        this.fWeight3 = this.restoreColumnWeight(settings, qualifier, 2);
        this.fPHPExeList.getTable().layout(true);
        try {
            this.fSortColumn = settings.getInt(String.valueOf(qualifier) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSortColumn = 1;
        }
        switch (this.fSortColumn) {
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByDebugger();
                break;
            }
            case 3: {
                this.sortByLocation();
                break;
            }
            case 4: {
                this.sortByType();
            }
        }
    }

    private float restoreColumnWeight(IDialogSettings settings, String qualifier, int col) {
        try {
            return settings.getFloat(String.valueOf(qualifier) + ".column" + col);
        }
        catch (NumberFormatException numberFormatException) {
            switch (col) {
                case 1: {
                    return 0.25f;
                }
            }
            return 0.375f;
        }
    }

    public void saveColumnSettings(IDialogSettings settings, String qualifier) {
        int i = 0;
        while (i < 3) {
            settings.put(String.valueOf(qualifier) + ".column" + i, this.getColumnWeight(i));
            ++i;
        }
        settings.put(String.valueOf(qualifier) + ".sortColumn", this.fSortColumn);
    }

    protected void search() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(PHPDebugUIMessages.InstalledPHPsBlock_9);
        dialog.setText(PHPDebugUIMessages.InstalledPHPsBlock_10);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        final File rootDir = new File(path);
        final ArrayList locations = new ArrayList();
        final ArrayList<PHPexeItem> found = new ArrayList<PHPexeItem>();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(PHPDebugUIMessages.InstalledPHPsBlock_11, -1);
                InstalledPHPsBlock.this.search(rootDir, locations, monitor);
                if (!locations.isEmpty()) {
                    monitor.setTaskName(PHPDebugUIMessages.InstalledPHPsBlock_Processing_search_results);
                    Iterator iter2 = locations.iterator();
                    while (iter2.hasNext()) {
                        AbstractDebuggerConfiguration[] debuggers;
                        if (monitor.isCanceled()) break;
                        File location = (File)iter2.next();
                        PHPexeItem phpExe = new PHPexeItem(null, location, null, null, true);
                        if (phpExe.getName() == null) continue;
                        String nameCopy = new String(phpExe.getName());
                        monitor.subTask(MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_Fetching_php_exe_info, nameCopy));
                        List modules = PHPExeUtil.getModules((PHPexeItem)phpExe);
                        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggers = PHPDebuggersRegistry.getDebuggersConfigurations();
                        int n = debuggers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AbstractDebuggerConfiguration debugger = abstractDebuggerConfigurationArray[n2];
                            for (PHPExeUtil.PHPModuleInfo m : modules) {
                                if (!m.getName().equalsIgnoreCase(debugger.getModuleId())) continue;
                                phpExe.setDebuggerID(debugger.getDebuggerId());
                                break;
                            }
                            ++n2;
                        }
                        if (phpExe.getDebuggerID() == null) {
                            phpExe.setDebuggerID("org.eclipse.php.debug.core.noneDebugger");
                        }
                        int i = 1;
                        block3: while (true) {
                            if (InstalledPHPsBlock.this.isDuplicateName(nameCopy)) {
                                nameCopy = String.valueOf(phpExe.getName()) + ' ' + '[' + i++ + ']';
                                continue;
                            }
                            for (PHPexeItem item : found) {
                                if (!nameCopy.equalsIgnoreCase(item.getName())) continue;
                                nameCopy = String.valueOf(phpExe.getName()) + ' ' + '[' + i++ + ']';
                                continue block3;
                            }
                            break;
                        }
                        phpExe.setName(nameCopy);
                        if (phpExe.getExecutable() == null) continue;
                        found.add(phpExe);
                    }
                }
                monitor.done();
            }
        };
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(PHPDebugUIMessages.InstalledPHPsBlock_PHP_executables_search);
                }
            };
            progress.run(true, true, r);
        }
        catch (InvocationTargetException e) {
            PHPDebugUIPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (!found.isEmpty()) {
            Comparator<PHPexeItem> sorter = new Comparator<PHPexeItem>(){

                @Override
                public int compare(PHPexeItem a, PHPexeItem b) {
                    return b.getVersion().compareTo(a.getVersion());
                }
            };
            Collections.sort(found, sorter);
            PHPsSearchResultDialog searchDialog = new PHPsSearchResultDialog(found, MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_Search_result_dialog_message, path));
            searchDialog.open();
            List<PHPexeItem> itemsToAdd = searchDialog.getPHPExecutables();
            for (PHPexeItem item : itemsToAdd) {
                this.fPHPexes.add(item);
                PHPexes.getInstance().addItem(item);
                PHPexes.getInstance().save();
                DBGpProxyHandlersManager.INSTANCE.registerHandler(item.getUniqueId());
                PHPExeVerifier.verify(PHPexes.getInstance().getAllItems());
            }
            this.fPHPExeList.refresh();
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)PHPDebugUIMessages.InstalledPHPsBlock_12, (String)MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_13, path));
        }
    }

    protected void search(File directory, List<File> found, IProgressMonitor monitor) {
        String[] names;
        if (monitor.isCanceled()) {
            return;
        }
        List<File> foundExecs = InstalledPHPsBlock.findPHPExecutable(directory);
        if (!foundExecs.isEmpty()) {
            found.addAll(foundExecs);
            monitor.setTaskName(MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_Searching_with_found, found.size()));
        }
        if ((names = directory.list()) == null) {
            return;
        }
        ArrayList<File> subDirs = new ArrayList<File>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            File file = new File(directory, element);
            if (file.isDirectory()) {
                try {
                    monitor.subTask(MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_14, file.getCanonicalPath()));
                }
                catch (IOException iOException) {}
                if (monitor.isCanceled()) {
                    return;
                }
                subDirs.add(file);
            }
            ++n2;
        }
        while (!subDirs.isEmpty()) {
            File subDir = (File)subDirs.remove(0);
            this.search(subDir, found, monitor);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    private static List<File> findPHPExecutable(File phpLocation) {
        ArrayList<File> found = new ArrayList<File>(0);
        String[] stringArray = PHP_CANDIDATE_BIN;
        int n = PHP_CANDIDATE_BIN.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            File phpExecFile = new File(phpLocation, element);
            if (phpExecFile.exists() && !phpExecFile.isDirectory()) {
                found.add(phpExecFile);
            }
            ++n2;
        }
        return found;
    }

    protected void setPHPs(PHPexeItem[] phpExes) {
        this.fPHPexes.clear();
        PHPexeItem[] pHPexeItemArray = phpExes;
        int n = phpExes.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem element = pHPexeItemArray[n2];
            this.fPHPexes.add(element);
            ++n2;
        }
        this.fPHPExeList.setInput(this.fPHPexes);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                InstalledPHPsBlock.this.fPHPExeList.refresh();
            }
        });
    }

    private void sortByLocation() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PHPexeItem && e2 instanceof PHPexeItem) {
                    PHPexeItem left = (PHPexeItem)e1;
                    PHPexeItem right = (PHPexeItem)e2;
                    return left.getExecutable().getAbsolutePath().compareToIgnoreCase(right.getExecutable().getAbsolutePath());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 2;
    }

    private void sortByDebugger() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PHPexeItem && e2 instanceof PHPexeItem) {
                    PHPexeItem left = (PHPexeItem)e1;
                    PHPexeItem right = (PHPexeItem)e2;
                    String leftDebugger = PHPDebuggersRegistry.getDebuggerName((String)left.getDebuggerID());
                    String rightDebugger = PHPDebuggersRegistry.getDebuggerName((String)right.getDebuggerID());
                    return rightDebugger.compareToIgnoreCase(leftDebugger);
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 3;
    }

    private void sortByName() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PHPexeItem && e2 instanceof PHPexeItem) {
                    PHPexeItem left = (PHPexeItem)e1;
                    PHPexeItem right = (PHPexeItem)e2;
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 1;
    }

    private void sortByType() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PHPexeItem && e2 instanceof PHPexeItem) {
                    String rightType;
                    PHPexeItem left = (PHPexeItem)e1;
                    PHPexeItem right = (PHPexeItem)e2;
                    String leftType = left.getName();
                    int res = leftType.compareToIgnoreCase(rightType = right.getName());
                    if (res != 0) {
                        return res;
                    }
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 3;
    }

    class PHPExeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        PHPExeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PHPDebugUIImages.get("IMG_OBJ_PHP_EXE");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PHPexeItem) {
                PHPexeItem phpExe = (PHPexeItem)element;
                switch (columnIndex) {
                    case 0: {
                        if (this.isDefault(element)) {
                            return String.valueOf(phpExe.getName()) + PHPDebugUIMessages.PHPsPreferencePage_WorkspaceDefault;
                        }
                        return phpExe.getName();
                    }
                    case 1: {
                        String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)phpExe.getDebuggerID());
                        if (debuggerName == null) {
                            debuggerName = "";
                        }
                        return debuggerName;
                    }
                    case 2: {
                        File executable = phpExe.getExecutable();
                        if (executable == null) {
                            return "";
                        }
                        return executable.getAbsolutePath();
                    }
                }
            }
            return element.toString();
        }

        public Font getFont(Object element) {
            if (this.isDefault(element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        private boolean isDefault(Object element) {
            if (element instanceof PHPexeItem) {
                return ((PHPexeItem)element).isDefault();
            }
            return false;
        }
    }

    class PHPsContentProvider
    implements IStructuredContentProvider {
        PHPsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object input) {
            return InstalledPHPsBlock.this.fPHPexes.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

