/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;
import org.eclipse.php.internal.core.util.collections.BucketMap;
import org.eclipse.php.refactoring.core.rename.AbstractRenameProcessor;
import org.eclipse.php.refactoring.core.rename.IReferenceUpdating;

public abstract class AbstraceRenameResourceProcessor
extends AbstractRenameProcessor<IResource>
implements IReferenceUpdating {
    BucketMap<IResource, IBreakpoint> fBreakpoints;
    HashMap<IBreakpoint, Map<String, Object>> fBreakpointAttributes;
    private RenameArguments fRenameArguments;
    boolean isUpdateReferences;

    public AbstraceRenameResourceProcessor(IResource file) {
        super(file);
    }

    protected void collectBrakePoint() throws CoreException {
        IMarker[] markers;
        this.fBreakpoints = new BucketMap(6);
        this.fBreakpointAttributes = new HashMap(6);
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IMarker[] iMarkerArray = markers = this.resource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            IResource markerResource = marker.getResource();
            IBreakpoint breakpoint = breakpointManager.getBreakpoint(marker);
            if (breakpoint != null) {
                this.fBreakpoints.add((Object)markerResource, (Object)breakpoint);
                this.fBreakpointAttributes.put(breakpoint, breakpoint.getMarker().getAttributes());
            }
            ++n2;
        }
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures((IResource)this.resource);
        this.fRenameArguments = new RenameArguments(this.getNewElementName(), this.getUpdateReferences());
        return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.resource, (RenameArguments)this.fRenameArguments, null, (String[])affectedNatures, (SharableParticipants)sharedParticipants);
    }

    @Override
    public boolean getUpdateReferences() {
        return this.isUpdateReferences;
    }
}

