/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.Map;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighter.ModelUtils;
import org.eclipse.php.internal.ui.editor.highlighters.AbstractSemanticApplyWithNS;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;
import org.eclipse.swt.graphics.RGB;

public class InternalFunctionHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new InternalFunctionApply(this.getSourceModule());
    }

    @Override
    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false).setDefaultTextColor(new RGB(0, 0, 192));
    }

    public String getDisplayName() {
        return Messages.InternalFunctionHighlighting_0;
    }

    @Override
    public int getPriority() {
        return 110;
    }

    protected class InternalFunctionApply
    extends AbstractSemanticApplyWithNS {
        public InternalFunctionApply(ISourceModule sourceModule) {
            super(sourceModule);
        }

        public boolean visit(FunctionInvocation functionInvocation) {
            Expression functionName = functionInvocation.getFunctionName().getName();
            int invocationParent = functionInvocation.getParent().getType();
            if ((functionName.getType() == 33 || functionName.getType() == 65) && invocationParent != 53) {
                Identifier identifier = (Identifier)functionName;
                this.dealIdentifier(identifier);
            }
            return true;
        }

        private void dealIdentifier(Identifier identifier) {
            IModelElement[] elements = this.findMethods(identifier, this.fCurrentNamespace);
            if (elements == null || elements.length == 0) {
                elements = this.findMethods(identifier, null);
            }
            if (elements != null && elements.length > 0 && elements[0] != null) {
                IModelElement[] iModelElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement modelElement = iModelElementArray[n2];
                    if (modelElement != null && ModelUtils.isExternalElement(modelElement)) {
                        InternalFunctionHighlighting.this.highlight((ASTNode)identifier);
                        return;
                    }
                    ++n2;
                }
            }
        }

        private IModelElement[] findMethods(Identifier identifier, NamespaceDeclaration namespace) {
            String fullName = AbstractOccurrencesFinder.getFullName((Identifier)identifier, (Map)this.fLastUseParts, (NamespaceDeclaration)namespace);
            return PhpModelAccess.getDefault().findMethods(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, this.createSearchScope(), null);
        }
    }
}

