/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IImportContainer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.preferences.CorePreferencesSupport;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.FakeType;
import org.eclipse.php.internal.core.typeinference.UseStatementElement;
import org.eclipse.php.internal.core.util.OutlineFilter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.outline.PHPContentOutlineConfiguration;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PHPOutlineContentProvider
implements ITreeContentProvider {
    private TreeViewer fOutlineViewer;
    private ISourceModule fSourceModule;
    private ISourceModule fInput;
    private IModelElement[] fUseStatements;
    private UseStatementsNode fUseStatementsNode;
    private ElementChangedListener fListener;
    private ProblemChangedListener fProblemListener;

    public PHPOutlineContentProvider(TreeViewer viewer) {
        this.fOutlineViewer = viewer;
        this.fOutlineViewer.setAutoExpandLevel(-1);
        this.inputChanged((Viewer)this.fOutlineViewer, null, null);
    }

    public void dispose() {
        if (this.fListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
        }
        if (this.fProblemListener != null) {
            PHPUiPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fProblemListener);
            this.fProblemListener = null;
        }
    }

    public Object[] getChildren(Object parent) {
        block3: {
            if (parent instanceof IParent) {
                IParent c = (IParent)parent;
                try {
                    return OutlineFilter.filterChildrenForOutline((Object)parent, (IModelElement[])c.getChildren());
                }
                catch (ModelException x) {
                    if (!DLTKCore.DEBUG && x.isDoesNotExist()) break block3;
                    DLTKUIPlugin.log((Throwable)x);
                }
            }
        }
        return PHPContentOutlineConfiguration.NO_CHILDREN;
    }

    private boolean isNamespaceSupported(IModelElement modelElement) {
        PHPVersion phpVersion = null;
        if (modelElement == null || modelElement.getScriptProject() == null) {
            String versionName = CorePreferencesSupport.getInstance().getWorkspacePreferencesValue("phpVersion");
            phpVersion = PHPVersion.byAlias((String)versionName);
        } else {
            phpVersion = ProjectOptions.getPhpVersion((IProject)modelElement.getScriptProject().getProject());
        }
        return phpVersion.isGreaterThan(PHPVersion.PHP5);
    }

    public Object[] getElements(Object parent) {
        ISourceModule sourceModule;
        Object[] children = this.getChildren(parent);
        if (parent instanceof ISourceModule && this.isNamespaceSupported((IModelElement)(sourceModule = (ISourceModule)parent))) {
            Object[] newChildren = new Object[children.length + 1];
            this.fUseStatementsNode = new UseStatementsNode(sourceModule);
            newChildren[0] = this.fUseStatementsNode;
            System.arraycopy(children, 0, newChildren, 1, children.length);
            children = newChildren;
        }
        return children;
    }

    public Object getParent(Object child) {
        if (child instanceof IModelElement) {
            IModelElement e = (IModelElement)child;
            return e.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        block4: {
            IModelElement me;
            if (parent instanceof IModelElement && (me = (IModelElement)parent).getElementType() == 8) {
                return false;
            }
            if (parent instanceof IParent) {
                IParent c = (IParent)parent;
                try {
                    IModelElement[] children = OutlineFilter.filter((IModelElement[])c.getChildren());
                    return children != null && children.length > 0;
                }
                catch (ModelException x) {
                    if (!DLTKUIPlugin.isDebug() && x.isDoesNotExist()) break block4;
                    DLTKUIPlugin.log((Throwable)x);
                }
            }
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        boolean isCU = newInput instanceof ISourceModule;
        if (isCU && this.fListener == null) {
            this.fInput = (ISourceModule)newInput;
            this.fListener = new ElementChangedListener();
            DLTKCore.addElementChangedListener((IElementChangedListener)this.fListener);
            this.fProblemListener = new ProblemChangedListener();
            PHPUiPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fProblemListener, 1);
        } else if (!isCU && this.fListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
            PHPUiPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fProblemListener);
            this.fProblemListener = null;
            this.fInput = null;
        }
    }

    public boolean isDeleted(Object o) {
        return false;
    }

    private IModelElement[] getUseStatements() {
        if (this.fSourceModule == null || !this.fSourceModule.exists()) {
            return new IModelElement[0];
        }
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)this.fSourceModule);
        if (moduleDeclaration == null) {
            return new IModelElement[0];
        }
        UseStatement[] useStatements = ASTUtils.getUseStatements((ModuleDeclaration)moduleDeclaration, (int)moduleDeclaration.sourceEnd());
        LinkedList<UseStatementElement> elements = new LinkedList<UseStatementElement>();
        UseStatement[] useStatementArray = useStatements;
        int n = useStatements.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatement useStatement = useStatementArray[n2];
            for (UsePart usePart : useStatement.getParts()) {
                elements.add(new UseStatementElement((ModelElement)this.fSourceModule, usePart));
            }
            ++n2;
        }
        return elements.toArray(new UseStatementElement[elements.size()]);
    }

    protected class ElementChangedListener
    implements IElementChangedListener {
        private int useStatementsCount;
        private int useStatementsCountNew;

        protected ElementChangedListener() {
        }

        public void elementChanged(final ElementChangedEvent e) {
            final Control control = PHPOutlineContentProvider.this.fOutlineViewer.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            HashSet<ISourceModule> eventSources = new HashSet<ISourceModule>();
            this.collectSourceModules(e.getDelta(), eventSources);
            if (PHPOutlineContentProvider.this.fInput == null || !eventSources.contains(PHPOutlineContentProvider.this.fInput)) {
                return;
            }
            Job job = new Job(PHPUIMessages.PHPOutlineContentProvider_0){

                protected IStatus run(IProgressMonitor monitor) {
                    Display d;
                    IModelElementDelta delta;
                    IEditorPart activeEditor;
                    IWorkbenchPage activePage;
                    PHPOutlineContentProvider.this.fUseStatements = PHPOutlineContentProvider.this.getUseStatements();
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof PHPStructuredEditor) {
                        IModelElement base = ((PHPStructuredEditor)activeEditor).getModelElement();
                        if (PHPOutlineContentProvider.this.isNamespaceSupported(base)) {
                            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)((ISourceModule)base));
                            UseStatement[] useStatements = ASTUtils.getUseStatements((ModuleDeclaration)moduleDeclaration, (int)moduleDeclaration.sourceEnd());
                            ElementChangedListener.this.useStatementsCountNew = useStatements.length;
                        }
                    }
                    if (!((delta = ElementChangedListener.this.findElement((IModelElement)PHPOutlineContentProvider.this.fSourceModule, e.getDelta())) == null && e.getType() != 1 || PHPOutlineContentProvider.this.fOutlineViewer == null || PHPOutlineContentProvider.this.fOutlineViewer.getControl() == null || PHPOutlineContentProvider.this.fOutlineViewer.getControl().isDisposed() || (d = control.getDisplay()) == null)) {
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ElementChangedListener.this.refresh(delta);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(50);
            job.setSystem(true);
            job.schedule();
        }

        private void collectSourceModules(IModelElementDelta delta, Set<ISourceModule> sourceModules) {
            if (delta.getElement() instanceof ISourceModule) {
                sourceModules.add((ISourceModule)delta.getElement());
            }
            IModelElementDelta[] iModelElementDeltaArray = delta.getAffectedChildren();
            int n = iModelElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElementDelta child = iModelElementDeltaArray[n2];
                this.collectSourceModules(child, sourceModules);
                ++n2;
            }
        }

        private void refresh(IModelElementDelta delta) {
            if (delta == null) {
                return;
            }
            if (PHPOutlineContentProvider.this.fOutlineViewer.getTree() == null || PHPOutlineContentProvider.this.fOutlineViewer.getTree() != null && !PHPOutlineContentProvider.this.fOutlineViewer.getTree().isDisposed()) {
                this.visitAndUpdate(delta);
            }
        }

        private void visitAndUpdate(IModelElementDelta delta) {
            if (delta.getElement() != null) {
                IModelElement modelElement = delta.getElement();
                switch (delta.getKind()) {
                    case 1: {
                        if (modelElement.getElementType() == 11) {
                            IModelElement parent = new ImportContainerFinder().findParent((IImportContainer)modelElement);
                            if (parent != null) {
                                PHPOutlineContentProvider.this.fOutlineViewer.add((Object)parent, (Object)modelElement);
                            }
                        } else {
                            PHPOutlineContentProvider.this.fOutlineViewer.add((Object)modelElement.getParent(), (Object)modelElement);
                        }
                        this.refreshUseStatements(modelElement);
                        break;
                    }
                    case 4: {
                        PHPOutlineContentProvider.this.fOutlineViewer.update((Object)modelElement, null);
                        break;
                    }
                    case 2: {
                        PHPOutlineContentProvider.this.fOutlineViewer.remove((Object)modelElement);
                        this.refreshUseStatements(modelElement);
                    }
                }
            }
            IModelElementDelta[] iModelElementDeltaArray = delta.getAffectedChildren();
            int n = iModelElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElementDelta child = iModelElementDeltaArray[n2];
                this.visitAndUpdate(child);
                ++n2;
            }
        }

        private void refreshUseStatements(IModelElement element) {
            if (PHPOutlineContentProvider.this.fUseStatementsNode != null && (element.getElementType() == 11 || element.getElementType() == 12)) {
                PHPOutlineContentProvider.this.fOutlineViewer.refresh((Object)PHPOutlineContentProvider.this.fUseStatementsNode);
            }
        }

        protected IModelElementDelta findElement(IModelElement unit, IModelElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 5) {
                return null;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }

        private boolean isPossibleStructuralChange(IModelElementDelta cuDelta) {
            int oldValue = this.useStatementsCount;
            this.useStatementsCount = this.useStatementsCountNew;
            if (oldValue != this.useStatementsCountNew) {
                return true;
            }
            if (cuDelta.getKind() != 4) {
                return true;
            }
            int flags = cuDelta.getFlags();
            if ((flags & 8) != 0) {
                return true;
            }
            return (flags & 0x4001) == 1;
        }
    }

    private class ImportContainerFinder {
        private ImportContainerFinder() {
        }

        public IModelElement findParent(IImportContainer importContainer) {
            Object[] elements;
            Object[] objectArray = elements = PHPOutlineContentProvider.this.getElements(PHPOutlineContentProvider.this.fInput);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IModelElement parent = this.findParent(element, importContainer);
                if (parent != null) {
                    return parent;
                }
                ++n2;
            }
            return null;
        }

        private IModelElement findParent(Object object, IImportContainer importContainer) {
            Object[] children;
            Object[] objectArray = children = PHPOutlineContentProvider.this.getChildren(object);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child == importContainer && object instanceof IModelElement) {
                    return (IModelElement)object;
                }
                IModelElement parent = this.findParent(child, importContainer);
                if (parent != null) {
                    return parent;
                }
                ++n2;
            }
            return null;
        }
    }

    private class ProblemChangedCollector
    implements IResourceDeltaVisitor {
        public Set<Object> toUpdate = new HashSet<Object>();

        private ProblemChangedCollector() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IProject project;
            IResource res = delta.getResource();
            if (res instanceof IProject && delta.getKind() == 4 && !(project = (IProject)res).isAccessible()) {
                return false;
            }
            this.visitDelta(delta, res);
            return true;
        }

        private void visitDelta(IResourceDelta delta, IResource resource) {
            if (PHPOutlineContentProvider.this.fInput == null) {
                return;
            }
            try {
                IResource inputResource = PHPOutlineContentProvider.this.fInput.getCorrespondingResource();
                if (inputResource == null || !inputResource.equals((Object)resource)) {
                    return;
                }
            }
            catch (ModelException modelException) {
                return;
            }
            int kind = delta.getKind();
            if (kind == 2 || kind == 1 || kind == 4) {
                this.collectChangedElements(delta);
            }
        }

        private void collectChangedElements(IResourceDelta delta) {
            if ((delta.getFlags() & 0x20000) == 0) {
                return;
            }
            IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
            int i = 0;
            while (i < markerDeltas.length) {
                if (markerDeltas[i].isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    Integer charStart = (Integer)markerDeltas[i].getAttribute("charStart");
                    Integer charEnd = (Integer)markerDeltas[i].getAttribute("charEnd");
                    if (charStart != null && charEnd != null) {
                        try {
                            IModelElement element = PHPOutlineContentProvider.this.fInput.getElementAt(charStart.intValue());
                            this.collectToUpdate(element);
                        }
                        catch (ModelException e) {
                            PHPUiPlugin.log(e);
                        }
                    }
                }
                ++i;
            }
        }

        private void collectToUpdate(IModelElement element) {
            if (element == null) {
                return;
            }
            this.toUpdate.add(element);
            if (PHPOutlineContentProvider.this.fUseStatementsNode != null && element.getElementType() == 12) {
                Object[] objects = PHPOutlineContentProvider.this.getChildren((Object)PHPOutlineContentProvider.this.fUseStatementsNode);
                this.toUpdate.addAll(Arrays.asList(objects));
            }
            element = element.getParent();
            while (element != null && !(element instanceof ISourceModule)) {
                IModelElement parent;
                this.toUpdate.add(element);
                if (element instanceof IImportContainer && (parent = new ImportContainerFinder().findParent((IImportContainer)element)) != null) {
                    this.toUpdate.add(parent);
                }
                element = element.getParent();
            }
        }
    }

    private class ProblemChangedListener
    implements IResourceChangeListener {
        private ProblemChangedListener() {
        }

        public void resourceChanged(final IResourceChangeEvent event) {
            final Control control = PHPOutlineContentProvider.this.fOutlineViewer.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            Job job = new Job(PHPUIMessages.PHPOutlineContentProvider_0){

                protected IStatus run(IProgressMonitor monitor) {
                    Display d;
                    ProblemChangedCollector collector = new ProblemChangedCollector();
                    try {
                        IResourceDelta delta = event.getDelta();
                        if (delta != null) {
                            delta.accept((IResourceDeltaVisitor)collector);
                        }
                    }
                    catch (CoreException e) {
                        PHPUiPlugin.log(e.getStatus());
                        return Status.OK_STATUS;
                    }
                    if (!collector.toUpdate.isEmpty() && PHPOutlineContentProvider.this.fOutlineViewer != null && PHPOutlineContentProvider.this.fOutlineViewer.getControl() != null && !PHPOutlineContentProvider.this.fOutlineViewer.getControl().isDisposed() && (d = control.getDisplay()) != null) {
                        final Object[] objects = collector.toUpdate.toArray();
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PHPOutlineContentProvider.this.fOutlineViewer.update(objects, null);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(50);
            job.setSystem(true);
            job.schedule();
        }
    }

    public class UseStatementsNode
    extends FakeType {
        public UseStatementsNode(ISourceModule sourceModule) {
            super((ModelElement)sourceModule, PHPUIMessages.PHPOutlineContentProvider_useStatementsNode, 0, null);
            PHPOutlineContentProvider.this.fSourceModule = sourceModule;
        }

        public IModelElement[] getChildren() throws ModelException {
            if (PHPOutlineContentProvider.this.fUseStatements == null) {
                PHPOutlineContentProvider.this.fUseStatements = PHPOutlineContentProvider.this.getUseStatements();
            }
            return PHPOutlineContentProvider.this.fUseStatements;
        }

        public boolean hasChildren() throws ModelException {
            return this.getChildren().length > 0;
        }

        public Object getElementInfo() throws ModelException {
            return null;
        }

        public int getElementType() {
            return 11;
        }
    }
}

