/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.IPVariableElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class IPVariableElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image fZIPImage;
    private Image fFolderImage;
    private boolean fShowResolvedVariables;
    private Color fResolvedBackground;

    public IPVariableElementLabelProvider(boolean showResolvedVariables) {
        ImageRegistry reg = PHPUiPlugin.getDefault().getImageRegistry();
        this.fZIPImage = reg.get("org.eclipse.php.ui.zip_l_obj.png");
        this.fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        this.fShowResolvedVariables = showResolvedVariables;
        this.fResolvedBackground = null;
    }

    public Image getImage(Object element) {
        if (element instanceof IPVariableElement) {
            IPVariableElement curr = (IPVariableElement)element;
            IPath path = curr.getPath();
            if (path.toFile().isFile()) {
                return this.fZIPImage;
            }
            return this.fFolderImage;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IPVariableElement) {
            IPVariableElement curr = (IPVariableElement)element;
            String name = curr.getName();
            IPath path = curr.getPath();
            StringBuffer buf = new StringBuffer(name);
            if (curr.isReserved()) {
                buf.append(' ');
                buf.append(PHPUIMessages.CPVariableElementLabelProvider_reserved);
            }
            if (path != null) {
                buf.append(" - ");
                if (!path.isEmpty()) {
                    buf.append(path.toOSString());
                } else {
                    buf.append(PHPUIMessages.CPVariableElementLabelProvider_empty);
                }
            }
            return buf.toString();
        }
        return super.getText(element);
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof IPVariableElement) {
            IPVariableElement curr = (IPVariableElement)element;
            if (!this.fShowResolvedVariables && curr.isReserved()) {
                if (this.fResolvedBackground == null) {
                    Display display = Display.getCurrent();
                    this.fResolvedBackground = display.getSystemColor(29);
                }
                return this.fResolvedBackground;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }
}

