/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import org.h2.jdbcx.JdbcConnectionPool;
import org.osgi.framework.Bundle;

public class PerformanceMonitor {
    private static final int AVG_SAMPLES = 5;
    private static final int HISTORY_SIZE = 50;
    private JdbcConnectionPool pool;
    private int executionId;

    public PerformanceMonitor(Bundle bundle) throws Exception {
        Class.forName("org.h2.Driver");
        File resultsDir = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".perf_results" + File.separator + bundle.getSymbolicName() + bundle.getVersion());
        if (!resultsDir.exists()) {
            resultsDir.mkdirs();
        }
        this.pool = JdbcConnectionPool.create((String)("jdbc:h2:" + new File(resultsDir, "db").getAbsolutePath()), (String)"test", (String)"");
        this.createSchema();
        this.executionId = this.getExecutionId();
        this.compact();
    }

    public void dispose() {
        try {
            this.pool.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createSchema() throws SQLException {
        try (Connection connection = this.pool.getConnection();){
            String sql = "CREATE TABLE IF NOT EXISTS TESTS(ID INT AUTO_INCREMENT PRIMARY KEY, NAME VARCHAR NOT NULL);\nCREATE TABLE IF NOT EXISTS EXECUTIONS(ID INT AUTO_INCREMENT PRIMARY KEY, DATE TIMESTAMP NOT NULL);\nCREATE TABLE IF NOT EXISTS RESULTS(EXECUTION_ID INT NOT NULL, TEST_ID INT NOT NULL, TIME LONG NOT NULL, FOREIGN KEY(EXECUTION_ID) REFERENCES EXECUTIONS(ID) ON UPDATE CASCADE ON DELETE CASCADE, FOREIGN KEY(TEST_ID) REFERENCES TESTS(ID) ON UPDATE CASCADE ON DELETE CASCADE);\n";
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate(sql);
            }
        }
    }

    private void compact() throws SQLException {
        try (Connection connection = this.pool.getConnection();){
            statement.setInt(1, 50);
            try (PreparedStatement statement = connection.prepareStatement("DELETE FROM EXECUTIONS WHERE ID IN (SELECT ID FROM (SELECT ROWNUM() AS R,ID FROM (SELECT ID FROM EXECUTIONS ORDER BY DATE DESC)) WHERE R > ?);");){
                statement.executeUpdate();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int getExecutionId() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getTestId(String testId) throws Exception {
        try (Connection connection = this.pool.getConnection();){
            statement.setString(1, testId);
            try (PreparedStatement statement = connection.prepareStatement("SELECT ID FROM TESTS WHERE NAME=?;");){
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        int n = result.getInt(1);
                        return n;
                    }
                }
                {
                }
            }
        }
    }

    private void writeResult(int testId, long time) throws SQLException {
        try (Connection connection = this.pool.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO RESULTS(EXECUTION_ID, TEST_ID, TIME) VALUES(?,?,?);");){
            statement.setInt(1, this.executionId);
            statement.setInt(2, testId);
            statement.setLong(3, time);
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getAverage(int testId, int samples) throws SQLException {
        try (Connection connection = this.pool.getConnection();){
            PreparedStatement statement = connection.prepareStatement("SELECT COUNT(*),AVG(TIME) FROM (SELECT R.TIME FROM RESULTS AS R JOIN TESTS AS T ON R.TEST_ID = T.ID AND T.ID=? JOIN EXECUTIONS AS E ON R.EXECUTION_ID = E.ID ORDER BY E.DATE DESC LIMIT ?);");
            statement.setInt(1, testId);
            statement.setInt(2, samples);
            try (ResultSet result = statement.executeQuery();){
                if (!result.next()) {
                }
                if (result.getInt(1) == samples) {
                    long l = result.getLong(2);
                    return l;
                }
            }
            finally {
                statement.close();
            }
        }
    }

    public void execute(String id, Operation operation, int times, int threshold) throws Exception {
        long diff;
        int testId = this.getTestId(id);
        long testTimeSum = 0L;
        int i = 0;
        while (i < times) {
            long testStart = System.currentTimeMillis();
            operation.run();
            testTimeSum += System.currentTimeMillis() - testStart;
            ++i;
        }
        long testAverage = testTimeSum / (long)times;
        long savedAverage = this.getAverage(testId, 5);
        if (savedAverage != 0L && savedAverage != -1L && testAverage > savedAverage && (diff = testAverage - savedAverage) * 100L / savedAverage > (long)threshold) {
            Assert.fail((String)("Average execution time (" + testAverage + "ms) is greater by more than " + threshold + "% than the saved average (" + savedAverage + "ms)"));
        }
        this.writeResult(testId, testAverage);
    }

    public static interface Operation {
        public void run() throws Exception;
    }
}

