/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.documentModel.parser.php5;

import org.eclipse.php.internal.core.util.collections.IntHashtable;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>highlighting_scanner.jflex</tt>
 */
public class PhpLexer extends org.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_PHP_IN_SCRIPTING = 2;
  public static final int ST_PHP_DOUBLE_QUOTES = 4;
  public static final int ST_PHP_SINGLE_QUOTE = 6;
  public static final int ST_PHP_BACKQUOTE = 8;
  public static final int ST_PHP_QUOTES_AFTER_VARIABLE = 10;
  public static final int ST_PHP_HEREDOC = 12;
  public static final int ST_PHP_START_HEREDOC = 14;
  public static final int ST_PHP_END_HEREDOC = 16;
  public static final int ST_PHP_LOOKING_FOR_PROPERTY = 18;
  public static final int ST_PHP_VAR_OFFSET = 20;
  public static final int ST_PHP_COMMENT = 22;
  public static final int ST_PHP_DOC_COMMENT = 24;
  public static final int ST_PHP_LINE_COMMENT = 26;
  public static final int ST_PHP_HIGHLIGHTING_ERROR = 28;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\15\2\0\1\11\22\0\1\12\1\26\1\17\1\74"+
    "\1\16\1\32\1\33\1\73\1\62\1\64\1\30\1\25\1\13\1\4"+
    "\1\2\1\31\1\5\11\1\1\60\1\14\1\27\1\23\1\24\1\75"+
    "\1\76\1\40\1\7\1\47\1\42\1\3\1\45\1\63\1\52\1\43"+
    "\1\65\1\55\1\54\1\57\1\41\1\36\1\56\1\67\1\37\1\50"+
    "\1\44\1\46\1\61\1\53\1\6\1\51\1\10\1\71\1\20\1\72"+
    "\1\35\1\66\1\21\1\40\1\7\1\47\1\42\1\3\1\45\1\63"+
    "\1\52\1\43\1\65\1\55\1\54\1\57\1\41\1\36\1\56\1\67"+
    "\1\37\1\50\1\44\1\46\1\61\1\53\1\6\1\51\1\10\1\22"+
    "\1\34\1\70\1\13\261\10\2\43\115\10\1\50\u1faa\10\1\55\uded5\10"+
    "\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\10\0\1\2\1\3\1\4\1\5\1\4"+
    "\1\3\3\5\1\6\1\4\1\7\1\4\1\10\1\11"+
    "\1\12\12\4\16\5\1\4\1\5\1\4\2\5\1\13"+
    "\1\14\1\15\1\4\1\16\1\17\1\20\4\17\1\16"+
    "\3\17\3\21\2\1\3\2\2\22\1\2\1\23\1\2"+
    "\1\0\1\24\1\25\1\24\1\3\1\26\1\3\1\27"+
    "\1\26\1\5\1\30\2\31\3\32\3\33\3\34\1\35"+
    "\1\36\2\3\1\37\6\5\1\40\2\0\1\5\2\41"+
    "\2\0\1\17\2\0\2\37\1\42\1\43\1\37\4\5"+
    "\1\44\3\5\1\45\2\5\1\46\26\5\1\47\1\5"+
    "\12\0\2\5\2\0\1\50\3\0\1\51\2\52\1\53"+
    "\1\54\1\52\4\0\3\55\1\56\3\0\1\1\1\57"+
    "\3\1\2\52\1\0\1\60\2\0\3\23\1\0\1\23"+
    "\1\0\1\61\1\51\1\62\1\63\20\0\1\64\1\65"+
    "\7\5\1\3\1\0\1\5\1\41\1\0\1\66\4\5"+
    "\1\67\3\5\1\70\6\5\1\71\1\5\1\72\5\5"+
    "\1\73\16\5\1\74\12\0\6\5\1\75\2\57\1\1"+
    "\2\23\33\0\1\76\6\5\1\77\1\100\1\5\1\101"+
    "\1\5\1\41\1\0\1\102\4\5\1\103\7\5\1\104"+
    "\2\5\1\105\7\5\1\106\2\5\1\107\3\5\1\110"+
    "\5\5\12\0\7\5\22\0\1\111\13\0\1\112\1\0"+
    "\2\5\1\113\4\5\1\114\1\115\1\116\2\117\3\5"+
    "\1\120\5\5\1\121\1\5\1\122\1\5\1\123\1\124"+
    "\1\5\1\125\1\5\1\126\1\127\1\130\1\131\2\5"+
    "\1\132\1\5\1\133\3\5\7\0\1\134\2\0\7\5"+
    "\6\0\1\135\1\136\7\0\1\137\5\0\1\140\10\0"+
    "\2\5\1\141\2\5\1\142\1\143\13\5\1\144\1\145"+
    "\2\5\1\146\1\147\4\0\1\150\6\5\13\0\1\151"+
    "\3\0\1\152\4\0\1\153\2\0\1\154\2\0\1\155"+
    "\4\5\1\156\1\5\1\157\1\160\1\5\1\161\2\5"+
    "\1\162\3\5\1\163\2\0\6\5\2\0\1\164\1\0"+
    "\1\165\1\166\2\0\1\167\1\0\1\170\3\0\1\171"+
    "\4\0\1\172\1\0\1\173\3\5\1\174\1\5\1\175"+
    "\4\5\1\176\1\177\1\5\1\200\3\5\1\201\1\5"+
    "\1\202\12\0\1\203\1\0\1\204\1\205\2\5\1\206"+
    "\1\5\1\207\3\5\1\210\1\5\1\211\2\5\1\0"+
    "\1\212\1\0\1\213\1\214\2\0\1\215\2\0\1\216"+
    "\1\217\1\220\2\5\1\221\1\222\2\5\1\223\1\224"+
    "\2\0\1\225\1\226\1\0\4\5\1\227\1\230\1\231"+
    "\1\232\1\233\1\234\3\5\1\235";

  private static int [] zzUnpackAction() {
    int [] result = new int[733];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\77\0\176\0\275\0\374\0\u013b\0\u017a\0\u01b9"+
    "\0\u01f8\0\u0237\0\u0276\0\u02b5\0\u02f4\0\u0333\0\u0372\0\0"+
    "\0\u03b1\0\u03f0\0\u042f\0\u046e\0\u04ad\0\u04ec\0\u052b\0\u056a"+
    "\0\u05a9\0\0\0\0\0\u05e8\0\u0627\0\0\0\0\0\u0666"+
    "\0\u06a5\0\u06e4\0\u0723\0\u0762\0\u07a1\0\u07e0\0\u081f\0\u085e"+
    "\0\u089d\0\u08dc\0\u091b\0\u095a\0\u0999\0\u09d8\0\u0a17\0\u0a56"+
    "\0\u0a95\0\u0ad4\0\u0b13\0\u0b52\0\u0b91\0\u0bd0\0\u0c0f\0\u0c4e"+
    "\0\u0c8d\0\u0ccc\0\u0d0b\0\u0d4a\0\0\0\u0d89\0\0\0\u0dc8"+
    "\0\u0e07\0\u0e46\0\0\0\u0e85\0\u0ec4\0\u0f03\0\u0f42\0\u0f81"+
    "\0\u0fc0\0\u0fff\0\u103e\0\0\0\u107d\0\u10bc\0\u10fb\0\u113a"+
    "\0\u1179\0\u11b8\0\u11f7\0\0\0\u1236\0\u1275\0\u12b4\0\u12f3"+
    "\0\u12f3\0\0\0\u1332\0\u1371\0\u13b0\0\0\0\u13ef\0\0"+
    "\0\u142e\0\u146d\0\0\0\u14ac\0\u14eb\0\0\0\u152a\0\u1569"+
    "\0\u15a8\0\u15e7\0\0\0\0\0\u1626\0\u0dc8\0\0\0\u1665"+
    "\0\u16a4\0\u16e3\0\0\0\u1722\0\u1761\0\u17a0\0\u17df\0\u181e"+
    "\0\u185d\0\0\0\u189c\0\u18db\0\u191a\0\u1959\0\u1998\0\u0627"+
    "\0\u19d7\0\0\0\u1a16\0\u1a55\0\u07a1\0\u1a94\0\u1ad3\0\u1b12"+
    "\0\u056a\0\u1b51\0\u1b90\0\u1bcf\0\u1c0e\0\u056a\0\u1c4d\0\u1c8c"+
    "\0\u1ccb\0\u056a\0\u1d0a\0\u1d49\0\u056a\0\u1d88\0\u1dc7\0\u1e06"+
    "\0\u1e45\0\u1e84\0\u1ec3\0\u1f02\0\u1f41\0\u1f80\0\u1fbf\0\u1ffe"+
    "\0\u203d\0\u207c\0\u20bb\0\u20fa\0\u2139\0\u2178\0\u21b7\0\u21f6"+
    "\0\u2235\0\u2274\0\u22b3\0\0\0\u22f2\0\u2331\0\u0ccc\0\u2370"+
    "\0\u23af\0\u23ee\0\u242d\0\u246c\0\u24ab\0\u24ea\0\u2529\0\u2568"+
    "\0\u25a7\0\u0d89\0\u25e6\0\u2625\0\u2664\0\u0e85\0\u26a3\0\u26e2"+
    "\0\u2664\0\0\0\0\0\0\0\u26a3\0\u2721\0\u2760\0\u0fff"+
    "\0\u279f\0\u2760\0\0\0\u279f\0\0\0\u27de\0\u11b8\0\u281d"+
    "\0\u285c\0\u289b\0\u28da\0\u2919\0\u2958\0\u27de\0\u281d\0\u1236"+
    "\0\0\0\u2997\0\u29d6\0\u2a15\0\0\0\u2a54\0\u2a93\0\u2ad2"+
    "\0\u1275\0\0\0\u2b11\0\0\0\0\0\u2b50\0\u2b8f\0\u2bce"+
    "\0\u2c0d\0\u2c4c\0\u2c8b\0\u2cca\0\u2d09\0\u2d48\0\u2d87\0\u2dc6"+
    "\0\u2e05\0\u2e44\0\u2e83\0\u2ec2\0\u2f01\0\0\0\u2f40\0\u2f7f"+
    "\0\u2fbe\0\u2ffd\0\u303c\0\u307b\0\u30ba\0\u30f9\0\u189c\0\u3138"+
    "\0\u3177\0\u31b6\0\u31f5\0\u3234\0\u3273\0\u32b2\0\u32f1\0\u3330"+
    "\0\u056a\0\u336f\0\u33ae\0\u33ed\0\u056a\0\u342c\0\u346b\0\u34aa"+
    "\0\u34e9\0\u3528\0\u3567\0\u056a\0\u35a6\0\u35e5\0\u3624\0\u3663"+
    "\0\u36a2\0\u36e1\0\u3720\0\u056a\0\u375f\0\u379e\0\u37dd\0\u381c"+
    "\0\u385b\0\u389a\0\u38d9\0\u3918\0\u3957\0\u3996\0\u39d5\0\u3a14"+
    "\0\u3a53\0\u3a92\0\u056a\0\u3ad1\0\u3b10\0\u3b4f\0\u3b8e\0\u3bcd"+
    "\0\u3c0c\0\u3c4b\0\u3c8a\0\u3cc9\0\u3d08\0\u3d47\0\u3d86\0\u3dc5"+
    "\0\u3e04\0\u3e43\0\u3e82\0\0\0\0\0\u3ec1\0\u3f00\0\u1275"+
    "\0\u3f3f\0\u3f7e\0\u3fbd\0\u3ffc\0\u403b\0\u407a\0\u40b9\0\u40f8"+
    "\0\u4137\0\u4176\0\u41b5\0\u41f4\0\u4233\0\u4272\0\u42b1\0\u42f0"+
    "\0\u432f\0\u436e\0\u43ad\0\u43ec\0\u442b\0\u446a\0\u44a9\0\u44e8"+
    "\0\u4527\0\u4566\0\u45a5\0\u45e4\0\u056a\0\u4623\0\u4662\0\u46a1"+
    "\0\u46e0\0\u471f\0\u475e\0\u056a\0\u479d\0\u47dc\0\u056a\0\u481b"+
    "\0\u485a\0\u4899\0\0\0\u48d8\0\u4917\0\u4956\0\u4995\0\u056a"+
    "\0\u49d4\0\u4a13\0\u4a52\0\u4a91\0\u4ad0\0\u4b0f\0\u4b4e\0\u056a"+
    "\0\u4b8d\0\u4bcc\0\u056a\0\u4c0b\0\u4c4a\0\u4c89\0\u4cc8\0\u4d07"+
    "\0\u4d46\0\u4d85\0\u056a\0\u4dc4\0\u4e03\0\u056a\0\u4e42\0\u4e81"+
    "\0\u4ec0\0\u056a\0\u4eff\0\u4f3e\0\u4f7d\0\u4fbc\0\u4ffb\0\u503a"+
    "\0\u5079\0\u50b8\0\u50f7\0\u5136\0\u5175\0\u51b4\0\u51f3\0\u5232"+
    "\0\u5271\0\u52b0\0\u52ef\0\u532e\0\u536d\0\u53ac\0\u53eb\0\u542a"+
    "\0\u5469\0\u54a8\0\u54e7\0\u5526\0\u5565\0\u55a4\0\u55e3\0\u5622"+
    "\0\u5661\0\u56a0\0\u56df\0\u571e\0\u575d\0\u579c\0\u57db\0\u581a"+
    "\0\u5859\0\u5898\0\0\0\u58d7\0\u5916\0\u5955\0\u5994\0\u59d3"+
    "\0\u5a12\0\u5a51\0\u5a90\0\u5acf\0\u5b0e\0\u5b4d\0\0\0\u5b8c"+
    "\0\u5bcb\0\u5c0a\0\u056a\0\u5c49\0\u5c88\0\u5cc7\0\u5d06\0\u056a"+
    "\0\u056a\0\u1959\0\u5d45\0\0\0\u5d84\0\u5dc3\0\u5e02\0\u056a"+
    "\0\u5e41\0\u5e80\0\u5ebf\0\u5efe\0\u5f3d\0\u056a\0\u5f7c\0\u056a"+
    "\0\u5fbb\0\u056a\0\u056a\0\u5ffa\0\u056a\0\u6039\0\u056a\0\u056a"+
    "\0\u056a\0\u056a\0\u6078\0\u60b7\0\u056a\0\u60f6\0\u056a\0\u6135"+
    "\0\u6174\0\u61b3\0\u61f2\0\u6231\0\u6270\0\u62af\0\u62ee\0\u632d"+
    "\0\u636c\0\0\0\u63ab\0\u63ea\0\u6429\0\u6468\0\u64a7\0\u64e6"+
    "\0\u6525\0\u6564\0\u65a3\0\u65e2\0\u6621\0\u6660\0\u669f\0\u66de"+
    "\0\u671d\0\0\0\0\0\u675c\0\u679b\0\u67da\0\u6819\0\u6858"+
    "\0\u6897\0\u68d6\0\0\0\u6915\0\u6954\0\u6993\0\u69d2\0\u6a11"+
    "\0\0\0\u6a50\0\u6a8f\0\u6ace\0\u6b0d\0\u6b4c\0\u6b8b\0\u6bca"+
    "\0\u6c09\0\u6c48\0\u6c87\0\u6cc6\0\u6d05\0\u6d44\0\u056a\0\u056a"+
    "\0\u6d83\0\u6dc2\0\u6e01\0\u6e40\0\u6e7f\0\u6ebe\0\u6efd\0\u6f3c"+
    "\0\u6f7b\0\u6fba\0\u6ff9\0\u056a\0\u056a\0\u7038\0\u7077\0\u056a"+
    "\0\u056a\0\u70b6\0\u70f5\0\u7134\0\u7173\0\u056a\0\u71b2\0\u71f1"+
    "\0\u7230\0\u726f\0\u72ae\0\u72ed\0\u732c\0\u736b\0\u73aa\0\u73e9"+
    "\0\u7428\0\u7467\0\u74a6\0\u74e5\0\u7524\0\u7563\0\u75a2\0\0"+
    "\0\u75e1\0\u7620\0\u765f\0\0\0\u769e\0\u76dd\0\u771c\0\u775b"+
    "\0\0\0\u779a\0\u77d9\0\0\0\u7818\0\u7857\0\u056a\0\u7896"+
    "\0\u78d5\0\u7914\0\u7953\0\u7992\0\u79d1\0\u056a\0\u056a\0\u7a10"+
    "\0\u7a4f\0\u7a8e\0\u7acd\0\u056a\0\u7b0c\0\u7b4b\0\u7b8a\0\u056a"+
    "\0\u7bc9\0\u7c08\0\u7c47\0\u7c86\0\u7cc5\0\u7d04\0\u7d43\0\u7d82"+
    "\0\u7dc1\0\u7e00\0\0\0\u7e3f\0\0\0\0\0\u7e7e\0\u7ebd"+
    "\0\0\0\u7efc\0\0\0\u7f3b\0\u7f7a\0\u7fb9\0\u7ff8\0\u8037"+
    "\0\u8076\0\u80b5\0\u80f4\0\0\0\u8133\0\0\0\u8172\0\u81b1"+
    "\0\u81f0\0\u056a\0\u822f\0\u056a\0\u826e\0\u82ad\0\u82ec\0\u832b"+
    "\0\u056a\0\u056a\0\u836a\0\u056a\0\u83a9\0\u83e8\0\u8427\0\u056a"+
    "\0\u8466\0\0\0\u84a5\0\u84e4\0\u8523\0\u8562\0\u85a1\0\u85e0"+
    "\0\u861f\0\u865e\0\u869d\0\u86dc\0\0\0\u871b\0\0\0\0"+
    "\0\u875a\0\u8799\0\u056a\0\u87d8\0\u056a\0\u8817\0\u8856\0\u8895"+
    "\0\u056a\0\u88d4\0\u056a\0\u8913\0\u8952\0\u8991\0\0\0\u89d0"+
    "\0\0\0\0\0\u8a0f\0\u8a4e\0\0\0\u8a8d\0\u8acc\0\0"+
    "\0\u056a\0\u056a\0\u8b0b\0\u8b4a\0\u056a\0\u056a\0\u8b89\0\u8bc8"+
    "\0\u056a\0\0\0\u8c07\0\u8c46\0\0\0\0\0\u8c85\0\u8cc4"+
    "\0\u8d03\0\u8d42\0\u8d81\0\0\0\0\0\0\0\u056a\0\u056a"+
    "\0\u056a\0\u8dc0\0\u8dff\0\u8e3e\0\u056a";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[733];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\77\0\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\2\31\1\32\1\33\1\31\1\34\1\35"+
    "\1\20\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\45\1\52\1\53"+
    "\1\54\1\55\1\56\1\57\1\60\1\61\1\62\1\63"+
    "\1\64\2\30\1\65\1\66\1\30\1\67\1\30\1\70"+
    "\1\71\1\72\1\73\1\32\1\30\1\74\1\30\1\75"+
    "\2\32\1\76\1\77\1\100\1\32\16\101\1\102\1\103"+
    "\1\104\1\101\1\105\54\101\20\106\1\107\52\106\1\103"+
    "\3\106\16\110\1\111\1\110\1\112\1\103\1\113\54\110"+
    "\4\114\1\115\15\114\1\116\54\114\11\117\1\120\3\117"+
    "\1\120\1\121\1\117\1\122\1\117\1\123\54\117\3\124"+
    "\1\125\2\124\3\125\25\124\22\125\1\124\1\125\1\124"+
    "\1\125\1\124\3\125\7\124\3\126\1\127\2\126\3\127"+
    "\1\130\3\126\1\131\20\126\22\127\1\126\1\127\1\126"+
    "\1\127\1\126\3\127\7\126\3\132\1\133\1\134\1\132"+
    "\3\133\25\132\22\133\1\132\1\133\1\132\1\133\1\132"+
    "\3\133\7\132\1\20\1\135\1\136\1\30\1\136\1\137"+
    "\3\30\2\140\2\136\1\140\1\141\1\136\1\140\15\136"+
    "\3\30\1\142\16\30\1\136\1\30\1\136\1\30\1\136"+
    "\3\30\1\136\1\32\1\143\2\140\2\136\30\144\1\145"+
    "\46\144\30\146\1\147\45\146\1\150\11\151\1\152\3\151"+
    "\1\153\6\151\1\154\5\151\1\155\42\151\1\156\1\151"+
    "\11\157\2\160\2\157\1\160\61\157\1\0\1\21\1\161"+
    "\1\162\1\0\1\21\72\0\1\161\3\0\1\161\15\0"+
    "\1\163\54\0\1\30\1\0\1\30\1\0\1\30\1\164"+
    "\2\30\25\0\3\30\1\165\5\30\1\166\4\30\1\167"+
    "\2\30\1\170\1\0\1\171\1\0\1\30\1\0\3\30"+
    "\13\0\1\163\16\0\1\163\1\172\53\0\1\21\1\161"+
    "\1\162\1\0\1\21\1\173\71\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\1\52\21\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\6\0\1\35\7\0\1\174\6\0\1\30\1\175"+
    "\20\30\1\0\1\30\1\0\1\30\1\0\3\30\3\0"+
    "\1\76\4\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\22\30\1\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\2\31\2\0\1\31\64\0\1\176\2\0\3\176\25\0"+
    "\6\176\1\177\13\176\1\0\1\176\1\0\1\176\1\0"+
    "\3\176\7\0\16\200\1\201\1\202\1\203\1\200\1\204"+
    "\54\200\23\0\1\205\1\163\75\0\1\163\1\205\75\0"+
    "\1\163\1\0\1\163\74\0\1\205\76\0\2\163\2\0"+
    "\1\206\72\0\1\163\76\0\1\163\4\0\1\207\1\77"+
    "\70\0\1\163\1\210\75\0\1\163\7\0\1\163\66\0"+
    "\1\163\10\0\1\163\43\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\1\30\1\211\20\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\212\1\0"+
    "\4\30\25\0\22\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\2\30\1\213"+
    "\1\30\25\0\1\30\1\214\1\30\1\215\6\30\1\216"+
    "\7\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\217\1\0\4\30\25\0\10\30\1\220"+
    "\11\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\221\1\0\4\30\25\0\1\222\4\30"+
    "\1\223\14\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\3\30"+
    "\1\224\3\30\1\225\2\30\1\226\6\30\1\227\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\30\1\230\12\30\1\231"+
    "\5\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\1\232\1\233"+
    "\1\234\2\30\1\235\2\30\1\236\11\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\3\30\1\237\6\30\1\240\7\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\1\241\1\30\1\242"+
    "\13\30\1\243\3\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\244\1\0\4\30\25\0"+
    "\6\30\1\245\6\30\1\246\4\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\14\30\1\247\5\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\5\30\1\250\14\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\1\30\1\251\1\252\5\30\1\253\11\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\67\0\1\254"+
    "\17\0\1\30\1\0\1\30\1\0\4\30\25\0\2\30"+
    "\1\255\17\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\16\0\1\256\2\0\1\257\23\0\1\260\1\261\1\262"+
    "\1\0\1\263\1\264\1\0\1\265\1\266\1\0\1\267"+
    "\27\0\1\30\1\0\1\30\1\0\4\30\25\0\16\30"+
    "\1\270\3\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\22\30"+
    "\1\0\1\30\1\0\1\30\1\0\1\30\1\271\1\30"+
    "\7\0\20\272\1\273\52\272\1\202\3\272\24\0\1\274"+
    "\52\0\16\101\1\275\1\0\1\276\1\101\1\277\57\101"+
    "\1\300\2\101\3\300\5\101\1\301\1\302\1\276\1\101"+
    "\1\303\13\101\22\300\1\101\1\300\1\101\1\300\1\101"+
    "\3\300\124\101\1\304\1\302\1\276\1\101\1\305\54\101"+
    "\20\106\1\306\52\106\1\0\23\106\1\202\52\106\1\202"+
    "\3\106\16\110\1\307\1\110\1\310\1\0\1\311\57\110"+
    "\1\300\2\110\3\300\5\110\1\312\1\110\1\310\1\313"+
    "\1\303\13\110\22\300\1\110\1\300\1\110\1\300\1\110"+
    "\3\300\124\110\1\304\1\110\1\310\1\313\1\314\54\110"+
    "\24\0\1\315\70\0\1\304\60\0\11\117\1\120\3\117"+
    "\1\120\1\316\1\117\1\317\1\117\1\320\54\117\3\321"+
    "\1\322\2\321\3\322\1\120\3\321\1\120\1\323\1\321"+
    "\1\324\1\321\1\325\13\321\22\322\1\321\1\322\1\321"+
    "\1\322\1\321\3\322\7\321\3\117\1\300\2\117\3\300"+
    "\1\120\3\117\1\120\1\326\1\117\1\317\1\117\1\303"+
    "\13\117\22\300\1\117\1\300\1\117\1\300\1\117\3\300"+
    "\20\117\1\120\3\117\1\120\72\117\1\120\3\117\1\120"+
    "\1\304\1\117\1\317\1\117\1\327\54\117\1\0\1\330"+
    "\1\0\1\330\1\0\4\330\1\331\2\0\1\332\1\331"+
    "\20\0\22\330\1\0\1\330\1\0\1\330\1\0\3\330"+
    "\7\0\11\333\1\0\2\333\2\0\62\333\1\334\1\333"+
    "\1\334\1\333\4\334\1\335\2\333\1\336\1\335\20\333"+
    "\22\334\1\333\1\334\1\333\1\334\1\333\3\334\7\333"+
    "\3\337\1\340\2\337\3\340\1\131\2\337\1\341\1\131"+
    "\20\337\22\340\1\337\1\340\1\337\1\340\1\337\3\340"+
    "\7\337\1\0\1\133\1\0\1\133\1\0\4\133\25\0"+
    "\22\133\1\0\1\133\1\0\1\133\1\0\3\133\33\0"+
    "\1\342\53\0\1\135\3\0\1\135\72\0\1\135\3\0"+
    "\1\135\1\173\73\0\1\343\2\0\3\343\25\0\22\343"+
    "\1\0\1\343\1\0\1\343\1\0\3\343\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\10\30\1\220\11\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\7\0\30\144"+
    "\1\0\46\144\31\0\1\344\76\0\1\345\50\0\1\346"+
    "\33\0\1\347\1\350\1\351\1\352\1\353\1\354\1\355"+
    "\1\356\1\357\1\360\3\0\1\361\1\0\1\362\1\363"+
    "\1\0\1\364\1\0\1\365\13\0\11\151\1\153\3\151"+
    "\1\153\6\151\1\153\5\151\1\153\42\151\1\153\1\151"+
    "\15\0\1\366\105\0\1\367\63\0\2\160\2\0\1\160"+
    "\62\0\1\161\1\0\1\162\1\0\1\161\72\0\1\135"+
    "\2\0\2\135\17\0\1\135\52\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\5\30\1\370\1\371\13\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\4\30\1\372\15\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\14\30\1\373\5\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\12\30\1\374\7\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\20\30\1\375\1\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\2\30\1\376\17\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\377\1\0"+
    "\1\377\1\0\1\377\1\0\1\377\30\0\1\377\1\0"+
    "\1\377\2\0\1\377\1\0\1\377\56\0\1\u0100\50\0"+
    "\1\30\1\0\1\u0101\1\0\4\30\25\0\22\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\176\1\0"+
    "\1\176\1\0\4\176\25\0\22\176\1\0\1\176\1\0"+
    "\1\176\1\0\3\176\10\0\1\176\1\0\1\176\1\0"+
    "\4\176\25\0\14\176\1\u0102\5\176\1\0\1\176\1\0"+
    "\1\176\1\0\3\176\7\0\3\200\1\0\2\200\3\0"+
    "\5\200\1\201\1\202\1\203\1\200\1\0\13\200\22\0"+
    "\1\200\1\0\1\200\1\0\1\200\3\0\124\200\1\0"+
    "\1\202\1\203\1\200\1\204\54\200\23\0\1\163\3\0"+
    "\1\u0103\77\0\1\u0104\57\0\2\210\2\0\1\210\62\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\6\30\1\u0105"+
    "\13\30\1\0\1\30\1\0\1\30\1\0\2\30\1\u0106"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\12\30"+
    "\1\u0107\7\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\1\30"+
    "\1\u0108\20\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\4\30"+
    "\1\211\15\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\15\30"+
    "\1\u0109\4\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\16\30"+
    "\1\u010a\3\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\7\30"+
    "\1\u010b\1\30\1\u010c\10\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\u010d\1\0\4\30"+
    "\25\0\22\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\6\30"+
    "\1\u010e\2\30\1\u010f\1\u0110\7\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\12\30\1\u0111\7\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\20\30\1\u0112\1\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\10\30\1\u0113\2\30\1\u0114\6\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\30\1\u0115\20\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\30\1\u0116\20\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\u0117\21\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\16\30\1\u0118\3\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\3\30\1\u0119\16\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\3\30\1\u011a\16\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\12\30\1\u011b\7\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\u011c"+
    "\1\0\4\30\25\0\22\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\3\30\1\u011d\16\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\6\30\1\u011e\3\30\1\u011f\7\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\1\u0120\1\30\1\u0121\17\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\16\30\1\u0122\3\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\2\30\1\u0123\17\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\5\30\1\u0124\14\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\5\30\1\u0125\14\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\12\30\1\u0126\7\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\u0127\4\30\1\u0128\14\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\1\30\1\u0129\20\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\2\30\1\u012a\1\30\25\0\22\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\1\30\1\u012b\20\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\45\0\1\u012c"+
    "\4\0\1\u012d\42\0\1\u012e\72\0\1\u012f\132\0\1\u0130"+
    "\75\0\1\u0131\101\0\1\u0132\111\0\1\u0133\63\0\1\u0134"+
    "\101\0\1\u0135\33\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\1\u0136\21\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\7\30\1\u0137\1\30\1\u0138\2\30\1\u0139\1\30\1\u013a"+
    "\2\30\1\u013b\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\7\0\77\272\11\0\2\274\2\0\1\274\61\0\3\101"+
    "\1\0\2\101\3\0\5\101\1\301\1\302\1\276\1\101"+
    "\1\0\13\101\22\0\1\101\1\0\1\101\1\0\1\101"+
    "\3\0\25\101\1\0\1\302\1\276\1\101\1\305\54\101"+
    "\1\0\1\300\1\0\1\300\1\0\4\300\25\0\22\300"+
    "\1\0\1\300\1\0\1\300\1\0\3\300\1\0\1\u013c"+
    "\5\0\20\106\1\0\52\106\1\0\3\106\3\110\1\0"+
    "\2\110\3\0\5\110\1\312\1\110\1\310\1\313\1\0"+
    "\13\110\22\0\1\110\1\0\1\110\1\0\1\110\3\0"+
    "\25\110\1\0\1\110\1\310\1\313\1\314\54\110\3\117"+
    "\1\0\2\117\3\0\1\120\3\117\1\120\1\326\1\117"+
    "\1\317\1\117\1\0\13\117\22\0\1\117\1\0\1\117"+
    "\1\0\1\117\3\0\20\117\1\120\3\117\1\120\1\0"+
    "\1\117\1\317\1\117\1\327\54\117\11\321\1\120\3\321"+
    "\1\120\1\323\1\321\1\324\1\321\1\325\55\321\1\322"+
    "\1\321\1\322\1\321\4\322\1\u013d\2\321\1\u013e\1\u013d"+
    "\1\323\1\321\1\324\1\321\1\325\13\321\22\322\1\321"+
    "\1\322\1\321\1\322\1\321\3\322\12\321\1\u013f\2\321"+
    "\3\u013f\1\120\3\321\1\120\1\323\1\321\1\324\1\321"+
    "\1\u013f\13\321\22\u013f\1\321\1\u013f\1\321\1\u013f\1\321"+
    "\3\u013f\20\321\1\120\3\321\1\120\72\321\1\120\3\321"+
    "\1\120\1\u013f\1\321\1\324\1\321\1\325\54\321\11\0"+
    "\1\331\3\0\1\331\61\0\3\341\1\127\2\341\3\127"+
    "\25\341\22\127\1\341\1\127\1\341\1\127\1\341\3\127"+
    "\10\341\1\127\1\341\1\127\1\341\4\127\1\u0140\2\341"+
    "\1\u0141\1\u0140\20\341\22\127\1\341\1\127\1\341\1\127"+
    "\1\341\3\127\7\341\11\0\1\335\3\0\1\335\61\0"+
    "\3\337\1\340\2\337\3\340\1\341\2\337\2\341\20\337"+
    "\22\340\1\337\1\340\1\337\1\340\1\337\3\340\10\337"+
    "\1\340\1\337\1\340\1\337\4\340\1\u0140\2\337\1\u0141"+
    "\1\u0140\20\337\22\340\1\337\1\340\1\337\1\340\1\337"+
    "\3\340\7\337\1\0\1\343\1\0\1\343\1\0\4\343"+
    "\25\0\22\343\1\0\1\343\1\0\1\343\1\0\3\343"+
    "\15\0\1\u0142\73\0\1\u0143\102\0\1\u0144\36\0\1\u0145"+
    "\1\u0146\67\0\1\u0147\41\0\1\u0148\134\0\1\u0149\21\0"+
    "\1\u014a\61\0\1\u014b\3\0\1\u014c\67\0\1\u014d\103\0"+
    "\1\u014e\64\0\1\u014f\1\0\1\u0150\41\0\1\u0151\37\0"+
    "\1\u0152\1\u0153\1\0\1\u0154\73\0\1\u0155\72\0\1\u0156"+
    "\1\u0157\41\0\1\u0158\34\0\1\u0159\41\0\1\u015a\34\0"+
    "\1\u015b\112\0\1\u015c\33\0\2\367\2\0\1\367\62\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\6\30\1\u015d"+
    "\13\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\u015e\1\0\4\30\25\0\22\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\4\30\1\u015f\1\u0160\1\30"+
    "\1\u0161\2\30\1\u0162\2\30\1\u0163\4\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\1\u0164\21\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\u0165\1\0"+
    "\4\30\25\0\22\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\6\30\1\u0166\13\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\16\30\1\u0167\3\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\36\0\1\u0103\50\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\2\30\1\u0168\17\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\176\1\0\1\176\1\0"+
    "\4\176\25\0\5\176\1\u0169\14\176\1\0\1\176\1\0"+
    "\1\176\1\0\3\176\12\0\1\u016a\2\0\3\u016a\1\0"+
    "\1\u0103\23\0\22\u016a\1\0\1\u016a\1\0\1\u016a\1\0"+
    "\3\u016a\40\0\1\u016b\46\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\10\30\1\u016c\11\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\10\30\1\u016d\11\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\6\30\1\u016e\13\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\2\30\1\u016f\17\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\16\30\1\u0170\3\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\2\30\1\u0171\17\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\16\30\1\u0172\3\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\u0173\1\0"+
    "\4\30\25\0\22\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\16\30\1\u0174\3\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\6\30\1\u0175\13\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\u0176\1\0\4\30\25\0"+
    "\22\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\16\30\1\u0177"+
    "\3\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\u0178\1\0\4\30\25\0\22\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\u0179\21\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\u017a"+
    "\1\0\4\30\25\0\22\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\21\30\1\u017b\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\12\30\1\u017c\7\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\2\30\1\u017d\17\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\11\30\1\u017e\10\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\u017f\1\0\4\30\25\0"+
    "\22\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\6\30\1\u0180"+
    "\3\30\1\u0181\7\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\11\30\1\u0182\10\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\u0183\1\0\4\30\25\0"+
    "\22\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\3\30\1\u0184"+
    "\16\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\12\30\1\u0185"+
    "\7\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\7\30\1\u0186"+
    "\12\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\6\30\1\u0187"+
    "\13\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\6\30\1\u0188"+
    "\13\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\16\30\1\u0189"+
    "\3\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\6\30\1\u018a"+
    "\13\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\6\30\1\u018b"+
    "\13\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\3\30\1\u018c"+
    "\16\30\1\0\1\u018d\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\u018e\1\0\4\30\25\0\22\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\16\30\1\u018f\3\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\45\0\1\u0190\101\0"+
    "\1\u0191\122\0\1\u0192\51\0\1\u0193\75\0\1\u0194\105\0"+
    "\1\u0195\74\0\1\u0196\70\0\1\u0197\110\0\1\u0198\65\0"+
    "\1\u0199\40\0\1\30\1\0\1\30\1\0\2\30\1\u019a"+
    "\1\30\25\0\22\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\5\30\1\u019b\2\30\1\u019c\11\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\16\30\1\u019d\3\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\2\30\1\u019e\17\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\5\30\1\u019f\14\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\u01a0\1\0"+
    "\4\30\25\0\22\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\7\0\11\321\1\u013d\3\321\1\u013d\1\323\1\321"+
    "\1\324\1\321\1\325\54\321\11\u013f\1\0\3\u013f\1\0"+
    "\61\u013f\11\333\1\335\2\333\1\0\1\335\61\333\40\0"+
    "\1\u01a1\6\0\1\u01a2\73\0\1\u01a3\102\0\1\u01a4\72\0"+
    "\1\u01a5\101\0\1\u01a6\106\0\1\u01a7\67\0\1\u01a8\5\0"+
    "\1\u01a9\64\0\1\u01aa\73\0\1\u01ab\101\0\1\u01ac\71\0"+
    "\1\u01ad\100\0\1\u01ae\12\0\1\u01af\25\0\1\u01b0\151\0"+
    "\1\u01b1\64\0\1\u01b2\35\0\1\u01b3\134\0\1\u01b4\75\0"+
    "\1\u01b5\45\0\1\u01b6\130\0\1\u01b7\5\0\1\u01b8\65\0"+
    "\1\u01b9\77\0\1\u01ba\7\0\1\u01bb\73\0\1\u01bc\115\0"+
    "\1\u01bd\52\0\1\u01be\76\0\1\u01bf\75\0\1\u01c0\41\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\3\30\1\u01c1"+
    "\16\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\u01c2\1\0\4\30\25\0\22\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\7\30\1\u01c3\12\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\u01c4\21\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\15\30\1\u01c5\4\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\14\30\1\u01c6\5\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\5\30\1\u01c7\14\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\13\30\1\u01c8\6\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\17\30\1\u01c9\2\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\176\1\0\1\176"+
    "\1\0\4\176\25\0\12\176\1\u01ca\7\176\1\0\1\176"+
    "\1\0\1\176\1\0\3\176\10\0\1\u016a\1\0\1\u016a"+
    "\1\0\4\u016a\1\u01cb\3\0\1\u01cc\20\0\22\u016a\1\0"+
    "\1\u016a\1\0\1\u016a\1\0\3\u016a\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\30\1\u01cd\20\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\5\30\1\u01ce\14\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\30\1\u01cf\20\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\13\30\1\u01d0\6\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\10\30\1\u01d1\11\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\2\30\1\u01d2\17\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\30\1\u01d3\20\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\10\30\1\u01d4\11\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\2\30\1\u01d5\17\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\6\30\1\u01d6\13\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\u01d7\1\0\4\30\25\0\22\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\15\30\1\u01d8\4\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\2\30\1\u01d9\17\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\u01da\1\0"+
    "\4\30\25\0\22\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\16\30\1\u01db\3\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\6\30\1\u01dc\13\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\6\30\1\u01dd\13\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\5\30\1\u01de\14\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\6\30\1\u01df\13\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\14\30\1\u01e0\5\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\u01e1\1\0\4\30\25\0"+
    "\22\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\12\30\1\u01e2"+
    "\7\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\5\30\1\u01e3"+
    "\14\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\11\30\1\u01e4"+
    "\10\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\u01e5\1\0\4\30\25\0\22\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\u01e6\1\0\4\30\25\0\22\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\6\30\1\u01e7\13\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\2\30\1\u01e8\17\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\3\30\1\u01e9\16\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\5\30\1\u01ea\14\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\63\0\1\u01eb\62\0\1\u01ec\41\0"+
    "\1\u01ed\147\0\1\u01ee\62\0\1\u01ef\45\0\1\u01f0\72\0"+
    "\1\u01f1\6\0\1\u01ee\51\0\1\u01f2\52\0\1\u01f3\41\0"+
    "\1\u01f3\136\0\1\u01f4\34\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\2\30\1\u01f5\17\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\16\30\1\u01f6\3\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\3\30\1\u01f7\16\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\2\30\1\u01f8\17\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\16\30\1\u01f9\3\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\3\30\1\u01fa\16\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\6\30\1\u01fb\13\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\66\0\1\u01fc\22\0\1\u01fd\141\0"+
    "\1\u01fe\74\0\1\u01ff\104\0\1\u0200\27\0\1\u0201\76\0"+
    "\1\u0202\142\0\1\u0203\66\0\1\u0204\42\0\1\u0205\131\0"+
    "\1\u0206\76\0\1\u0207\76\0\1\u0208\100\0\1\u0209\41\0"+
    "\1\u020a\143\0\1\u020b\77\0\1\u020c\30\0\1\u020d\142\0"+
    "\1\u020e\73\0\1\u020f\110\0\1\u0210\75\0\1\u0211\24\0"+
    "\1\u0212\151\0\1\u0213\60\0\1\u0214\113\0\1\u0215\73\0"+
    "\1\u0216\67\0\1\u0217\103\0\1\u0218\35\0\1\u0219\70\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\4\30\1\u021a"+
    "\15\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\11\30\1\u021b"+
    "\10\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\1\30\1\u021c"+
    "\20\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\5\30\1\u021d"+
    "\14\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\5\30\1\u021e"+
    "\14\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\30\1\0\4\30\25\0\7\30\1\u021f"+
    "\12\30\1\0\1\30\1\0\1\30\1\0\3\30\24\0"+
    "\1\u01cc\62\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\3\30\1\u0220\16\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\1\30\1\u0221\20\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\2\30\1\u0222\17\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\16\30\1\u0223\3\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\1\30\1\u0224\20\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\7\30\1\u0225\12\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\4\30\1\u0226\15\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\3\30\1\u0227\16\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\21\30\1\u0228\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\11\30"+
    "\1\u0229\10\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\5\30"+
    "\1\u022a\14\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\3\30"+
    "\1\u022b\16\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\11\30"+
    "\1\u022c\10\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\14\30"+
    "\1\u022d\5\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\11\30"+
    "\1\u022e\10\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\6\30"+
    "\1\u022f\13\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\6\30"+
    "\1\u0230\13\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\11\30"+
    "\1\u0231\10\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\12\0\1\u0232\6\0\1\u01ee\51\0\1\u01f2\51\0\1\u01ef"+
    "\106\0\1\u01f3\41\0\1\u01ee\51\0\1\u01f2\63\0\1\u01ee"+
    "\101\0\1\u0233\105\0\1\u0234\57\0\1\u01ee\73\0\1\u0235"+
    "\36\0\1\30\1\0\1\30\1\0\4\30\25\0\16\30"+
    "\1\u0236\3\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\u0237\1\0\4\30\25\0\22\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\11\30\1\u0238\10\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\12\30\1\u0239\7\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\6\30\1\u023a\13\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\u023b\1\0\4\30\25\0\22\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\14\30\1\u023c\5\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\65\0\1\u023d\76\0\1\u023e"+
    "\57\0\1\u023f\76\0\1\u0240\75\0\1\u0241\110\0\1\u0242"+
    "\31\0\1\u0243\132\0\1\u0244\76\0\1\u0245\76\0\1\u0246"+
    "\112\0\1\u0247\77\0\1\u0248\72\0\1\u0249\65\0\1\u024a"+
    "\122\0\1\u024b\16\0\1\u024c\136\0\1\u024d\73\0\1\u024e"+
    "\77\0\1\u024f\40\0\1\u0250\152\0\1\u0251\57\0\1\u0252"+
    "\74\0\1\u0253\107\0\1\u0254\72\0\1\u0255\73\0\1\u0256"+
    "\37\0\1\30\1\0\1\30\1\0\4\30\25\0\12\30"+
    "\1\u0257\7\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\16\30"+
    "\1\u0258\3\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\u0259\1\0\4\30\25\0\22\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\6\30\1\u025a\13\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\16\30\1\u025b\3\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\u025c\1\0\4\30\25\0\22\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\11\30\1\u025d\10\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\6\30\1\u025e\13\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\u025f"+
    "\1\0\4\30\25\0\22\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\2\30\1\u0260\17\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\u0261\1\0\4\30"+
    "\25\0\22\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\11\30"+
    "\1\u0262\10\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\u0263\1\0\4\30\25\0\22\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\14\30\1\u0264\5\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\1\u0265\21\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\10\30\1\u0266\11\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\6\30\1\u0267\13\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\u0268\1\0\4\30\25\0\22\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\47\0\1\u0269\41\0\1\u01ee\76\0"+
    "\1\u026a\156\0\1\u01ee\14\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\22\30\1\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\u026b\1\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\6\30\1\u026c\13\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\12\30\1\u026d\7\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\22\30\1\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\u026e\1\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\22\30\1\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\u026f\1\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\1\u0270\21\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\63\0\1\u0271\66\0\1\u0272\73\0\1\u0273"+
    "\75\0\1\u0274\75\0\1\u0275\107\0\1\u0276\75\0\1\u0277"+
    "\70\0\1\u0278\40\0\1\u0279\136\0\1\u027a\103\0\1\u027b"+
    "\64\0\1\u027c\103\0\1\u027d\71\0\1\u027e\107\0\1\u027f"+
    "\76\0\1\u0280\77\0\1\u0281\65\0\1\u0282\122\0\1\u0283"+
    "\55\0\1\u0284\72\0\1\u0285\114\0\1\u0286\23\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\2\30\1\u0287\17\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\2\30\1\u0288\17\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\30\1\0\4\30\25\0\11\30\1\u0289\10\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\10\0\1\30"+
    "\1\0\1\u028a\1\0\4\30\25\0\22\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\22\30\1\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\u028b\1\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\6\30\1\u028c\13\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\11\30\1\u028d\10\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\22\30\1\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\u028e\1\30\10\0\1\30\1\0\1\u028f"+
    "\1\0\4\30\25\0\22\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\3\30\1\u0290\16\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\3\30\1\u0291\16\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\u0292\1\0\4\30"+
    "\25\0\22\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\u0293\1\0\4\30\25\0\22\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\50\0\1\u01ee"+
    "\74\0\1\u01ee\40\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\22\30\1\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\u0294\1\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\5\30\1\u0295\14\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\22\30\1\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\u0296\1\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\11\30\1\u0297\10\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\22\30\1\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\u0298\1\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\4\30\1\u0299\15\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\12\0\1\u029a\136\0\1\u029b\102\0\1\u029c"+
    "\67\0\1\u029d\76\0\1\u029e\76\0\1\u029f\104\0\1\u02a0"+
    "\113\0\1\u02a1\52\0\1\u02a2\120\0\1\u02a3\72\0\1\u02a4"+
    "\24\0\1\u02a5\137\0\1\u02a6\35\0\1\u02a7\134\0\1\u02a8"+
    "\36\0\1\30\1\0\1\30\1\0\4\30\25\0\1\30"+
    "\1\u02a9\20\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\11\30"+
    "\1\u02aa\10\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\14\30"+
    "\1\u02ab\5\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\1\u02ac"+
    "\21\30\1\0\1\30\1\0\1\30\1\0\3\30\10\0"+
    "\1\30\1\0\1\u02ad\1\0\4\30\25\0\22\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\1\u02ae\21\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\1\u02af\21\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\6\30\1\u02b0\13\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\4\30\1\u02b1\15\30\1\0\1\30\1\0"+
    "\1\30\1\0\3\30\10\0\1\30\1\0\1\30\1\0"+
    "\4\30\25\0\1\u02b2\21\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\22\30\1\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\u02b3\1\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\1\u02b4\21\30\1\0\1\30\1\0\1\30\1\0"+
    "\3\30\10\0\1\30\1\0\1\30\1\0\4\30\25\0"+
    "\22\30\1\0\1\30\1\0\1\30\1\0\1\30\1\u02b5"+
    "\1\30\45\0\1\u02b6\104\0\1\u02b7\76\0\1\u02b8\106\0"+
    "\1\u02b9\76\0\1\u02ba\61\0\1\u02bb\111\0\1\u02bc\75\0"+
    "\1\u02bd\65\0\1\u02be\76\0\1\u02bf\107\0\1\u02c0\26\0"+
    "\1\30\1\0\1\u02c1\1\0\4\30\25\0\22\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\14\30\1\u02c2\5\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\3\30\1\u02c3\16\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\3\30\1\u02c4\16\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\7\30\1\u02c5\12\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\12\30\1\u02c6\7\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\3\30\1\u02c7\16\30\1\0"+
    "\1\30\1\0\1\30\1\0\3\30\10\0\1\30\1\0"+
    "\1\30\1\0\4\30\25\0\21\30\1\u02c8\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\30"+
    "\1\0\4\30\25\0\22\30\1\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\u02c9\1\30\50\0\1\u02ca\40\0\1\u02cb"+
    "\142\0\1\u02cc\73\0\1\u02cd\71\0\1\u02ce\122\0\1\u02cf"+
    "\14\0\1\30\1\0\1\30\1\0\4\30\25\0\11\30"+
    "\1\u02d0\10\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\11\30"+
    "\1\u02d1\10\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\22\30"+
    "\1\0\1\30\1\0\1\30\1\0\1\30\1\u02d2\1\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\20\30"+
    "\1\u02d3\1\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\51\0\1\u02d4\37\0\1\u02d5\76\0\1\u02d6\74\0\1\30"+
    "\1\0\1\u02d7\1\0\4\30\25\0\22\30\1\0\1\30"+
    "\1\0\1\30\1\0\3\30\10\0\1\30\1\0\1\u02d8"+
    "\1\0\4\30\25\0\22\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\22\30\1\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\u02d9\1\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\5\30\1\u02da\14\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\30\1\0\4\30"+
    "\25\0\16\30\1\u02db\3\30\1\0\1\30\1\0\1\30"+
    "\1\0\3\30\10\0\1\30\1\0\1\u02dc\1\0\4\30"+
    "\25\0\22\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\10\0\1\30\1\0\1\30\1\0\4\30\25\0\1\30"+
    "\1\u02dd\20\30\1\0\1\30\1\0\1\30\1\0\3\30"+
    "\7\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[36477];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"		//$NON-NLS-1$
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\5\0\1\1\10\0\1\11\11\1\2\11\2\1"+
    "\2\11\35\1\1\11\1\1\1\11\3\1\1\11\10\1"+
    "\1\11\7\1\1\11\4\1\1\0\1\11\3\1\1\11"+
    "\1\1\1\11\2\1\1\11\2\1\1\11\4\1\2\11"+
    "\2\1\1\11\3\1\1\11\6\1\1\11\2\0\3\1"+
    "\2\0\1\11\2\0\47\1\1\11\1\1\12\0\2\1"+
    "\2\0\1\1\3\0\2\1\3\11\1\1\4\0\1\1"+
    "\1\11\1\1\1\11\3\0\7\1\1\0\1\11\2\0"+
    "\1\1\1\11\1\1\1\0\1\1\1\0\1\11\1\1"+
    "\2\11\20\0\1\11\11\1\1\0\2\1\1\0\50\1"+
    "\12\0\6\1\2\11\4\1\33\0\15\1\1\0\1\11"+
    "\44\1\12\0\7\1\22\0\1\11\13\0\1\11\1\0"+
    "\13\1\1\11\36\1\7\0\1\11\2\0\7\1\6\0"+
    "\2\11\7\0\1\11\5\0\1\11\10\0\30\1\4\0"+
    "\7\1\13\0\1\11\3\0\1\11\4\0\1\11\2\0"+
    "\1\11\2\0\22\1\2\0\6\1\2\0\1\11\1\0"+
    "\2\11\2\0\1\11\1\0\1\11\3\0\1\1\4\0"+
    "\1\11\1\0\1\11\23\1\1\11\12\0\1\11\1\0"+
    "\2\11\15\1\1\0\1\11\1\0\2\11\2\0\1\11"+
    "\2\0\1\11\11\1\1\11\2\0\2\11\1\0\4\1"+
    "\3\11\7\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[733];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
    public PhpLexer(int state){
        initialize(state);
    }

    // NB: this method resets the lexer only partially
    protected void reset(java.io.Reader reader, char[] buffer, int[] parameters){
    	this.zzReader = reader;
    	this.zzBuffer = buffer;
    	this.zzFinalHighSurrogate = 0;
    	this.zzMarkedPos = parameters[0];
    	this._zzPushbackPos = parameters[1];
    	this.zzCurrentPos = parameters[2];
    	this.zzStartRead = parameters[3];
    	this.zzEndRead = parameters[4];
    	this.yyline = parameters[5];
    	initialize(parameters[6]);
    }

    protected boolean isHeredocState(int state){
    	    	return state == ST_PHP_HEREDOC || state == ST_PHP_START_HEREDOC || state == ST_PHP_END_HEREDOC;
    }

    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, _zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
    }

    protected int getZZLexicalState() {
        return zzLexicalState;
    }

    protected int getZZMarkedPos() {
        return zzMarkedPos;
    }

    protected int getZZEndRead() {
        return zzEndRead;
    }

    public char[] getZZBuffer() {
        return zzBuffer;
    }

    protected int getZZStartRead() {
    	return this.zzStartRead;
    }

    protected int getZZPushBackPosition() {
    	return this._zzPushbackPos;
    }

	protected void pushBack(int i) {
		yypushback(i);
	}

	public int getScriptingState() {
       return ST_PHP_IN_SCRIPTING;
    }

	// A pool of states. To avoid creation of a new state on each createMemento.
	private static final IntHashtable lexerStates = new IntHashtable(100);

	protected IntHashtable getLexerStates() {
		return lexerStates;
	}

 // End user code



  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 234) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (zzRefill()) {
        return YYEOF;
    }

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
    oldString = null;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		startPos = zzMarkedPos;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { if(heredoc!=null&&yytext().startsWith(heredoc)){
		String text = yytext();
		if(heredoc_len < text.length() && (text.charAt(heredoc_len) == '\r'
			|| text.charAt(heredoc_len) == '\n'|| text.charAt(heredoc_len) == ';')){
			yypushback(yylength()-heredoc_len-1);
	        heredoc=null;
	        heredoc_len=0;
	        yybegin(ST_PHP_IN_SCRIPTING);
	        return PHP_HEREDOC_TAG;
		}
	}
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 158: break;
          case 2: 
            { yypushback(1);
    pushState(ST_PHP_HIGHLIGHTING_ERROR);
            }
          case 159: break;
          case 3: 
            { return PHP_NUMBER;
            }
          case 160: break;
          case 4: 
            { return PHP_TOKEN;
            }
          case 161: break;
          case 5: 
            { return  PHP_LABEL;
            }
          case 162: break;
          case 6: 
            { return  WHITESPACE;
            }
          case 163: break;
          case 7: 
            { return PHP_SEMICOLON;
            }
          case 164: break;
          case 8: 
            { pushState(ST_PHP_DOUBLE_QUOTES);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 165: break;
          case 9: 
            { pushState(ST_PHP_BACKQUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 166: break;
          case 10: 
            { return PHP_CURLY_OPEN;
            }
          case 167: break;
          case 11: 
            { if (!phpStack.isEmpty()) {
        popState();
    }
    return  PHP_CURLY_CLOSE;
            }
          case 168: break;
          case 12: 
            { pushState(ST_PHP_SINGLE_QUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 169: break;
          case 13: 
            { pushState(ST_PHP_LINE_COMMENT);
    return PHP_LINE_COMMENT;
            }
          case 170: break;
          case 14: 
            { return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 171: break;
          case 15: 
            { return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 172: break;
          case 16: 
            { popState();
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 173: break;
          case 17: 
            { yypushback(1);
        popState();
            }
          case 174: break;
          case 18: 
            { yypushback(1);
	yybegin(ST_PHP_HEREDOC);
            }
          case 175: break;
          case 19: 
            { int label_len = yylength() - 1;
	int startIndex = 0;
	String yytext = yytext();
	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}
	while (yytext.charAt(startIndex) == '\r'
			|| yytext.charAt(startIndex) == '\n') {
		startIndex++;
	}

	if (label_len > heredoc_len
			&& yytext.substring(startIndex, label_len).equals(
					heredoc)) {
		heredoc = null;
		heredoc_len = 0;
		yybegin(ST_PHP_IN_SCRIPTING);
		return PHP_HEREDOC_TAG;
	} else {
		yybegin(ST_PHP_HEREDOC);
		return PHP_CONSTANT_ENCAPSED_STRING;
	}
            }
          case 176: break;
          case 20: 
            { yypushback(1);
    popState();
            }
          case 177: break;
          case 21: 
            { popState();
    return PHP_LABEL;
            }
          case 178: break;
          case 22: 
            { //the difference from the original rules comes from the fact that we took ';' out of tokens
	return UNKNOWN_TOKEN;
            }
          case 179: break;
          case 23: 
            { yypushback(1);
	popState();
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 180: break;
          case 24: 
            { popState();
	return PHP_TOKEN;
            }
          case 181: break;
          case 25: 
            { return PHP_COMMENT;
            }
          case 182: break;
          case 26: 
            { return PHPDOC_COMMENT;
            }
          case 183: break;
          case 27: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			if (yylength() > 0) {
				return PHP_LINE_COMMENT;
			}
			break;
		default:
			popState();
			return PHP_LINE_COMMENT;
	}
            }
          case 184: break;
          case 28: 
            { return PHP_LINE_COMMENT;
            }
          case 185: break;
          case 29: 
            { return UNKNOWN_TOKEN;
            }
          case 186: break;
          case 30: 
            { popState();return WHITESPACE;
            }
          case 187: break;
          case 31: 
            { return PHP_OPERATOR;
            }
          case 188: break;
          case 32: 
            { pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OBJECT_OPERATOR;
            }
          case 189: break;
          case 33: 
            { return PHP_VARIABLE;
            }
          case 190: break;
          case 34: 
            { pushState(ST_PHP_COMMENT);
    return PHP_COMMENT_START;
            }
          case 191: break;
          case 35: 
            { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	return UNKNOWN_TOKEN;
            }
          case 192: break;
          case 36: 
            { return PHP_AS;
            }
          case 193: break;
          case 37: 
            { return PHP_DO;
            }
          case 194: break;
          case 38: 
            { return PHP_IF;
            }
          case 195: break;
          case 39: 
            { return PHP_PAAMAYIM_NEKUDOTAYIM;
            }
          case 196: break;
          case 40: 
            { return PHP_CLOSETAG;
            }
          case 197: break;
          case 41: 
            { pushState(ST_PHP_QUOTES_AFTER_VARIABLE);
    return PHP_VARIABLE;
            }
          case 198: break;
          case 42: 
            { yypushback(1);
    return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 199: break;
          case 43: 
            { pushState(ST_PHP_IN_SCRIPTING);
    return PHP_TOKEN;
            }
          case 200: break;
          case 44: 
            { yypushback(1);
    pushState(ST_PHP_IN_SCRIPTING);
    return PHP_CURLY_OPEN;
            }
          case 201: break;
          case 45: 
            { yypushback(1);
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 202: break;
          case 46: 
            { popState();
    pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OBJECT_OPERATOR;
            }
          case 203: break;
          case 47: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	   label_len--;
    }
    if (label_len > heredoc_len && yytext().substring(label_len - heredoc_len,label_len).equals(heredoc)) {
    	if ((label_len - heredoc_len-2) >= 0 && yytext().charAt(label_len - heredoc_len-2)=='\r') {
        	label_len = label_len-2;
    	} else {
        	label_len--;
    	}
    	yypushback(heredoc_len + (yylength() - label_len));
        yybegin(ST_PHP_END_HEREDOC);
    }
    // In some cases, all text is pushed back (using yypushback()),
    // especially when the parsed document has Windows newlines.
    // In those cases, ignore this rule and try next one...
    if (yylength() > 0) {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 204: break;
          case 48: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	    label_len--;
    }

    if (label_len==heredoc_len && yytext().substring(0,label_len).equals(heredoc)) {
        heredoc=null;
        heredoc_len=0;
        yybegin(ST_PHP_IN_SCRIPTING);
        return PHP_HEREDOC_TAG;
    } else {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 205: break;
          case 49: 
            { return PHP_OBJECT_OPERATOR;
            }
          case 206: break;
          case 50: 
            { popState();
    return PHP_COMMENT_END;
            }
          case 207: break;
          case 51: 
            { popState();
    return PHPDOC_COMMENT_END;
            }
          case 208: break;
          case 52: 
            { popState();
    return PHP_LINE_COMMENT;
            }
          case 209: break;
          case 53: 
            { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	String text = yytext();
	if(text.indexOf('\r') != -1 || text.indexOf('\n') != -1 ){
		popState();
	}
	return PHP_LINE_COMMENT;
            }
          case 210: break;
          case 54: 
            { pushState(ST_PHP_DOC_COMMENT);
    return PHPDOC_COMMENT_START;
            }
          case 211: break;
          case 55: 
            { return PHP_NEW;
            }
          case 212: break;
          case 56: 
            { return PHP_DIE;
            }
          case 213: break;
          case 57: 
            { return PHP_TRY;
            }
          case 214: break;
          case 58: 
            { return PHP_FOR;
            }
          case 215: break;
          case 59: 
            { return PHP_USE;
            }
          case 216: break;
          case 60: 
            { return PHP_VAR;
            }
          case 217: break;
          case 61: 
            { yypushback(1);
	pushState(ST_PHP_VAR_OFFSET);
	return PHP_VARIABLE;
            }
          case 218: break;
          case 62: 
            { return PHP_EXIT;
            }
          case 219: break;
          case 63: 
            { return PHP_ECHO;
            }
          case 220: break;
          case 64: 
            { return PHP_ELSE;
            }
          case 221: break;
          case 65: 
            { return PHP_EVAL;
            }
          case 222: break;
          case 66: 
            { yypushback(2);
    pushState(ST_PHP_COMMENT);
    return PHP_COMMENT_START;
            }
          case 223: break;
          case 67: 
            { return  PHP_KEYWORD;
            }
          case 224: break;
          case 68: 
            { return PHP_TRUE;
            }
          case 225: break;
          case 69: 
            { return PHP_FROM;
            }
          case 226: break;
          case 70: 
            { return PHP_CASE;
            }
          case 227: break;
          case 71: 
            { return PHP_SELF;
            }
          case 228: break;
          case 72: 
            { return PHP_LIST;
            }
          case 229: break;
          case 73: 
            { return PHPDOC_SEE;
            }
          case 230: break;
          case 74: 
            { return PHPDOC_VAR;
            }
          case 231: break;
          case 75: 
            { return PHP_ENDIF;
            }
          case 232: break;
          case 76: 
            { return PHP_EMPTY;
            }
          case 233: break;
          case 77: 
            { return PHP_BREAK;
            }
          case 234: break;
          case 78: 
            { return PHP_THIS;
            }
          case 235: break;
          case 79: 
            { int bprefix = (yytext().charAt(0) != '<') ? 1 : 0;
    int startString=3+bprefix;
    heredoc_len = yylength()-bprefix-3-1-(yytext().charAt(yylength()-2)=='\r'?1:0);
    while ((yytext().charAt(startString) == ' ') || (yytext().charAt(startString) == '\t')) {
        startString++;
        heredoc_len--;
    }
    heredoc = yytext().substring(startString,heredoc_len+startString);
    yybegin(ST_PHP_START_HEREDOC);
    return PHP_HEREDOC_TAG;
            }
          case 236: break;
          case 80: 
            { return PHP_ARRAY;
            }
          case 237: break;
          case 81: 
            { return PHP_ISSET;
            }
          case 238: break;
          case 82: 
            { return PHP_THROW;
            }
          case 239: break;
          case 83: 
            { return PHP_FALSE;
            }
          case 240: break;
          case 84: 
            { return PHP_FINAL;
            }
          case 241: break;
          case 85: 
            { return PHP_UNSET;
            }
          case 242: break;
          case 86: 
            { return PHP_CONST;
            }
          case 243: break;
          case 87: 
            { return PHP_CATCH;
            }
          case 244: break;
          case 88: 
            { return PHP_CLONE;
            }
          case 245: break;
          case 89: 
            { return PHP_CLASS;
            }
          case 246: break;
          case 90: 
            { return PHP_WHILE;
            }
          case 247: break;
          case 91: 
            { return PHP_PRINT;
            }
          case 248: break;
          case 92: 
            { return PHP_CASTING;
            }
          case 249: break;
          case 93: 
            { return PHPDOC_NAME;
            }
          case 250: break;
          case 94: 
            { return PHPDOC_DESC;
            }
          case 251: break;
          case 95: 
            { return PHPDOC_USES;
            }
          case 252: break;
          case 96: 
            { return PHPDOC_LINK;
            }
          case 253: break;
          case 97: 
            { return PHP_ENDFOR;
            }
          case 254: break;
          case 98: 
            { return PHP_ELSEIF;
            }
          case 255: break;
          case 99: 
            { return PHP_RETURN;
            }
          case 256: break;
          case 100: 
            { return PHP_STATIC;
            }
          case 257: break;
          case 101: 
            { return PHP_SWITCH;
            }
          case 258: break;
          case 102: 
            { return PHP_PARENT;
            }
          case 259: break;
          case 103: 
            { return PHP_PUBLIC;
            }
          case 260: break;
          case 104: 
            { return PHP_GLOBAL;
            }
          case 261: break;
          case 105: 
            { return PHPDOC_FINAL;
            }
          case 262: break;
          case 106: 
            { return PHPDOC_SINCE;
            }
          case 263: break;
          case 107: 
            { return PHPDOC_PARAM;
            }
          case 264: break;
          case 108: 
            { return PHPDOC_MAGIC;
            }
          case 265: break;
          case 109: 
            { return PHP_EXTENDS;
            }
          case 266: break;
          case 110: 
            { return PHP_REQUIRE;
            }
          case 267: break;
          case 111: 
            { return PHP_DEFAULT;
            }
          case 268: break;
          case 112: 
            { return PHP_DECLARE;
            }
          case 269: break;
          case 113: 
            { return PHP_INCLUDE;
            }
          case 270: break;
          case 114: 
            { return PHP_FOREACH;
            }
          case 271: break;
          case 115: 
            { return PHP_PRIVATE;
            }
          case 272: break;
          case 116: 
            { return PHPDOC_RETURN;
            }
          case 273: break;
          case 117: 
            { return PHPDOC_AUTHOR;
            }
          case 274: break;
          case 118: 
            { return PHPDOC_ACCESS;
            }
          case 275: break;
          case 119: 
            { return PHPDOC_IGNORE;
            }
          case 276: break;
          case 120: 
            { return PHPDOC_THROWS;
            }
          case 277: break;
          case 121: 
            { return PHPDOC_STATIC;
            }
          case 278: break;
          case 122: 
            { return PHPDOC_METHOD;
            }
          case 279: break;
          case 123: 
            { return PHPDOC_GLOBAL;
            }
          case 280: break;
          case 124: 
            { return PHP_ENDWHILE;
            }
          case 281: break;
          case 125: 
            { return PHP_ABSTRACT;
            }
          case 282: break;
          case 126: 
            { return PHP_FUNCTION;
            }
          case 283: break;
          case 127: 
            { return PHP_CONTINUE;
            }
          case 284: break;
          case 128: 
            { return PHP__FILE__;
            }
          case 285: break;
          case 129: 
            { return PHP__LINE__;
            }
          case 286: break;
          case 130: 
            { return PHPDOC_EXAMPLE;
            }
          case 287: break;
          case 131: 
            { return PHPDOC_LICENSE;
            }
          case 288: break;
          case 132: 
            { return PHPDOC_PACKAGE;
            }
          case 289: break;
          case 133: 
            { return PHPDOC_VERSION;
            }
          case 290: break;
          case 134: 
            { return PHP_ENDSWITCH;
            }
          case 291: break;
          case 135: 
            { return PHP_INTERFACE;
            }
          case 292: break;
          case 136: 
            { return PHP_PROTECTED;
            }
          case 293: break;
          case 137: 
            { return PHP__CLASS__;
            }
          case 294: break;
          case 138: 
            { return PHPDOC_ABSTRACT;
            }
          case 295: break;
          case 139: 
            { return PHPDOC_INTERNAL;
            }
          case 296: break;
          case 140: 
            { return PHPDOC_TUTORIAL;
            }
          case 297: break;
          case 141: 
            { return PHPDOC_CATEGORY;
            }
          case 298: break;
          case 142: 
            { return PHPDOC_PROPERTY;
            }
          case 299: break;
          case 143: 
            { return PHP_ENDDECLARE;
            }
          case 300: break;
          case 144: 
            { return PHP_ENDFOREACH;
            }
          case 301: break;
          case 145: 
            { return PHP_INSTANCEOF;
            }
          case 302: break;
          case 146: 
            { return PHP_IMPLEMENTS;
            }
          case 303: break;
          case 147: 
            { return PHP__METHOD__;
            }
          case 304: break;
          case 148: 
            { return PHPDOC_EXCEPTION;
            }
          case 305: break;
          case 149: 
            { return PHPDOC_COPYRIGHT;
            }
          case 306: break;
          case 150: 
            { return PHPDOC_STATICVAR;
            }
          case 307: break;
          case 151: 
            { return PHPDOC_DEPRECATED;
            }
          case 308: break;
          case 152: 
            { return PHPDOC_FILESOURCE;
            }
          case 309: break;
          case 153: 
            { return PHPDOC_SUBPACKAGE;
            }
          case 310: break;
          case 154: 
            { return PHP_REQUIRE_ONCE;
            }
          case 311: break;
          case 155: 
            { return PHP_INCLUDE_ONCE;
            }
          case 312: break;
          case 156: 
            { return PHP__FUNCTION__;
            }
          case 313: break;
          case 157: 
            { return PHP_HALT_COMPILER;
            }
          case 314: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
