/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.documentModel.parser.php54;

import org.eclipse.php.internal.core.util.collections.IntHashtable;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>highlighting_scanner.jflex</tt>
 */
public class PhpLexer extends org.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_PHP_IN_SCRIPTING = 2;
  public static final int ST_PHP_DOUBLE_QUOTES = 4;
  public static final int ST_PHP_SINGLE_QUOTE = 6;
  public static final int ST_PHP_BACKQUOTE = 8;
  public static final int ST_PHP_QUOTES_AFTER_VARIABLE = 10;
  public static final int ST_PHP_HEREDOC = 12;
  public static final int ST_PHP_NOWDOC = 14;
  public static final int ST_PHP_START_HEREDOC = 16;
  public static final int ST_PHP_START_NOWDOC = 18;
  public static final int ST_PHP_END_HEREDOC = 20;
  public static final int ST_PHP_LOOKING_FOR_PROPERTY = 22;
  public static final int ST_PHP_VAR_OFFSET = 24;
  public static final int ST_PHP_COMMENT = 26;
  public static final int ST_PHP_DOC_COMMENT = 28;
  public static final int ST_PHP_LINE_COMMENT = 30;
  public static final int ST_PHP_HIGHLIGHTING_ERROR = 32;
  public static final int ST_PHP_END_NOWDOC = 34;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\14\1\13\2\0\1\17\22\0\1\14\1\30\1\21\1\75"+
    "\1\20\1\34\1\35\1\74\1\64\1\65\1\32\1\27\1\15\1\4"+
    "\1\2\1\33\1\5\1\11\10\1\1\62\1\16\1\31\1\25\1\26"+
    "\1\76\1\77\1\42\1\10\1\7\1\44\1\3\1\47\1\57\1\53"+
    "\1\45\1\66\1\56\1\55\1\61\1\43\1\40\1\60\1\70\1\41"+
    "\1\51\1\46\1\50\1\63\1\54\1\6\1\52\1\12\1\72\1\22"+
    "\1\73\1\37\1\67\1\23\1\42\1\10\1\7\1\44\1\3\1\47"+
    "\1\57\1\53\1\45\1\66\1\56\1\55\1\61\1\43\1\40\1\60"+
    "\1\70\1\41\1\51\1\46\1\50\1\63\1\54\1\6\1\52\1\12"+
    "\1\24\1\36\1\71\1\15\261\12\2\45\115\12\1\51\u1faa\12\1\56"+
    "\uded5\12\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\12\0\1\3\1\4\1\5\1\6"+
    "\1\5\1\4\4\6\1\7\1\5\1\10\1\5\1\11"+
    "\1\12\1\13\1\14\12\5\16\6\1\5\1\6\1\5"+
    "\1\6\1\15\1\16\1\17\1\5\1\2\1\20\1\21"+
    "\4\20\1\2\3\20\3\22\2\1\3\3\1\2\2\23"+
    "\2\24\2\3\1\0\1\3\1\25\1\26\1\25\1\27"+
    "\1\30\1\27\1\31\1\30\1\6\1\32\2\33\3\34"+
    "\3\35\3\36\1\37\1\40\1\0\1\3\2\4\1\41"+
    "\6\6\1\42\2\0\3\6\1\0\1\6\2\43\2\0"+
    "\1\20\2\0\2\41\1\44\1\45\1\41\4\6\1\46"+
    "\4\6\1\47\2\6\1\50\25\6\1\51\1\6\12\0"+
    "\1\6\2\0\1\52\3\0\1\53\2\54\1\55\1\56"+
    "\1\54\4\0\3\57\1\60\3\0\1\1\2\54\1\2"+
    "\1\0\1\61\2\0\1\62\6\0\1\63\4\0\1\64"+
    "\1\4\1\53\1\65\1\66\20\0\1\67\1\70\1\0"+
    "\7\6\2\4\6\6\1\0\1\6\1\43\1\0\1\71"+
    "\4\6\1\72\4\6\1\73\7\6\1\74\1\6\1\75"+
    "\5\6\1\76\13\6\1\77\12\0\7\6\1\100\1\101"+
    "\1\1\1\102\1\2\3\0\1\103\4\0\1\63\37\0"+
    "\1\104\1\0\1\105\1\6\1\106\5\6\1\107\1\6"+
    "\1\110\3\6\1\111\4\6\1\43\3\0\1\112\5\6"+
    "\1\113\10\6\1\114\2\6\1\115\4\6\1\116\3\6"+
    "\1\117\1\120\6\6\12\0\10\6\3\0\1\103\24\0"+
    "\1\121\14\0\1\122\2\6\1\123\4\6\1\124\1\6"+
    "\1\125\1\126\1\6\1\127\1\130\1\131\1\132\2\133"+
    "\2\0\3\6\1\134\7\6\1\135\1\6\1\136\1\137"+
    "\1\6\1\140\1\141\1\6\1\142\2\6\1\143\2\6"+
    "\1\144\3\6\7\0\1\145\2\0\10\6\11\0\1\146"+
    "\1\147\7\0\1\150\4\0\1\151\7\0\2\6\1\152"+
    "\2\6\1\153\2\6\1\0\1\154\14\6\1\155\1\156"+
    "\1\157\2\6\1\160\1\161\4\0\10\6\20\0\1\162"+
    "\1\0\1\163\6\0\1\164\1\0\1\165\1\0\1\166"+
    "\6\6\1\167\2\6\1\170\1\171\1\172\4\6\1\173"+
    "\2\6\1\174\2\0\2\6\1\175\5\6\5\0\1\176"+
    "\1\177\1\0\1\200\3\0\1\201\1\0\1\202\1\0"+
    "\1\203\2\0\1\204\2\0\1\205\1\0\3\6\1\206"+
    "\1\207\1\210\1\6\1\211\6\6\1\212\3\6\1\213"+
    "\2\6\1\214\1\6\1\0\1\215\12\0\1\216\1\0"+
    "\1\217\1\220\2\6\1\221\1\6\1\222\1\6\1\223"+
    "\1\224\2\6\1\225\1\226\4\6\2\0\1\227\1\230"+
    "\2\0\1\231\1\232\3\0\1\233\1\234\1\235\2\6"+
    "\1\236\1\237\3\6\1\240\1\241\1\242\1\243\2\0"+
    "\1\244\1\0\5\6\1\245\1\246\1\247\1\250\1\251"+
    "\1\6\1\252\1\6\1\253\2\6\1\254";

  private static int [] zzUnpackAction() {
    int [] result = new int[824];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\100\0\200\0\300\0\u0100\0\u0140\0\u0180\0\u01c0"+
    "\0\u0200\0\u0240\0\u0280\0\u02c0\0\u0300\0\u0340\0\u0380\0\u03c0"+
    "\0\u0400\0\u0440\0\0\0\u0480\0\u04c0\0\u0500\0\u0540\0\u0580"+
    "\0\u05c0\0\u0600\0\u0640\0\u0680\0\u06c0\0\0\0\0\0\u0700"+
    "\0\u0740\0\0\0\0\0\0\0\u0780\0\u07c0\0\u0800\0\u0840"+
    "\0\u0880\0\u08c0\0\u0900\0\u0940\0\u0980\0\u09c0\0\u0a00\0\u0a40"+
    "\0\u0a80\0\u0ac0\0\u0b00\0\u0b40\0\u0b80\0\u0bc0\0\u0c00\0\u0c40"+
    "\0\u0c80\0\u0cc0\0\u0d00\0\u0d40\0\u0d80\0\u0dc0\0\u0e00\0\u0e40"+
    "\0\0\0\u0e80\0\0\0\u0ec0\0\u0f00\0\u0f40\0\0\0\u0f80"+
    "\0\u0fc0\0\u1000\0\u1040\0\u1080\0\u10c0\0\u1100\0\u1140\0\0"+
    "\0\u1180\0\u11c0\0\u1200\0\u1240\0\u1280\0\u12c0\0\u1300\0\u1340"+
    "\0\0\0\u1380\0\0\0\u13c0\0\u1400\0\u1440\0\u1480\0\u1480"+
    "\0\0\0\u14c0\0\u1500\0\u1540\0\0\0\u1580\0\0\0\u15c0"+
    "\0\u1600\0\0\0\u1640\0\u1680\0\0\0\u16c0\0\u1700\0\u1740"+
    "\0\0\0\u1780\0\0\0\u17c0\0\u0ec0\0\0\0\u1800\0\u1840"+
    "\0\u1880\0\u18c0\0\u1900\0\0\0\u1940\0\u1980\0\u19c0\0\u1a00"+
    "\0\u1a40\0\u1a80\0\0\0\u1ac0\0\u1b00\0\u1b40\0\u1b80\0\u1bc0"+
    "\0\u1c00\0\u1c40\0\u1c80\0\u1cc0\0\u0740\0\u1d00\0\0\0\u1d40"+
    "\0\u1d80\0\u08c0\0\u1dc0\0\u1e00\0\u1e40\0\u0680\0\u1e80\0\u1ec0"+
    "\0\u1f00\0\u1f40\0\u0680\0\u1f80\0\u1fc0\0\u2000\0\u2040\0\u0680"+
    "\0\u2080\0\u20c0\0\u0680\0\u2100\0\u2140\0\u2180\0\u21c0\0\u2200"+
    "\0\u2240\0\u2280\0\u22c0\0\u2300\0\u2340\0\u2380\0\u23c0\0\u2400"+
    "\0\u2440\0\u2480\0\u24c0\0\u2500\0\u2540\0\u2580\0\u25c0\0\u2600"+
    "\0\0\0\u2640\0\u2680\0\u0e00\0\u26c0\0\u2700\0\u2740\0\u2780"+
    "\0\u27c0\0\u2800\0\u2840\0\u2880\0\u28c0\0\u0e80\0\u2900\0\u2940"+
    "\0\u2980\0\u0f80\0\u29c0\0\u2a00\0\u2980\0\0\0\0\0\0"+
    "\0\u29c0\0\u2a40\0\u2a80\0\u1100\0\u2ac0\0\u2a80\0\0\0\u2ac0"+
    "\0\0\0\u2b00\0\u12c0\0\u2b40\0\u2b80\0\u2b00\0\u2b40\0\u2bc0"+
    "\0\u1380\0\0\0\u2c00\0\u13c0\0\0\0\u2c40\0\u2c80\0\u2cc0"+
    "\0\u2d00\0\u2d40\0\u2d80\0\0\0\u2dc0\0\u2e00\0\u2e40\0\u1400"+
    "\0\0\0\u2e80\0\u2ec0\0\0\0\0\0\u2f00\0\u2f40\0\u2f80"+
    "\0\u2fc0\0\u3000\0\u3040\0\u3080\0\u30c0\0\u3100\0\u3140\0\u3180"+
    "\0\u31c0\0\u3200\0\u3240\0\u3280\0\u32c0\0\0\0\u3300\0\u3340"+
    "\0\u3380\0\u33c0\0\u3400\0\u3440\0\u3480\0\u34c0\0\u3500\0\u1ac0"+
    "\0\u1b00\0\u3540\0\u3580\0\u35c0\0\u3600\0\u3640\0\u3680\0\u36c0"+
    "\0\u3700\0\u3740\0\u3780\0\u37c0\0\u3800\0\u3840\0\u3880\0\u38c0"+
    "\0\u0680\0\u3900\0\u3940\0\u3980\0\u39c0\0\u0680\0\u3a00\0\u3a40"+
    "\0\u3a80\0\u3ac0\0\u3b00\0\u3b40\0\u3b80\0\u0680\0\u3bc0\0\u3c00"+
    "\0\u3c40\0\u3c80\0\u3cc0\0\u3d00\0\u3d40\0\u0680\0\u3d80\0\u3dc0"+
    "\0\u3e00\0\u3e40\0\u3e80\0\u3ec0\0\u3f00\0\u3f40\0\u3f80\0\u3fc0"+
    "\0\u4000\0\u0680\0\u4040\0\u4080\0\u40c0\0\u4100\0\u4140\0\u4180"+
    "\0\u41c0\0\u4200\0\u4240\0\u4280\0\u42c0\0\u4300\0\u4340\0\u4380"+
    "\0\u43c0\0\u4400\0\u4440\0\0\0\0\0\u4480\0\0\0\u44c0"+
    "\0\u4500\0\u4540\0\u4580\0\u4540\0\u45c0\0\u4600\0\u4640\0\u1440"+
    "\0\u4540\0\u4680\0\u46c0\0\u4700\0\u4740\0\u4780\0\u47c0\0\u4800"+
    "\0\u4840\0\u4880\0\u48c0\0\u4900\0\u4940\0\u4980\0\u49c0\0\u4a00"+
    "\0\u4a40\0\u4a80\0\u4ac0\0\u4b00\0\u4b40\0\u4b80\0\u4bc0\0\u4c00"+
    "\0\u4c40\0\u4c80\0\u4cc0\0\u4d00\0\u4d40\0\u4d80\0\u4dc0\0\u4e00"+
    "\0\0\0\u4e40\0\u0680\0\u4e80\0\u0680\0\u4ec0\0\u4f00\0\u4f40"+
    "\0\u4f80\0\u4fc0\0\u5000\0\u5040\0\u0680\0\u5080\0\u50c0\0\u5100"+
    "\0\u0680\0\u5140\0\u5180\0\u51c0\0\u5200\0\u5240\0\u5280\0\u52c0"+
    "\0\u5300\0\0\0\u5340\0\u5380\0\u53c0\0\u5400\0\u5440\0\u0680"+
    "\0\u5480\0\u54c0\0\u5500\0\u5540\0\u5580\0\u55c0\0\u5600\0\u5640"+
    "\0\u0680\0\u5680\0\u56c0\0\u0680\0\u5700\0\u5740\0\u5780\0\u57c0"+
    "\0\u0680\0\u5800\0\u5840\0\u5880\0\u0680\0\u0680\0\u58c0\0\u5900"+
    "\0\u5940\0\u5980\0\u59c0\0\u5a00\0\u5a40\0\u5a80\0\u5ac0\0\u5b00"+
    "\0\u5b40\0\u5b80\0\u5bc0\0\u5c00\0\u5c40\0\u5c80\0\u5cc0\0\u5d00"+
    "\0\u5d40\0\u5d80\0\u5dc0\0\u5e00\0\u5e40\0\u5e80\0\u5ec0\0\u5f00"+
    "\0\u5f40\0\0\0\u5f80\0\u5fc0\0\u6000\0\u6040\0\u6080\0\u60c0"+
    "\0\u6100\0\u6140\0\u6180\0\u61c0\0\u6200\0\u6240\0\u6280\0\u62c0"+
    "\0\u6300\0\u6340\0\u6380\0\u63c0\0\u6400\0\u6440\0\0\0\u6480"+
    "\0\u64c0\0\u6500\0\u6540\0\u6580\0\u65c0\0\u6600\0\u6640\0\u6680"+
    "\0\u66c0\0\u6700\0\u6740\0\0\0\u6780\0\u67c0\0\u0680\0\u6800"+
    "\0\u6840\0\u6880\0\u68c0\0\u0680\0\u6900\0\u0680\0\u0680\0\u6940"+
    "\0\u0680\0\u0680\0\u0680\0\u1c80\0\0\0\u6980\0\u69c0\0\u6a00"+
    "\0\u6a40\0\u6a80\0\u6ac0\0\u0680\0\u6b00\0\u6b40\0\u6b80\0\u6bc0"+
    "\0\u6c00\0\u6c40\0\u6c80\0\u0680\0\u6cc0\0\u0680\0\u0680\0\u6d00"+
    "\0\u0680\0\u0680\0\u6d40\0\u0680\0\u6d80\0\u6dc0\0\u0680\0\u6e00"+
    "\0\u6e40\0\u0680\0\u6e80\0\u6ec0\0\u6f00\0\u6f40\0\u6f80\0\u6fc0"+
    "\0\u7000\0\u7040\0\u7080\0\u70c0\0\0\0\u7100\0\u7140\0\u7180"+
    "\0\u71c0\0\u7200\0\u7240\0\u7280\0\u72c0\0\u7300\0\u7340\0\u7380"+
    "\0\u73c0\0\u7400\0\u7440\0\u7480\0\u74c0\0\u7500\0\u7540\0\u7580"+
    "\0\u75c0\0\0\0\u7600\0\u7640\0\u7680\0\u76c0\0\u7700\0\u7740"+
    "\0\u7780\0\0\0\u77c0\0\u7800\0\u7840\0\u7880\0\0\0\u78c0"+
    "\0\u7900\0\u7940\0\u7980\0\u79c0\0\u7a00\0\u7a40\0\u7a80\0\u7ac0"+
    "\0\u7b00\0\u7b40\0\u7b80\0\u0680\0\u7bc0\0\u7c00\0\u7c40\0\u0680"+
    "\0\u7c80\0\u7cc0\0\u7d00\0\u7d40\0\u7d80\0\u7dc0\0\u7e00\0\u7e40"+
    "\0\u7e80\0\u7ec0\0\u7f00\0\u7f40\0\u0680\0\u0680\0\u0680\0\u7f80"+
    "\0\u7fc0\0\u0680\0\u0680\0\u8000\0\u8040\0\u8080\0\u80c0\0\u8100"+
    "\0\u8140\0\u8180\0\u81c0\0\u8200\0\u8240\0\u8280\0\u82c0\0\u8300"+
    "\0\u8340\0\u8380\0\u83c0\0\u8400\0\u8440\0\u8480\0\u84c0\0\u8500"+
    "\0\u8540\0\u8580\0\u85c0\0\u8600\0\u8640\0\u8680\0\u86c0\0\0"+
    "\0\u8700\0\0\0\u8740\0\u8780\0\u87c0\0\u8800\0\u8840\0\u8880"+
    "\0\0\0\u88c0\0\0\0\u8900\0\u0680\0\u8940\0\u8980\0\u89c0"+
    "\0\u8a00\0\u8a40\0\u8a80\0\u8ac0\0\u8b00\0\u8b40\0\u0680\0\u0680"+
    "\0\u8b80\0\u8bc0\0\u8c00\0\u8c40\0\u8c80\0\u0680\0\u8cc0\0\u8d00"+
    "\0\u0680\0\u8d40\0\u8d80\0\u8dc0\0\u8e00\0\u0680\0\u8e40\0\u8e80"+
    "\0\u8ec0\0\u8f00\0\u8f40\0\u8f80\0\u8fc0\0\u9000\0\u9040\0\u9080"+
    "\0\0\0\0\0\u90c0\0\0\0\u9100\0\u9140\0\u9180\0\0"+
    "\0\u91c0\0\0\0\u9200\0\u9240\0\u9280\0\u92c0\0\0\0\u9300"+
    "\0\u9340\0\0\0\u9380\0\u93c0\0\u9400\0\u9440\0\u0680\0\u0680"+
    "\0\u0680\0\u9480\0\u0680\0\u94c0\0\u9500\0\u9540\0\u9580\0\u95c0"+
    "\0\u9600\0\u0680\0\u9640\0\u9680\0\u96c0\0\u0680\0\u9700\0\u9740"+
    "\0\u0680\0\u9780\0\u97c0\0\0\0\u9800\0\u9840\0\u9880\0\u98c0"+
    "\0\u9900\0\u9940\0\u9980\0\u99c0\0\u9a00\0\u9a40\0\0\0\u9a80"+
    "\0\0\0\0\0\u9ac0\0\u9b00\0\u0680\0\u9b40\0\u0680\0\u9b80"+
    "\0\u0680\0\u0680\0\u9bc0\0\u9c00\0\u0680\0\u0680\0\u9c40\0\u9c80"+
    "\0\u9cc0\0\u9d00\0\u9d40\0\u9d80\0\0\0\0\0\u9dc0\0\u9e00"+
    "\0\0\0\0\0\u9e40\0\u9e80\0\u9ec0\0\0\0\u0680\0\u0680"+
    "\0\u9f00\0\u9f40\0\u0680\0\u0680\0\u9f80\0\u9fc0\0\ua000\0\u0680"+
    "\0\0\0\0\0\0\0\ua040\0\ua080\0\0\0\ua0c0\0\ua100"+
    "\0\ua140\0\ua180\0\ua1c0\0\ua200\0\0\0\0\0\0\0\u0680"+
    "\0\u0680\0\ua240\0\u0680\0\ua280\0\u0680\0\ua2c0\0\ua300\0\u0680";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[824];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\100\0\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\24\1\34\2\35\1\36\1\37\1\35"+
    "\1\40\1\41\1\42\1\43\1\44\1\45\1\46\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\1\52"+
    "\1\57\1\60\1\61\1\62\1\63\1\64\1\65\1\66"+
    "\1\67\1\70\2\34\1\71\1\72\1\34\1\73\1\74"+
    "\1\34\1\75\1\76\1\77\1\36\1\34\1\100\1\34"+
    "\1\101\2\36\1\102\1\103\1\104\1\36\20\105\1\106"+
    "\1\107\1\110\1\105\1\111\53\105\22\112\1\113\51\112"+
    "\1\107\3\112\20\114\1\115\1\114\1\116\1\107\1\117"+
    "\53\114\4\120\1\121\17\120\1\122\53\120\13\123\1\124"+
    "\3\123\1\124\1\125\1\123\1\126\1\123\1\127\53\123"+
    "\13\10\1\130\3\10\1\130\60\10\3\131\1\132\2\131"+
    "\3\132\1\131\1\132\25\131\22\132\1\131\1\132\2\131"+
    "\3\132\7\131\3\133\1\134\2\133\3\134\1\133\1\134"+
    "\25\133\22\134\1\133\1\134\2\133\3\134\7\133\3\135"+
    "\1\136\2\135\3\136\1\135\1\136\1\137\3\135\1\140"+
    "\20\135\22\136\1\135\1\136\2\135\3\136\7\135\3\141"+
    "\1\142\1\143\1\141\3\142\1\141\1\142\2\35\2\141"+
    "\1\35\20\141\22\142\1\141\1\142\2\141\3\142\7\141"+
    "\1\23\1\144\1\145\1\34\1\145\1\146\3\34\1\144"+
    "\1\34\2\147\2\145\1\147\1\150\1\145\1\147\15\145"+
    "\3\34\1\151\16\34\1\145\1\34\2\145\3\34\1\145"+
    "\1\36\1\152\2\147\2\145\32\153\1\154\45\153\32\155"+
    "\1\156\44\155\1\157\13\160\1\161\3\160\1\162\6\160"+
    "\1\163\5\160\1\164\41\160\1\165\1\160\13\166\2\167"+
    "\2\166\1\167\60\166\13\23\1\170\3\23\1\171\60\23"+
    "\1\0\1\24\1\172\1\173\1\0\1\24\3\0\1\24"+
    "\67\0\1\172\3\0\1\172\3\0\1\172\13\0\1\174"+
    "\53\0\1\34\1\0\1\34\1\0\1\34\1\175\1\176"+
    "\3\34\25\0\3\34\1\177\11\34\1\200\3\34\1\201"+
    "\1\0\1\202\2\0\3\34\13\0\1\174\20\0\1\174"+
    "\1\203\52\0\1\24\1\172\1\173\1\0\1\24\1\204"+
    "\1\0\1\205\1\24\67\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\57\21\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\1\206"+
    "\1\34\1\207\12\34\1\210\4\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\6\0"+
    "\1\41\7\0\1\211\6\0\1\34\1\212\20\34\1\0"+
    "\1\34\2\0\3\34\3\0\1\102\4\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\22\0\2\35\2\0\1\35\63\0\1\213\2\0"+
    "\3\213\1\0\1\213\25\0\6\213\1\214\13\213\1\0"+
    "\1\213\2\0\3\213\7\0\20\215\1\216\1\217\1\220"+
    "\1\215\1\221\53\215\25\0\1\222\1\174\76\0\1\174"+
    "\1\222\76\0\1\174\1\0\1\174\75\0\1\222\77\0"+
    "\2\174\2\0\1\223\73\0\1\174\77\0\1\174\4\0"+
    "\1\224\1\103\71\0\1\174\1\225\76\0\1\174\7\0"+
    "\1\174\67\0\1\174\10\0\1\174\42\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\34\1\226\20\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\227\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\3\34\1\230\2\34\25\0"+
    "\1\34\1\231\1\34\1\232\5\34\1\233\10\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\234\1\0"+
    "\6\34\25\0\2\34\1\235\5\34\1\236\11\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\237\1\0"+
    "\6\34\25\0\1\240\4\34\1\241\14\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\3\34\1\242\3\34\1\243\1\34\1\244\7\34"+
    "\1\245\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\34\1\246\11\34\1\247"+
    "\6\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\250\1\251\1\252\2\34"+
    "\1\253\2\34\1\254\11\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\3\34"+
    "\1\255\5\34\1\256\10\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\257\1\0\6\34\25\0\6\34"+
    "\1\260\5\34\1\261\5\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\13\34"+
    "\1\262\6\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\263\14\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\1\264\14\34\1\265\4\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\34\1\266\1\267\5\34\1\270\11\34"+
    "\1\0\1\34\2\0\3\34\71\0\1\271\16\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\2\34\1\272\17\34"+
    "\1\0\1\34\2\0\3\34\17\0\1\273\3\0\1\274"+
    "\23\0\1\275\1\276\1\277\1\0\1\300\1\301\1\0"+
    "\1\302\1\303\1\304\27\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\1\34\1\305"+
    "\1\34\7\0\22\306\1\307\51\306\1\217\3\306\26\0"+
    "\1\310\51\0\20\105\1\311\1\0\1\312\1\105\1\313"+
    "\56\105\1\314\2\105\3\314\1\105\1\314\5\105\1\315"+
    "\1\316\1\312\1\105\1\317\13\105\22\314\1\105\1\314"+
    "\2\105\3\314\127\105\1\320\1\316\1\312\1\105\1\321"+
    "\53\105\22\112\1\322\51\112\1\0\25\112\1\217\51\112"+
    "\1\217\3\112\20\114\1\323\1\114\1\324\1\0\1\325"+
    "\56\114\1\314\2\114\3\314\1\114\1\314\5\114\1\326"+
    "\1\114\1\324\1\327\1\317\13\114\22\314\1\114\1\314"+
    "\2\114\3\314\127\114\1\320\1\114\1\324\1\327\1\330"+
    "\53\114\26\0\1\331\71\0\1\320\57\0\13\123\1\124"+
    "\3\123\1\124\1\332\1\123\1\333\1\123\1\334\56\123"+
    "\1\335\2\123\3\335\1\123\1\335\1\124\3\123\1\124"+
    "\1\332\1\123\1\333\1\123\1\334\13\123\22\335\1\123"+
    "\1\335\2\123\3\335\12\123\1\314\2\123\3\314\1\123"+
    "\1\314\1\124\3\123\1\124\1\336\1\123\1\333\1\123"+
    "\1\317\13\123\22\314\1\123\1\314\2\123\3\314\22\123"+
    "\1\124\3\123\1\124\73\123\1\124\3\123\1\124\1\320"+
    "\1\123\1\333\1\123\1\337\53\123\3\10\1\340\2\10"+
    "\3\340\1\10\1\340\1\130\3\10\1\130\20\10\22\340"+
    "\1\10\1\340\2\10\3\340\7\10\1\0\1\341\1\0"+
    "\1\341\1\0\6\341\1\342\2\0\1\343\1\342\20\0"+
    "\22\341\1\0\1\341\2\0\3\341\10\0\1\344\1\0"+
    "\1\344\1\0\6\344\1\345\2\0\1\346\1\345\20\0"+
    "\22\344\1\0\1\344\2\0\3\344\7\0\3\347\1\350"+
    "\2\347\3\350\1\347\1\350\1\0\2\347\1\351\1\0"+
    "\20\347\22\350\1\347\1\350\2\347\3\350\7\347\1\352"+
    "\1\353\1\352\1\353\1\352\6\353\1\354\2\352\1\355"+
    "\1\354\20\352\22\353\1\352\1\353\2\352\3\353\7\352"+
    "\3\356\1\357\2\356\3\357\1\356\1\357\1\137\2\356"+
    "\1\360\1\137\20\356\22\357\1\356\1\357\2\356\3\357"+
    "\7\356\1\0\1\142\1\0\1\142\1\0\6\142\25\0"+
    "\22\142\1\0\1\142\2\0\3\142\35\0\1\361\52\0"+
    "\1\144\3\0\1\144\3\0\1\144\67\0\1\362\3\0"+
    "\1\362\1\204\1\0\1\205\1\362\71\0\1\363\2\0"+
    "\3\363\1\0\1\363\25\0\22\363\1\0\1\363\2\0"+
    "\3\363\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\10\34\1\236\11\34\1\0\1\34\2\0\3\34\7\0"+
    "\32\153\1\0\45\153\33\0\1\364\77\0\1\365\47\0"+
    "\1\366\3\0\1\367\31\0\1\370\1\371\1\372\1\373"+
    "\1\374\1\375\1\376\1\377\1\u0100\3\0\1\u0101\1\0"+
    "\1\u0102\1\u0103\1\u0104\1\0\1\u0105\14\0\13\160\1\161"+
    "\3\160\1\161\6\160\1\161\5\160\1\161\41\160\1\161"+
    "\1\160\13\0\1\u0106\112\0\1\u0107\64\0\2\167\2\0"+
    "\1\167\63\0\1\u0108\2\0\3\u0108\1\0\1\u0108\25\0"+
    "\22\u0108\1\0\1\u0108\2\0\3\u0108\12\0\1\u0108\2\0"+
    "\3\u0108\1\0\1\u0108\1\170\24\0\22\u0108\1\0\1\u0108"+
    "\2\0\3\u0108\10\0\1\172\1\0\1\173\1\0\1\172"+
    "\3\0\1\172\67\0\1\362\2\0\2\362\3\0\1\362"+
    "\15\0\1\362\51\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\u0109\1\u010a\13\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\13\34\1\u010b\6\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\4\34\1\u010c"+
    "\15\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\11\34\1\u010d\10\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\20\34\1\u010e\1\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\2\34\1\u010f\17\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\u0110\1\0\1\u0110\1\0\1\u0110\1\0\3\u0110\30\0"+
    "\1\u0110\1\0\1\u0110\2\0\1\u0110\35\0\1\u0111\3\0"+
    "\1\u0111\67\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\3\34\1\u0112\16\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\6\34\1\u0113"+
    "\2\34\1\u0114\3\34\1\u0115\4\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\1\u0116\1\34\1\u0117\17\34\1\0\1\34\2\0\3\34"+
    "\40\0\1\u0118\47\0\1\34\1\0\1\u0119\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\10\0\1\213"+
    "\1\0\1\213\1\0\6\213\25\0\22\213\1\0\1\213"+
    "\2\0\3\213\10\0\1\213\1\0\1\213\1\0\6\213"+
    "\25\0\13\213\1\u011a\6\213\1\0\1\213\2\0\3\213"+
    "\7\0\3\215\1\0\2\215\3\0\1\215\1\0\5\215"+
    "\1\216\1\217\1\220\1\215\1\0\13\215\22\0\1\215"+
    "\1\0\2\215\3\0\127\215\1\0\1\217\1\220\1\215"+
    "\1\221\53\215\25\0\1\174\3\0\1\u011b\100\0\1\u011c"+
    "\60\0\2\225\2\0\1\225\61\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\6\34\1\u011d\13\34\1\0\1\34"+
    "\2\0\2\34\1\u011e\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\11\34\1\u011f\10\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\1\34\1\u0120\20\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\4\34\1\226"+
    "\15\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\14\34\1\u0121\5\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\21\34\1\u0122\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\15\34"+
    "\1\u0123\4\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\u0124\3\34\25\0\7\34"+
    "\1\u0125\12\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\u0126\1\0\6\34\25\0\22\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\2\34"+
    "\1\u0127\3\34\25\0\6\34\1\u0128\2\34\1\u0129\10\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\11\34\1\u012a\10\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\20\34\1\u012b\1\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\2\34"+
    "\1\u012c\5\34\1\u012d\1\34\1\u012e\7\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\1\34\1\u012f\20\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\1\34"+
    "\1\u0130\20\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\1\u0131\21\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\15\34\1\u0132\4\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\3\34\1\u0133\16\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\3\34\1\u0134"+
    "\16\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\11\34\1\u0135\10\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\u0136\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\15\34\1\u0137"+
    "\4\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\2\34\1\u0138\17\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\u0139\14\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\u013a\14\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\11\34\1\u013b"+
    "\10\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\6\34\1\u013c\13\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\u013d\21\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\1\u013e"+
    "\4\34\1\u013f\14\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\1\34\1\u0140"+
    "\20\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\3\34\1\u0141\2\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\34\1\u0142\20\34\1\0\1\34\2\0"+
    "\3\34\47\0\1\u0143\4\0\1\u0144\42\0\1\u0145\72\0"+
    "\1\u0146\135\0\1\u0147\76\0\1\u0148\102\0\1\u0149\111\0"+
    "\1\u014a\65\0\1\u014b\102\0\1\u014c\32\0\1\34\1\0"+
    "\1\34\1\0\2\34\1\u014d\3\34\25\0\3\34\1\u014e"+
    "\1\u014f\2\34\1\u0150\3\34\1\u0151\1\34\1\u0152\3\34"+
    "\1\u0153\1\0\1\34\2\0\3\34\7\0\100\306\13\0"+
    "\2\310\2\0\1\310\60\0\3\105\1\0\2\105\3\0"+
    "\1\105\1\0\5\105\1\315\1\316\1\312\1\105\1\0"+
    "\13\105\22\0\1\105\1\0\2\105\3\0\27\105\1\0"+
    "\1\316\1\312\1\105\1\321\53\105\1\0\1\314\1\0"+
    "\1\314\1\0\6\314\25\0\22\314\1\0\1\314\2\0"+
    "\3\314\1\0\1\u0154\5\0\22\112\1\0\51\112\1\0"+
    "\3\112\3\114\1\0\2\114\3\0\1\114\1\0\5\114"+
    "\1\326\1\114\1\324\1\327\1\0\13\114\22\0\1\114"+
    "\1\0\2\114\3\0\27\114\1\0\1\114\1\324\1\327"+
    "\1\330\53\114\3\123\1\0\2\123\3\0\1\123\1\0"+
    "\1\124\3\123\1\124\1\336\1\123\1\333\1\123\1\0"+
    "\13\123\22\0\1\123\1\0\2\123\3\0\22\123\1\124"+
    "\3\123\1\124\1\0\1\123\1\333\1\123\1\337\54\123"+
    "\1\335\1\123\1\335\1\123\6\335\1\u0155\2\123\1\u0156"+
    "\1\u0155\1\332\1\123\1\333\1\123\1\334\13\123\22\335"+
    "\1\123\1\335\2\123\3\335\7\123\1\10\1\340\1\10"+
    "\1\340\1\10\6\340\1\u0157\2\10\1\u0158\1\u0157\20\10"+
    "\22\340\1\10\1\340\2\10\3\340\7\10\13\0\1\342"+
    "\3\0\1\342\73\0\1\345\3\0\1\345\60\0\3\360"+
    "\1\u0159\2\360\3\u0159\1\360\1\u0159\1\u015a\3\360\1\u015a"+
    "\20\360\22\u0159\1\360\1\u0159\2\360\3\u0159\10\360\1\u015b"+
    "\1\360\1\u0159\1\360\1\u015b\3\u0159\1\u015b\1\u0159\1\u015c"+
    "\2\360\1\u015d\1\u015c\20\360\22\u0159\1\360\1\u0159\2\360"+
    "\3\u0159\7\360\3\351\1\u015e\2\351\3\u015e\1\351\1\u015e"+
    "\1\0\3\351\1\0\20\351\22\u015e\1\351\1\u015e\2\351"+
    "\3\u015e\7\351\3\u015f\1\u0160\2\u015f\3\u0160\1\u015f\1\u0160"+
    "\1\u015c\3\u015f\1\u015c\20\u015f\22\u0160\1\u015f\1\u0160\2\u015f"+
    "\3\u0160\10\u015f\1\u0160\1\u015f\1\u0160\1\u015f\6\u0160\1\u0161"+
    "\2\u015f\1\u0162\1\u0161\20\u015f\22\u0160\1\u015f\1\u0160\2\u015f"+
    "\3\u0160\7\u015f\13\u0163\1\354\3\u0163\1\354\60\u0163\3\356"+
    "\1\u0164\2\356\3\u0164\1\356\1\u0164\1\u015a\2\356\1\360"+
    "\1\u015a\20\356\22\u0164\1\356\1\u0164\2\356\3\u0164\7\356"+
    "\1\u0165\1\357\1\u0165\1\357\1\u0165\6\357\1\u0161\2\u0165"+
    "\1\u0162\1\u0161\20\u0165\22\357\1\u0165\1\357\2\u0165\3\357"+
    "\7\u0165\1\0\1\362\3\0\1\362\3\0\1\362\67\0"+
    "\1\363\1\0\1\363\1\0\6\363\25\0\22\363\1\0"+
    "\1\363\2\0\3\363\15\0\1\u0166\131\0\1\u0167\1\0"+
    "\1\u0168\40\0\1\u0169\103\0\1\u016a\1\u016b\37\0\1\u016c"+
    "\71\0\1\u016d\40\0\1\u016e\137\0\1\u016f\13\0\1\u0170"+
    "\70\0\1\u0171\2\0\1\u0172\71\0\1\u0173\103\0\1\u0174"+
    "\31\0\1\u0175\41\0\1\u0176\1\u0177\1\0\1\u0178\74\0"+
    "\1\u0179\107\0\1\u017a\63\0\1\u017b\1\u017c\40\0\1\u017d"+
    "\36\0\1\u017e\40\0\1\u017f\36\0\1\u0180\50\0\2\u0107"+
    "\2\0\1\u0107\61\0\1\u0108\1\0\1\u0108\1\0\6\u0108"+
    "\1\u0181\2\0\1\u0182\1\u0181\20\0\22\u0108\1\0\1\u0108"+
    "\2\0\3\u0108\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\6\34\1\u0183\13\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\u0184\1\0\6\34\25\0\22\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\1\u0185\21\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\4\34\1\u0186\1\u0187\1\34\1\u0188\1\34\1\u0189\2\34"+
    "\1\u018a\5\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\u018b\1\0\6\34\25\0\22\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\6\34\1\u018c\13\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\15\34"+
    "\1\u018d\4\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\6\34\1\u018e\2\34"+
    "\1\u018f\10\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\u0190\3\34\25\0\22\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\u0191"+
    "\1\0\6\34\25\0\22\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\15\34"+
    "\1\u0192\4\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\u0193\16\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\11\34\1\u0194\10\34\1\0\1\34"+
    "\2\0\3\34\40\0\1\u011b\47\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\2\34\1\u0195\17\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\213\1\0\1\213\1\0\6\213"+
    "\25\0\5\213\1\u0196\14\213\1\0\1\213\2\0\3\213"+
    "\12\0\1\u0197\2\0\3\u0197\1\0\1\u0197\1\0\1\u011b"+
    "\4\0\1\u0198\16\0\22\u0197\1\0\1\u0197\2\0\3\u0197"+
    "\3\0\1\u0199\36\0\1\u019a\45\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\10\34\1\u019b\11\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\10\34\1\u019c\11\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\6\34"+
    "\1\u019d\13\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\2\34\1\u019e\17\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\u019f"+
    "\1\0\6\34\25\0\22\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\15\34"+
    "\1\u01a0\4\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\15\34\1\u01a1\4\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\2\34\1\u01a2\17\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\15\34\1\u01a3\4\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\u01a4\1\0\6\34\25\0\22\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\6\34\1\u01a5\13\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\u01a6\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\15\34\1\u01a7\4\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\u01a8\14\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\u01a9\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\1\u01aa\21\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\u01ab\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\21\34\1\u01ac"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\11\34\1\u01ad\10\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\2\34\1\u01ae\17\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\2\34\1\u01af\3\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\u01b0\1\0\6\34\25\0\22\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\7\34\1\u01b1\12\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\6\34"+
    "\1\u01b2\13\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\6\34\1\u01b3\13\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\15\34\1\u01b4\4\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\6\34\1\u01b5\13\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\1\u01b6"+
    "\21\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\3\34\1\u01b7\2\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\6\34\1\u01b8\13\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\3\34\1\u01b9\16\34\1\0\1\u01ba\2\0\3\34\10\0"+
    "\1\34\1\0\1\u01bb\1\0\6\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\15\34\1\u01bc\4\34\1\0\1\34\2\0"+
    "\3\34\47\0\1\u01bd\102\0\1\u01be\122\0\1\u01bf\53\0"+
    "\1\u01c0\76\0\1\u01c1\106\0\1\u01c2\75\0\1\u01c3\71\0"+
    "\1\u01c4\110\0\1\u01c5\67\0\1\u01c6\37\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\15\34\1\u01c7\4\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\2\34\1\u01c8\17\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\u01c9\14\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\u01ca"+
    "\2\34\1\u01cb\11\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\2\34\1\u01cc"+
    "\17\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\u01cd\14\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\u01ce\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\7\0"+
    "\13\123\1\u0155\3\123\1\u0155\1\332\1\123\1\333\1\123"+
    "\1\334\53\123\13\10\1\u0157\3\10\1\u0157\60\10\1\347"+
    "\1\u01cf\1\347\1\u01cf\1\347\6\u01cf\1\354\2\347\1\u01d0"+
    "\1\354\20\347\22\u01cf\1\347\1\u01cf\2\347\3\u01cf\7\347"+
    "\13\u01d1\1\0\2\u01d1\2\0\60\u01d1\1\347\1\350\1\347"+
    "\1\350\1\347\6\350\1\u01d2\2\347\1\u01d3\1\u01d2\20\347"+
    "\22\350\1\347\1\350\2\347\3\350\12\347\1\350\2\347"+
    "\3\350\1\347\1\350\1\u01d2\2\347\1\351\1\u01d2\20\347"+
    "\22\350\1\347\1\350\2\347\3\350\7\347\1\351\1\u015e"+
    "\1\351\1\u015e\1\351\6\u015e\1\u01d2\2\351\1\u01d3\1\u01d2"+
    "\20\351\22\u015e\1\351\1\u015e\2\351\3\u015e\7\351\13\352"+
    "\1\u01d2\2\352\1\u0163\1\u01d2\73\352\1\354\2\352\1\u0163"+
    "\1\354\60\352\13\u0163\1\u01d2\3\u0163\1\u01d2\60\u0163\1\356"+
    "\1\u0164\1\356\1\u0164\1\356\6\u0164\1\u0161\2\356\1\u01d4"+
    "\1\u0161\20\356\22\u0164\1\356\1\u0164\2\356\3\u0164\7\356"+
    "\3\u0165\1\357\2\u0165\3\357\1\u0165\1\357\1\u015c\2\u0165"+
    "\1\u015f\1\u015c\20\u0165\22\357\1\u0165\1\357\2\u0165\3\357"+
    "\7\u0165\7\0\1\u01d5\32\0\1\u01d6\115\0\1\u01d7\65\0"+
    "\1\u01d8\77\0\1\u01d9\40\0\1\u01da\141\0\1\u01db\74\0"+
    "\1\u01dc\112\0\1\u01dd\67\0\1\u01de\6\0\1\u01df\65\0"+
    "\1\u01e0\74\0\1\u01e1\102\0\1\u01e2\72\0\1\u01e3\101\0"+
    "\1\u01e4\11\0\1\u01e5\25\0\1\u01e6\77\0\1\u01e7\137\0"+
    "\1\u01e8\76\0\1\u01e9\45\0\1\u01ea\76\0\1\u01eb\33\0"+
    "\1\u01ec\74\0\1\u01ed\77\0\1\u01ee\46\0\1\u01ef\31\0"+
    "\1\u01f0\104\0\1\u01f1\110\0\1\u01f2\61\0\1\u01f3\77\0"+
    "\1\u01f4\51\0\1\u0181\3\0\1\u0181\61\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\3\34\1\u01f5\16\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\u01f6\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\7\34\1\u01f7"+
    "\12\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\u01f8\21\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\14\34\1\u01f9\5\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\13\34"+
    "\1\u01fa\6\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\u01fb\14\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\12\34\1\u01fc\7\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\u01fd\14\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\6\34"+
    "\1\u01fe\13\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\13\34\1\u01ff\6\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\2\34\1\u0200\17\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\u0201\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\11\34\1\u0202\10\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\16\34\1\u0203\3\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\213\1\0\1\213\1\0\6\213"+
    "\25\0\11\213\1\u0204\10\213\1\0\1\213\2\0\3\213"+
    "\10\0\1\u0197\1\0\1\u0197\1\0\6\u0197\1\u0205\3\0"+
    "\1\u0206\20\0\22\u0197\1\0\1\u0197\2\0\3\u0197\12\0"+
    "\1\u0207\2\0\3\u0207\1\0\1\u0207\25\0\22\u0207\1\0"+
    "\1\u0207\2\0\3\u0207\12\0\1\u0208\2\0\3\u0208\1\0"+
    "\1\u0208\25\0\22\u0208\1\0\1\u0208\2\0\3\u0208\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\1\34\1\u0209"+
    "\20\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\u020a\14\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\34\1\u020b\20\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\12\34\1\u020c\7\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\11\34\1\u020d"+
    "\10\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\2\34\1\u020e\17\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\10\34\1\u020f\11\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\10\34\1\u0210\11\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\1\34\1\u0211"+
    "\20\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\u0212\1\0\6\34\25\0\2\34\1\u0213\17\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\6\34\1\u0214\13\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\u0215\1\0\6\34\25\0"+
    "\22\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\6\34\1\u0216\13\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\14\34\1\u0217\5\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\2\34\1\u0218\17\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\u0219\1\0\6\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\15\34\1\u021a\4\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\6\34\1\u021b\13\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\6\34\1\u021c"+
    "\13\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\u021d\14\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u021e\3\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\u021f\1\0\6\34\25\0"+
    "\22\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\2\34\1\u0220\17\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\u0221\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\6\34\1\u0222"+
    "\13\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\2\34\1\u0223\17\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\3\34\1\u0224\16\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\u0225\14\34\1\0\1\34\2\0\3\34\64\0"+
    "\1\u0226\64\0\1\u0227\40\0\1\u0228\151\0\1\u0229\64\0"+
    "\1\u022a\45\0\1\u022b\72\0\1\u022c\10\0\1\u0229\50\0"+
    "\1\u022d\54\0\1\u022e\40\0\1\u022e\141\0\1\u022f\33\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\2\34\1\u0230"+
    "\17\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\21\34\1\u0231\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\1\34\1\u0232\20\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\15\34"+
    "\1\u0233\4\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\u0234\16\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\15\34\1\u0235\4\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\3\34\1\u0236\16\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\6\34"+
    "\1\u0237\13\34\1\0\1\34\2\0\3\34\7\0\1\360"+
    "\1\u0159\1\360\1\u0159\1\360\6\u0159\1\u0161\2\360\1\u01d4"+
    "\1\u0161\20\360\22\u0159\1\360\1\u0159\2\360\3\u0159\7\360"+
    "\3\351\1\u015e\2\351\3\u015e\1\351\1\u015e\1\354\3\351"+
    "\1\354\20\351\22\u015e\1\351\1\u015e\2\351\3\u015e\7\351"+
    "\3\u015a\1\u0238\2\u015a\3\u0238\1\u015a\1\u0238\25\u015a\22\u0238"+
    "\1\u015a\1\u0238\2\u015a\3\u0238\7\u015a\3\351\1\u015e\2\351"+
    "\3\u015e\1\351\1\u015e\1\u01d2\3\351\1\u01d2\20\351\22\u015e"+
    "\1\351\1\u015e\2\351\3\u015e\7\351\3\347\1\350\2\347"+
    "\3\350\1\347\1\350\1\354\2\347\1\351\1\354\20\347"+
    "\22\350\1\347\1\350\2\347\3\350\7\347\3\0\1\u0239"+
    "\155\0\1\u023a\70\0\1\u023b\30\0\1\u023c\144\0\1\u023d"+
    "\32\0\1\u023e\142\0\1\u023f\104\0\1\u0240\27\0\1\u0241"+
    "\103\0\1\u0242\131\0\1\u0243\41\0\1\u0244\134\0\1\u0245"+
    "\77\0\1\u0246\77\0\1\u0247\101\0\1\u0248\40\0\1\u0249"+
    "\145\0\1\u024a\35\0\1\u024b\136\0\1\u024c\111\0\1\u024d"+
    "\22\0\1\u024e\152\0\1\u024f\31\0\1\u0250\147\0\1\u0251"+
    "\75\0\1\u0252\63\0\1\u0253\110\0\1\u0254\71\0\1\u0255"+
    "\103\0\1\u0256\27\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\4\34\1\u0257\15\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\2\34\1\u0258\3\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\1\34\1\u0259\20\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\u025a\14\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\u025b\14\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\7\34"+
    "\1\u025c\12\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\u025d\16\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\3\34\1\u025e\2\34\25\0\22\34\1\0\1\34"+
    "\2\0\3\34\22\0\1\u0205\65\0\1\u0207\1\0\1\u0207"+
    "\1\0\6\u0207\6\0\1\u025f\16\0\22\u0207\1\0\1\u0207"+
    "\2\0\3\u0207\10\0\1\u0208\1\0\1\u0208\1\0\6\u0208"+
    "\25\0\22\u0208\1\0\1\u0208\2\0\3\u0208\3\0\1\u025f"+
    "\4\0\1\34\1\0\1\34\1\0\6\34\25\0\3\34"+
    "\1\u0260\16\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\1\34\1\u0261\20\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\2\34\1\u0262\17\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\20\34\1\u0263\1\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\1\34"+
    "\1\u0264\20\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\15\34\1\u0265\4\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\4\34\1\u0266\15\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\7\34\1\u0267\12\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\2\34"+
    "\1\u0268\17\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\u0269\16\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\21\34\1\u026a\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\2\34\1\u026b"+
    "\3\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\u026c"+
    "\14\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\2\34\1\u026d\3\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\13\34\1\u026e\6\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\15\34\1\u026f\4\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\2\34\1\u0270\3\34\25\0"+
    "\22\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\6\34\1\u0271\13\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\6\34\1\u0272\13\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\2\34\1\u0273"+
    "\3\34\25\0\22\34\1\0\1\34\2\0\3\34\12\0"+
    "\1\u0274\10\0\1\u0229\50\0\1\u022d\53\0\1\u022a\45\0"+
    "\1\u022e\104\0\1\u0229\50\0\1\u022d\64\0\1\u0229\102\0"+
    "\1\u0275\101\0\1\u0276\66\0\1\u0229\74\0\1\u0277\35\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\11\34\1\u0278"+
    "\10\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\u0279\1\0\6\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\22\34\1\0\1\34\2\0\1\34\1\u027a\1\34\10\0"+
    "\1\34\1\0\1\u027b\1\0\6\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u027c\3\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\6\34\1\u027d\13\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\u027e\1\0\6\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\13\34\1\u027f\6\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\u01d1\1\u0280\1\u01d1\1\u0280\1\u01d1\6\u0280"+
    "\1\354\2\u01d1\1\u0281\1\354\20\u01d1\22\u0280\1\u01d1\1\u0280"+
    "\2\u01d1\3\u0280\7\u01d1\60\0\1\u0282\77\0\1\u0283\60\0"+
    "\1\u0284\115\0\1\u0285\61\0\1\u0286\107\0\1\u0287\67\0"+
    "\1\u0288\76\0\1\u0289\110\0\1\u028a\31\0\1\u028b\135\0"+
    "\1\u028c\77\0\1\u028d\77\0\1\u028e\112\0\1\u028f\100\0"+
    "\1\u0290\73\0\1\u0291\31\0\1\u0292\141\0\1\u0293\74\0"+
    "\1\u0294\100\0\1\u0295\76\0\1\u0296\40\0\1\u0297\136\0"+
    "\1\u0298\116\0\1\u0299\56\0\1\u029a\46\0\1\u029b\135\0"+
    "\1\u029c\33\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\11\34\1\u029d\10\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\15\34\1\u029e"+
    "\4\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\u029f\1\0\6\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\6\34\1\u02a0\13\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\15\34\1\u02a1"+
    "\4\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\10\34\1\u02a2\11\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\15\34\1\u02a3\4\34\1\0\1\34\2\0"+
    "\3\34\22\0\1\u0205\3\0\1\u0206\61\0\1\34\1\0"+
    "\1\u02a4\1\0\6\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\2\34\1\u02a5"+
    "\3\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\2\34\1\u02a6"+
    "\17\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\u02a7\1\0\6\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\6\34\1\u02a8\13\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\u02a9\1\0\6\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\2\34\1\u02aa\17\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\4\34\1\u02ab\15\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\2\34\1\u02ac\3\34\25\0"+
    "\22\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\u02ad\1\0\6\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\13\34\1\u02ae\6\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\1\u02af\21\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\6\34\1\u02b0\13\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\u02b1\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\51\0\1\u02b2"+
    "\40\0\1\u0229\77\0\1\u02b3\153\0\1\u0229\21\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\11\34\1\u02b4\10\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\11\34\1\u02b5\10\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\1\34\1\u02b6\1\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\22\34"+
    "\1\0\1\34\2\0\1\34\1\u02b7\1\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\6\34\1\u02b8\13\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\22\34\1\0\1\34\2\0\1\34"+
    "\1\u02b9\1\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\1\34\1\u02ba\1\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\1\u02bb"+
    "\21\34\1\0\1\34\2\0\3\34\7\0\1\u015a\1\u0238"+
    "\1\u015a\1\u0238\1\u015a\6\u0238\1\u0161\2\u015a\1\u02bc\1\u0161"+
    "\20\u015a\22\u0238\1\u015a\1\u0238\2\u015a\3\u0238\7\u015a\13\0"+
    "\1\354\3\0\1\354\126\0\1\u02bd\106\0\1\u02be\67\0"+
    "\1\u02bf\72\0\1\u02c0\102\0\1\u02c1\105\0\1\u02c2\70\0"+
    "\1\u02c3\76\0\1\u02c4\116\0\1\u02c5\26\0\1\u02c6\133\0"+
    "\1\u02c7\37\0\1\u02c8\141\0\1\u02c9\103\0\1\u02ca\66\0"+
    "\1\u02cb\46\0\1\u02cc\77\0\1\u02cd\141\0\1\u02ce\103\0"+
    "\1\u02cf\63\0\1\u02d0\115\0\1\u02d1\64\0\1\u02d2\73\0"+
    "\1\u02d3\40\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\2\34\1\u02d4\17\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\2\34\1\u02d5"+
    "\17\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\2\34\1\u02d6\3\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\u02d7\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\u02d8\1\0\6\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\u02d9\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\22\34\1\0"+
    "\1\34\2\0\1\34\1\u02da\1\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\6\34\1\u02db\13\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u02dc\3\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\22\34\1\0\1\34\2\0\1\34\1\u02dd\1\34\10\0"+
    "\1\34\1\0\1\34\1\0\2\34\1\u02de\3\34\25\0"+
    "\22\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\u02df\21\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\u02e0\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\u02e1\16\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\3\34\1\u02e2\16\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\u02e3\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\52\0\1\u0229"+
    "\75\0\1\u0229\37\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\1\34\1\u02e4\1\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\20\34"+
    "\1\u02e5\1\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\22\34\1\0\1\34"+
    "\2\0\1\34\1\u02e6\1\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\u02e7\14\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\2\34"+
    "\1\u02e8\3\34\25\0\22\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\22\34"+
    "\1\0\1\34\2\0\1\34\1\u02e9\1\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\4\34\1\u02ea\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\13\u01d1\1\354\2\u01d1"+
    "\1\0\1\354\60\u01d1\45\0\1\u02eb\35\0\1\u02ec\153\0"+
    "\1\u02ed\61\0\1\u02ee\45\0\1\u02ef\132\0\1\u02f0\77\0"+
    "\1\u02f1\77\0\1\u02f2\77\0\1\u02f3\105\0\1\u02f4\112\0"+
    "\1\u02f5\72\0\1\u02f6\24\0\1\u02f7\142\0\1\u02f8\34\0"+
    "\1\u02f9\137\0\1\u02fa\35\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\34\1\u02fb\20\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\2\34\1\u02fc"+
    "\3\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\13\34\1\u02fd"+
    "\6\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\u02fe\21\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\u02ff\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\1\u0300\21\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\u0301\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\7\34\1\u0302"+
    "\12\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\u0303\21\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\6\34\1\u0304\13\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\4\34"+
    "\1\u0305\15\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\22\34\1\0\1\34"+
    "\2\0\1\34\1\u0306\1\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\2\34\1\u0307\17\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\1\u0308\21\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\1\u0309\21\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\22\34\1\0\1\34\2\0\1\34"+
    "\1\u030a\1\34\47\0\1\u030b\112\0\1\u030c\76\0\1\u030d"+
    "\73\0\1\u030e\40\0\1\u030f\136\0\1\u0310\106\0\1\u0311"+
    "\77\0\1\u0312\63\0\1\u0313\100\0\1\u0314\77\0\1\u0315"+
    "\107\0\1\u0316\26\0\1\34\1\0\1\u0317\1\0\6\34"+
    "\25\0\22\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\13\34\1\u0318\6\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\3\34\1\u0319\16\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\3\34\1\u031a\16\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\7\34"+
    "\1\u031b\12\34\1\0\1\34\2\0\3\34\10\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\11\34\1\u031c\10\34"+
    "\1\0\1\34\2\0\3\34\10\0\1\34\1\0\1\34"+
    "\1\0\2\34\1\u031d\3\34\25\0\22\34\1\0\1\34"+
    "\2\0\3\34\10\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\3\34\1\u031e\16\34\1\0\1\34\2\0\3\34"+
    "\10\0\1\34\1\0\1\34\1\0\6\34\25\0\21\34"+
    "\1\u031f\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\22\34\1\0\1\34\2\0"+
    "\1\34\1\u0320\1\34\52\0\1\u0321\102\0\1\u0322\34\0"+
    "\1\u0323\77\0\1\u0324\103\0\1\u0325\131\0\1\u0326\115\0"+
    "\1\u0327\21\0\1\34\1\0\1\34\1\0\2\34\1\u0328"+
    "\3\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\34\1\0\2\34\1\u0329\3\34\25\0"+
    "\22\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\u032a\1\0\6\34\25\0\22\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\22\34\1\0\1\34\2\0\1\34\1\u032b\1\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\20\34\1\u032c"+
    "\1\34\1\0\1\34\2\0\3\34\53\0\1\u032d\36\0"+
    "\1\u032e\77\0\1\u032f\75\0\1\34\1\0\1\u0330\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\3\34\10\0"+
    "\1\34\1\0\1\u0331\1\0\6\34\25\0\22\34\1\0"+
    "\1\34\2\0\3\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\22\34\1\0\1\34\2\0\1\34\1\u0332"+
    "\1\34\10\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\22\34\1\0\1\34\2\0\1\34\1\u0333\1\34\10\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\u0334"+
    "\14\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\22\34\1\0\1\34\2\0"+
    "\1\34\1\u0335\1\34\10\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\15\34\1\u0336\4\34\1\0\1\34\2\0"+
    "\3\34\10\0\1\34\1\0\1\u0337\1\0\6\34\25\0"+
    "\22\34\1\0\1\34\2\0\3\34\10\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\34\1\u0338\20\34\1\0"+
    "\1\34\2\0\3\34\7\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[41792];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"		//$NON-NLS-1$
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\5\0\2\1\12\0\1\11\12\1\2\11\2\1"+
    "\3\11\34\1\1\11\1\1\1\11\3\1\1\11\10\1"+
    "\1\11\10\1\1\11\1\1\1\11\3\1\1\0\1\1"+
    "\1\11\3\1\1\11\1\1\1\11\2\1\1\11\2\1"+
    "\1\11\3\1\1\11\1\1\1\11\2\1\1\11\1\1"+
    "\1\0\3\1\1\11\6\1\1\11\2\0\3\1\1\0"+
    "\3\1\2\0\1\11\2\0\47\1\1\11\1\1\12\0"+
    "\1\1\2\0\1\1\3\0\2\1\3\11\1\1\4\0"+
    "\1\1\1\11\1\1\1\11\3\0\4\1\1\0\1\11"+
    "\2\0\1\11\6\0\1\11\4\0\1\11\2\1\2\11"+
    "\20\0\1\11\1\1\1\0\17\1\1\0\2\1\1\0"+
    "\47\1\12\0\7\1\2\11\1\1\1\11\1\1\3\0"+
    "\1\1\4\0\1\1\37\0\1\11\1\0\24\1\3\0"+
    "\1\11\42\1\12\0\10\1\3\0\1\11\24\0\1\11"+
    "\14\0\1\11\20\1\1\11\1\1\2\0\35\1\7\0"+
    "\1\11\2\0\10\1\11\0\1\1\1\11\7\0\1\11"+
    "\4\0\1\11\7\0\10\1\1\0\24\1\4\0\10\1"+
    "\20\0\1\11\1\0\1\11\6\0\1\11\1\0\1\11"+
    "\1\0\25\1\2\0\10\1\5\0\2\11\1\0\1\11"+
    "\3\0\1\11\1\0\1\11\1\0\1\1\2\0\1\11"+
    "\2\0\1\11\1\0\27\1\1\0\1\11\12\0\1\11"+
    "\1\0\2\11\20\1\2\0\2\11\2\0\2\11\3\0"+
    "\1\11\12\1\3\11\2\0\1\11\1\0\5\1\3\11"+
    "\11\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[824];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
    public PhpLexer(int state){
        initialize(state);
    }

    // NB: this method resets the lexer only partially
    protected void reset(java.io.Reader reader, char[] buffer, int[] parameters){
    	this.zzReader = reader;
    	this.zzBuffer = buffer;
    	this.zzFinalHighSurrogate = 0;
    	this.zzMarkedPos = parameters[0];
    	this._zzPushbackPos = parameters[1];
    	this.zzCurrentPos = parameters[2];
    	this.zzStartRead = parameters[3];
    	this.zzEndRead = parameters[4];
    	this.yyline = parameters[5];
    	initialize(parameters[6]);
    }

    protected boolean isHeredocState(int state){
        return state == ST_PHP_HEREDOC || state == ST_PHP_START_HEREDOC || state == ST_PHP_END_HEREDOC || state == ST_PHP_NOWDOC || state == ST_PHP_START_NOWDOC || state == ST_PHP_END_NOWDOC;
    }

    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, _zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
    }

    protected int getZZLexicalState() {
        return zzLexicalState;
    }

    protected int getZZMarkedPos() {
        return zzMarkedPos;
    }

    protected int getZZEndRead() {
        return zzEndRead;
    }

    public char[] getZZBuffer() {
        return zzBuffer;
    }

    protected int getZZStartRead() {
    	return this.zzStartRead;
    }

    protected int getZZPushBackPosition() {
    	return this._zzPushbackPos;
    }

	protected void pushBack(int i) {
		yypushback(i);
	}

	public int getScriptingState() {
       return ST_PHP_IN_SCRIPTING;
    }

	// A pool of states. To avoid creation of a new state on each createMemento.
	private static final IntHashtable lexerStates = new IntHashtable(100);

	protected IntHashtable getLexerStates() {
		return lexerStates;
	}

 // End user code


  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 236) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (zzRefill()) {
        return YYEOF;
    }

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
    oldString = null;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		startPos = zzMarkedPos;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { if(heredoc!=null&&yytext().startsWith(heredoc)){
		String text = yytext();
		if(heredoc_len < text.length() && (text.charAt(heredoc_len) == '\r'
			|| text.charAt(heredoc_len) == '\n'|| text.charAt(heredoc_len) == ';')){
			yypushback(yylength()-heredoc_len-1);
	        heredoc=null;
	        heredoc_len=0;
	        yybegin(ST_PHP_IN_SCRIPTING);
	        return PHP_HEREDOC_TAG;
		}
	}
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 173: break;
          case 2: 
            { return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 174: break;
          case 3: 
            { yypushback(1);
    pushState(ST_PHP_HIGHLIGHTING_ERROR);
            }
          case 175: break;
          case 4: 
            { return PHP_NUMBER;
            }
          case 176: break;
          case 5: 
            { return PHP_TOKEN;
            }
          case 177: break;
          case 6: 
            { return  PHP_LABEL;
            }
          case 178: break;
          case 7: 
            { return WHITESPACE;
            }
          case 179: break;
          case 8: 
            { return PHP_SEMICOLON;
            }
          case 180: break;
          case 9: 
            { pushState(ST_PHP_DOUBLE_QUOTES);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 181: break;
          case 10: 
            { return PHP_NS_SEPARATOR;
            }
          case 182: break;
          case 11: 
            { pushState(ST_PHP_BACKQUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 183: break;
          case 12: 
            { return PHP_CURLY_OPEN;
            }
          case 184: break;
          case 13: 
            { if (!phpStack.isEmpty()) {
        popState();
    }
    return  PHP_CURLY_CLOSE;
            }
          case 185: break;
          case 14: 
            { pushState(ST_PHP_SINGLE_QUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 186: break;
          case 15: 
            { pushState(ST_PHP_LINE_COMMENT);
    return PHP_LINE_COMMENT;
            }
          case 187: break;
          case 16: 
            { return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 188: break;
          case 17: 
            { popState();
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 189: break;
          case 18: 
            { yypushback(1);
        popState();
            }
          case 190: break;
          case 19: 
            { yypushback(1);
	yybegin(ST_PHP_HEREDOC);
            }
          case 191: break;
          case 20: 
            { yypushback(1);
	yybegin(ST_PHP_NOWDOC);
            }
          case 192: break;
          case 21: 
            { yypushback(1);
    popState();
            }
          case 193: break;
          case 22: 
            { popState();
    return PHP_LABEL;
            }
          case 194: break;
          case 23: 
            { /* Offset could be treated as a long */
	return PHP_NUMBER;
            }
          case 195: break;
          case 24: 
            { //the difference from the original rules comes from the fact that we took ';' out of tokens
	return UNKNOWN_TOKEN;
            }
          case 196: break;
          case 25: 
            { yypushback(1);
	popState();
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 197: break;
          case 26: 
            { popState();
	return PHP_TOKEN;
            }
          case 198: break;
          case 27: 
            { return PHP_COMMENT;
            }
          case 199: break;
          case 28: 
            { return PHPDOC_COMMENT;
            }
          case 200: break;
          case 29: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			if (yylength() > 0) {
				return PHP_LINE_COMMENT;
			}
			break;
		default:
			popState();
			return PHP_LINE_COMMENT;
	}
            }
          case 201: break;
          case 30: 
            { return PHP_LINE_COMMENT;
            }
          case 202: break;
          case 31: 
            { return UNKNOWN_TOKEN;
            }
          case 203: break;
          case 32: 
            { popState();return WHITESPACE;
            }
          case 204: break;
          case 33: 
            { return PHP_OPERATOR;
            }
          case 205: break;
          case 34: 
            { pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OBJECT_OPERATOR;
            }
          case 206: break;
          case 35: 
            { return PHP_VARIABLE;
            }
          case 207: break;
          case 36: 
            { pushState(ST_PHP_COMMENT);
    return PHP_COMMENT_START;
            }
          case 208: break;
          case 37: 
            { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	return UNKNOWN_TOKEN;
            }
          case 209: break;
          case 38: 
            { return PHP_AS;
            }
          case 210: break;
          case 39: 
            { return PHP_DO;
            }
          case 211: break;
          case 40: 
            { return PHP_IF;
            }
          case 212: break;
          case 41: 
            { return PHP_PAAMAYIM_NEKUDOTAYIM;
            }
          case 213: break;
          case 42: 
            { return PHP_CLOSETAG;
            }
          case 214: break;
          case 43: 
            { pushState(ST_PHP_QUOTES_AFTER_VARIABLE);
    return PHP_VARIABLE;
            }
          case 215: break;
          case 44: 
            { yypushback(1);
    return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 216: break;
          case 45: 
            { pushState(ST_PHP_IN_SCRIPTING);
    return PHP_TOKEN;
            }
          case 217: break;
          case 46: 
            { yypushback(1);
    pushState(ST_PHP_IN_SCRIPTING);
    return PHP_CURLY_OPEN;
            }
          case 218: break;
          case 47: 
            { yypushback(1);
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 219: break;
          case 48: 
            { popState();
    pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OBJECT_OPERATOR;
            }
          case 220: break;
          case 49: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	    label_len--;
    }

    if (label_len==heredoc_len && yytext().substring(0,label_len).equals(heredoc)) {
        heredoc=null;
        heredoc_len=0;
        yybegin(ST_PHP_IN_SCRIPTING);
        return PHP_HEREDOC_TAG;
    } else {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 221: break;
          case 50: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	    label_len--;
    }

    if (label_len==nowdoc_len && yytext().substring(0,label_len).equals(nowdoc)) {
        nowdoc=null;
        nowdoc_len=0;
        yybegin(ST_PHP_IN_SCRIPTING);
        return PHP_HEREDOC_TAG;
    } else {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 222: break;
          case 51: 
            { int label_len = yylength() - 1;
	int startIndex = 0;
	String yytext = yytext();
	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}
	while (yytext.charAt(startIndex) == '\r'
			|| yytext.charAt(startIndex) == '\n') {
		startIndex++;
	}

	if (label_len > heredoc_len
			&& yytext.substring(startIndex, label_len).equals(
					heredoc)) {
		heredoc = null;
		heredoc_len = 0;
		yybegin(ST_PHP_IN_SCRIPTING);
		return PHP_HEREDOC_TAG;
	} else {
		yybegin(ST_PHP_HEREDOC);
		return PHP_CONSTANT_ENCAPSED_STRING;
	}
            }
          case 223: break;
          case 52: 
            { return PHP_OBJECT_OPERATOR;
            }
          case 224: break;
          case 53: 
            { popState();
    return PHP_COMMENT_END;
            }
          case 225: break;
          case 54: 
            { popState();
    return PHPDOC_COMMENT_END;
            }
          case 226: break;
          case 55: 
            { popState();
    return PHP_LINE_COMMENT;
            }
          case 227: break;
          case 56: 
            { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	String text = yytext();
	if(text.indexOf('\r') != -1 || text.indexOf('\n') != -1 ){
		popState();
	}
	return PHP_LINE_COMMENT;
            }
          case 228: break;
          case 57: 
            { pushState(ST_PHP_DOC_COMMENT);
    return PHPDOC_COMMENT_START;
            }
          case 229: break;
          case 58: 
            { return PHP_NEW;
            }
          case 230: break;
          case 59: 
            { return PHP_DIE;
            }
          case 231: break;
          case 60: 
            { return PHP_TRY;
            }
          case 232: break;
          case 61: 
            { return PHP_FOR;
            }
          case 233: break;
          case 62: 
            { return PHP_USE;
            }
          case 234: break;
          case 63: 
            { return PHP_VAR;
            }
          case 235: break;
          case 64: 
            { yypushback(1);
	pushState(ST_PHP_VAR_OFFSET);
	return PHP_VARIABLE;
            }
          case 236: break;
          case 65: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	   label_len--;
    }
    if (label_len > heredoc_len && yytext().substring(label_len - heredoc_len,label_len).equals(heredoc)) {

    	if ((label_len - heredoc_len-2) >= 0 && yytext().charAt(label_len - heredoc_len-2)=='\r') {
        	label_len = label_len-2;
    	} else {
        	label_len--;
    	}
    	yypushback(heredoc_len + (yylength() - label_len));

        yybegin(ST_PHP_END_HEREDOC);
    }
    // In some cases, all text is pushed back (using yypushback()),
    // especially when the parsed document has Windows newlines.
    // In those cases, ignore this rule and try next one...
    if (yylength() > 0) {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 237: break;
          case 66: 
            { int label_len = yylength() - 1;

	if (yytext().charAt(label_len-1)==';') {
	   label_len--;
    }
    if (label_len > nowdoc_len && yytext().substring(label_len - nowdoc_len,label_len).equals(nowdoc)) {
    	//nowdoc = null;
    	//nowdoc_len = 0;
		//yypushback(1);
		//yybegin(ST_PHP_END_NOWDOC);

    	if ((label_len - nowdoc_len-2) >= 0 && yytext().charAt(label_len - nowdoc_len-2)=='\r') {
        	label_len = label_len-2;
    	} else {
        	label_len--;
    	}
    	yypushback(nowdoc_len + (yylength() - label_len));

        yybegin(ST_PHP_END_NOWDOC);
	}
    // In some cases, all text is pushed back (using yypushback()),
    // especially when the parsed document has Windows newlines.
    // In those cases, ignore this rule and try next one...
    if (yylength() > 0) {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 238: break;
          case 67: 
            { yybegin(ST_PHP_HEREDOC);
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 239: break;
          case 68: 
            { nowdoc = null;
	nowdoc_len = 0;
    yybegin(ST_PHP_IN_SCRIPTING);
    return PHP_HEREDOC_TAG;
            }
          case 240: break;
          case 69: 
            { return PHP_EXIT;
            }
          case 241: break;
          case 70: 
            { return PHP_ECHO;
            }
          case 242: break;
          case 71: 
            { return PHP_ELSE;
            }
          case 243: break;
          case 72: 
            { return PHP_EVAL;
            }
          case 244: break;
          case 73: 
            { return PHP_CASE;
            }
          case 245: break;
          case 74: 
            { yypushback(2);
    pushState(ST_PHP_COMMENT);
    return PHP_COMMENT_START;
            }
          case 246: break;
          case 75: 
            { return  PHP_KEYWORD;
            }
          case 247: break;
          case 76: 
            { return PHP_TRUE;
            }
          case 248: break;
          case 77: 
            { return PHP_FROM;
            }
          case 249: break;
          case 78: 
            { return PHP_SELF;
            }
          case 250: break;
          case 79: 
            { return PHP_LIST;
            }
          case 251: break;
          case 80: 
            { return PHP_GOTO;
            }
          case 252: break;
          case 81: 
            { return PHPDOC_SEE;
            }
          case 253: break;
          case 82: 
            { return PHPDOC_VAR;
            }
          case 254: break;
          case 83: 
            { return PHP_ENDIF;
            }
          case 255: break;
          case 84: 
            { return PHP_EMPTY;
            }
          case 256: break;
          case 85: 
            { return PHP_CONST;
            }
          case 257: break;
          case 86: 
            { return PHP_CATCH;
            }
          case 258: break;
          case 87: 
            { return PHP_CLONE;
            }
          case 259: break;
          case 88: 
            { return PHP_CLASS;
            }
          case 260: break;
          case 89: 
            { return PHP_BREAK;
            }
          case 261: break;
          case 90: 
            { return PHP_THIS;
            }
          case 262: break;
          case 91: 
            { int bprefix = (yytext().charAt(0) != '<') ? 1 : 0;
    int startString=3+bprefix;

    int hereOrNowDoc_len = yylength()-bprefix-3-1-(yytext().charAt(yylength()-2)=='\r'?1:0);
    while ((yytext().charAt(startString) == ' ') || (yytext().charAt(startString) == '\t')) {
        startString++;
        hereOrNowDoc_len--;
    }
    String hereOrNowDoc = yytext().substring(startString,hereOrNowDoc_len+startString);
    if (hereOrNowDoc.charAt(0) == '\'') {
    	nowdoc = hereOrNowDoc.substring(1, hereOrNowDoc_len-1);
    	nowdoc_len = hereOrNowDoc_len - 2;
    	yybegin(ST_PHP_START_NOWDOC);
    }
    else if (hereOrNowDoc.charAt(0) == '"') {
    	heredoc = hereOrNowDoc.substring(1, hereOrNowDoc_len-1);
    	heredoc_len = hereOrNowDoc_len - 2;
    	yybegin(ST_PHP_START_HEREDOC);
    } else {
    	heredoc = hereOrNowDoc;
    	heredoc_len = hereOrNowDoc_len;
    	yybegin(ST_PHP_START_HEREDOC);
    }
    return PHP_HEREDOC_TAG;
            }
          case 263: break;
          case 92: 
            { return PHP_ARRAY;
            }
          case 264: break;
          case 93: 
            { return PHP_ISSET;
            }
          case 265: break;
          case 94: 
            { return PHP_TRAIT;
            }
          case 266: break;
          case 95: 
            { return PHP_THROW;
            }
          case 267: break;
          case 96: 
            { return PHP_FALSE;
            }
          case 268: break;
          case 97: 
            { return PHP_FINAL;
            }
          case 269: break;
          case 98: 
            { return PHP_UNSET;
            }
          case 270: break;
          case 99: 
            { return PHP_WHILE;
            }
          case 271: break;
          case 100: 
            { return PHP_PRINT;
            }
          case 272: break;
          case 101: 
            { return PHP_CASTING;
            }
          case 273: break;
          case 102: 
            { return PHPDOC_NAME;
            }
          case 274: break;
          case 103: 
            { return PHPDOC_DESC;
            }
          case 275: break;
          case 104: 
            { return PHPDOC_USES;
            }
          case 276: break;
          case 105: 
            { return PHPDOC_LINK;
            }
          case 277: break;
          case 106: 
            { return PHP_ENDFOR;
            }
          case 278: break;
          case 107: 
            { return PHP_ELSEIF;
            }
          case 279: break;
          case 108: 
            { return PHP_RETURN;
            }
          case 280: break;
          case 109: 
            { return PHP_STATIC;
            }
          case 281: break;
          case 110: 
            { return PHP_SWITCH;
            }
          case 282: break;
          case 111: 
            { return PHP_GLOBAL;
            }
          case 283: break;
          case 112: 
            { return PHP_PARENT;
            }
          case 284: break;
          case 113: 
            { return PHP_PUBLIC;
            }
          case 285: break;
          case 114: 
            { return PHPDOC_FINAL;
            }
          case 286: break;
          case 115: 
            { return PHPDOC_SINCE;
            }
          case 287: break;
          case 116: 
            { return PHPDOC_PARAM;
            }
          case 288: break;
          case 117: 
            { return PHPDOC_MAGIC;
            }
          case 289: break;
          case 118: 
            { return PHP_EXTENDS;
            }
          case 290: break;
          case 119: 
            { return PHP_REQUIRE;
            }
          case 291: break;
          case 120: 
            { return PHP_DECLARE;
            }
          case 292: break;
          case 121: 
            { return PHP_DEFAULT;
            }
          case 293: break;
          case 122: 
            { return PHP_INCLUDE;
            }
          case 294: break;
          case 123: 
            { return PHP_FOREACH;
            }
          case 295: break;
          case 124: 
            { return PHP_PRIVATE;
            }
          case 296: break;
          case 125: 
            { return PHP__DIR__;
            }
          case 297: break;
          case 126: 
            { return PHPDOC_RETURN;
            }
          case 298: break;
          case 127: 
            { return PHPDOC_ACCESS;
            }
          case 299: break;
          case 128: 
            { return PHPDOC_AUTHOR;
            }
          case 300: break;
          case 129: 
            { return PHPDOC_IGNORE;
            }
          case 301: break;
          case 130: 
            { return PHPDOC_THROWS;
            }
          case 302: break;
          case 131: 
            { return PHPDOC_STATIC;
            }
          case 303: break;
          case 132: 
            { return PHPDOC_GLOBAL;
            }
          case 304: break;
          case 133: 
            { return PHPDOC_METHOD;
            }
          case 305: break;
          case 134: 
            { return PHP_ENDWHILE;
            }
          case 306: break;
          case 135: 
            { return PHP_CONTINUE;
            }
          case 307: break;
          case 136: 
            { return PHP_CALLABLE;
            }
          case 308: break;
          case 137: 
            { return PHP_ABSTRACT;
            }
          case 309: break;
          case 138: 
            { return PHP_FUNCTION;
            }
          case 310: break;
          case 139: 
            { return PHP__FILE__;
            }
          case 311: break;
          case 140: 
            { return PHP__LINE__;
            }
          case 312: break;
          case 141: 
            { return PHPDOC_EXAMPLE;
            }
          case 313: break;
          case 142: 
            { return PHPDOC_LICENSE;
            }
          case 314: break;
          case 143: 
            { return PHPDOC_PACKAGE;
            }
          case 315: break;
          case 144: 
            { return PHPDOC_VERSION;
            }
          case 316: break;
          case 145: 
            { return PHP_ENDSWITCH;
            }
          case 317: break;
          case 146: 
            { return PHP_NAMESPACE;
            }
          case 318: break;
          case 147: 
            { return PHP_INTERFACE;
            }
          case 319: break;
          case 148: 
            { return PHP_INSTEADOF;
            }
          case 320: break;
          case 149: 
            { return PHP_PROTECTED;
            }
          case 321: break;
          case 150: 
            { return PHP__CLASS__;
            }
          case 322: break;
          case 151: 
            { return PHPDOC_CATEGORY;
            }
          case 323: break;
          case 152: 
            { return PHPDOC_ABSTRACT;
            }
          case 324: break;
          case 153: 
            { return PHPDOC_INTERNAL;
            }
          case 325: break;
          case 154: 
            { return PHPDOC_TUTORIAL;
            }
          case 326: break;
          case 155: 
            { return PHPDOC_PROPERTY;
            }
          case 327: break;
          case 156: 
            { return PHP_ENDDECLARE;
            }
          case 328: break;
          case 157: 
            { return PHP_ENDFOREACH;
            }
          case 329: break;
          case 158: 
            { return PHP_INSTANCEOF;
            }
          case 330: break;
          case 159: 
            { return PHP_IMPLEMENTS;
            }
          case 331: break;
          case 160: 
            { return PHP__METHOD__;
            }
          case 332: break;
          case 161: 
            { return PHPDOC_EXCEPTION;
            }
          case 333: break;
          case 162: 
            { return PHPDOC_COPYRIGHT;
            }
          case 334: break;
          case 163: 
            { return PHPDOC_NAMESPACE;
            }
          case 335: break;
          case 164: 
            { return PHPDOC_STATICVAR;
            }
          case 336: break;
          case 165: 
            { return PHPDOC_DEPRECATED;
            }
          case 337: break;
          case 166: 
            { return PHPDOC_FILESOURCE;
            }
          case 338: break;
          case 167: 
            { return PHPDOC_SUBPACKAGE;
            }
          case 339: break;
          case 168: 
            { return PHP_REQUIRE_ONCE;
            }
          case 340: break;
          case 169: 
            { return PHP_INCLUDE_ONCE;
            }
          case 341: break;
          case 170: 
            { return PHP__FUNCTION__;
            }
          case 342: break;
          case 171: 
            { return PHP__NAMESPACE__;
            }
          case 343: break;
          case 172: 
            { return PHP_HALT_COMPILER;
            }
          case 344: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
