/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.searchEngine;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class SearchFieldTests {
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected IFile testFile;
    protected PHPVersion phpVersion;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/searchEngine/php5"});
    }

    public SearchFieldTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("AutoSelectionEngine_" + this.phpVersion.toString());
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        PHPCoreTests.setProjectPhpVersion(this.project, this.phpVersion);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
    }

    @After
    public void afterTest() throws Exception {
        if (this.testFile != null) {
            this.testFile.delete(true, null);
            this.testFile = null;
        }
    }

    @Test
    public void search(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        List<String> paths = this.getSelection(pdttFile.getFile());
        int occurrences = Integer.parseInt(pdttFile.getExpected().trim());
        boolean proposalsEqual = true;
        if (paths.size() != occurrences) {
            proposalsEqual = false;
        }
        if (!proposalsEqual) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED OCCURRENCE TIMES:\n-----------------------------\n");
            errorBuf.append(pdttFile.getExpected());
            errorBuf.append("\nACTUAL OCCURRENCE TIMES:\n-----------------------------\n");
            errorBuf.append(paths.size());
            Assert.fail((String)errorBuf.toString());
        }
    }

    protected void createFile(String data) throws Exception {
        this.testFile = this.project.getFile("test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
        PHPCoreTests.waitForIndexer();
    }

    protected ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)this.testFile);
    }

    protected static int getSearchFlags(boolean includeInterp) {
        int flags = 3;
        if (includeInterp) {
            flags |= 4;
        }
        return flags;
    }

    protected List<String> getSelection(String data) throws Exception {
        this.createFile(data);
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.testFile);
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule, (int)SearchFieldTests.getSearchFlags(false));
        ISearchEngine searchEngine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)scope.getLanguageToolkit());
        final ArrayList<String> paths = new ArrayList<String>();
        if (searchEngine != null) {
            ISearchRequestor requestor = new ISearchRequestor(){

                public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                    paths.add(sourceModule.getPath().toString());
                }
            };
            searchEngine.search(8, null, "$testField", 0, 0, 0, ISearchEngine.SearchFor.ALL_OCCURRENCES, ISearchEngine.MatchRule.EXACT, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        return paths;
    }
}

