/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.BasicSearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.language.PHPVariables;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.FakeField;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class GlobalVariablesStrategy
extends GlobalElementStrategy {
    private boolean showPhpVariables = true;

    public GlobalVariablesStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public GlobalVariablesStrategy(ICompletionContext context, boolean showPhpVariables) {
        super(context);
        this.showPhpVariables = showPhpVariables;
    }

    public GlobalVariablesStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        IDLTKSearchScope scope;
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        String prefix = abstractContext.getPrefix();
        if (prefix.length() > 0 && !prefix.startsWith("$")) {
            return;
        }
        CompletionRequestor requestor = abstractContext.getCompletionRequestor();
        ISearchEngine.MatchRule matchRule = ISearchEngine.MatchRule.PREFIX;
        if (requestor.isContextInformationMode()) {
            matchRule = ISearchEngine.MatchRule.EXACT;
        }
        IField[] fields = null;
        if (this.showVarsFromOtherFiles("contentAssistShowVariablesFromOtherFiles")) {
            scope = this.createSearchScope();
            fields = PhpModelAccess.getDefault().findFileFields(prefix, matchRule, 8192, 2, scope, null);
        } else if (this.showVarsFromOtherFiles("contentAssistShowVariablesFromReferencedFiles")) {
            scope = this.createSearchScopeWithReferencedFiles(abstractContext.getSourceModule());
            fields = PhpModelAccess.getDefault().findFileFields(prefix, matchRule, 8192, 2, scope, null);
        }
        LinkedList<IField> result = new LinkedList<IField>();
        if (fields != null) {
            result.addAll(Arrays.asList(fields));
        }
        if ((fields = PHPModelUtils.getFileFields(abstractContext.getSourceModule(), prefix, false, null)) != null) {
            result.addAll(Arrays.asList(fields));
        }
        fields = result.toArray(new IField[result.size()]);
        SourceRange replaceRange = this.getReplacementRange(context);
        IField[] iFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField var = iFieldArray[n2];
            reporter.reportField(var, "", (ISourceRange)replaceRange, false);
            ++n2;
        }
        if (this.showPhpVariables) {
            PHPVersion phpVersion = abstractContext.getPhpVersion();
            String[] stringArray = PHPVariables.getVariables(phpVersion);
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String variable = stringArray[n];
                if (variable.startsWith(prefix) && (!requestor.isContextInformationMode() || variable.length() == prefix.length())) {
                    reporter.reportField((IField)new FakeField((ModelElement)abstractContext.getSourceModule(), variable, 0, 0), "", (ISourceRange)replaceRange, false);
                }
                ++n;
            }
        }
    }

    private IDLTKSearchScope createSearchScopeWithReferencedFiles(ISourceModule sourceModule) {
        Collection<ReferenceTree.Node> allIncludedNodes;
        ReferenceTree tree = FileNetworkUtility.buildReferencedFilesTree(sourceModule, null);
        HashSet<ISourceModule> list = new HashSet<ISourceModule>();
        list.add(sourceModule);
        if (tree != null && tree.getRoot() != null && (allIncludedNodes = tree.getRoot().getChildren()) != null) {
            this.getNodeChildren(tree.getRoot(), list);
        }
        return BasicSearchEngine.createSearchScope((IModelElement[])((IModelElement[])list.toArray(new ISourceModule[list.size()])), (IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)sourceModule));
    }

    private void getNodeChildren(ReferenceTree.Node root, Set<ISourceModule> list) {
        if (root.getChildren() == null) {
            return;
        }
        for (ReferenceTree.Node includedNode : root.getChildren()) {
            ISourceModule sm = includedNode.getFile();
            list.add(sm);
            this.getNodeChildren(includedNode, list);
        }
    }

    protected boolean showVarsFromOtherFiles(String id) {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.core", id, true, null);
    }

    @Override
    protected IDLTKSearchScope createSearchScope() {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        if (abstractContext.getPrefixWithoutProcessing().trim().length() == 0) {
            ISourceModule sourceModule = ((AbstractCompletionContext)context).getSourceModule();
            return SearchEngine.createSearchScope((IModelElement)sourceModule);
        }
        return super.createSearchScope();
    }
}

