/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.LinkedList;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.NamespacePHPDocVarStartContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class NamespaceDocTypesStrategy
extends AbstractCompletionStrategy {
    public NamespaceDocTypesStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public NamespaceDocTypesStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof NamespacePHPDocVarStartContext)) {
            return;
        }
        NamespacePHPDocVarStartContext concreteContext = (NamespacePHPDocVarStartContext)context;
        String suffix = "";
        String nsSuffix = this.getNSSuffix(concreteContext);
        SourceRange replaceRange = this.getReplacementRange(concreteContext);
        IType[] iTypeArray = this.getTypes(concreteContext);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                int flags = type.getFlags();
                int extraInfo = this.getExtraInfo();
                boolean isNamespace = PHPFlags.isNamespace(flags);
                reporter.reportType(type, isNamespace ? nsSuffix : suffix, (ISourceRange)replaceRange, isNamespace ? extraInfo : extraInfo | 0x80);
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
    }

    public IType[] getTypes(NamespacePHPDocVarStartContext context) throws BadLocationException {
        String prefix = context.getPrefix();
        prefix = PHPModelUtils.extractElementName(prefix);
        LinkedList<Object> result = new LinkedList<Object>();
        IType[] iTypeArray = context.getNamespaces();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            try {
                IType[] iTypeArray2 = ns.getTypes();
                int n3 = iTypeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType type = iTypeArray2[n4];
                    if (CodeAssistUtils.startsWithIgnoreCase(type.getElementName(), prefix)) {
                        result.add(type);
                    }
                    ++n4;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        String lastNamespace = null;
        IType[] iTypeArray3 = context.getPossibleNamespaces();
        int n5 = iTypeArray3.length;
        n = 0;
        while (n < n5) {
            IType ns = iTypeArray3[n];
            if (context.getNsPrefix() == null) {
                if (!ns.getElementName().equals(lastNamespace)) {
                    result.add(ns);
                }
                lastNamespace = ns.getElementName();
            } else {
                String fullName = ns.getElementName();
                String alias = this.getAlias(ns, context.getNsPrefix());
                if (alias == null) {
                    result.add(ns);
                } else {
                    result.add((Object)new AliasType((ModelElement)ns, fullName, alias));
                }
            }
            ++n;
        }
        return result.toArray(new IType[result.size()]);
    }

    private String getAlias(IType ns, String currentNSName) {
        String result = ns.getElementName();
        result = result.startsWith(currentNSName = String.valueOf(currentNSName) + '\\') ? result.substring(currentNSName.length()) : null;
        return result;
    }

    protected int getExtraInfo() {
        return 2;
    }
}

