/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class IndentationUtils {
    public static boolean isRegionTypeAllowedMultiline(String regionType) {
        return regionType != null && !"PHPDOC_COMMENT_START".equals(regionType) && !"PHP_COMMENT_START".equals(regionType) && !"PHP_LINE_COMMENT".equals(regionType) && !"PHP_CASE".equals(regionType) && !"PHP_DEFAULT".equals(regionType);
    }

    public static boolean isBlanks(IStructuredDocument document, int startOffset, int endOffset) throws BadLocationException {
        int i = startOffset;
        while (i < endOffset) {
            if (!Character.isWhitespace(document.getChar(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int moveLineStartToNonBlankChar(IStructuredDocument document, int lineStart, int currLineIndex, boolean moveAfterNonBlankChar) {
        try {
            int lineLength = document.getLineLength(currLineIndex);
            int i = 0;
            while (i < lineLength) {
                char c = document.getChar(lineStart + i);
                if (!Character.isWhitespace(c)) {
                    lineStart += i + (moveAfterNonBlankChar ? 1 : 0);
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return lineStart;
    }

    public static boolean inBracelessBlock(PHPHeuristicScanner scanner, IStructuredDocument document, int offset) {
        try {
            if (scanner.isBracelessBlockStart(offset - 1, -2) && scanner.nextToken(offset, -2) != 1) {
                return true;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }
}

