/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.IIndexingRequestor;
import org.eclipse.php.core.index.PhpIndexingVisitorExtension;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReferenceExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class PhpIndexingVisitor
extends PhpIndexingVisitorExtension {
    private static final String DOLOR = "$";
    private static final String CONSTRUCTOR_NAME = "__construct";
    private static final Pattern WHITESPACE_SEPERATOR = Pattern.compile("\\s+");
    private static final String EXTENSION_POINT = "phpIndexingVisitors";
    private static final String CLASS_ATTR = "class";
    public static final String PARAMETER_SEPERATOR = "|";
    public static final String NULL_VALUE = "#";
    private static final String DEFAULT_VALUE = " ";
    protected Stack<Declaration> declarations = new Stack();
    protected List<ASTNode> deferredDeclarations = new LinkedList<ASTNode>();
    protected List<ASTNode> deferredNamespacedDeclarations = new LinkedList<ASTNode>();
    protected Stack<Set<String>> methodGlobalVars = new Stack();
    private PhpIndexingVisitorExtension[] extensions;
    private static IConfigurationElement[] extensionElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core", "phpIndexingVisitors");
    protected NamespaceDeclaration fCurrentNamespace;
    protected Map<String, UsePart> fLastUseParts = new HashMap<String, UsePart>();
    protected String fCurrentQualifier;
    protected Map<String, Integer> fCurrentQualifierCounts = new HashMap<String, Integer>();
    protected String fCurrentParent;
    protected Stack<ASTNode> fNodes = new Stack();

    public PhpIndexingVisitor(IIndexingRequestor requestor, ISourceModule module) {
        this.requestor = requestor;
        ArrayList<PhpIndexingVisitorExtension> extensions = new ArrayList<PhpIndexingVisitorExtension>(extensionElements.length);
        IConfigurationElement[] iConfigurationElementArray = extensionElements;
        int n = extensionElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                PhpIndexingVisitorExtension ext = (PhpIndexingVisitorExtension)((Object)element.createExecutableExtension(CLASS_ATTR));
                ext.setRequestor(requestor);
                ext.setSourceModule(module);
                extensions.add(ext);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            ++n2;
        }
        this.extensions = extensions.toArray(new PhpIndexingVisitorExtension[extensions.size()]);
    }

    @Override
    public void modifyDeclaration(ASTNode node, IIndexingRequestor.DeclarationInfo info) {
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n2];
            visitor.modifyDeclaration(node, info);
            ++n2;
        }
        if (info.elementType != 10) {
            if (info.parent == null) {
                info.parent = "<f>";
            }
            if (info.qualifier == null) {
                info.qualifier = "<g>";
            }
        }
        this.requestor.addDeclaration(info);
    }

    @Override
    public void modifyReference(ASTNode node, IIndexingRequestor.ReferenceInfo info) {
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n2];
            visitor.modifyReference(node, info);
            ++n2;
        }
        this.requestor.addReference(info);
    }

    protected static String encodeDocInfo(Declaration declaration) {
        PHPDocBlock docBlock;
        if (declaration instanceof IPHPDocAwareDeclaration && (docBlock = ((IPHPDocAwareDeclaration)declaration).getPHPDoc()) != null) {
            HashMap<String, String> info = new HashMap<String, String>();
            PHPDocTag[] pHPDocTagArray = docBlock.getTags();
            int n = pHPDocTagArray.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                if (tag.getTagKind() == 2) {
                    info.put("d", null);
                } else if (tag.getTagKind() == 6) {
                    StringBuilder buf = new StringBuilder();
                    for (TypeReference ref : tag.getTypeReferences()) {
                        String type = ref.getName().replaceAll(",", "~");
                        if (buf.length() > 0) {
                            buf.append(',');
                        }
                        buf.append(type);
                    }
                    info.put("r", buf.toString());
                } else if (tag.getTagKind() == 12 && tag.getTypeReferences().size() > 0) {
                    String typeNames = PHPModelUtils.appendTypeReferenceNames(tag.getTypeReferences());
                    typeNames = typeNames.replace('|', '.');
                    info.put("v", typeNames);
                }
                ++n2;
            }
            return PhpIndexingVisitor.encodeDocInfo(info);
        }
        return null;
    }

    protected static String encodeDocInfo(Map<String, String> info) {
        if (info == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> e : info.entrySet()) {
            if (buf.length() > 0) {
                buf.append(';');
            }
            buf.append(e.getKey());
            if (e.getValue() == null) continue;
            buf.append(':').append(e.getValue());
        }
        return buf.length() > 0 ? buf.toString() : null;
    }

    public boolean endvisit(MethodDeclaration method) throws Exception {
        this.methodGlobalVars.pop();
        this.declarations.pop();
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n2];
            visitor.endvisit(method);
            ++n2;
        }
        this.endvisitGeneral((ASTNode)method);
        return true;
    }

    public boolean endvisit(TypeDeclaration type) throws Exception {
        if (type instanceof NamespaceDeclaration) {
            NamespaceDeclaration namespaceDecl = (NamespaceDeclaration)type;
            while (this.deferredNamespacedDeclarations != null && !this.deferredNamespacedDeclarations.isEmpty()) {
                ASTNode[] declarations = this.deferredNamespacedDeclarations.toArray(new ASTNode[this.deferredNamespacedDeclarations.size()]);
                this.deferredNamespacedDeclarations.clear();
                ASTNode[] aSTNodeArray = declarations;
                int n = declarations.length;
                int n2 = 0;
                while (n2 < n) {
                    ASTNode deferred = aSTNodeArray[n2];
                    deferred.traverse((ASTVisitor)this);
                    ++n2;
                }
            }
            this.fCurrentNamespace = null;
            this.fCurrentQualifier = null;
            this.fLastUseParts.clear();
            if (namespaceDecl.isGlobal()) {
                return this.visitGeneral((ASTNode)type);
            }
        } else {
            this.fCurrentParent = null;
        }
        this.declarations.pop();
        this.resolveMagicMembers(type);
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n3 = 0;
        while (n3 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n3];
            visitor.endvisit(type);
            ++n3;
        }
        this.endvisitGeneral((ASTNode)type);
        return true;
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        String methodName;
        this.fNodes.push((ASTNode)method);
        this.methodGlobalVars.add(new HashSet());
        int modifiers = method.getModifiers();
        PHPDocBlock doc = null;
        if (method instanceof IPHPDocAwareDeclaration) {
            IPHPDocAwareDeclaration declaration = (IPHPDocAwareDeclaration)method;
            doc = declaration.getPHPDoc();
        }
        Declaration parentDeclaration = null;
        if (!this.declarations.empty()) {
            parentDeclaration = this.declarations.peek();
        }
        this.declarations.push((Declaration)method);
        if (parentDeclaration instanceof MethodDeclaration) {
            if (this.fCurrentNamespace == null) {
                this.deferredDeclarations.add((ASTNode)method);
            } else {
                this.deferredNamespacedDeclarations.add((ASTNode)method);
            }
            return this.visitGeneral((ASTNode)method);
        }
        if (parentDeclaration instanceof InterfaceDeclaration) {
            method.setModifier(1);
        }
        if ((methodName = method.getName()).equalsIgnoreCase(CONSTRUCTOR_NAME) || parentDeclaration instanceof ClassDeclaration && methodName.equalsIgnoreCase(((ClassDeclaration)parentDeclaration).getName())) {
            modifiers |= 0x100000;
        }
        if (parentDeclaration == null || parentDeclaration instanceof TypeDeclaration && parentDeclaration == this.fCurrentNamespace) {
            modifiers |= 0x2000;
        }
        if (!(Flags.isPrivate((int)modifiers) || Flags.isProtected((int)modifiers) || Flags.isPublic((int)modifiers))) {
            modifiers |= 0x40;
        }
        modifiers = this.markAsDeprecated(modifiers, (ASTNode)method);
        StringBuilder metadata = new StringBuilder();
        metadata.append(this.fCurrentQualifier != null ? this.fCurrentQualifierCounts.get(this.fCurrentQualifier) : 1);
        metadata.append(";");
        List arguments = method.getArguments();
        if (arguments != null) {
            Iterator i = arguments.iterator();
            while (i.hasNext()) {
                FormalParameter fp;
                Argument arg = (Argument)i.next();
                String type = NULL_VALUE;
                if (arg instanceof FormalParameter && (fp = (FormalParameter)arg).getParameterType() != null && fp.getParameterType().getName() != null) {
                    type = fp.getParameterType().getName();
                }
                if (type == NULL_VALUE && doc != null) {
                    type = this.getParamType(doc, arg.getName(), type);
                }
                metadata.append(type);
                metadata.append(PARAMETER_SEPERATOR);
                metadata.append(arg.getName());
                metadata.append(PARAMETER_SEPERATOR);
                String defaultValue = NULL_VALUE;
                if (arg.getInitialization() != null) {
                    if (arg.getInitialization() instanceof Literal) {
                        Literal scalar = (Literal)arg.getInitialization();
                        defaultValue = scalar.getValue();
                    } else {
                        defaultValue = DEFAULT_VALUE;
                    }
                }
                metadata.append(defaultValue);
                if (!i.hasNext()) continue;
                metadata.append(",");
            }
        }
        this.modifyDeclaration((ASTNode)method, new IIndexingRequestor.DeclarationInfo(9, modifiers, method.sourceStart(), method.sourceEnd() - method.sourceStart(), method.getNameStart(), method.getNameEnd() - method.getNameStart(), methodName, metadata.toString(), PhpIndexingVisitor.encodeDocInfo((Declaration)method), this.fCurrentQualifier, this.fCurrentParent));
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n2];
            visitor.visit(method);
            ++n2;
        }
        return this.visitGeneral((ASTNode)method);
    }

    private int markAsDeprecated(int modifiers, PHPDocBlock phpDoc) {
        if (phpDoc != null && phpDoc.getTags(2).length > 0) {
            return modifiers | 0x800000;
        }
        return modifiers;
    }

    private int markAsDeprecated(int modifiers, ASTNode node) {
        if (node instanceof IPHPDocAwareDeclaration) {
            return this.markAsDeprecated(modifiers, ((IPHPDocAwareDeclaration)node).getPHPDoc());
        }
        return modifiers;
    }

    private String getParamType(PHPDocBlock docBlock, String paramName, String defaultType) {
        String result = defaultType;
        if (docBlock != null) {
            PHPDocTag[] pHPDocTagArray = docBlock.getTags(7);
            int n = pHPDocTagArray.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                if (tag.isValidParamTag() && tag.getVariableReference().getName().equals(paramName)) {
                    String typeNames = tag.getSingleTypeReference().getName();
                    result = typeNames.replace('|', '.');
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean visit(TypeDeclaration type) throws Exception {
        StringBuilder metadata;
        int modifiers;
        if (type instanceof NamespaceDeclaration) {
            NamespaceDeclaration namespaceDecl;
            this.fCurrentNamespace = namespaceDecl = (NamespaceDeclaration)type;
            this.fLastUseParts.clear();
            if (namespaceDecl.isGlobal()) {
                return this.visitGeneral((ASTNode)type);
            }
            this.declarations.push((Declaration)type);
            modifiers = type.getModifiers() | 0x800;
            this.fCurrentQualifier = type.getName();
            Integer count = this.fCurrentQualifierCounts.get(this.fCurrentQualifier);
            count = count != null ? count + 1 : 1;
            this.fCurrentQualifierCounts.put(this.fCurrentQualifier, count);
            modifiers = this.markAsDeprecated(modifiers, (ASTNode)type);
            metadata = new StringBuilder();
            metadata.append(this.fCurrentQualifier != null ? this.fCurrentQualifierCounts.get(this.fCurrentQualifier) : 1);
            metadata.append(";");
            this.modifyDeclaration((ASTNode)type, new IIndexingRequestor.DeclarationInfo(10, modifiers, type.sourceStart(), type.sourceEnd() - type.sourceStart(), type.getNameStart(), type.getNameEnd() - type.getNameStart(), type.getName(), metadata.toString(), PhpIndexingVisitor.encodeDocInfo((Declaration)type), null, null));
        } else {
            Declaration parentDeclaration = null;
            if (!this.declarations.empty()) {
                parentDeclaration = this.declarations.peek();
            }
            this.declarations.push((Declaration)type);
            if (!(parentDeclaration instanceof NamespaceDeclaration)) {
                type.setModifier(8192);
            }
            if (parentDeclaration instanceof MethodDeclaration) {
                if (this.fCurrentNamespace == null) {
                    this.deferredDeclarations.add((ASTNode)type);
                } else {
                    this.deferredNamespacedDeclarations.add((ASTNode)type);
                }
                return this.visitGeneral((ASTNode)type);
            }
            modifiers = type.getModifiers();
            this.fCurrentParent = type.getName();
            String[] superClasses = this.processSuperClasses(type);
            metadata = new StringBuilder();
            metadata.append(this.fCurrentQualifier != null ? this.fCurrentQualifierCounts.get(this.fCurrentQualifier) : 1);
            metadata.append(";");
            int i = 0;
            while (i < superClasses.length) {
                metadata.append(superClasses[i]);
                if (i < superClasses.length - 1) {
                    metadata.append(",");
                }
                ++i;
            }
            modifiers = this.markAsDeprecated(modifiers, (ASTNode)type);
            this.modifyDeclaration((ASTNode)type, new IIndexingRequestor.DeclarationInfo(7, modifiers, type.sourceStart(), type.sourceEnd() - type.sourceStart(), type.getNameStart(), type.getNameEnd() - type.getNameStart(), type.getName(), metadata.toString(), PhpIndexingVisitor.encodeDocInfo((Declaration)type), this.fCurrentQualifier, null));
        }
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n2];
            visitor.visit(type);
            ++n2;
        }
        return this.visitGeneral((ASTNode)type);
    }

    protected String[] processSuperClasses(TypeDeclaration type) {
        ASTListNode superClasses = type.getSuperClasses();
        if (superClasses == null) {
            return new String[0];
        }
        List superClassNames = superClasses.getChilds();
        ArrayList<String> result = new ArrayList<String>(superClassNames.size());
        for (ASTNode nameNode : superClassNames) {
            if (nameNode instanceof FullyQualifiedReference) {
                FullyQualifiedReference fullyQualifiedName = (FullyQualifiedReference)nameNode;
                String name = fullyQualifiedName.getFullyQualifiedName();
                if (fullyQualifiedName.getNamespace() != null) {
                    String namespace = fullyQualifiedName.getNamespace().getName();
                    String subnamespace = "";
                    if (namespace.charAt(0) != '\\' && namespace.indexOf(92) > 0) {
                        int firstNSLocation = namespace.indexOf(92);
                        subnamespace = namespace.substring(firstNSLocation);
                        namespace = namespace.substring(0, firstNSLocation);
                    }
                    if (name.charAt(0) == '\\') {
                        name = name.substring(1);
                    } else if (this.fLastUseParts.containsKey(namespace)) {
                        name = this.fLastUseParts.get(namespace).getNamespace().getFullyQualifiedName() + subnamespace + '\\' + fullyQualifiedName.getName();
                    } else if (this.fCurrentNamespace != null) {
                        name = this.fCurrentNamespace.getName() + '\\' + name;
                    }
                } else if (this.fLastUseParts.containsKey(name)) {
                    if ((name = this.fLastUseParts.get(name).getNamespace().getFullyQualifiedName()).charAt(0) == '\\') {
                        name = name.substring(1);
                    }
                } else if (this.fCurrentNamespace != null) {
                    name = this.fCurrentNamespace.getName() + '\\' + name;
                }
                result.add(name);
                continue;
            }
            if (!(nameNode instanceof SimpleReference)) continue;
            result.add(((SimpleReference)nameNode).getName());
        }
        return result.toArray(new String[result.size()]);
    }

    private void resolveMagicMembers(TypeDeclaration type) {
        IPHPDocAwareDeclaration declaration;
        PHPDocBlock doc;
        if (type instanceof IPHPDocAwareDeclaration && (doc = (declaration = (IPHPDocAwareDeclaration)type).getPHPDoc()) != null) {
            PHPDocTag[] pHPDocTagArray = doc.getTags();
            int n = pHPDocTagArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] split;
                PHPDocTag docTag = pHPDocTagArray[n2];
                int tagKind = docTag.getTagKind();
                if (tagKind == 30 || tagKind == 31 || tagKind == 32) {
                    split = WHITESPACE_SEPERATOR.split(docTag.getValue().trim());
                    if (split.length < 2) break;
                    String name = this.removeParenthesis(split);
                    int offset = docTag.sourceStart();
                    int length = docTag.sourceStart() + 9;
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("v", split[0]);
                    StringBuilder metadata = new StringBuilder();
                    metadata.append(this.fCurrentQualifier != null ? this.fCurrentQualifierCounts.get(this.fCurrentQualifier) : 1);
                    metadata.append(";");
                    this.modifyDeclaration(null, new IIndexingRequestor.DeclarationInfo(8, 64, offset, length, offset, length, name, metadata.toString(), PhpIndexingVisitor.encodeDocInfo(info), this.fCurrentQualifier, this.fCurrentParent));
                } else if (tagKind == 33) {
                    String name;
                    int index;
                    split = WHITESPACE_SEPERATOR.split(docTag.getValue().trim());
                    if (split.length < 2) break;
                    int methodModifiers = 64;
                    if ("static".equals(split[0].trim())) {
                        if (split.length < 3) break;
                        methodModifiers |= 0x80;
                        split = Arrays.copyOfRange(split, 1, split.length);
                    }
                    if ((index = (name = this.removeParenthesis(split)).indexOf(40)) > 0) {
                        name = name.substring(0, index);
                    }
                    int offset = docTag.sourceStart();
                    int length = docTag.sourceStart() + 6;
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("r", split[0]);
                    StringBuilder metadata = new StringBuilder();
                    metadata.append(this.fCurrentQualifier != null ? this.fCurrentQualifierCounts.get(this.fCurrentQualifier) : 1);
                    metadata.append(";");
                    this.modifyDeclaration(null, new IIndexingRequestor.DeclarationInfo(9, methodModifiers, offset, length, offset, length, name, metadata.toString(), PhpIndexingVisitor.encodeDocInfo(info), this.fCurrentQualifier, this.fCurrentParent));
                }
                ++n2;
            }
        }
    }

    private String removeParenthesis(String[] split) {
        String name = split[1];
        return name.endsWith("()") ? name.substring(0, name.length() - 2) : name;
    }

    public boolean visit(UseStatement declaration) throws Exception {
        Collection<UsePart> parts = declaration.getParts();
        for (UsePart part : parts) {
            String name = null;
            if (part.getAlias() != null) {
                name = part.getAlias().getName();
            } else {
                name = part.getNamespace().getName();
                int index = name.lastIndexOf(92);
                if (index >= 0) {
                    name = name.substring(index + 1);
                }
            }
            this.fLastUseParts.put(name, part);
        }
        return this.visitGeneral((ASTNode)declaration);
    }

    public boolean visit(FieldDeclaration decl) throws Exception {
        int modifiers = decl.getModifiers();
        modifiers = this.markAsDeprecated(modifiers, (ASTNode)decl);
        this.modifyDeclaration((ASTNode)decl, new IIndexingRequestor.DeclarationInfo(8, modifiers, decl.sourceStart(), decl.sourceEnd() - decl.sourceStart(), decl.getNameStart(), decl.getNameEnd() - decl.getNameStart(), decl.getName(), null, PhpIndexingVisitor.encodeDocInfo((Declaration)decl), null, null));
        return this.visitGeneral((ASTNode)decl);
    }

    public boolean endvisit(FieldDeclaration declaration) throws Exception {
        this.endvisitGeneral((ASTNode)declaration);
        return true;
    }

    public boolean visit(PHPFieldDeclaration decl) throws Exception {
        int modifiers = this.markAsDeprecated(decl.getModifiers(), (ASTNode)decl);
        StringBuilder metadata = new StringBuilder();
        metadata.append(this.fCurrentQualifier != null ? this.fCurrentQualifierCounts.get(this.fCurrentQualifier) : 1);
        metadata.append(";");
        this.modifyDeclaration((ASTNode)decl, new IIndexingRequestor.DeclarationInfo(8, modifiers, decl.sourceStart(), decl.sourceEnd() - decl.sourceStart(), decl.getNameStart(), decl.getNameEnd() - decl.getNameStart(), decl.getName(), metadata.toString(), PhpIndexingVisitor.encodeDocInfo((Declaration)decl), this.fCurrentQualifier, this.fCurrentParent));
        return this.visitGeneral((ASTNode)decl);
    }

    public boolean endvisit(PHPFieldDeclaration declaration) throws Exception {
        this.endvisitGeneral((ASTNode)declaration);
        return true;
    }

    public boolean visit(CallExpression call) throws Exception {
        FieldDeclaration constantDecl = ASTUtils.getConstantDeclaration(call);
        if (constantDecl != null) {
            if (!this.declarations.empty() && this.declarations.peek() instanceof MethodDeclaration) {
                this.deferredDeclarations.add((ASTNode)constantDecl);
                return this.visitGeneral((ASTNode)call);
            }
            this.visit(constantDecl);
        } else {
            int argsCount = 0;
            CallArgumentsList args = call.getArgs();
            if (args != null && args.getChilds() != null) {
                argsCount = args.getChilds().size();
            }
            this.modifyReference((ASTNode)call, new IIndexingRequestor.ReferenceInfo(9, call.sourceStart(), call.sourceEnd() - call.sourceStart(), call.getName(), Integer.toString(argsCount), null));
        }
        return this.visitGeneral((ASTNode)call);
    }

    public boolean visit(Include include) throws Exception {
        if (include.getExpr() instanceof Scalar) {
            Scalar filePath = (Scalar)include.getExpr();
            this.modifyReference((ASTNode)include, new IIndexingRequestor.ReferenceInfo(9, filePath.sourceStart(), filePath.sourceEnd() - filePath.sourceStart(), "include", Integer.toString(1), null));
            String fullPath = ASTUtils.stripQuotes(filePath.getValue());
            int idx = Math.max(fullPath.lastIndexOf(47), fullPath.lastIndexOf(92));
            String lastSegment = fullPath;
            if (idx != -1) {
                lastSegment = lastSegment.substring(idx + 1);
            }
            StringBuilder metadata = new StringBuilder();
            metadata.append(1);
            metadata.append(";");
            metadata.append(fullPath);
            this.modifyDeclaration((ASTNode)include, new IIndexingRequestor.DeclarationInfo(12, 0, include.sourceStart(), include.sourceEnd() - include.sourceStart(), filePath.sourceStart(), filePath.sourceEnd() - filePath.sourceStart(), lastSegment, metadata.toString(), null, null, null));
        }
        return this.visitGeneral((ASTNode)include);
    }

    public boolean visit(ConstantDeclaration declaration) throws Exception {
        int modifiers = 70;
        if (this.fCurrentParent != null) {
            modifiers |= 0x400;
        }
        modifiers = this.markAsDeprecated(modifiers, (ASTNode)declaration);
        ConstantReference constantName = declaration.getConstantName();
        int offset = constantName.sourceStart();
        int length = constantName.sourceEnd();
        StringBuilder metadata = new StringBuilder();
        metadata.append(this.fCurrentQualifier != null ? this.fCurrentQualifierCounts.get(this.fCurrentQualifier) : 1);
        metadata.append(";");
        this.modifyDeclaration((ASTNode)declaration, new IIndexingRequestor.DeclarationInfo(8, modifiers, offset, length, offset, length, ASTUtils.stripQuotes(constantName.getName()), metadata.toString(), PhpIndexingVisitor.encodeDocInfo(declaration), this.fCurrentQualifier, this.fCurrentParent));
        return this.visitGeneral((ASTNode)declaration);
    }

    public boolean endvisit(ConstantDeclaration declaration) throws Exception {
        this.endvisitGeneral((ASTNode)declaration);
        return true;
    }

    public boolean visit(Assignment assignment) throws Exception {
        Expression left = assignment.getVariable();
        if (left instanceof FieldAccess) {
            Expression field;
            FieldAccess fieldAccess = (FieldAccess)left;
            Expression dispatcher = fieldAccess.getDispatcher();
            if (dispatcher instanceof VariableReference && "$this".equals(((VariableReference)dispatcher).getName()) && (field = fieldAccess.getField()) instanceof SimpleReference) {
                SimpleReference var = (SimpleReference)field;
                int modifiers = 64;
                int offset = var.sourceStart();
                int length = var.sourceEnd() - offset;
                StringBuilder metadata = new StringBuilder();
                metadata.append(this.fCurrentQualifier != null ? this.fCurrentQualifierCounts.get(this.fCurrentQualifier) : 1);
                metadata.append(";");
                this.modifyDeclaration((ASTNode)assignment, new IIndexingRequestor.DeclarationInfo(8, modifiers, offset, length, offset, length, String.valueOf('$') + var.getName(), metadata.toString(), null, this.fCurrentQualifier, this.fCurrentParent));
            }
        } else if (left instanceof VariableReference && !(left instanceof ArrayVariableReference)) {
            int modifiers = 8256;
            if (!this.declarations.empty() && this.declarations.peek() instanceof MethodDeclaration && !this.methodGlobalVars.peek().contains(((VariableReference)left).getName())) {
                return this.visitGeneral((ASTNode)assignment);
            }
            int offset = left.sourceStart();
            int length = left.sourceEnd() - offset;
            this.modifyDeclaration((ASTNode)assignment, new IIndexingRequestor.DeclarationInfo(8, modifiers, offset, length, offset, length, ((VariableReference)left).getName(), null, null, null, null));
        }
        return this.visitGeneral((ASTNode)assignment);
    }

    public boolean endvisit(Assignment assignment) throws Exception {
        this.endvisitGeneral((ASTNode)assignment);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(GlobalStatement s) throws Exception {
        if (!this.declarations.empty() && this.declarations.peek() instanceof MethodDeclaration) {
            for (Expression expression : s.getVariables()) {
                void var2_3;
                if (expression instanceof ReferenceExpression) {
                    Expression expression2 = ((ReferenceExpression)expression).getVariable();
                }
                if (!(var2_3 instanceof SimpleReference)) continue;
                this.methodGlobalVars.peek().add(((SimpleReference)var2_3).getName());
            }
        }
        return this.visitGeneral((ASTNode)s);
    }

    public boolean visit(TypeReference reference) throws Exception {
        this.modifyReference((ASTNode)reference, new IIndexingRequestor.ReferenceInfo(7, reference.sourceStart(), reference.sourceEnd() - reference.sourceStart(), reference.getName(), null, null));
        return this.visitGeneral((ASTNode)reference);
    }

    public boolean visit(Statement node) throws Exception {
        if (node instanceof PHPFieldDeclaration) {
            return this.visit((PHPFieldDeclaration)node);
        }
        if (node instanceof FieldDeclaration) {
            return this.visit((FieldDeclaration)node);
        }
        if (node instanceof ConstantDeclaration) {
            return this.visit((ConstantDeclaration)node);
        }
        if (node instanceof GlobalStatement) {
            return this.visit((GlobalStatement)node);
        }
        if (node instanceof UseStatement) {
            return this.visit((UseStatement)node);
        }
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n2];
            visitor.visit(node);
            ++n2;
        }
        return this.visitGeneral((ASTNode)node);
    }

    public boolean endvisit(Statement node) throws Exception {
        if (node instanceof PHPFieldDeclaration) {
            return this.endvisit((PHPFieldDeclaration)node);
        }
        if (node instanceof FieldDeclaration) {
            return this.endvisit((FieldDeclaration)node);
        }
        if (node instanceof ConstantDeclaration) {
            return this.endvisit((ConstantDeclaration)node);
        }
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n2];
            visitor.endvisit(node);
            ++n2;
        }
        this.endvisitGeneral((ASTNode)node);
        return true;
    }

    public boolean visit(Expression node) throws Exception {
        if (node instanceof Assignment) {
            return this.visit((Assignment)node);
        }
        if (node instanceof TypeReference) {
            return this.visit((TypeReference)node);
        }
        if (node instanceof Include) {
            return this.visit((Include)node);
        }
        if (node instanceof PHPCallExpression) {
            return this.visit((PHPCallExpression)node);
        }
        if (node instanceof FieldAccess) {
            return this.visit((FieldAccess)node);
        }
        if (node instanceof StaticConstantAccess) {
            return this.visit((StaticConstantAccess)node);
        }
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n2];
            visitor.visit(node);
            ++n2;
        }
        return this.visitGeneral((ASTNode)node);
    }

    public boolean endvisit(Expression node) throws Exception {
        if (node instanceof Assignment) {
            return this.endvisit((Assignment)node);
        }
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n2];
            visitor.endvisit(node);
            ++n2;
        }
        this.endvisitGeneral((ASTNode)node);
        return true;
    }

    public boolean endvisit(ModuleDeclaration declaration) throws Exception {
        int n;
        while (this.deferredDeclarations != null && !this.deferredDeclarations.isEmpty()) {
            ASTNode[] declarations = this.deferredDeclarations.toArray(new ASTNode[this.deferredDeclarations.size()]);
            this.deferredDeclarations.clear();
            ASTNode[] aSTNodeArray = declarations;
            int n2 = declarations.length;
            n = 0;
            while (n < n2) {
                ASTNode deferred = aSTNodeArray[n];
                deferred.traverse((ASTVisitor)this);
                ++n;
            }
        }
        PhpIndexingVisitorExtension[] phpIndexingVisitorExtensionArray = this.extensions;
        n = this.extensions.length;
        int n3 = 0;
        while (n3 < n) {
            PhpIndexingVisitorExtension visitor = phpIndexingVisitorExtensionArray[n3];
            visitor.endvisit(declaration);
            ++n3;
        }
        this.fLastUseParts.clear();
        this.endvisitGeneral((ASTNode)declaration);
        return true;
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
        this.fNodes.pop();
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        this.fNodes.push(node);
        return true;
    }

    public boolean endvisit(FieldAccess declaration) throws Exception {
        this.endvisitGeneral((ASTNode)declaration);
        return true;
    }

    public boolean visit(FieldAccess access) throws Exception {
        if (access.getField() instanceof SimpleReference) {
            SimpleReference simpleReference = (SimpleReference)access.getField();
            String name = simpleReference.getName();
            if (!name.startsWith(DOLOR)) {
                name = DOLOR + name;
            }
            this.modifyReference((ASTNode)access, new IIndexingRequestor.ReferenceInfo(8, simpleReference.sourceStart(), simpleReference.sourceEnd() - simpleReference.sourceStart(), name, null, null));
        }
        return this.visitGeneral((ASTNode)access);
    }

    public boolean visit(StaticConstantAccess access) throws Exception {
        if (access.getConstant() != null) {
            ConstantReference constantReference = access.getConstant();
            String name = constantReference.getName();
            this.modifyReference((ASTNode)access, new IIndexingRequestor.ReferenceInfo(8, constantReference.sourceStart(), constantReference.sourceEnd() - constantReference.sourceStart(), name, null, null));
        }
        return this.visitGeneral((ASTNode)access);
    }
}

