/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.internal.ui.views.launch.SourceNotFoundEditorInput;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.model.IPHPExceptionBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPCompositeSourceContainer;
import org.eclipse.php.internal.debug.core.xdebug.IDELayer;
import org.eclipse.php.internal.debug.core.xdebug.breakpoints.DBGpExceptionBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.breakpoints.DBGpLineBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;

public class PdtLayer
implements IDELayer,
DBGpBreakpointFacade {
    @Override
    public String getBreakpointModelID() {
        return "org.eclipse.php.debug.core";
    }

    @Override
    public Object sourceNotFound(Object debugElement) {
        SourceNotFoundEditorInput obj = null;
        if (debugElement instanceof IStackFrame) {
            obj = new SourceNotFoundEditorInput((IStackFrame)debugElement);
        }
        return obj;
    }

    @Override
    public ISourceContainer getSourceContainer(IProject resource, ILaunchConfiguration launchConfig) {
        return new PHPCompositeSourceContainer(resource, launchConfig);
    }

    @Override
    public DBGpBreakpoint createDBGpBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint instanceof PHPLineBreakpoint) {
            return new DBGpLineBreakpoint((PHPLineBreakpoint)breakpoint);
        }
        if (breakpoint instanceof IPHPExceptionBreakpoint) {
            return new DBGpExceptionBreakpoint((IPHPExceptionBreakpoint)breakpoint);
        }
        return null;
    }

    @Override
    public IBreakpoint findBreakpointHit(String sourceFileLocation, int lineno, String exception) {
        IPHPExceptionBreakpoint bpFound = null;
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getBreakpointModelID());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (this.supportsBreakpoint(breakpoint)) {
                IPHPExceptionBreakpoint exBreakpoint;
                if (breakpoint instanceof PHPLineBreakpoint && exception.isEmpty()) {
                    PHPLineBreakpoint lineBreakpoint = (PHPLineBreakpoint)breakpoint;
                    Breakpoint zBP = lineBreakpoint.getRuntimeBreakpoint();
                    String bpFileLocation = zBP.getFileName();
                    int bLineNumber = zBP.getLineNumber();
                    try {
                        if (bLineNumber == lineno && FileUtils.isSameFile((String)bpFileLocation, (String)sourceFileLocation)) {
                            bpFound = breakpoint;
                            if (DBGpLogger.debugBP()) {
                                DBGpLogger.debug("breakpoint at " + sourceFileLocation + "(" + lineno + ") found");
                            }
                        }
                    }
                    catch (Exception exception2) {}
                    if (breakpoint instanceof PHPRunToLineBreakpoint) {
                        IBreakpointManager bmgr = DebugPlugin.getDefault().getBreakpointManager();
                        try {
                            if (DBGpLogger.debugBP()) {
                                DBGpLogger.debug("removing runtoline breakpoint");
                            }
                            bmgr.removeBreakpoint(breakpoint, true);
                        }
                        catch (CoreException e) {
                            DBGpLogger.logException("Exception trying to remove a runtoline breakpoint", this, e);
                        }
                    }
                } else if (breakpoint instanceof IPHPExceptionBreakpoint && (exBreakpoint = (IPHPExceptionBreakpoint)breakpoint).getExceptionName().equals(exception)) {
                    bpFound = exBreakpoint;
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("exception breakpoint at " + sourceFileLocation + "(" + lineno + ") found");
                    }
                }
            }
            ++i;
        }
        return bpFound;
    }

    @Override
    public boolean supportsBreakpoint(IBreakpoint bp) {
        return bp.getModelIdentifier().equals(this.getBreakpointModelID());
    }

    @Override
    public IBreakpoint createRunToLineBreakpoint(IFile fileName, int lineNumber) throws DebugException {
        return new PHPRunToLineBreakpoint(fileName, lineNumber);
    }

    @Override
    public String getSystemDebugProperty() {
        return "org.eclipse.php.debug.ui.activeDebugging";
    }
}

