/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpBaseVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpBoolValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpContainerValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpNullValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpNumValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpResourceValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStringValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;

public class DBGpVariable
extends AbstractDBGpBaseVariable
implements IVariable {
    static final String PHP_BOOL = "bool";
    static final String PHP_INT = "int";
    static final String PHP_FLOAT = "float";
    static final String PHP_STRING = "string";
    static final String PHP_NULL = "null";
    static final String PHP_ARRAY = "array";
    static final String PHP_OBJECT = "object";
    static final String PHP_RESOURCE = "resource";
    private DBGpValue value;
    private String name;
    private String type;
    private boolean hasChanged = false;

    public DBGpVariable(DBGpTarget target, Node property, String level, IVariableFacet.Facet ... facets) {
        super((IDebugTarget)target, level, facets);
        this.parseProperty(property);
        this.hasChanged = target.storeValue(this.value, property);
    }

    private void parseProperty(Node property) {
        this.name = DBGpResponse.getAttribute(property, "name");
        this.setFullName(DBGpResponse.getAttribute(property, "fullname"));
        this.setAddress(DBGpResponse.getAttribute(property, "address"));
        this.type = DBGpResponse.getAttribute(property, "type");
        if (this.type.equals(PHP_BOOL)) {
            this.value = new DBGpBoolValue(this, property);
        } else if (this.type.equals(PHP_INT)) {
            this.value = new DBGpNumValue(this, property, PHP_INT);
        } else if (this.type.equals(PHP_FLOAT)) {
            this.value = new DBGpNumValue(this, property, PHP_FLOAT);
        } else if (this.type.equals(PHP_STRING)) {
            String size = DBGpResponse.getAttribute(property, "size");
            int strByteLen = -1;
            try {
                strByteLen = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {}
            this.value = new DBGpStringValue(this, property, strByteLen);
        } else if (this.type.equals(PHP_RESOURCE)) {
            this.value = new DBGpResourceValue(this, property);
        } else if (this.type.equals(PHP_NULL)) {
            this.value = new DBGpNullValue(this, property);
        } else if (this.type.equals(PHP_ARRAY) || this.type.equals(PHP_OBJECT)) {
            this.value = new DBGpContainerValue(this, property);
        }
        String facets = DBGpResponse.getAttribute(property, "facet");
        if (facets.contains("static")) {
            this.addFacets(IVariableFacet.Facet.MOD_STATIC);
        }
        if (facets.contains("public")) {
            this.addFacets(IVariableFacet.Facet.MOD_PUBLIC);
        } else if (facets.contains("protected")) {
            this.addFacets(IVariableFacet.Facet.MOD_PROTECTED);
        } else if (facets.contains("private")) {
            this.addFacets(IVariableFacet.Facet.MOD_PRIVATE);
        }
        if (this.getFullName().length() > 1 && this.name.equals(this.getFullName().substring(1))) {
            this.name = this.getFullName();
        }
        if (this.hasFacet(IVariableFacet.Facet.KIND_ARRAY_MEMBER)) {
            this.name = String.valueOf('[') + this.name + ']';
        } else if (this.hasFacet(IVariableFacet.Facet.MOD_STATIC) && this.name.startsWith(":")) {
            this.name = this.name.substring(this.name.lastIndexOf(58) + 1);
        } else if (this.name.equals("::")) {
            this.name = "<class>";
        }
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.getName().equals("<class>")) {
            return "class";
        }
        return this.type;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    @Override
    public boolean hasValueChanged() throws DebugException {
        return this.hasChanged;
    }

    @Override
    public void setValue(String expression) throws DebugException {
        if (!this.verifyValue(expression)) {
            Status stat = new Status(2, "org.eclipse.php.debug.core", PHPDebugCoreMessages.XDebug_DBGpVariable_0);
            throw new DebugException((IStatus)stat);
        }
        if (!((DBGpTarget)this.getDebugTarget()).setProperty(this, expression)) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.php.debug.core", 5010, PHPDebugCoreMessages.XDebug_DBGpVariable_1, null));
        }
        this.value.setValue(expression);
        this.fireChangeEvent(512);
    }

    @Override
    public void setValue(IValue xvalue) throws DebugException {
        this.setValue(xvalue.getValueString());
    }

    @Override
    public boolean supportsValueModification() {
        return this.value.isModifiable() && this.getFullName() != null && this.getFullName().trim().length() != 0;
    }

    @Override
    public boolean verifyValue(String expression) throws DebugException {
        return this.value.verifyValue(expression);
    }

    @Override
    public boolean verifyValue(IValue xvalue) throws DebugException {
        return this.verifyValue(xvalue.getValueString());
    }

    public void replaceValue(IValue value) {
        if (value instanceof DBGpValue) {
            this.value = (DBGpValue)value;
            this.fireChangeEvent(512);
        }
    }
}

