/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.AbstractDebuggerConfigurationDialog;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.zend.communication.BroadcastDaemon;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerConfiguration;
import org.eclipse.php.internal.debug.daemon.communication.DaemonsRegistry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class ZendDebuggerConfigurationDialog
extends AbstractDebuggerConfigurationDialog {
    protected Button fRunWithDebugInfo;
    protected Text fDebugTextBox;
    protected Text fClientIP;
    protected Text fDebugResponseTimeout;
    protected Button fUseNewProtocol;
    protected ZendDebuggerConfiguration zendDebuggerConfiguration;
    protected Text fBroadcastPortText;
    protected Text fDummyFileText;
    private Button autoModeButton;
    private Button manualModeButton;
    private Image titleImage;

    public ZendDebuggerConfigurationDialog(ZendDebuggerConfiguration zendDebuggerConfiguration, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.zendDebuggerConfiguration = zendDebuggerConfiguration;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = (Composite)super.createDialogArea(parent);
        GridData ptGridData = (GridData)parent.getLayoutData();
        ptGridData.widthHint = this.convertWidthInCharsToPixels(120);
        this.getShell().setText(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Dialog_title);
        this.setTitle(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_zendDebuggerSettings);
        this.setMessage(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Dialog_description);
        this.titleImage = this.getDialogImage();
        if (this.titleImage != null) {
            this.setTitleImage(this.titleImage);
        }
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ZendDebuggerConfigurationDialog.this.titleImage != null) {
                    ZendDebuggerConfigurationDialog.this.titleImage.dispose();
                }
            }
        });
        Composite connectionSettingsGroup = this.createSubsection(parent, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Connection_settings_group);
        this.addLabelControl(connectionSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_client_host_ip, PHPDebugCorePreferenceNames.CLIENT_IP);
        this.autoModeButton = new Button(connectionSettingsGroup, 16);
        this.autoModeButton.setText(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_AutoMode);
        this.autoModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ZendDebuggerConfigurationDialog.this.autoModeButton.getSelection()) {
                    String value = DefaultScope.INSTANCE.getNode("org.eclipse.php.debug.core").get(PHPDebugCorePreferenceNames.CLIENT_IP, "127.0.0.1");
                    ZendDebuggerConfigurationDialog.this.fClientIP.setText(value);
                }
            }
        });
        this.manualModeButton = new Button(connectionSettingsGroup, 16);
        this.manualModeButton.setText(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_ManualMode);
        this.manualModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZendDebuggerConfigurationDialog.this.fClientIP.setEnabled(ZendDebuggerConfigurationDialog.this.manualModeButton.getSelection());
            }
        });
        new Label(connectionSettingsGroup, 0);
        this.fClientIP = this.addTextField(connectionSettingsGroup, PHPDebugCorePreferenceNames.CLIENT_IP, 0, 2);
        GridData gridData = (GridData)this.fClientIP.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        this.addLabelControl(connectionSettingsGroup, PHPDebugCoreMessages.DebuggerConfigurationDialog_debugPort, PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT);
        this.fDebugTextBox = this.addTextField(connectionSettingsGroup, PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, 6, 2);
        gridData = (GridData)this.fDebugTextBox.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        this.fDebugTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZendDebuggerConfigurationDialog.this.validate();
            }
        });
        this.addLabelControl(connectionSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_debug_response_timeout, PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT);
        this.fDebugResponseTimeout = this.addTextField(connectionSettingsGroup, PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, 0, 2);
        gridData = (GridData)this.fDebugResponseTimeout.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        this.fDebugResponseTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZendDebuggerConfigurationDialog.this.validate();
            }
        });
        this.createNoteComposite(connectionSettingsGroup.getFont(), connectionSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Note_label, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Note_text, 3);
        Composite generalSettingsGroup = this.createSubsection(parent, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_General_settings_group);
        this.addLabelControl(generalSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Broadcast_port, PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT);
        this.fBroadcastPortText = this.addTextField(generalSettingsGroup, PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, 6, 2);
        gridData = (GridData)this.fBroadcastPortText.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(100);
        this.fBroadcastPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ZendDebuggerConfigurationDialog.this.validate();
            }
        });
        this.addLabelControl(generalSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Dummy_file_name, PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE);
        this.fDummyFileText = this.addTextField(generalSettingsGroup, PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, 20, 2);
        this.fRunWithDebugInfo = this.addCheckBox(generalSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_runWithDebugInfo, PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, 0);
        this.fUseNewProtocol = this.addCheckBox(generalSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_useNewProtocol, PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, 0);
        this.internalInitializeValues();
        return parent;
    }

    private Image getDialogImage() {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.php.debug.ui");
        URL url = null;
        if (bundle != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path("$nl$/icon/full/wizban/zend_debugger_conf_wiz.png"), null);
            desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        return null;
    }

    private void internalInitializeValues() {
        IPreferencesService service = Platform.getPreferencesService();
        this.fRunWithDebugInfo.setSelection(service.getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, false, null));
        this.fDebugTextBox.setText(Integer.toString(service.getInt("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, 0, null)));
        IEclipsePreferences instanceScope = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core");
        String customClientHosts = instanceScope.get(PHPDebugCorePreferenceNames.CLIENT_IP, null);
        this.autoModeButton.setSelection(customClientHosts == null);
        this.manualModeButton.setSelection(customClientHosts != null);
        this.fClientIP.setEnabled(customClientHosts != null);
        this.fClientIP.setText(PHPDebugPlugin.getDebugHosts());
        this.fDebugResponseTimeout.setText(Integer.toString(service.getInt("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, 0, null)));
        this.fUseNewProtocol.setSelection(service.getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, false, null));
        this.fBroadcastPortText.setText(Integer.toString(service.getInt("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, 0, null)));
        this.fDummyFileText.setText(service.getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, null, null));
    }

    protected void okPressed() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core");
        prefs.putBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, this.fRunWithDebugInfo.getSelection());
        prefs.put(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, this.fDebugTextBox.getText());
        prefs.putInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, Integer.parseInt(this.fBroadcastPortText.getText()));
        prefs.put(PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, this.fDummyFileText.getText().trim());
        if (this.autoModeButton.getSelection()) {
            prefs.remove(PHPDebugCorePreferenceNames.CLIENT_IP);
        } else {
            prefs.put(PHPDebugCorePreferenceNames.CLIENT_IP, this.fClientIP.getText());
        }
        prefs.putInt(PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, Integer.parseInt(this.fDebugResponseTimeout.getText()));
        prefs.putBoolean(PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, this.fUseNewProtocol.getSelection());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
        super.okPressed();
    }

    protected void validate() {
        this.setMessage(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Dialog_description);
        String debugPort = this.fDebugTextBox.getText();
        Integer debugPortNumber = null;
        try {
            debugPortNumber = Integer.valueOf(debugPort);
            int i = debugPortNumber;
            if (i < 1 || i > 65535) {
                this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPortRange, 3);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        catch (Exception exception) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        String broadcastPort = this.fBroadcastPortText.getText();
        Integer broadcastPortNumber = null;
        try {
            broadcastPortNumber = Integer.valueOf(broadcastPort);
            int i = broadcastPortNumber;
            if (i < 1 || i > 65535) {
                this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPortRange, 3);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        catch (Exception exception) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        String responseTime = this.fDebugResponseTimeout.getText();
        Integer responseTimeout = null;
        try {
            responseTimeout = Integer.valueOf(responseTime);
            int i = responseTimeout;
            if (i < 5000) {
                this.setMessage(NLS.bind((String)PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_invalid_response_time, (Object)5000), 3);
                return;
            }
        }
        catch (Exception exception) {
            this.setMessage(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_invalid_response_time_exc, 3);
            return;
        }
        if (!PHPLaunchUtilities.isPortAvailable(debugPortNumber) && !PHPLaunchUtilities.isDebugDaemonActive(debugPortNumber, "org.eclipse.php.debug.core.zendDebugger")) {
            this.setMessage(NLS.bind((String)PHPDebugCoreMessages.DebugConfigurationDialog_PortInUse, (Object)debugPort), 2);
        }
        if (!PHPLaunchUtilities.isPortAvailable(broadcastPortNumber)) {
            for (ICommunicationDaemon daemon : DaemonsRegistry.getDaemons()) {
                if (!(daemon instanceof BroadcastDaemon) || ((BroadcastDaemon)daemon).isListening(broadcastPortNumber)) continue;
                this.setMessage(NLS.bind((String)PHPDebugCoreMessages.DebugConfigurationDialog_PortInUse, (Object)broadcastPort), 2);
            }
        }
    }
}

