/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.php.formatter.core.EmbeddedCSSFormatterForPhpCode;
import org.eclipse.php.formatter.core.HTMLElementFormatterForPhpCode;
import org.eclipse.php.formatter.core.HTMLTextFormatterForPhpCode;
import org.eclipse.wst.html.core.internal.format.HTMLFormatter;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;
import org.w3c.dom.Node;

class HTMLFormatterFactoryForPhpCode {
    private static HTMLFormatterFactoryForPhpCode fInstance = null;
    protected StructuredFormatPreferencesXML fFormatPreferences = null;

    static synchronized HTMLFormatterFactoryForPhpCode getInstance() {
        if (fInstance == null) {
            fInstance = new HTMLFormatterFactoryForPhpCode();
        }
        return fInstance;
    }

    protected IStructuredFormatter createFormatter(Node node, IStructuredFormatPreferences formatPreferences) {
        Object formatter = null;
        switch (node.getNodeType()) {
            case 1: {
                formatter = new HTMLElementFormatterForPhpCode();
                break;
            }
            case 3: {
                if (this.isEmbeddedCSS(node)) {
                    formatter = new EmbeddedCSSFormatterForPhpCode();
                    break;
                }
                formatter = new HTMLTextFormatterForPhpCode();
                break;
            }
            default: {
                formatter = new HTMLFormatter();
            }
        }
        formatter.setFormatPreferences(formatPreferences);
        return formatter;
    }

    private boolean isEmbeddedCSS(Node node) {
        if (node == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent.getNodeType() != 1) {
            return false;
        }
        String name = parent.getNodeName();
        if (name == null) {
            return false;
        }
        return name.equalsIgnoreCase("STYLE");
    }

    private HTMLFormatterFactoryForPhpCode() {
    }

    protected StructuredFormatPreferencesXML getFormatPreferences() {
        if (this.fFormatPreferences == null) {
            this.fFormatPreferences = new StructuredFormatPreferencesXML();
            IPreferencesService service = Platform.getPreferencesService();
            this.fFormatPreferences.setLineWidth(service.getInt("org.eclipse.wst.html.core", "lineWidth", 0, null));
            this.fFormatPreferences.setSplitMultiAttrs(service.getBoolean("org.eclipse.wst.html.core", "splitMultiAttrs", false, null));
            this.fFormatPreferences.setAlignEndBracket(service.getBoolean("org.eclipse.wst.html.core", "alignEndBracket", false, null));
            this.fFormatPreferences.setClearAllBlankLines(service.getBoolean("org.eclipse.wst.html.core", "clearAllBlankLines", false, null));
            char indentChar = ' ';
            String indentCharPref = service.getString("org.eclipse.wst.html.core", "indentationChar", null, null);
            if ("tab".equals(indentCharPref)) {
                indentChar = '\t';
            }
            int indentationWidth = service.getInt("org.eclipse.wst.html.core", "indentationSize", 0, null);
            StringBuffer indent = new StringBuffer();
            int i = 0;
            while (i < indentationWidth) {
                indent.append(indentChar);
                ++i;
            }
            this.fFormatPreferences.setIndent(indent.toString());
        }
        return this.fFormatPreferences;
    }
}

