/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.php.formatter.core.CodeFormatterPreferences;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.preferences.CodeFormatterPreview;
import org.eclipse.php.formatter.ui.preferences.ModifyDialog;
import org.eclipse.php.formatter.ui.preferences.ModifyDialogTabPage;
import org.eclipse.php.formatter.ui.preferences.PhpPreview;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class IndentationTabPage
extends ModifyDialogTabPage {
    private final String PREVIEW = "<?php\n" + IndentationTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header) + "class Example {" + "  var $theInt= 1;" + "  function foo($a, $b) {" + "    switch($a) {" + "    case 0: " + "      $Other->doFoo();" + "      break;" + "    default:" + "      $Other->doBaz();" + "    }" + "  }" + "  function bar($v) {" + "    for ($i= 0; $i < 10; $i++) {" + "      $v->add($i);" + "    }" + "  }" + "} \n?>";
    private CodeFormatterPreview fPreview;
    private ModifyDialogTabPage.ComboPreference tabPolicy;
    private ModifyDialogTabPage.NumberPreference indentSize;
    private ModifyDialogTabPage.NumberPreference tabSize;
    private ModifyDialogTabPage.NumberPreference fDefaultIndentArrayInit;
    private ModifyDialogTabPage.CheckboxPreference classIndent;
    private ModifyDialogTabPage.CheckboxPreference methodIndent;
    private ModifyDialogTabPage.CheckboxPreference blockIndent;
    private ModifyDialogTabPage.CheckboxPreference switchIndent;
    private ModifyDialogTabPage.CheckboxPreference caseIndent;
    private ModifyDialogTabPage.CheckboxPreference breakIndent;
    private ModifyDialogTabPage.CheckboxPreference emptylineIndent;
    private boolean isInitialized = false;

    public IndentationTabPage(ModifyDialog modifyDialog, CodeFormatterPreferences preferences) {
        super(modifyDialog, preferences);
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB};
        this.tabPolicy = this.createComboPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, tabPolicyLabels);
        this.indentSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_indent_size, 0, 32);
        this.indentSize.setValue(this.codeFormatterPreferences.indentationSize);
        this.tabSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_size, 0, 32);
        this.tabSize.setValue(this.codeFormatterPreferences.tabSize);
        this.fDefaultIndentArrayInit = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_array, 0, 9999);
        this.fDefaultIndentArrayInit.setValue(this.codeFormatterPreferences.line_wrap_array_init_indentation);
        char indentChar = this.codeFormatterPreferences.indentationChar;
        if (indentChar == ' ') {
            this.indentSize.getControl().setEnabled(true);
            this.tabPolicy.setSelectedItem(tabPolicyLabels[0]);
        } else {
            this.indentSize.getControl().setEnabled(false);
            this.tabPolicy.setSelectedItem(tabPolicyLabels[1]);
        }
        this.tabPolicy.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                int indentChar;
                int index = IndentationTabPage.this.tabPolicy.getSelectionIndex();
                int n = indentChar = index == 0 ? 32 : 9;
                if (indentChar == 32 && !IndentationTabPage.this.indentSize.getControl().isEnabled()) {
                    IndentationTabPage.this.indentSize.getControl().setEnabled(true);
                } else if (indentChar == 9 && IndentationTabPage.this.indentSize.getControl().isEnabled()) {
                    IndentationTabPage.this.indentSize.getControl().setEnabled(false);
                    IndentationTabPage.this.indentSize.setValue(1);
                }
                IndentationTabPage.this.updatePreferences();
                IndentationTabPage.this.doUpdatePreview();
                IndentationTabPage.this.notifyValuesModified();
            }
        });
        Group classGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.classIndent = this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_within_class_body);
        this.classIndent.setIsChecked(this.codeFormatterPreferences.indent_statements_within_type_declaration);
        this.methodIndent = this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_body);
        this.methodIndent.setIsChecked(this.codeFormatterPreferences.indent_statements_within_function);
        this.blockIndent = this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_block);
        this.blockIndent.setIsChecked(this.codeFormatterPreferences.indent_statements_within_block);
        this.switchIndent = this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_switch_body);
        this.switchIndent.setIsChecked(this.codeFormatterPreferences.indent_statements_within_switch);
        this.caseIndent = this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_case_body);
        this.caseIndent.setIsChecked(this.codeFormatterPreferences.indent_statements_within_case);
        this.breakIndent = this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_break_statements);
        this.breakIndent.setIsChecked(this.codeFormatterPreferences.indent_break_statements_within_case);
        this.emptylineIndent = this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_indent_empty_lines);
        this.emptylineIndent.setIsChecked(this.codeFormatterPreferences.indent_empty_lines);
        this.isInitialized = true;
    }

    @Override
    public void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    @Override
    protected PhpPreview doCreatePhpPreview(Composite parent) {
        this.fPreview = new CodeFormatterPreview(this.codeFormatterPreferences, parent);
        return this.fPreview;
    }

    @Override
    protected void doUpdatePreview() {
        if (this.fPreview != null) {
            this.fPreview.update();
        }
    }

    @Override
    protected void updatePreferences() {
        if (this.isInitialized) {
            int index = this.tabPolicy.getSelectionIndex();
            this.codeFormatterPreferences.indentationChar = (char)(index == 0 ? 32 : 9);
            this.codeFormatterPreferences.indentationSize = this.indentSize.getValue();
            this.codeFormatterPreferences.tabSize = this.tabSize.getValue();
            this.codeFormatterPreferences.line_wrap_array_init_indentation = this.fDefaultIndentArrayInit.getValue();
            this.codeFormatterPreferences.indent_statements_within_type_declaration = this.classIndent.isChecked();
            this.codeFormatterPreferences.indent_statements_within_function = this.methodIndent.isChecked();
            this.codeFormatterPreferences.indent_statements_within_block = this.blockIndent.isChecked();
            this.codeFormatterPreferences.indent_statements_within_switch = this.switchIndent.isChecked();
            this.codeFormatterPreferences.indent_statements_within_case = this.caseIndent.isChecked();
            this.codeFormatterPreferences.indent_break_statements_within_case = this.breakIndent.isChecked();
            this.codeFormatterPreferences.indent_empty_lines = this.emptylineIndent.isChecked();
        }
    }
}

