/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPFormatterConfigurationBlock
extends PHPCoreOptionsConfigurationBlock
implements ModifyListener,
SelectionListener {
    public static final Key PREF_FORMATTER_USE_TABS = PHPFormatterConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.phpForamtterUseTabs");
    public static final Key PREF_FORMATTER_INDENTATION_SIZE = PHPFormatterConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.phpForamtterIndentationSize");
    public static final Key PREF_FORMATTER_TAB_SIZE = PHPFormatterConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.phpForamtterTabSize");
    public static final Key PREF_FORMATTER_INDENTATION_WRAPPED_LINE_SIZE = PHPFormatterConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.phpForamtterIndentationWrappedLineSize");
    public static final Key PREF_FORMATTER_INDENTATION_ARRAY_INIT_SIZE = PHPFormatterConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.phpForamtterArrayInitSize");
    private static final int MIN_INDENT_SIZE = 0;
    private static final int MAX_INDENT_SIZE = 32;
    private IStatus fFormatterStatus = new StatusInfo();
    private Combo tabPolicyCombo;
    private Text indentSizeTxt;
    private Text tabSizeTxt;
    private Text fDefaultIndentWrapLineSizeTxt;
    private Text fDefaultIndentArrayInitSizeTxt;
    private boolean fUseTabs;
    private int fIndentationSize;
    private int fTabSize;
    private int fIndentationWrappedLineSize;
    private int fIndentationArrayInitSize;

    public PHPFormatterConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, PHPFormatterConfigurationBlock.getKeys(), container);
    }

    @Override
    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite markersComposite = this.createFormaterContent(parent);
        this.validateSettings(null, null, null);
        return markersComposite;
    }

    private Composite createFormaterContent(Composite parent) {
        Group formattingComposite = this.createComposite(parent, 2);
        String[] tabPolicyLabels = new String[]{PHPUIMessages.PHPFormatterConfigurationBlock_tabsLabel, PHPUIMessages.PHPFormatterConfigurationBlock_spacesLabel};
        Label indentTabsLabel = new Label((Composite)formattingComposite, 0);
        indentTabsLabel.setText(PHPUIMessages.PHPFormatterConfigurationBlock_tabPolicyLabel);
        this.tabPolicyCombo = new Combo((Composite)formattingComposite, 8);
        this.tabPolicyCombo.setItems(tabPolicyLabels);
        this.tabPolicyCombo.select(0);
        GridData gd = new GridData();
        gd.widthHint = 20;
        Label indentSizeLabel = new Label((Composite)formattingComposite, 0);
        indentSizeLabel.setText(PHPUIMessages.PHPFormatterConfigurationBlock_indentSizeLabel);
        this.indentSizeTxt = new Text((Composite)formattingComposite, 2048);
        this.indentSizeTxt.setTextLimit(2);
        this.indentSizeTxt.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 20;
        Label tabSizeLabel = new Label((Composite)formattingComposite, 0);
        tabSizeLabel.setText(PHPUIMessages.PHPFormatterConfigurationBlock_tabSizeLabel);
        this.tabSizeTxt = new Text((Composite)formattingComposite, 2048);
        this.tabSizeTxt.setTextLimit(2);
        this.tabSizeTxt.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 20;
        Label indentWrapLineSize = new Label((Composite)formattingComposite, 0);
        indentWrapLineSize.setText(PHPUIMessages.PHPFormatterConfigurationBlock_indentWrapLineSizeLabel);
        this.fDefaultIndentWrapLineSizeTxt = new Text((Composite)formattingComposite, 2048);
        this.fDefaultIndentWrapLineSizeTxt.setTextLimit(2);
        this.fDefaultIndentWrapLineSizeTxt.setLayoutData((Object)gd);
        Label indentArrayInitSize = new Label((Composite)formattingComposite, 0);
        indentArrayInitSize.setText(PHPUIMessages.PHPFormatterConfigurationBlock_indentArrayInitSizeLabel);
        this.fDefaultIndentArrayInitSizeTxt = new Text((Composite)formattingComposite, 2048);
        this.fDefaultIndentArrayInitSizeTxt.setTextLimit(2);
        this.fDefaultIndentArrayInitSizeTxt.setLayoutData((Object)gd);
        this.tabPolicyCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo source = (Combo)e.getSource();
                int selectIndex = source.getSelectionIndex();
                if (selectIndex == 1) {
                    PHPFormatterConfigurationBlock.this.indentSizeTxt.setEnabled(true);
                } else {
                    PHPFormatterConfigurationBlock.this.indentSizeTxt.setEnabled(false);
                    PHPFormatterConfigurationBlock.this.indentSizeTxt.setText("1");
                }
            }
        });
        this.indentSizeTxt.addModifyListener((ModifyListener)this);
        this.tabSizeTxt.addModifyListener((ModifyListener)this);
        this.fDefaultIndentWrapLineSizeTxt.addModifyListener((ModifyListener)this);
        this.fDefaultIndentArrayInitSizeTxt.addModifyListener((ModifyListener)this);
        this.tabPolicyCombo.addSelectionListener((SelectionListener)this);
        this.initValues();
        this.updateValues();
        return formattingComposite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
        block20: {
            if (changedKey != null) {
                if (PREF_FORMATTER_INDENTATION_SIZE.equals(changedKey)) {
                    try {
                        this.fIndentationSize = Integer.valueOf(newValue);
                        if (this.fIndentationSize < 0 || this.fIndentationSize > 32) {
                            this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.PHPFormatterConfigurationBlock_indentSizeErrorMessage);
                        } else {
                            this.setValue(PREF_FORMATTER_INDENTATION_SIZE, String.valueOf(this.fIndentationSize));
                            this.fFormatterStatus = new StatusInfo();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.PHPFormatterConfigurationBlock_indentSizeErrorMessage);
                    }
                }
                if (PREF_FORMATTER_TAB_SIZE.equals(changedKey)) {
                    try {
                        this.fTabSize = Integer.valueOf(newValue);
                        if (this.fTabSize < 0 || this.fTabSize > 32) {
                            this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.PHPFormatterConfigurationBlock_tabSizeErrorMessage);
                        } else {
                            this.setValue(PREF_FORMATTER_TAB_SIZE, String.valueOf(this.fTabSize));
                            this.fFormatterStatus = new StatusInfo();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.PHPFormatterConfigurationBlock_tabSizeErrorMessage);
                    }
                }
                if (PREF_FORMATTER_INDENTATION_WRAPPED_LINE_SIZE.equals(changedKey)) {
                    try {
                        this.fIndentationWrappedLineSize = Integer.valueOf(newValue);
                        if (this.fIndentationWrappedLineSize < 0 || this.fIndentationWrappedLineSize > 32) {
                            this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.PHPFormatterConfigurationBlock_indentSizeErrorMessage);
                        } else {
                            this.setValue(PREF_FORMATTER_INDENTATION_WRAPPED_LINE_SIZE, String.valueOf(this.fIndentationWrappedLineSize));
                            this.fFormatterStatus = new StatusInfo();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.PHPFormatterConfigurationBlock_indentSizeErrorMessage);
                    }
                }
                if (!PREF_FORMATTER_INDENTATION_ARRAY_INIT_SIZE.equals(changedKey)) return;
                try {
                    this.fIndentationArrayInitSize = Integer.valueOf(newValue);
                    if (this.fIndentationArrayInitSize < 0 || this.fIndentationArrayInitSize > 32) {
                        this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.PHPFormatterConfigurationBlock_indentSizeErrorMessage);
                        break block20;
                    }
                    this.setValue(PREF_FORMATTER_INDENTATION_ARRAY_INIT_SIZE, String.valueOf(this.fIndentationArrayInitSize));
                    this.fFormatterStatus = new StatusInfo();
                }
                catch (NumberFormatException numberFormatException) {
                    this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.PHPFormatterConfigurationBlock_indentSizeErrorMessage);
                }
            } else {
                this.fFormatterStatus = new StatusInfo();
            }
        }
        this.fContext.statusChanged(this.fFormatterStatus);
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    private static Key[] getKeys() {
        return new Key[]{PREF_FORMATTER_USE_TABS, PREF_FORMATTER_INDENTATION_SIZE, PREF_FORMATTER_INDENTATION_WRAPPED_LINE_SIZE, PREF_FORMATTER_INDENTATION_ARRAY_INIT_SIZE};
    }

    private Group createComposite(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        group.setText(PHPUIMessages.PHPFormatterConfigurationBlock_0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginTop = 5;
        layout.marginBottom = 5;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 128, true, false);
        group.setLayoutData((Object)data);
        group.setLayoutData((Object)data);
        return group;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget != null && e.widget.isDisposed()) {
            return;
        }
        this.validateValues(e.widget);
    }

    protected void validateValues(Widget w) {
        Text c = (Text)w;
        String textFieldStr = c.getText();
        if (c == this.indentSizeTxt) {
            this.validateSettings(PREF_FORMATTER_INDENTATION_SIZE, Integer.valueOf(this.fIndentationSize).toString(), textFieldStr);
        } else if (c == this.tabSizeTxt) {
            this.validateSettings(PREF_FORMATTER_TAB_SIZE, Integer.valueOf(this.fTabSize).toString(), textFieldStr);
        } else if (c == this.fDefaultIndentWrapLineSizeTxt) {
            this.validateSettings(PREF_FORMATTER_INDENTATION_WRAPPED_LINE_SIZE, Integer.valueOf(this.fIndentationWrappedLineSize).toString(), textFieldStr);
        } else if (c == this.fDefaultIndentArrayInitSizeTxt) {
            this.validateSettings(PREF_FORMATTER_INDENTATION_ARRAY_INIT_SIZE, Integer.valueOf(this.fIndentationArrayInitSize).toString(), textFieldStr);
        }
    }

    @Override
    protected void updateControls() {
        this.initValues();
        this.updateValues();
    }

    private void initValues() {
        String useTabs = this.getValue(PREF_FORMATTER_USE_TABS);
        String indentationSize = this.getValue(PREF_FORMATTER_INDENTATION_SIZE);
        String tabSize = this.getValue(PREF_FORMATTER_TAB_SIZE);
        String indentationWrappedLineSize = this.getValue(PREF_FORMATTER_INDENTATION_WRAPPED_LINE_SIZE);
        String indentationArrayInitSize = this.getValue(PREF_FORMATTER_INDENTATION_ARRAY_INIT_SIZE);
        this.fUseTabs = Boolean.valueOf(useTabs);
        this.fIndentationSize = Integer.valueOf(indentationSize);
        this.indentSizeTxt.setText(indentationSize);
        this.fTabSize = Integer.valueOf(tabSize);
        this.tabSizeTxt.setText(tabSize);
        this.fIndentationWrappedLineSize = Integer.valueOf(indentationWrappedLineSize);
        this.fDefaultIndentWrapLineSizeTxt.setText(indentationWrappedLineSize);
        this.fIndentationArrayInitSize = Integer.valueOf(indentationArrayInitSize);
        this.fDefaultIndentArrayInitSizeTxt.setText(indentationArrayInitSize);
    }

    private void updateValues() {
        if (this.fUseTabs) {
            this.tabPolicyCombo.select(0);
            this.indentSizeTxt.setEnabled(false);
        } else {
            this.tabPolicyCombo.select(1);
            this.indentSizeTxt.setEnabled(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateButtonStatus((Combo)e.widget);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateButtonStatus((Combo)e.widget);
    }

    private void updateButtonStatus(Combo b) {
        this.fUseTabs = b.getSelectionIndex() == 0;
        this.setValue(PREF_FORMATTER_USE_TABS, this.fUseTabs ? "true" : "false");
    }
}

