/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.quickassist;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.ui.dialogs.OpenTypeSelectionDialog2;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.PHPUILanguageToolkit;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.quickassist.Messages;
import org.eclipse.php.internal.ui.text.correction.IInvocationContext;
import org.eclipse.php.internal.ui.text.correction.IProblemLocation;
import org.eclipse.php.internal.ui.text.correction.IQuickAssistProcessor;
import org.eclipse.php.internal.ui.text.correction.proposals.AbstractCorrectionProposal;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class VarCommentQuickAssistProcessor
implements IQuickAssistProcessor {
    private static ASTNode getVariableNode(ASTNode selectedNode) {
        ASTNode variableNode = null;
        int state = 1;
        while (selectedNode != null && state != 4) {
            switch (selectedNode.getType()) {
                case 60: {
                    if (((Variable)selectedNode).isDollared()) {
                        state = 4;
                        variableNode = selectedNode;
                        break;
                    }
                    if (3 == state) {
                        state = 4;
                        break;
                    }
                    state = 2;
                    selectedNode = selectedNode.getParent();
                    break;
                }
                case 23: {
                    if (3 == state) {
                        state = 4;
                        break;
                    }
                    selectedNode = NodeFinder.perform((ASTNode)selectedNode, (int)selectedNode.getStart(), (int)0);
                    state = 3;
                    break;
                }
                case 24: 
                case 30: 
                case 31: 
                case 33: 
                case 43: {
                    if (3 == state) {
                        state = 4;
                        break;
                    }
                    state = 2;
                    selectedNode = selectedNode.getParent();
                    break;
                }
                default: {
                    state = 4;
                }
            }
        }
        return variableNode;
    }

    @Override
    public IScriptCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode variableNode = VarCommentQuickAssistProcessor.getVariableNode(context.getCoveringNode());
        if (variableNode != null) {
            return new IScriptCompletionProposal[]{new VarCommentCorrectionProposal(variableNode, context.getCompilationUnit())};
        }
        return null;
    }

    @Override
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        return VarCommentQuickAssistProcessor.getVariableNode(context.getCoveringNode()) != null;
    }

    private static class VarCommentCorrectionProposal
    extends AbstractCorrectionProposal {
        private static final String COMMAND_ID = "org.eclipse.php.ui.insertVarComment";
        private static final Pattern noneSpacePattern = Pattern.compile("\\S+");
        private ASTNode variableNode;
        private ISourceModule sourceModule;

        public VarCommentCorrectionProposal(ASTNode variableNode, ISourceModule sourceModule) {
            super(Messages.VarCommentQuickAssistProcessor_name, 0, DLTKPluginImages.get((String)"org.eclipse.dltk.ui.annotation_obj.png"), COMMAND_ID);
            this.variableNode = variableNode;
            this.sourceModule = sourceModule;
        }

        public void apply(IDocument document) {
            try {
                SelectionDialog dialog = this.createTypeDialog(document);
                int result = dialog.open();
                if (result != 0) {
                    return;
                }
                TextEdit textEdit = null;
                Object[] types = dialog.getResult();
                if (types != null && types.length == 1 && types[0] instanceof IModelElement) {
                    textEdit = this.createTextEditForType(document, (IModelElement)types[0]);
                }
                if (textEdit != null) {
                    textEdit.apply(document);
                }
            }
            catch (ModelException | BadLocationException | MalformedTreeException e) {
                PHPUiPlugin.log(e);
            }
        }

        private TextEdit createTextEditForType(IDocument document, IModelElement selectedType) throws BadLocationException, ModelException {
            String typeName = selectedType.getElementName();
            IModelElement parent = selectedType.getParent();
            if (parent instanceof IMember && PHPFlags.isNamespace((int)((IMember)parent).getFlags())) {
                typeName = String.valueOf(parent.getElementName()) + '\\' + typeName;
            }
            if ((typeName = typeName.trim()).length() > 0) {
                typeName = String.valueOf('\\') + typeName;
            }
            int varOffset = this.variableNode.getStart();
            int varLength = this.variableNode.getLength();
            String varName = document.get(varOffset, varLength);
            int selectionStartLine = document.getLineOfOffset(varOffset);
            int selectionLineOffset = document.getLineOffset(selectionStartLine);
            IRegion selectionLineInfo = document.getLineInformation(selectionStartLine);
            int selectionLineLength = selectionLineInfo.getLength();
            String selectionLineText = document.get(selectionLineOffset, selectionLineLength);
            Matcher nonSpaceMatch = noneSpacePattern.matcher(selectionLineText);
            StringBuilder varTypeHint = new StringBuilder();
            if (nonSpaceMatch.find()) {
                varTypeHint.append(selectionLineText.substring(0, nonSpaceMatch.start()));
            }
            varTypeHint.append("/** @var ");
            varTypeHint.append(typeName);
            varTypeHint.append(" ");
            varTypeHint.append(varName);
            varTypeHint.append(" */");
            varTypeHint.append(TextUtilities.getDefaultLineDelimiter((IDocument)document));
            return new InsertEdit(selectionLineOffset, varTypeHint.toString());
        }

        private SelectionDialog createTypeDialog(IDocument document) throws BadLocationException {
            String varName = document.get(this.variableNode.getStart(), this.variableNode.getLength());
            IDLTKUILanguageToolkit languageToolkit = PHPUILanguageToolkit.getInstance();
            Shell parent = DLTKUIPlugin.getActiveWorkbenchShell();
            IDLTKSearchScope searchScope = SearchEngine.createSearchScope((IModelElement)this.sourceModule.getScriptProject());
            OpenTypeSelectionDialog2 dialog = new OpenTypeSelectionDialog2(parent, true, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), searchScope, 0, languageToolkit);
            dialog.setTitle(Messages.VarCommentQuickAssistProcessor_OpenTypeAction_dialogTitle);
            dialog.setMessage(NLS.bind((String)Messages.VarCommentQuickAssistProcessor_OpenTypeAction_dialogMessage, (Object)varName));
            dialog.setFilter("");
            return dialog;
        }

        public String getAdditionalProposalInfo() {
            return Messages.VarCommentQuickAssistProcessor_AdditionalProposalInfo;
        }
    }
}

