/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.astview.views;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.astview.ASTViewImages;
import org.eclipse.php.astview.ASTViewPlugin;
import org.eclipse.php.astview.EditorUtility;
import org.eclipse.php.astview.NodeFinder;
import org.eclipse.php.astview.TreeInfoCollector;
import org.eclipse.php.astview.views.ASTAttribute;
import org.eclipse.php.astview.views.ASTViewContentProvider;
import org.eclipse.php.astview.views.ASTViewLabelProvider;
import org.eclipse.php.astview.views.Binding;
import org.eclipse.php.astview.views.DynamicAttributeProperty;
import org.eclipse.php.astview.views.DynamicBindingProperty;
import org.eclipse.php.astview.views.ExceptionAttribute;
import org.eclipse.php.astview.views.NodeProperty;
import org.eclipse.php.astview.views.NonRelevantFilter;
import org.eclipse.php.astview.views.PhpElement;
import org.eclipse.php.astview.views.ProblemNode;
import org.eclipse.php.astview.views.TreeCopyAction;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ASTView
extends ViewPart
implements IShowInSource {
    private static final String SETTINGS_LINK_WITH_EDITOR = "link_with_editor";
    private static final String SETTINGS_INPUT_KIND = "input_kind";
    private static final String SETTINGS_NO_BINDINGS = "create_bindings";
    private static final String SETTINGS_NO_STATEMENTS_RECOVERY = "no_statements_recovery";
    private static final String SETTINGS_NO_BINDINGS_RECOVERY = "no_bindings_recovery";
    private static final String SETTINGS_SHOW_NON_RELEVANT = "show_non_relevant";
    public static final String LINK_WITH_EDITOR_COMMAND_ID = "org.eclipse.ui.navigate.linkWithEditor";
    private SashForm fSash;
    private TreeViewer fViewer;
    private ASTViewLabelProvider fASTLabelProvider;
    private TreeViewer fTray;
    private DrillDownAdapter fDrillDownAdapter;
    private Action fFocusAction;
    private Action fRefreshAction;
    private Action fCreateBindingsAction;
    private Action fStatementsRecoveryAction;
    private Action fBindingsRecoveryAction;
    private Action fFilterNonRelevantAction;
    private Action fFindDeclaringNodeAction;
    private Action fParseBindingFromKeyAction;
    private Action fParseBindingFromElementAction;
    private Action fCollapseAction;
    private Action fExpandAction;
    private Action fClearAction;
    private TreeCopyAction fCopyAction;
    private Action fDoubleClickAction;
    private Action fLinkWithEditor;
    private Action fDeleteAction;
    private PHPVersion fPHPVersion;
    private ASTInputKindAction[] fASTInputKindActions;
    private int fCurrentInputKind;
    private ITextEditor fEditor;
    private ISourceModule fSourceRoot;
    private Program fRoot;
    private IDocument fCurrentDocument;
    private ArrayList fTrayRoots;
    private boolean fDoLinkWithEditor;
    private boolean fCreateBindings;
    private NonRelevantFilter fNonRelevantFilter;
    private boolean fStatementsRecovery;
    private boolean fBindingsRecovery;
    private Object fPreviousDouble;
    private ListenerMix fSuperListener = null;
    private ISelectionChangedListener fTrayUpdater = null;
    private IDialogSettings fDialogSettings = ASTViewPlugin.getDefault().getDialogSettings();

    public ASTView() {
        this.fDoLinkWithEditor = this.fDialogSettings.getBoolean(SETTINGS_LINK_WITH_EDITOR);
        try {
            this.fCurrentInputKind = this.fDialogSettings.getInt(SETTINGS_INPUT_KIND);
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentInputKind = 1;
        }
        this.fCreateBindings = !this.fDialogSettings.getBoolean(SETTINGS_NO_BINDINGS);
        this.fStatementsRecovery = !this.fDialogSettings.getBoolean(SETTINGS_NO_STATEMENTS_RECOVERY);
        this.fBindingsRecovery = !this.fDialogSettings.getBoolean(SETTINGS_NO_BINDINGS_RECOVERY);
        this.fPHPVersion = PHPVersion.getLatestVersion();
        this.fNonRelevantFilter = new NonRelevantFilter();
        this.fNonRelevantFilter.setShowNonRelevant(this.fDialogSettings.getBoolean(SETTINGS_SHOW_NON_RELEVANT));
    }

    final void notifyWorkbenchPartClosed(IWorkbenchPartReference partRef) {
        if (this.fEditor != null && this.fEditor.equals(partRef.getPart(false))) {
            try {
                this.setInput(null);
            }
            catch (CoreException coreException) {}
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        if (this.fSuperListener == null) {
            this.fSuperListener = new ListenerMix(this);
            ISelectionService service = site.getWorkbenchWindow().getSelectionService();
            service.addPostSelectionListener((ISelectionListener)this.fSuperListener);
            site.getPage().addPartListener((IPartListener2)this.fSuperListener);
            FileBuffers.getTextFileBufferManager().addFileBufferListener((IFileBufferListener)this.fSuperListener);
        }
    }

    public PHPVersion getCurrentPHPVersion() {
        return this.fPHPVersion;
    }

    public int getCurrentInputKind() {
        return this.fCurrentInputKind;
    }

    public void setInput(ITextEditor editor) throws CoreException {
        if (this.fEditor != null) {
            this.uninstallModificationListener();
        }
        this.fEditor = null;
        this.fRoot = null;
        if (editor != null) {
            ISourceModule typeRoot = EditorUtility.getPhpInput((IEditorPart)editor);
            if (typeRoot == null) {
                throw new CoreException(this.getErrorStatus("Editor not showing a CU or class file", null));
            }
            this.fSourceRoot = typeRoot;
            PHPVersion astLevel = this.getInitialASTLevel(typeRoot);
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                this.fRoot = this.internalSetInput(typeRoot, textSelection.getOffset(), textSelection.getLength(), astLevel);
                this.fEditor = editor;
                this.setASTLevel(astLevel, false);
            }
            this.installModificationListener();
        }
    }

    private PHPVersion getInitialASTLevel(ISourceModule typeRoot) {
        return ProjectOptions.getPhpVersion((IProject)typeRoot.getScriptProject().getProject());
    }

    private Program internalSetInput(ISourceModule input, int offset, int length, PHPVersion phpVersion) throws CoreException {
        Program root;
        block9: {
            if (input.getBuffer() == null) {
                throw new CoreException(this.getErrorStatus("Input has no buffer", null));
            }
            root = this.createAST(input, phpVersion, offset);
            this.resetView(root);
            if (root != null) break block9;
            this.setContentDescription("AST could not be created.");
            return null;
        }
        try {
            ASTNode node = NodeFinder.perform((ASTNode)root, offset, length);
            if (node != null) {
                this.fViewer.getTree().setRedraw(false);
                try {
                    this.fASTLabelProvider.setSelectedRange(node.getStart(), node.getLength());
                    this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
                }
                finally {
                    this.fViewer.getTree().setRedraw(true);
                }
            }
            return root;
        }
        catch (RuntimeException e) {
            throw new CoreException(this.getErrorStatus("Could not create AST:\n" + e.getMessage(), e));
        }
        catch (Exception e) {
            throw new CoreException(this.getErrorStatus("Could not create AST:\n" + e.getMessage(), e));
        }
    }

    private void clearView() {
        this.resetView(null);
        this.setContentDescription("Open a PHP editor and press the 'Show AST of active editor' toolbar button");
    }

    private void resetView(Program root) {
        this.fViewer.setInput((Object)root);
        this.fViewer.getTree().setEnabled(root != null);
        this.fSash.setMaximizedControl((Control)this.fViewer.getTree());
        this.fTrayRoots = new ArrayList();
        this.setASTUptoDate(root != null);
        this.fClearAction.setEnabled(root != null);
        this.fFindDeclaringNodeAction.setEnabled(root != null);
        this.fPreviousDouble = null;
    }

    private Program createAST(ISourceModule input, PHPVersion phpVersion, int offset) throws Exception {
        long endTime;
        long startTime;
        Program root = null;
        if (this.getCurrentInputKind() == 2) {
            final IProblemRequestor problemRequestor = new IProblemRequestor(){

                public void acceptProblem(IProblem problem) {
                }

                public void beginReporting() {
                }

                public void endReporting() {
                }

                public boolean isActive() {
                    return true;
                }
            };
            WorkingCopyOwner workingCopyOwner = new WorkingCopyOwner(){

                public IProblemRequestor getProblemRequestor(ISourceModule workingCopy) {
                    return problemRequestor;
                }
            };
            ISourceModule wc = input.getWorkingCopy(workingCopyOwner, null, (IProgressMonitor)new NullProgressMonitor());
            try {
                startTime = System.currentTimeMillis();
                wc.reconcile(true, wc.getOwner(), (IProgressMonitor)new NullProgressMonitor());
                root = SharedASTProvider.getAST((ISourceModule)wc, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
                endTime = System.currentTimeMillis();
            }
            finally {
                wc.discardWorkingCopy();
            }
        } else if (input instanceof ISourceModule && this.getCurrentInputKind() == 3) {
            ISourceModule cu = input;
            startTime = System.currentTimeMillis();
            root = SharedASTProvider.getAST((ISourceModule)cu, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
            endTime = System.currentTimeMillis();
        } else {
            ISourceModule sm = input;
            StringReader st = new StringReader(sm.getBuffer().getContents());
            ASTParser parser = ASTParser.newParser((Reader)st, (PHPVersion)phpVersion, (boolean)false, (ISourceModule)sm);
            startTime = System.currentTimeMillis();
            root = parser.createAST(null);
            endTime = System.currentTimeMillis();
        }
        if (root != null) {
            this.updateContentDescription((IModelElement)input, root, endTime - startTime);
        }
        return root;
    }

    protected void refreshASTSettingsActions() {
        boolean enabled;
        switch (this.getCurrentInputKind()) {
            case 2: 
            case 3: {
                enabled = false;
                break;
            }
            default: {
                enabled = true;
            }
        }
        this.fBindingsRecoveryAction.setEnabled(enabled);
        this.fCreateBindingsAction.setEnabled(enabled);
        this.fStatementsRecoveryAction.setEnabled(enabled);
    }

    private void updateContentDescription(IModelElement element, Program root, long time) {
        String version = root.getAST().apiLevel().getAlias();
        if (this.getCurrentInputKind() == 2) {
            version = String.valueOf(version) + ", from reconciler";
        } else if (this.getCurrentInputKind() == 3) {
            version = String.valueOf(version) + ", from ASTProvider";
        } else if (this.getCurrentInputKind() == 4) {
            version = String.valueOf(version) + ", using focal position";
        }
        TreeInfoCollector collector = new TreeInfoCollector(root);
        String msg = "{0} ({1}).  Creation time: {2,number} ms.  Size: {3,number} nodes, {4,number} bytes (AST nodes only).";
        Object[] args = new Object[]{element.getElementName(), version, time, collector.getNumberOfNodes(), collector.getSize()};
        this.setContentDescription(MessageFormat.format(msg, args));
    }

    public void dispose() {
        if (this.fSuperListener != null) {
            if (this.fEditor != null) {
                this.uninstallModificationListener();
            }
            ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
            service.removePostSelectionListener((ISelectionListener)this.fSuperListener);
            this.getSite().getPage().removePartListener((IPartListener2)this.fSuperListener);
            FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)this.fSuperListener);
            this.fSuperListener.dispose();
            this.fSuperListener = null;
        }
        if (this.fTrayUpdater != null) {
            this.fViewer.removePostSelectionChangedListener(this.fTrayUpdater);
            this.fTray.removePostSelectionChangedListener(this.fTrayUpdater);
            this.fTrayUpdater = null;
        }
        super.dispose();
    }

    private IStatus getErrorStatus(String message, Throwable th) {
        return new Status(4, ASTViewPlugin.getPluginId(), 4, message, th);
    }

    public void createPartControl(Composite parent) {
        this.fSash = new SashForm(parent, 66048);
        this.fViewer = new TreeViewer((Composite)this.fSash, 770);
        this.fDrillDownAdapter = new DrillDownAdapter(this.fViewer);
        this.fViewer.setContentProvider((IContentProvider)new ASTViewContentProvider());
        this.fASTLabelProvider = new ASTViewLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fASTLabelProvider);
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.fSuperListener);
        this.fViewer.addDoubleClickListener((IDoubleClickListener)this.fSuperListener);
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ASTView.this.fCreateBindings || !(element instanceof Binding);
            }
        });
        this.fViewer.addFilter((ViewerFilter)this.fNonRelevantFilter);
        ViewForm trayForm = new ViewForm((Composite)this.fSash, 0);
        Label label = new Label((Composite)trayForm, 0);
        label.setText(" Comparison Tray (* = selection in the upper tree):");
        trayForm.setTopLeft((Control)label);
        this.fTray = new TreeViewer((Composite)trayForm, 770);
        trayForm.setContent((Control)this.fTray.getTree());
        this.makeActions();
        this.hookContextMenu();
        this.hookTrayContextMenu();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)new ASTViewSelectionProvider());
        try {
            IEditorPart part = EditorUtility.getActiveEditor();
            if (part instanceof ITextEditor) {
                this.setInput((ITextEditor)part);
            }
        }
        catch (CoreException coreException) {}
        if (this.fSourceRoot == null) {
            this.clearView();
        } else {
            this.setASTUptoDate(this.fSourceRoot != null);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ASTView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void hookTrayContextMenu() {
        MenuManager menuMgr = new MenuManager("#TrayPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)ASTView.this.fCopyAction);
                manager.add((IAction)ASTView.this.fDeleteAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fTray.getControl());
        this.fTray.getControl().setMenu(menu);
        this.getSite().registerContextMenu("#TrayPopupMenu", menuMgr, (ISelectionProvider)this.fTray);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fFocusAction);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        IHandlerService handlerService = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        handlerService.activateHandler(LINK_WITH_EDITOR_COMMAND_ID, (IHandler)new ActionHandler((IAction)this.fLinkWithEditor));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fCreateBindingsAction);
        manager.add((IAction)this.fStatementsRecoveryAction);
        manager.add((IAction)this.fBindingsRecoveryAction);
        manager.add((IAction)this.fFilterNonRelevantAction);
        manager.add((IContributionItem)new Separator());
        ASTInputKindAction[] aSTInputKindActionArray = this.fASTInputKindActions;
        int n = this.fASTInputKindActions.length;
        int n2 = 0;
        while (n2 < n) {
            ASTInputKindAction fASTInputKindAction = aSTInputKindActionArray[n2];
            manager.add((IAction)fASTInputKindAction);
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fFindDeclaringNodeAction);
        manager.add((IAction)this.fParseBindingFromKeyAction);
        manager.add((IAction)this.fParseBindingFromElementAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fLinkWithEditor);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fFocusAction);
        manager.add((IAction)this.fRefreshAction);
        manager.add((IAction)this.fClearAction);
        manager.add((IAction)this.fCollapseAction);
        manager.add((IAction)this.fExpandAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fCopyAction);
        manager.add((IContributionItem)new Separator());
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fFocusAction);
        manager.add((IAction)this.fRefreshAction);
        manager.add((IAction)this.fClearAction);
        manager.add((IContributionItem)new Separator());
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fExpandAction);
        manager.add((IAction)this.fCollapseAction);
        manager.add((IAction)this.fLinkWithEditor);
    }

    private void setASTUptoDate(boolean isuptoDate) {
        this.fRefreshAction.setEnabled(!isuptoDate && this.fSourceRoot != null);
    }

    private void makeActions() {
        this.fRefreshAction = new Action(){

            public void run() {
                ASTView.this.performRefresh();
            }
        };
        this.fRefreshAction.setText("&Refresh AST");
        this.fRefreshAction.setToolTipText("Refresh AST");
        this.fRefreshAction.setEnabled(false);
        ASTViewImages.setImageDescriptors((IAction)this.fRefreshAction, "refresh.gif");
        this.fClearAction = new Action(){

            public void run() {
                ASTView.this.performClear();
            }
        };
        this.fClearAction.setText("&Clear AST");
        this.fClearAction.setToolTipText("Clear AST and release memory");
        this.fClearAction.setEnabled(false);
        ASTViewImages.setImageDescriptors((IAction)this.fClearAction, "clear.gif");
        this.fASTInputKindActions = new ASTInputKindAction[]{new ASTInputKindAction("Use ASTParser.&createAST", 1), new ASTInputKindAction("Use ASTParser with &focal position", 4), new ASTInputKindAction("Use IProgram.&reconcile", 2), new ASTInputKindAction("Use SharedASTProvider.&getAST", 3)};
        this.fCreateBindingsAction = new Action("&Create Bindings", 2){

            public void run() {
                ASTView.this.performCreateBindings();
            }
        };
        this.fCreateBindingsAction.setChecked(this.fCreateBindings);
        this.fCreateBindingsAction.setToolTipText("Create Bindings");
        this.fCreateBindingsAction.setEnabled(true);
        this.fStatementsRecoveryAction = new Action("&Statements Recovery", 2){

            public void run() {
                ASTView.this.performStatementsRecovery();
            }
        };
        this.fStatementsRecoveryAction.setChecked(this.fStatementsRecovery);
        this.fStatementsRecoveryAction.setEnabled(true);
        this.fBindingsRecoveryAction = new Action("&Bindings Recovery", 2){

            public void run() {
                ASTView.this.performBindingsRecovery();
            }
        };
        this.fBindingsRecoveryAction.setChecked(this.fBindingsRecovery);
        this.fBindingsRecoveryAction.setEnabled(true);
        this.fFilterNonRelevantAction = new Action("&Hide Non-Relevant Attributes", 2){

            public void run() {
                ASTView.this.performFilterNonRelevant();
            }
        };
        this.fFilterNonRelevantAction.setChecked(!this.fNonRelevantFilter.isShowNonRelevant());
        this.fFilterNonRelevantAction.setToolTipText("Hide non-relevant binding attributes");
        this.fFilterNonRelevantAction.setEnabled(true);
        this.fFindDeclaringNodeAction = new Action("Find &Declaring Node...", 1){

            public void run() {
                ASTView.this.performFindDeclaringNode();
            }
        };
        this.fFindDeclaringNodeAction.setToolTipText("Find Declaring Node...");
        this.fFindDeclaringNodeAction.setEnabled(false);
        this.fParseBindingFromElementAction = new Action("&Parse Binding from &Element Handle...", 1){

            public void run() {
                ASTView.this.performParseBindingFromElement();
            }
        };
        this.fParseBindingFromElementAction.setToolTipText("Parse Binding from Element Handle...");
        this.fParseBindingFromElementAction.setEnabled(true);
        this.fParseBindingFromKeyAction = new Action("Parse Binding from &Key...", 1){

            public void run() {
                ASTView.this.performParseBindingFromKey();
            }
        };
        this.fParseBindingFromKeyAction.setToolTipText("Parse Binding from Key...");
        this.fParseBindingFromKeyAction.setEnabled(true);
        this.fFocusAction = new Action(){

            public void run() {
                ASTView.this.performSetFocus();
            }
        };
        this.fFocusAction.setText("&Show AST of active editor");
        this.fFocusAction.setToolTipText("Show AST of active editor");
        this.fFocusAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        ASTViewImages.setImageDescriptors((IAction)this.fFocusAction, "setfocus.gif");
        this.fCollapseAction = new Action(){

            public void run() {
                ASTView.this.performCollapse();
            }
        };
        this.fCollapseAction.setText("C&ollapse");
        this.fCollapseAction.setToolTipText("Collapse Selected Node");
        this.fCollapseAction.setEnabled(false);
        ASTViewImages.setImageDescriptors((IAction)this.fCollapseAction, "collapseall.gif");
        this.fExpandAction = new Action(){

            public void run() {
                ASTView.this.performExpand();
            }
        };
        this.fExpandAction.setText("E&xpand");
        this.fExpandAction.setToolTipText("Expand Selected Node");
        this.fExpandAction.setEnabled(false);
        ASTViewImages.setImageDescriptors((IAction)this.fExpandAction, "expandall.gif");
        this.fCopyAction = new TreeCopyAction(new Tree[]{this.fViewer.getTree(), this.fTray.getTree()});
        this.fDoubleClickAction = new Action(){

            public void run() {
                ASTView.this.performDoubleClick();
            }
        };
        this.fLinkWithEditor = new Action(){

            public void run() {
                ASTView.this.performLinkWithEditor();
            }
        };
        this.fLinkWithEditor.setChecked(this.fDoLinkWithEditor);
        this.fLinkWithEditor.setText("&Link with Editor");
        this.fLinkWithEditor.setToolTipText("Link With Editor");
        this.fLinkWithEditor.setActionDefinitionId(LINK_WITH_EDITOR_COMMAND_ID);
        ASTViewImages.setImageDescriptors((IAction)this.fLinkWithEditor, "synced.gif");
        this.fDeleteAction = new Action(){

            public void run() {
                ASTView.this.performDelete();
            }
        };
        this.fDeleteAction.setText("&Delete");
        this.fDeleteAction.setToolTipText("Delete Binding from Tray");
        this.fDeleteAction.setEnabled(false);
        this.fDeleteAction.setImageDescriptor(ASTViewPlugin.getDefault().getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.fDeleteAction.setId(ActionFactory.DELETE.getId());
        this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.refreshASTSettingsActions();
    }

    private void refreshAST() throws CoreException {
        ASTNode node = this.getASTNodeNearSelection((IStructuredSelection)this.fViewer.getSelection());
        int offset = 0;
        int length = 0;
        if (node != null) {
            offset = node.getStart();
            length = node.getLength();
        }
        this.internalSetInput(this.fSourceRoot, offset, length, this.getCurrentPHPVersion());
    }

    protected void setASTLevel(PHPVersion level, boolean doRefresh) {
        PHPVersion oldLevel = this.fPHPVersion;
        this.fPHPVersion = level;
        if (doRefresh && this.fSourceRoot != null && oldLevel != this.fPHPVersion) {
            try {
                this.refreshAST();
            }
            catch (CoreException e) {
                this.showAndLogError("Could not set AST to new level.", e);
                this.fPHPVersion = oldLevel;
            }
        }
    }

    protected void setASTInputType(int inputKind) {
        if (inputKind != this.fCurrentInputKind) {
            this.fCurrentInputKind = inputKind;
            this.fDialogSettings.put(SETTINGS_INPUT_KIND, inputKind);
            ASTInputKindAction[] aSTInputKindActionArray = this.fASTInputKindActions;
            int n = this.fASTInputKindActions.length;
            int n2 = 0;
            while (n2 < n) {
                ASTInputKindAction curr;
                curr.setChecked((curr = aSTInputKindActionArray[n2]).getInputKind() == inputKind);
                ++n2;
            }
            this.refreshASTSettingsActions();
            this.performRefresh();
        }
    }

    private ASTNode getASTNodeNearSelection(IStructuredSelection selection) {
        Object elem = selection.getFirstElement();
        if (elem instanceof ASTAttribute) {
            return ((ASTAttribute)elem).getParentASTNode();
        }
        if (elem instanceof ASTNode) {
            return (ASTNode)elem;
        }
        return null;
    }

    private void installModificationListener() {
        this.fCurrentDocument = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        this.fCurrentDocument.addDocumentListener((IDocumentListener)this.fSuperListener);
    }

    private void uninstallModificationListener() {
        if (this.fCurrentDocument != null) {
            this.fCurrentDocument.removeDocumentListener((IDocumentListener)this.fSuperListener);
            this.fCurrentDocument = null;
        }
    }

    protected void handleDocumentDisposed(IDocument document) {
        this.uninstallModificationListener();
    }

    protected void handleDocumentChanged(IDocument document) {
        this.setASTUptoDate(false);
    }

    protected void handleSelectionChanged(ISelection selection) {
        this.fExpandAction.setEnabled(!selection.isEmpty());
        this.fCollapseAction.setEnabled(!selection.isEmpty());
        this.fCopyAction.setEnabled(!selection.isEmpty());
    }

    protected void handleEditorPostSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (part == this.fEditor) {
            this.fViewer.getTree().setRedraw(false);
            try {
                this.fASTLabelProvider.setSelectedRange(textSelection.getOffset(), textSelection.getLength());
            }
            finally {
                this.fViewer.getTree().setRedraw(true);
            }
        }
        if (!this.fDoLinkWithEditor) {
            return;
        }
        if (this.fRoot == null || part != this.fEditor) {
            if (part instanceof ITextEditor && EditorUtility.getPhpInput((IEditorPart)((ITextEditor)part)) != null) {
                try {
                    this.setInput((ITextEditor)part);
                }
                catch (CoreException e) {
                    this.setContentDescription(e.getStatus().getMessage());
                }
            }
        } else {
            this.doLinkWithEditor(selection);
        }
    }

    private void doLinkWithEditor(ISelection selection) {
        ITextSelection textSelection = (ITextSelection)selection;
        int offset = textSelection.getOffset();
        int length = textSelection.getLength();
        NodeFinder finder = new NodeFinder(offset, length);
        this.fRoot.accept((Visitor)finder);
        ASTNode covering = finder.getCoveringNode();
        if (covering != null) {
            this.fViewer.reveal((Object)covering);
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)covering));
        }
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        this.fDoubleClickAction.run();
    }

    protected void performLinkWithEditor() {
        ISelectionProvider selectionProvider;
        this.fDoLinkWithEditor = this.fLinkWithEditor.isChecked();
        this.fDialogSettings.put(SETTINGS_LINK_WITH_EDITOR, this.fDoLinkWithEditor);
        if (this.fDoLinkWithEditor && this.fEditor != null && (selectionProvider = this.fEditor.getSelectionProvider()) != null) {
            this.doLinkWithEditor(selectionProvider.getSelection());
        }
    }

    protected void performCollapse() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.isEmpty()) {
            this.fViewer.collapseAll();
        } else {
            Object[] selected = selection.toArray();
            this.fViewer.getTree().setRedraw(false);
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.fViewer.collapseToLevel(element, -1);
                ++n2;
            }
            this.fViewer.getTree().setRedraw(true);
        }
    }

    protected void performExpand() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.isEmpty()) {
            this.fViewer.expandToLevel(3);
        } else {
            Object[] selected = selection.toArray();
            this.fViewer.getTree().setRedraw(false);
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.fViewer.expandToLevel(element, 3);
                ++n2;
            }
            this.fViewer.getTree().setRedraw(true);
        }
    }

    protected void performSetFocus() {
        IEditorPart part = EditorUtility.getActiveEditor();
        if (part instanceof ITextEditor) {
            try {
                this.setInput((ITextEditor)part);
            }
            catch (CoreException e) {
                this.showAndLogError("Could not set AST view input ", e);
            }
        }
    }

    protected void performRefresh() {
        if (this.fSourceRoot != null) {
            try {
                this.refreshAST();
            }
            catch (CoreException e) {
                this.showAndLogError("Could not set AST view input ", e);
            }
        }
    }

    protected void performClear() {
        this.fSourceRoot = null;
        try {
            this.setInput(null);
        }
        catch (CoreException e) {
            this.showAndLogError("Could not reset AST view ", e);
        }
        this.clearView();
    }

    private void showAndLogError(String message, CoreException e) {
        ASTViewPlugin.log(message, e);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"AST View", (String)message, (IStatus)e.getStatus());
    }

    private void showAndLogError(String message, Throwable e) {
        Status status = new Status(4, ASTViewPlugin.getPluginId(), 0, message, e);
        ASTViewPlugin.log((IStatus)status);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"AST View", null, (IStatus)status);
    }

    protected void performCreateBindings() {
        this.fCreateBindings = this.fCreateBindingsAction.isChecked();
        this.fDialogSettings.put(SETTINGS_NO_BINDINGS, !this.fCreateBindings);
        this.performRefresh();
    }

    protected void performStatementsRecovery() {
        this.fStatementsRecovery = this.fStatementsRecoveryAction.isChecked();
        this.fDialogSettings.put(SETTINGS_NO_STATEMENTS_RECOVERY, !this.fStatementsRecovery);
        this.performRefresh();
    }

    protected void performBindingsRecovery() {
        this.fBindingsRecovery = this.fBindingsRecoveryAction.isChecked();
        this.fDialogSettings.put(SETTINGS_NO_BINDINGS_RECOVERY, !this.fBindingsRecovery);
        this.performRefresh();
    }

    protected void performFilterNonRelevant() {
        boolean showNonRelevant = !this.fFilterNonRelevantAction.isChecked();
        this.fNonRelevantFilter.setShowNonRelevant(showNonRelevant);
        this.fDialogSettings.put(SETTINGS_SHOW_NON_RELEVANT, showNonRelevant);
        this.fViewer.refresh();
    }

    protected void performFindDeclaringNode() {
        String msg = "Find Declaring Node from Key";
        String key = this.askForKey(msg);
        if (key == null) {
            return;
        }
        Object node = null;
        if (node != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(node), true);
        } else {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Find Declaring Node from Key", (String)("The declaring node for key '" + key + "' could not be found"));
        }
    }

    private String askForKey(String dialogTitle) {
        InputDialog dialog = new InputDialog(this.getSite().getShell(), dialogTitle, "Key: (optionally surrounded by <KEY: '> and <'>)", "", null);
        if (dialog.open() != 0) {
            return null;
        }
        String key = dialog.getValue();
        if (key.startsWith("KEY: '") && key.endsWith("'")) {
            key = key.substring(6, key.length() - 1);
        }
        return key;
    }

    protected void performParseBindingFromKey() {
    }

    protected void performParseBindingFromElement() {
        InputDialog dialog = new InputDialog(this.getSite().getShell(), "Parse Binding from Java Element", "IJavaElement#getHandleIdentifier():", "", null);
        if (dialog.open() != 0) {
            return;
        }
    }

    protected void performDoubleClick() {
        Throwable exception;
        if (this.fEditor == null) {
            return;
        }
        ISelection selection = this.fViewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        boolean isTripleClick = obj == this.fPreviousDouble;
        Object object = this.fPreviousDouble = isTripleClick ? null : obj;
        if (obj instanceof ExceptionAttribute && (exception = ((ExceptionAttribute)obj).getException()) != null) {
            String label = ((ExceptionAttribute)obj).getLabel();
            this.showAndLogError("An error occurred while calculating an AST View Label:\n" + label, exception);
            return;
        }
        ASTNode node = null;
        if (obj instanceof ASTNode) {
            node = (ASTNode)obj;
        } else if (obj instanceof NodeProperty) {
            Object val = ((NodeProperty)obj).getNode();
            if (val instanceof ASTNode) {
                node = (ASTNode)val;
            }
        } else if (!(obj instanceof Binding)) {
            if (obj instanceof ProblemNode) {
                ProblemNode problemNode = (ProblemNode)obj;
                EditorUtility.selectInEditor(this.fEditor, problemNode.getOffset(), problemNode.getLength());
                return;
            }
            if (obj instanceof PhpElement) {
                return;
            }
        }
        if (node != null) {
            int offset = isTripleClick ? this.fRoot.getExtendedStartPosition(node) : node.getStart();
            int length = isTripleClick ? this.fRoot.getExtendedLength(node) : node.getLength();
            EditorUtility.selectInEditor(this.fEditor, offset, length);
        }
    }

    protected void performTrayDoubleClick() {
        Throwable exception;
        IStructuredSelection selection = (IStructuredSelection)this.fTray.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof ExceptionAttribute && (exception = ((ExceptionAttribute)obj).getException()) != null) {
            String label = ((ExceptionAttribute)obj).getLabel();
            this.showAndLogError("An error occurred while calculating an AST View Label:\n" + label, exception);
            return;
        }
        if (obj instanceof Binding) {
            Binding binding = (Binding)obj;
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)binding), true);
        }
    }

    protected void performDelete() {
        boolean removed = false;
        IStructuredSelection selection = (IStructuredSelection)this.fTray.getSelection();
        for (Object obj : selection) {
            if (obj instanceof DynamicAttributeProperty) {
                obj = ((DynamicAttributeProperty)obj).getParent();
            }
            if (obj instanceof DynamicBindingProperty) {
                obj = ((DynamicBindingProperty)obj).getParent();
            }
            removed |= this.fTrayRoots.remove(obj);
        }
        if (removed) {
            this.fTray.setInput((Object)this.fTrayRoots);
        }
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext(null, this.getSite().getSelectionProvider().getSelection());
    }

    static Object unwrapAttribute(Object attribute) {
        if (attribute instanceof Binding) {
            return ((Binding)attribute).getBinding();
        }
        if (attribute instanceof PhpElement) {
            return ((PhpElement)attribute).getPhpElement();
        }
        if (attribute instanceof ASTNode) {
            return attribute;
        }
        return null;
    }

    private class ASTInputKindAction
    extends Action {
        public static final int USE_PARSER = 1;
        public static final int USE_RECONCILE = 2;
        public static final int USE_CACHE = 3;
        public static final int USE_FOCAL = 4;
        private int fInputKind;

        public ASTInputKindAction(String label, int inputKind) {
            super(label, 8);
            this.fInputKind = inputKind;
            if (inputKind == ASTView.this.getCurrentInputKind()) {
                this.setChecked(true);
            }
        }

        public int getInputKind() {
            return this.fInputKind;
        }

        public void run() {
            ASTView.this.setASTInputType(this.fInputKind);
        }
    }

    private class ASTViewSelectionProvider
    implements ISelectionProvider {
        ListenerList fListeners = new ListenerList(1);

        private ASTViewSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            IStructuredSelection selection = (IStructuredSelection)ASTView.this.fViewer.getSelection();
            ArrayList<Object> externalSelection = new ArrayList<Object>();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object unwrapped = ASTView.unwrapAttribute(iter.next());
                if (unwrapped == null) continue;
                externalSelection.add(unwrapped);
            }
            return new StructuredSelection(externalSelection);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
        }
    }

    private static class ListenerMix
    implements ISelectionListener,
    IFileBufferListener,
    IDocumentListener,
    ISelectionChangedListener,
    IDoubleClickListener,
    IPartListener2 {
        private boolean fASTViewVisible = true;
        private ASTView fView;

        public ListenerMix(ASTView view) {
            this.fView = view;
        }

        public void dispose() {
            this.fView = null;
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (this.fASTViewVisible) {
                this.fView.handleEditorPostSelectionChanged(part, selection);
            }
        }

        public void bufferCreated(IFileBuffer buffer) {
        }

        public void bufferDisposed(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer) {
                this.fView.handleDocumentDisposed(((ITextFileBuffer)buffer).getDocument());
            }
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.fView.handleDocumentChanged(event.getDocument());
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fView.handleSelectionChanged(event.getSelection());
        }

        public void doubleClick(DoubleClickEvent event) {
            this.fView.handleDoubleClick(event);
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part == this.fView) {
                this.fASTViewVisible = false;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part == this.fView) {
                this.fASTViewVisible = true;
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            this.fView.notifyWorkbenchPartClosed(partRef);
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

