/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ArrayCreation
extends VariableBase {
    private final ASTNode.NodeList<ArrayElement> elements = new ASTNode.NodeList(this, ELEMENTS_PROPERTY);
    private boolean hasArrayKey;
    public static final ChildListPropertyDescriptor ELEMENTS_PROPERTY = new ChildListPropertyDescriptor(ArrayCreation.class, "elements", ArrayElement.class, true);
    public static final SimplePropertyDescriptor HAS_ARRAY_KEY = new SimplePropertyDescriptor(LambdaFunctionDeclaration.class, "hasArrayKey", Boolean.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(3);
        properyList.add(ELEMENTS_PROPERTY);
        properyList.add(HAS_ARRAY_KEY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public ArrayCreation(AST ast) {
        super(ast);
    }

    private ArrayCreation(int start, int end, AST ast, ArrayElement[] elements, boolean hasArrayKey) {
        super(start, end, ast);
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        ArrayElement[] arrayElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayElement arrayElement = arrayElementArray[n2];
            this.elements.add(arrayElement);
            ++n2;
        }
        this.setHasArrayKey(hasArrayKey);
    }

    public ArrayCreation(int start, int end, AST ast, List<ArrayElement> elements) {
        this(start, end, ast, elements == null ? null : elements.toArray(new ArrayElement[elements.size()]), true);
    }

    public ArrayCreation(int start, int end, AST ast, List<ArrayElement> elements, boolean hasArrayKey) {
        this(start, end, ast, elements == null ? null : elements.toArray(new ArrayElement[elements.size()]), hasArrayKey);
    }

    public boolean isHasArrayKey() {
        return this.hasArrayKey;
    }

    public void setHasArrayKey(boolean hasArrayKey) {
        this.preValueChange(HAS_ARRAY_KEY);
        this.hasArrayKey = hasArrayKey;
        this.postValueChange(HAS_ARRAY_KEY);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == HAS_ARRAY_KEY) {
            if (get) {
                return this.isHasArrayKey();
            }
            this.setHasArrayKey(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.elements) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.elements) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.elements) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ArrayCreation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        for (ASTNode aSTNode : this.elements) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</ArrayCreation>");
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public int getType() {
        return 1;
    }

    public List<ArrayElement> elements() {
        return this.elements;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List elements = ASTNode.copySubtrees(target, this.elements());
        ArrayCreation result = new ArrayCreation(this.getStart(), this.getEnd(), target, elements.toArray(new ArrayElement[elements.size()]), this.isHasArrayKey());
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == ELEMENTS_PROPERTY) {
            return this.elements();
        }
        return super.internalGetChildListProperty(property);
    }
}

