/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.CaseDefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.CommentIndentationStrategy;
import org.eclipse.php.internal.core.format.CurlyCloseIndentationStrategy;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.core.format.IndentationObject;
import org.eclipse.php.internal.core.format.PHPCloseTagIndentationStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.text.rules.SimpleStructuredRegion;

public class PhpIndentationFormatter {
    private final IIndentationStrategy defaultIndentationStrategy;
    private final IIndentationStrategy curlyCloseIndentationStrategy;
    private final IIndentationStrategy caseDefaultIndentationStrategy;
    private final IIndentationStrategy commentIndentationStrategy;
    private final IIndentationStrategy phpCloseTagIndentationStrategy;
    private final int length;
    private final int start;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_SPACE = 32;
    private final StringBuffer resultBuffer = new StringBuffer();
    private boolean isInHeredoc;
    private Set<Integer> ignoreLines = new HashSet<Integer>();

    public PhpIndentationFormatter(int start, int length, IndentationObject indentationObject) {
        this.start = start;
        this.length = length;
        this.defaultIndentationStrategy = new DefaultIndentationStrategy(indentationObject);
        this.curlyCloseIndentationStrategy = new CurlyCloseIndentationStrategy();
        this.caseDefaultIndentationStrategy = new CaseDefaultIndentationStrategy(indentationObject);
        this.commentIndentationStrategy = new CommentIndentationStrategy();
        this.phpCloseTagIndentationStrategy = new PHPCloseTagIndentationStrategy();
    }

    public void format(IStructuredDocumentRegion sdRegion) {
        assert (sdRegion != null);
        int regionStart = sdRegion.getStartOffset();
        int regionEnd = sdRegion.getEnd();
        int formatRequestStart = this.getStart();
        int formatRequestEnd = formatRequestStart + this.getLength();
        int startFormat = Math.max(formatRequestStart, regionStart);
        int endFormat = Math.min(formatRequestEnd, regionEnd);
        IStructuredDocument document = sdRegion.getParentDocument();
        int lineIndex = document.getLineOfOffset(startFormat);
        int endLineIndex = document.getLineOfOffset(endFormat);
        while (lineIndex <= endLineIndex) {
            this.formatLine(document, lineIndex);
            ++lineIndex;
        }
    }

    private void formatLine(IStructuredDocument document, int lineNumber) {
        this.resultBuffer.setLength(0);
        try {
            int startLine;
            boolean formatThisLine;
            int originalTextEnd;
            IRegion originalLineInfo = document.getLineInformation(lineNumber);
            int orginalLineStart = originalLineInfo.getOffset();
            int originalLineLength = originalLineInfo.getLength();
            if (originalLineLength == 0) {
                return;
            }
            String lineText = document.get(orginalLineStart, originalLineLength);
            IRegion formattedLineInformation = this.getFormattedLineInformation(originalLineInfo, lineText);
            if (!this.shouldReformat(document, formattedLineInformation)) {
                return;
            }
            int formattedLineStart = formattedLineInformation.getOffset();
            int formattedTextEnd = formattedLineStart + formattedLineInformation.getLength();
            if (formattedTextEnd != (originalTextEnd = orginalLineStart + originalLineLength)) {
                document.replace(formattedTextEnd, originalTextEnd - formattedTextEnd, "");
                if (formattedLineStart == formattedTextEnd) {
                    return;
                }
            }
            int startingWhiteSpaces = formattedLineStart - orginalLineStart;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(formattedLineStart);
            ITextRegion firstTokenInLine = sdRegion.getRegionAtCharacterOffset(formattedLineStart);
            ITextRegion lastTokenInLine = null;
            int regionStart = sdRegion.getStartOffset(firstTokenInLine);
            if (firstTokenInLine instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)firstTokenInLine;
                firstTokenInLine = container.getRegionAtCharacterOffset(formattedLineStart);
                regionStart += firstTokenInLine.getStart();
            }
            int scriptRegionLength = 0;
            if (firstTokenInLine instanceof IPhpScriptRegion) {
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)firstTokenInLine;
                if (scriptRegion.getEnd() - 1 < formattedLineStart) {
                    return;
                }
                scriptRegionLength = scriptRegion.getStart();
                firstTokenInLine = scriptRegion.getPhpToken(formattedLineStart - regionStart);
                if (firstTokenInLine.getStart() + sdRegion.getStartOffset() < orginalLineStart && firstTokenInLine.getType() == "WHITESPACE") {
                    firstTokenInLine = scriptRegion.getPhpToken(formattedLineStart - regionStart + firstTokenInLine.getLength());
                }
                if (formattedTextEnd <= scriptRegion.getEnd() && (lastTokenInLine = scriptRegion.getPhpToken(formattedTextEnd - regionStart - 1)).getEnd() + sdRegion.getStartOffset() > orginalLineStart + originalLineLength && lastTokenInLine.getType() == "WHITESPACE") {
                    lastTokenInLine = scriptRegion.getPhpToken(formattedTextEnd - regionStart - 1 - lastTokenInLine.getLength());
                }
            }
            if (firstTokenInLine == null) {
                return;
            }
            String firstTokenType = firstTokenInLine.getType();
            boolean bl = formatThisLine = !this.isInHeredoc;
            if (firstTokenType == "PHP_HEREDOC_TAG" || lastTokenInLine != null && lastTokenInLine.getType() == "PHP_HEREDOC_TAG") {
                boolean bl2 = this.isInHeredoc = !this.isInHeredoc;
            }
            if (firstTokenType == "PHP_CONSTANT_ENCAPSED_STRING" && (startLine = document.getLineOfOffset(firstTokenInLine.getStart() + scriptRegionLength)) < lineNumber) {
                this.ignoreLines.add(lineNumber);
                return;
            }
            if (!formatThisLine) {
                this.ignoreLines.add(lineNumber);
                return;
            }
            IIndentationStrategy insertionStrategy = firstTokenType == "PHP_CASE" || firstTokenType == "PHP_DEFAULT" ? this.caseDefaultIndentationStrategy : (this.isInsideOfPHPCommentRegion(firstTokenType) ? this.commentIndentationStrategy : (firstTokenType == "PHP_CLOSETAG" ? this.phpCloseTagIndentationStrategy : this.getIndentationStrategy(lineText.charAt(startingWhiteSpaces))));
            insertionStrategy.placeMatchingBlanks(document, this.resultBuffer, lineNumber, document.getLineOffset(lineNumber));
            String newIndentation = this.resultBuffer.toString();
            String oldIndentation = lineText.substring(0, startingWhiteSpaces);
            char newChar = '\u0000';
            if (newIndentation.length() > 0) {
                newChar = newIndentation.charAt(0);
            }
            char oldChar = '\u0000';
            if (oldIndentation.length() > 0) {
                oldChar = oldIndentation.charAt(0);
            }
            if (newIndentation.length() != oldIndentation.length() || newChar != oldChar) {
                document.replaceText((Object)sdRegion, orginalLineStart, startingWhiteSpaces, newIndentation);
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private boolean isInsideOfPHPCommentRegion(String tokenType) {
        return PHPPartitionTypes.isPHPMultiLineCommentRegion(tokenType) || PHPPartitionTypes.isPHPMultiLineCommentEndRegion(tokenType) || PHPPartitionTypes.isPHPDocRegion(tokenType) || PHPPartitionTypes.isPHPDocEndRegion(tokenType);
    }

    private IRegion getFormattedLineInformation(IRegion lineInfo, String lineText) {
        int leftNonWhitespaceChar = 0;
        int rightNonWhitespaceChar = lineText.length() - 1;
        char[] chars = lineText.toCharArray();
        boolean keepSearching = true;
        while (keepSearching) {
            boolean rightIsWhiteSpace;
            boolean leftIsWhiteSpace = chars[leftNonWhitespaceChar] == ' ' || chars[leftNonWhitespaceChar] == '\t';
            boolean bl = rightIsWhiteSpace = chars[rightNonWhitespaceChar] == ' ' || chars[rightNonWhitespaceChar] == '\t';
            if (leftIsWhiteSpace) {
                ++leftNonWhitespaceChar;
            }
            if (rightIsWhiteSpace) {
                --rightNonWhitespaceChar;
            }
            boolean bl2 = keepSearching = (leftIsWhiteSpace || rightIsWhiteSpace) && leftNonWhitespaceChar < rightNonWhitespaceChar;
        }
        if (leftNonWhitespaceChar > rightNonWhitespaceChar) {
            return new SimpleStructuredRegion(lineInfo.getOffset(), 0);
        }
        return leftNonWhitespaceChar == 0 && rightNonWhitespaceChar == lineText.length() - 1 ? lineInfo : new SimpleStructuredRegion(lineInfo.getOffset() + leftNonWhitespaceChar, rightNonWhitespaceChar - leftNonWhitespaceChar + 1);
    }

    private boolean shouldReformat(IStructuredDocument document, IRegion lineInfo) {
        String checkedLineBeginState = FormatterUtils.getPartitionType(document, lineInfo.getOffset());
        return checkedLineBeginState == "org.eclipse.php.PHP_DEFAULT" || checkedLineBeginState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_DOC" || checkedLineBeginState == "org.eclipse.php.PHP_QUOTED_STRING";
    }

    protected final int getStart() {
        return this.start;
    }

    protected final int getLength() {
        return this.length;
    }

    public Set<Integer> getIgnoreLines() {
        return this.ignoreLines;
    }

    protected IIndentationStrategy getIndentationStrategy(char c) {
        if (c == '}') {
            return this.curlyCloseIndentationStrategy;
        }
        return this.getDefaultIndentationStrategy();
    }

    private IIndentationStrategy getDefaultIndentationStrategy() {
        return this.defaultIndentationStrategy;
    }
}

