/*******************************************************************************
 * Copyright (c) 2016 Zend Technologies and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Zend Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.text.MessageFormat;

import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IVariableFacet.Facet;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;

/**
 * DBGp array value.
 * 
 * @author Bartlomiej Laczkowski
 */
public class DBGpArrayValue extends AbstractDBGpContainerValue {

	private static final String NAME_FORMAT = "Array [{0}]"; //$NON-NLS-1$

	/**
	 * Creates new DBGp array value.
	 * 
	 * @param owner
	 */
	public DBGpArrayValue(DBGpVariable owner) {
		super(owner);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.php.internal.debug.core.xdebug.dbgp.model.
	 * AbstractDBGpContainerValue#createVariable(org.w3c.dom.Node)
	 */
	@Override
	protected IVariable createVariable(Node descriptor) {
		return new DBGpVariable((DBGpTarget) getDebugTarget(), descriptor, getOwner().getStackLevel(),
				Facet.KIND_ARRAY_MEMBER);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue#
	 * createValueString(org.eclipse.php.internal.debug.core.xdebug.dbgp.model.
	 * AbstractDBGpValue.DBGpValueData)
	 */
	@Override
	protected String createValueString(DBGpValueData valueData) {
		String numChildStr = DBGpResponse.getAttribute(fDescriptor, "numchildren"); //$NON-NLS-1$
		return MessageFormat.format(NAME_FORMAT, numChildStr);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue#
	 * supportsValueModification()
	 */
	@Override
	protected boolean supportsValueModification() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue#
	 * verifyValue(java.lang.String)
	 */
	@Override
	protected boolean verifyValue(String expression) {
		return false;
	}

}
