/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.VirtualPartition;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpModelConstants;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;

public class DBGpStringValue
extends AbstractDBGpValue {
    private boolean fIsComplete = false;
    private int fRequiredBytes;
    private IVariable[] fStringInfo = null;
    private byte[] fValueBytes;

    public DBGpStringValue(DBGpVariable owner) {
        super(owner);
    }

    public boolean isComplete() {
        return this.fIsComplete;
    }

    public int getRequiredBytes() {
        return this.fRequiredBytes;
    }

    @Override
    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.fStringInfo == null) {
            this.createVariables();
        }
        return this.fStringInfo;
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return true;
    }

    @Override
    protected void update(Node descriptor) {
        int actualLength;
        super.update(descriptor);
        String size = DBGpResponse.getAttribute(descriptor, "size");
        int byteLength = -1;
        try {
            byteLength = Integer.parseInt(size);
        }
        catch (NumberFormatException numberFormatException) {}
        AbstractDBGpValue.DBGpValueData data = new AbstractDBGpValue.DBGpValueData(this, descriptor);
        this.fValueBytes = data.getValueBytes();
        if (this.fValueBytes == null) {
            String XMLEncoding = descriptor.getOwnerDocument().getInputEncoding();
            if (XMLEncoding == null) {
                XMLEncoding = ((DBGpTarget)this.getDebugTarget()).getBinaryEncoding();
            }
            try {
                this.fValueBytes = this.fValueString.getBytes(XMLEncoding);
            }
            catch (UnsupportedEncodingException uee) {
                DBGpLogger.logException("Unexpected encoding problem", this, uee);
                this.fValueBytes = this.fValueString.getBytes();
            }
        }
        this.fIsComplete = (actualLength = this.fValueBytes.length) >= byteLength;
        this.fRequiredBytes = byteLength;
    }

    @Override
    protected String createValueString(AbstractDBGpValue.DBGpValueData valueData) {
        this.fStringInfo = null;
        String valueString = valueData.getValueString();
        if (valueString != null && valueString.trim().length() > 0) {
            return valueString;
        }
        this.fValueBytes = new byte[0];
        return "";
    }

    @Override
    protected boolean supportsValueModification() {
        return true;
    }

    @Override
    protected void setValue(String value) {
        byte[] newBytes;
        this.fStringInfo = null;
        this.fValueString = value != null ? value.trim() : IDBGpModelConstants.INVALID_VAR_CONTENT;
        try {
            newBytes = value.getBytes(((DBGpTarget)this.getDebugTarget()).getBinaryEncoding());
        }
        catch (UnsupportedEncodingException e) {
            DBGpLogger.logException("unexpected encoding problem", this, e);
            newBytes = value.getBytes();
        }
        this.fValueBytes = newBytes;
        this.fRequiredBytes = newBytes.length;
    }

    @Override
    protected boolean verifyValue(String expression) {
        return true;
    }

    protected void createVariables() {
        int byteCount = this.fValueBytes.length;
        this.fStringInfo = new IVariable[1];
        this.fStringInfo[0] = new InfoVariable(PHPDebugCoreMessages.XDebug_DBGpStringValue_0, new InfoLengthValue(byteCount, this.getRequiredBytes(), this.getDebugTarget()), this.getDebugTarget(), IVariableFacet.Facet.VIRTUAL_LENGTH);
        InfoVariable[] byteVariables = null;
        if (byteCount > 100) {
            int subCount = (int)Math.ceil((double)byteCount / 100.0);
            byteVariables = new IVariable[subCount];
            int i = 0;
            while (i < subCount) {
                int startIndex = i * 100;
                int endIndex = (i + 1) * 100 - 1;
                if (endIndex > byteCount) {
                    endIndex = byteCount - 1;
                }
                int partitionSize = endIndex - startIndex + 1;
                final IVariable[] partitionVariables = new IVariable[partitionSize];
                int j = startIndex;
                while (j <= endIndex) {
                    InfoByteValue byteValue = new InfoByteValue(this.fValueBytes[j], this.getDebugTarget());
                    partitionVariables[j - startIndex] = new InfoVariable(String.valueOf('[') + Integer.toString(j) + ']', byteValue, this.getDebugTarget(), IVariableFacet.Facet.VIRTUAL_ARRAY_MEMBER);
                    ++j;
                }
                VirtualPartition partition = new VirtualPartition((IDebugElement)this, new VirtualPartition.IVariableProvider(){

                    @Override
                    public IVariable[] getVariables() throws DebugException {
                        return partitionVariables;
                    }
                }, startIndex, endIndex);
                byteVariables[i] = partition;
                ++i;
            }
        } else {
            byteVariables = new InfoVariable[byteCount];
            int i = 0;
            while (i < byteCount) {
                InfoByteValue byteValue = new InfoByteValue(this.fValueBytes[i], this.getDebugTarget());
                byteVariables[i] = new InfoVariable(String.valueOf('[') + Integer.toString(i) + ']', byteValue, this.getDebugTarget(), IVariableFacet.Facet.VIRTUAL_ARRAY_MEMBER);
                ++i;
            }
        }
        IVariable[] concat = Arrays.copyOf(this.fStringInfo, this.fStringInfo.length + byteVariables.length);
        System.arraycopy(byteVariables, 0, concat, this.fStringInfo.length, byteVariables.length);
        this.fStringInfo = concat;
    }

    private class InfoByteValue
    extends DBGpElement
    implements IValue {
        private byte fValue;

        public InfoByteValue(byte value, IDebugTarget debugTarget) {
            super(debugTarget);
            this.fValue = value;
        }

        public String getReferenceTypeName() throws DebugException {
            return "byte";
        }

        public String getValueString() throws DebugException {
            String valStr = Integer.toHexString(this.fValue & 0xFF);
            if (valStr.length() == 1) {
                valStr = "0" + valStr;
            }
            return valStr;
        }

        public IVariable[] getVariables() throws DebugException {
            return new IVariable[0];
        }

        public boolean hasVariables() throws DebugException {
            return false;
        }

        public boolean isAllocated() throws DebugException {
            return false;
        }
    }

    private class InfoLengthValue
    extends DBGpElement
    implements IValue {
        private int fCurrentLength;
        private int fTotalLength;

        public InfoLengthValue(int currentValue, int wantedValue, IDebugTarget debugTarget) {
            super(debugTarget);
            this.fCurrentLength = currentValue;
            this.fTotalLength = wantedValue;
        }

        public String getReferenceTypeName() throws DebugException {
            return null;
        }

        public String getValueString() throws DebugException {
            if (this.fCurrentLength == this.fTotalLength) {
                return Integer.toString(this.fCurrentLength);
            }
            return String.valueOf(Integer.toString(this.fCurrentLength)) + " (" + Integer.toString(this.fTotalLength) + ")";
        }

        public IVariable[] getVariables() throws DebugException {
            return new IVariable[0];
        }

        public boolean hasVariables() throws DebugException {
            return false;
        }

        public boolean isAllocated() throws DebugException {
            return false;
        }
    }

    private class InfoVariable
    extends DBGpElement
    implements IVariable,
    IVariableFacet {
        private String fName;
        private IValue fValue;
        private Set<IVariableFacet.Facet> fFacets;

        public InfoVariable(String name, IValue value, IDebugTarget debugTarget, IVariableFacet.Facet ... facets) {
            super(debugTarget);
            this.fFacets = new HashSet<IVariableFacet.Facet>();
            this.fName = name;
            this.fValue = value;
            this.addFacets(facets);
        }

        public InfoVariable(String name, IValue value, IDebugTarget debugTarget) {
            super(debugTarget);
            this.fFacets = new HashSet<IVariableFacet.Facet>();
            this.fName = name;
            this.fValue = value;
        }

        public String getName() throws DebugException {
            return this.fName;
        }

        public String getReferenceTypeName() throws DebugException {
            return this.fValue.getReferenceTypeName();
        }

        public IValue getValue() throws DebugException {
            return this.fValue;
        }

        public boolean hasValueChanged() throws DebugException {
            return false;
        }

        public void setValue(String expression) throws DebugException {
        }

        public void setValue(IValue value) throws DebugException {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public boolean verifyValue(String expression) throws DebugException {
            return true;
        }

        public boolean verifyValue(IValue value) throws DebugException {
            return true;
        }

        @Override
        public boolean hasFacet(IVariableFacet.Facet facet) {
            return this.fFacets.contains((Object)facet);
        }

        @Override
        public void addFacets(IVariableFacet.Facet ... facets) {
            IVariableFacet.Facet[] facetArray = facets;
            int n = facets.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableFacet.Facet facet = facetArray[n2];
                this.fFacets.add(facet);
                ++n2;
            }
        }
    }
}

