/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPRuntime;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPExeLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            PHPExeLaunchShortcut.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getPHPExeLaunchConfigType());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file == null) {
            IPath path = null;
            try {
                File systemFile;
                if (input instanceof IStorageEditorInput) {
                    IStorageEditorInput editorInput = (IStorageEditorInput)input;
                    IStorage storage = editorInput.getStorage();
                    path = storage.getFullPath();
                } else if (input instanceof IURIEditorInput) {
                    path = URIUtil.toPath((URI)((IURIEditorInput)input).getURI());
                } else if (input instanceof NonExistingPHPFileEditorInput) {
                    if (editor instanceof ITextEditor) {
                        ITextEditor textEditor = (ITextEditor)editor;
                        TextFileDocumentProvider documentProvider = (TextFileDocumentProvider)textEditor.getDocumentProvider();
                        IDocument document = documentProvider.getDocument((Object)input);
                        documentProvider.saveDocument(null, (Object)input, document, true);
                        document.replace(0, 0, "");
                    }
                    path = ((NonExistingPHPFileEditorInput)input).getPath((Object)input);
                }
                if (path != null && (systemFile = new File(path.toOSString())).exists()) {
                    PHPExeLaunchShortcut.searchAndLaunch(new Object[]{systemFile}, mode, this.getPHPExeLaunchConfigType());
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        } else {
            PHPExeLaunchShortcut.searchAndLaunch(new Object[]{file}, mode, this.getPHPExeLaunchConfigType());
        }
    }

    protected ILaunchConfigurationType getPHPExeLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");
    }

    public static void searchAndLaunch(Object[] search, String mode, ILaunchConfigurationType configType) {
        int entries = search == null ? 0 : search.length;
        int i = 0;
        while (i < entries) {
            block17: {
                try {
                    String phpExeName;
                    String phpPathString = null;
                    String phpFileLocation = null;
                    IProject project = null;
                    Object obj = search[i];
                    IFile res = null;
                    if (obj instanceof IModelElement) {
                        IModelElement elem = (IModelElement)obj;
                        if (elem instanceof ISourceModule) {
                            res = ((ISourceModule)elem).getCorrespondingResource();
                        } else if (elem instanceof IType) {
                            res = ((IType)elem).getUnderlyingResource();
                        } else if (elem instanceof IMethod) {
                            res = ((IMethod)elem).getUnderlyingResource();
                        }
                        if (res instanceof IFile) {
                            obj = res;
                        }
                    }
                    if (obj instanceof IFile) {
                        IFile file;
                        res = file = (IFile)obj;
                        project = file.getProject();
                        IContentType contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                        if (contentType.isAssociatedWith(file.getName())) {
                            phpPathString = new File(file.getFullPath().toOSString()).exists() ? file.getFullPath().toOSString() : file.getFullPath().toString();
                            IPath location = file.getLocation();
                            phpFileLocation = location != null ? location.toOSString() : file.getFullPath().toString();
                        }
                    } else if (obj instanceof File) {
                        File systemFile = (File)obj;
                        phpFileLocation = phpPathString = systemFile.getAbsolutePath();
                    }
                    if (phpPathString == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                    }
                    PHPexeItem bestMatchExe = PHPExeLaunchShortcut.getBestMatchPHPExe(project);
                    String string = phpExeName = bestMatchExe != null ? bestMatchExe.getExecutable().getAbsolutePath().toString() : null;
                    if (phpExeName == null) {
                        MessageDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_noexe_msg_title, (String)PHPDebugUIMessages.launch_noexe_msg_text);
                        PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)"org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage", null, null).open();
                        return;
                    }
                    ILaunchConfiguration config = PHPExeLaunchShortcut.findLaunchConfiguration(project, phpPathString, phpFileLocation, bestMatchExe, mode, configType, (IResource)res);
                    if (config != null) {
                        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
                        break block17;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_config, null));
                }
                catch (CoreException ce) {
                    final IStatus stat = ce.getStatus();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_exec_msg_text, (IStatus)stat);
                        }
                    });
                }
            }
            ++i;
        }
    }

    private static PHPexeItem getBestMatchPHPExe(IProject project) {
        PHPexeItem defaultItem = PHPDebugPlugin.getPHPexeItem((IProject)project);
        if (defaultItem == null) {
            defaultItem = PHPDebugPlugin.getWorkspaceDefaultExe();
        }
        PHPVersion phpVersion = ProjectOptions.getPhpVersion((IProject)project);
        PHPexeItem[] matchingItems = PHPexes.getInstance().getCompatibleItems(PHPexes.getInstance().getAllItems(), phpVersion);
        if (Arrays.asList(matchingItems).contains(defaultItem)) {
            return defaultItem;
        }
        if (matchingItems.length > 0) {
            return matchingItems[0];
        }
        return defaultItem;
    }

    private static IScopeContext[] createPreferenceScopes(IProject project) {
        if (project != null) {
            return new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        }
        return new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    }

    protected static ILaunchConfiguration findLaunchConfiguration(IProject phpProject, String phpPathString, String phpFileFullLocation, PHPexeItem bestMatchExe, String mode, ILaunchConfigurationType configType, IResource res) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int numConfigs = configs == null ? 0 : configs.length;
            int i = 0;
            while (i < numConfigs) {
                String fileName = configs[i].getAttribute("ATTR_FILE", null);
                String exeName = configs[i].getAttribute("ATTR_LOCATION", null);
                String iniPath = configs[i].getAttribute("ATTR_INI_LOCATION", null);
                PHPexes.getInstance().getItemForFile(exeName, iniPath);
                if (phpPathString.equals(fileName)) {
                    config = configs[i];
                    break;
                }
                ++i;
            }
            if (config == null) {
                config = PHPExeLaunchShortcut.createConfiguration(phpProject, phpPathString, phpFileFullLocation, bestMatchExe, configType, res);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return config;
    }

    protected static ILaunchConfiguration createConfiguration(IProject phpProject, String phpPathString, String phpFileFullLocation, PHPexeItem bestMatchExe, ILaunchConfigurationType configType, IResource res) throws CoreException {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, PHPExeLaunchShortcut.getNewConfigurationName(phpPathString));
        wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, bestMatchExe.getDebuggerID());
        AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)bestMatchExe.getDebuggerID());
        wc.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getScriptLaunchDelegateClass());
        wc.setAttribute("ATTR_FILE", phpPathString);
        wc.setAttribute("ATTR_FILE_FULL_PATH", phpFileFullLocation);
        wc.setAttribute("ATTR_LOCATION", bestMatchExe.getExecutable().getAbsolutePath().toString());
        if (!bestMatchExe.isDefault()) {
            wc.setAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", PHPRuntime.newPHPContainerPath((PHPexeItem)bestMatchExe).toPortableString());
        }
        String iniPath = bestMatchExe.getINILocation() != null ? bestMatchExe.getINILocation().toString() : null;
        wc.setAttribute("ATTR_INI_LOCATION", iniPath);
        wc.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
        wc.setAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine((IProject)phpProject));
        if (res != null) {
            wc.setMappedResources(new IResource[]{res});
        }
        config = wc.doSave();
        return config;
    }

    protected static String getNewConfigurationName(String fileName) {
        String configurationName = PHPDebugUIMessages.PHPExeLaunchShortcut_0;
        try {
            IPath path = Path.fromOSString((String)fileName);
            NonExistingPHPFileEditorInput editorInput = NonExistingPHPFileEditorInput.findEditorInput((IPath)path);
            if (editorInput != null) {
                path = new Path(editorInput.getName());
            }
            String fileExtention = path.getFileExtension();
            String lastSegment = path.lastSegment();
            if (lastSegment != null) {
                if (fileExtention != null) {
                    lastSegment = lastSegment.replaceFirst("." + fileExtention, "");
                }
                configurationName = lastSegment;
            }
        }
        catch (Exception e) {
            Logger.log(202, "Could not generate configuration name for " + fileName + ".\nThe default name will be used.", e);
        }
        return DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configurationName);
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return this.getLaunchableResource((IAdaptable)editorpart.getEditorInput());
    }

    public IResource getLaunchableResource(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
            return this.getLaunchableResource((IAdaptable)element);
        }
        return null;
    }

    private IResource getLaunchableResource(IAdaptable adaptable) {
        IModelElement je = (IModelElement)adaptable.getAdapter(IModelElement.class);
        if (je != null) {
            return je.getResource();
        }
        return null;
    }
}

