/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.rename.RenameClassMemberProcessor;
import org.eclipse.php.refactoring.core.rename.RenameClassMemberProcessorTest;
import org.eclipse.php.refactoring.core.test.PdttFileExt;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class RenameTraitMemberProcessorTest
extends RenameClassMemberProcessorTest {
    @PDTTList.Parameters
    public static String[] dirs = new String[]{"/resources/rename/renameTraitMember/"};

    public RenameTraitMemberProcessorTest(String[] fileNames) {
        super(fileNames);
    }

    @Override
    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        PHPCoreTests.setProjectPhpVersion((IProject)this.project.getProject(), (PHPVersion)PHPVersion.PHP5_4);
    }

    @Test
    public void test(String fileName) throws Exception {
        PdttFileExt testFile = (PdttFileExt)((Object)this.filesMap.get(fileName));
        IFile file = this.project.findFile(testFile.getTestFiles().get(0).getName());
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = Integer.valueOf((String)testFile.getConfig().get("start"));
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        RenameClassMemberProcessor processor = new RenameClassMemberProcessor(file, selectedNode);
        processor.setNewElementName((String)testFile.getConfig().get("newName"));
        processor.setUpdateTextualMatches(Boolean.valueOf((String)testFile.getConfig().get("updateTextualMatches")).booleanValue());
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        this.checkTestResult(testFile);
    }
}

