/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.test;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.test.Activator;
import org.eclipse.php.refactoring.core.test.FileInfo;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.eclipse.php.refactoring.core.test.PdttFileExt;
import org.eclipse.php.refactoring.core.test.TestProject;
import org.eclipse.php.refactoring.core.utils.ASTUtils;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public abstract class AbstractRefactoringTest {
    protected String[] fileNames = null;
    protected static final char OFFSET_CHAR = '|';
    protected TestProject project;
    protected Map<String, PdttFileExt> filesMap = new LinkedHashMap<String, PdttFileExt>();

    public AbstractRefactoringTest() {
    }

    protected AbstractRefactoringTest(String[] fileNames) {
        this.fileNames = fileNames;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = this.getProject();
        this.initFiles(this.fileNames);
    }

    protected void initFiles(String[] fileNames) throws Exception {
        this.project = this.getProject();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            PdttFileExt pdttFile = new PdttFileExt(AbstractRefactoringTest.getBundle(), fileName);
            for (FileInfo testFile : pdttFile.getTestFiles()) {
                this.project.createFile(testFile.getName(), this.getContents(pdttFile, testFile));
            }
            this.filesMap.put(fileName, pdttFile);
            ++n2;
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    private String getContents(PdttFileExt pdttFile, FileInfo testFile) {
        String data = testFile.getContents();
        int offset = data.lastIndexOf(124);
        if (offset < 0) {
            return data;
        }
        pdttFile.getConfig().put("start", String.valueOf(offset));
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        return data;
    }

    protected TestProject getProject() {
        return new TestProject("Refactoring");
    }

    @PDTTList.AfterList
    public void tearDown() throws Exception {
        this.project.delete();
    }

    protected Program createProgram(IFile file) throws Exception {
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
        Program program = null;
        program = ASTUtils.createProgramFromSource((ISourceModule)sourceModule);
        return program;
    }

    protected IFile createFile(String name, String content) {
        IFile file = null;
        try {
            file = this.project.createFile(name, content);
        }
        catch (CoreException e2) {
            Assert.fail((String)e2.getMessage());
        }
        Assert.assertNotNull((Object)file);
        return file;
    }

    protected void performChange(RefactoringProcessor processor) {
        try {
            Change change = processor.createChange((IProgressMonitor)new NullProgressMonitor());
            if (change != null) {
                change.perform((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    protected void checkInitCondition(RefactoringProcessor processor) {
        try {
            RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((long)0L, (long)status.getSeverity());
        }
        catch (OperationCanceledException e1) {
            Assert.fail((String)e1.getMessage());
        }
        catch (CoreException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }

    protected void checkFinalCondition(RefactoringProcessor processor) {
        try {
            RefactoringStatus status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
            Assert.assertNotSame((Object)4, (Object)status.getSeverity());
        }
        catch (OperationCanceledException e1) {
            Assert.fail((String)e1.getMessage());
        }
        catch (CoreException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }

    protected void performChange(Refactoring processor) {
        try {
            Change change = processor.createChange((IProgressMonitor)new NullProgressMonitor());
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected void checkInitCondition(Refactoring processor) {
        try {
            RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((long)0L, (long)status.getSeverity());
        }
        catch (OperationCanceledException e1) {
            Assert.fail((String)e1.getMessage());
        }
        catch (CoreException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }

    protected void checkTestResult(PdttFileExt pdttFile) {
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        List<FileInfo> files = pdttFile.getExpectedFiles();
        for (FileInfo expFile : files) {
            IFile file = this.project.findFile(expFile.getName());
            Assert.assertTrue((boolean)file.exists());
            try {
                PDTTUtils.assertContents((String)this.getContents(pdttFile, expFile), (String)FileUtils.getContents(file));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    public static IStructuredModel createUnManagedStructuredModelFor(IFile file) throws IOException, CoreException {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(file);
        }
        catch (Exception exception) {
            try {
                Thread.sleep(3000L);
                model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(file);
            }
            catch (InterruptedException e1) {
                Assert.fail((String)e1.getMessage());
            }
        }
        return model;
    }
}

