/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.tests.PHPCoreTests;

public class TestProject {
    IProject project;

    public TestProject() {
        this("TestProject");
    }

    public TestProject(String name) {
        this.createProject(name);
    }

    private void createProject(String name) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (this.project.exists()) {
            return;
        }
        try {
            this.project.create(null);
            this.project.open(128, (IProgressMonitor)new NullProgressMonitor());
            IProjectDescription desc = this.project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
            this.project.setDescription(desc, null);
            this.project.refreshLocal(2, null);
            this.project.build(6, null);
            PHPCoreTests.waitForIndexer();
            PHPCoreTests.waitForAutoBuild();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean exists() {
        return this.project != null && this.project.exists();
    }

    public IProject getProject() {
        return this.project;
    }

    public void delete() throws Exception {
        if (this.project != null && this.project.exists()) {
            this.project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public IFile createFile(String path, String content) throws CoreException {
        Path filePath = new Path(path);
        if (filePath.segmentCount() > 1) {
            this.createFolder(filePath.removeLastSegments(1));
        }
        if (this.project != null) {
            ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
            IFile file = this.project.getFile(path);
            if (!file.exists()) {
                file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
            }
            return file;
        }
        return null;
    }

    private IFolder createFolder(IPath path) throws CoreException {
        if (this.project != null) {
            IFolder folder = this.project.getFolder(path);
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            return folder;
        }
        return null;
    }

    public IFile findFile(String path) {
        if (this.project != null) {
            return this.project.getFile(path);
        }
        return null;
    }

    public IFolder createFolder(String path) throws CoreException {
        if (this.project != null) {
            IFolder folder = this.project.getFolder(path);
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            return folder;
        }
        return null;
    }
}

