/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.code.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.refactoring.core.code.flow.BlockFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.BranchFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.ConditionalFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.DoWhileFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.EnhancedForFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.FlowContext;
import org.eclipse.php.refactoring.core.code.flow.FlowInfo;
import org.eclipse.php.refactoring.core.code.flow.ForFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.GenericSequentialFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.IfFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.LocalFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.MessageSendFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.ReturnFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.SwitchFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.ThrowFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.TryFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.WhileFlowInfo;

abstract class FlowAnalyzer
extends ApplyAll {
    private HashMap<ASTNode, FlowInfo> fData = new HashMap(100);
    FlowContext fFlowContext = null;

    public FlowAnalyzer(FlowContext context) {
        this.fFlowContext = context;
    }

    protected abstract boolean createReturnFlowInfo(ReturnStatement var1);

    protected abstract boolean traverseNode(ASTNode var1);

    protected boolean skipNode(ASTNode node) {
        return !this.traverseNode(node);
    }

    protected final boolean apply(ASTNode node) {
        return this.traverseNode(node);
    }

    protected ReturnFlowInfo createReturn(ReturnStatement statement) {
        return new ReturnFlowInfo(statement);
    }

    protected ThrowFlowInfo createThrow() {
        return new ThrowFlowInfo();
    }

    protected BranchFlowInfo createBranch(Identifier label) {
        return new BranchFlowInfo(label, this.fFlowContext);
    }

    protected GenericSequentialFlowInfo createSequential() {
        return new GenericSequentialFlowInfo();
    }

    protected ConditionalFlowInfo createConditional() {
        return new ConditionalFlowInfo();
    }

    protected EnhancedForFlowInfo createEnhancedFor() {
        return new EnhancedForFlowInfo();
    }

    protected ForFlowInfo createFor() {
        return new ForFlowInfo();
    }

    protected TryFlowInfo createTry() {
        return new TryFlowInfo();
    }

    protected WhileFlowInfo createWhile() {
        return new WhileFlowInfo();
    }

    protected IfFlowInfo createIf() {
        return new IfFlowInfo();
    }

    protected DoWhileFlowInfo createDoWhile() {
        return new DoWhileFlowInfo();
    }

    protected SwitchFlowInfo createSwitch() {
        return new SwitchFlowInfo();
    }

    protected BlockFlowInfo createBlock() {
        return new BlockFlowInfo();
    }

    protected MessageSendFlowInfo createMessageSendFlowInfo() {
        return new MessageSendFlowInfo();
    }

    protected FlowContext getFlowContext() {
        return this.fFlowContext;
    }

    protected FlowInfo getFlowInfo(ASTNode node) {
        return this.fData.remove(node);
    }

    protected void setFlowInfo(ASTNode node, FlowInfo info) {
        this.fData.put(node, info);
    }

    protected FlowInfo assignFlowInfo(ASTNode target, ASTNode source) {
        FlowInfo result = this.getFlowInfo(source);
        this.setFlowInfo(target, result);
        return result;
    }

    protected FlowInfo accessFlowInfo(ASTNode node) {
        return this.fData.get(node);
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode parent, List nodes) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        this.process(result, nodes);
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode parent, ASTNode node1) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node1 != null) {
            result.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode parent, ASTNode node1, ASTNode node2) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node1 != null) {
            result.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        if (node2 != null) {
            result.merge(this.getFlowInfo(node2), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo createSequential(ASTNode parent) {
        GenericSequentialFlowInfo result = this.createSequential();
        this.setFlowInfo(parent, result);
        return result;
    }

    protected GenericSequentialFlowInfo createSequential(List nodes) {
        GenericSequentialFlowInfo result = this.createSequential();
        this.process(result, nodes);
        return result;
    }

    protected void process(GenericSequentialFlowInfo info, List nodes) {
        if (nodes == null) {
            return;
        }
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            info.merge(this.getFlowInfo((ASTNode)iter.next()), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo info, ASTNode node) {
        if (node != null) {
            info.merge(this.getFlowInfo(node), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo info, ASTNode node1, ASTNode node2) {
        if (node1 != null) {
            info.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        if (node2 != null) {
            info.merge(this.getFlowInfo(node2), this.fFlowContext);
        }
    }

    public boolean visit(EmptyStatement node) {
        return false;
    }

    public boolean visit(TryStatement node) {
        if (this.traverseNode((ASTNode)node)) {
            this.fFlowContext.pushExcptions(node);
            node.getBody().accept((Visitor)this);
            this.fFlowContext.popExceptions();
            List catchClauses = node.catchClauses();
            for (CatchClause catchClause : catchClauses) {
                catchClause.accept((Visitor)this);
            }
        }
        return false;
    }

    protected SwitchData createSwitchData(SwitchStatement node) {
        SwitchData result = new SwitchData();
        List statements = node.getBody().statements();
        if (statements.isEmpty()) {
            return result;
        }
        int start = -1;
        int end = -1;
        GenericSequentialFlowInfo info = null;
        for (Statement statement : statements) {
            if (statement instanceof SwitchCase) {
                SwitchCase switchCase = (SwitchCase)statement;
                if (switchCase.isDefault()) {
                    result.setHasDefaultCase();
                }
                if (info == null) {
                    info = this.createSequential();
                    start = statement.getStart();
                } else if (info.isReturn() || info.isPartialReturn() || info.branches()) {
                    result.add((IRegion)new Region(start, end - start + 1), info);
                    info = this.createSequential();
                    start = statement.getStart();
                }
            } else {
                info.merge(this.getFlowInfo((ASTNode)statement), this.fFlowContext);
            }
            end = statement.getEnd() - 1;
        }
        result.add((IRegion)new Region(start, end - start + 1), info);
        return result;
    }

    public void endVisit(ArrayAccess node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getName(), (ASTNode)node.getIndex());
    }

    public void endVisit(ArrayCreation node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.elements());
    }

    public void endVisit(ArrayElement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getKey(), (ASTNode)node.getValue());
    }

    public void endVisit(Assignment node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowInfo lhs = this.getFlowInfo((ASTNode)node.getLeftHandSide());
        FlowInfo rhs = this.getFlowInfo((ASTNode)node.getRightHandSide());
        if (lhs instanceof LocalFlowInfo) {
            LocalFlowInfo llhs = (LocalFlowInfo)lhs;
            llhs.setWriteAccess(this.fFlowContext);
            if (node.getOperator() != 0) {
                GenericSequentialFlowInfo tmp = this.createSequential();
                tmp.merge(new LocalFlowInfo(llhs, 2, this.fFlowContext), this.fFlowContext);
                tmp.merge(rhs, this.fFlowContext);
                rhs = tmp;
            }
        }
        GenericSequentialFlowInfo info = this.createSequential((ASTNode)node);
        info.merge(rhs, this.fFlowContext);
        info.merge(lhs, this.fFlowContext);
    }

    public void endVisit(BackTickExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.expressions());
    }

    public void endVisit(Block node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        BlockFlowInfo info = this.createBlock();
        this.setFlowInfo((ASTNode)node, info);
        this.process((GenericSequentialFlowInfo)info, node.statements());
    }

    public void endVisit(BreakStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(CastExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(CatchClause node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getVariable(), (ASTNode)node.getBody());
    }

    public void endVisit(ConstantDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.names());
        this.process(info, node.initializers());
    }

    public void endVisit(ClassDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getName());
        this.process(info, (ASTNode)node.getSuperClass());
        this.process(info, node.interfaces());
        this.process(info, (ASTNode)node.getBody());
    }

    public void endVisit(ClassInstanceCreation node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getClassName());
        this.process(info, node.ctorParams());
    }

    public void endVisit(ClassName node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getName());
    }

    public void endVisit(CloneExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(Comment node) {
    }

    public void endVisit(ConditionalExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        ConditionalFlowInfo info = this.createConditional();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getCondition()), this.fFlowContext);
        info.merge(this.getFlowInfo((ASTNode)node.getIfTrue()), this.getFlowInfo((ASTNode)node.getIfFalse()), this.fFlowContext);
    }

    public void endVisit(ContinueStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(DeclareStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.directiveNames());
        this.process(info, node.directiveValues());
        this.process(info, (ASTNode)node.getBody());
    }

    public void endVisit(DoStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        DoWhileFlowInfo info = this.createDoWhile();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getCondition()), this.fFlowContext);
        info.removeLabel(null);
    }

    public void endVisit(EchoStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.expressions());
    }

    public void endVisit(EmptyStatement node) {
    }

    public void endVisit(ExpressionStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(FieldAccess node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getField(), (ASTNode)node.getField().getName());
    }

    public void endVisit(FieldsDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.fields());
    }

    public void endVisit(ForEachStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getExpression());
        this.process(info, (ASTNode)node.getKey());
        this.process(info, (ASTNode)node.getValue());
        this.process(info, (ASTNode)node.getStatement());
    }

    public void endVisit(FormalParameter node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getParameterType());
        this.process(info, (ASTNode)node.getParameterName());
        this.process(info, (ASTNode)node.getDefaultValue());
    }

    public void endVisit(ForStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        ForFlowInfo forInfo = this.createFor();
        this.setFlowInfo((ASTNode)node, forInfo);
        forInfo.mergeInitializer(this.createSequential(node.initializers()), this.fFlowContext);
        forInfo.mergeCondition(this.createSequential(node.conditions()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        forInfo.mergeIncrement(this.createSequential(node.updaters()), this.fFlowContext);
        forInfo.removeLabel(null);
    }

    public void endVisit(FunctionDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.formalParameters());
        this.process(info, (ASTNode)node.getBody());
    }

    public void endVisit(FunctionInvocation node) {
        this.endVisitFunctionInvocation((ASTNode)node, node.parameters(), this.getMethodBinding(node));
    }

    public void endVisit(FunctionName node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getName());
    }

    public void endVisit(GlobalStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.variables());
    }

    public void endVisit(Identifier node) {
    }

    public void endVisit(IfStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        IfFlowInfo info = this.createIf();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getCondition()), this.fFlowContext);
        info.merge(this.getFlowInfo((ASTNode)node.getTrueStatement()), this.getFlowInfo((ASTNode)node.getFalseStatement()), this.fFlowContext);
    }

    public void endVisit(Include node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(InfixExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getLeft(), (ASTNode)node.getRight());
    }

    public void endVisit(InLineHtml node) {
    }

    public void endVisit(InterfaceDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getName());
        this.process(info, node.interfaces());
        this.process(info, (ASTNode)node.getBody());
    }

    public void endVisit(InstanceOfExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getExpression(), (ASTNode)node.getClassName());
    }

    public void endVisit(MethodDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getFunction().formalParameters());
        this.process(info, (ASTNode)node.getFunction().getBody());
    }

    public void endVisit(MethodInvocation node) {
        this.endVisitMethodInvocation((ASTNode)node, (ASTNode)node.getDispatcher(), node.getMethod().parameters(), this.getMethodBinding(node.getMethod()));
    }

    public void endVisit(ParenthesisExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(PostfixExpression node) {
        this.endVisitIncDecOperation((Expression)node, (Expression)node.getVariable());
    }

    public void endVisit(PrefixExpression node) {
        this.endVisitIncDecOperation((Expression)node, node.getVariable());
    }

    public void endVisit(Program node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.statements());
    }

    public void endVisit(Quote node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.expressions());
    }

    public void endVisit(Reference node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(ReflectionVariable node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getName());
    }

    public void endVisit(ReturnStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        if (this.createReturnFlowInfo(node)) {
            ReturnFlowInfo info = this.createReturn(node);
            this.setFlowInfo((ASTNode)node, info);
            info.merge(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        } else {
            this.assignFlowInfo((ASTNode)node, (ASTNode)node.getExpression());
        }
    }

    public void endVisit(Scalar node) {
    }

    public void endVisit(SingleFieldDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getName());
    }

    public void endVisit(StaticConstantAccess node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getClassName());
        this.process(info, (ASTNode)node.getConstant());
    }

    public void endVisit(StaticFieldAccess node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getClassName());
        this.process(info, (ASTNode)node.getField());
    }

    public void endVisit(StaticMethodInvocation node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getClassName());
        this.process(info, (ASTNode)node.getMethod());
    }

    public void endVisit(StaticStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.expressions());
    }

    public void endVisit(SwitchCase node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getValue());
        this.process(info, node.actions());
    }

    public void endVisit(SwitchStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.endVisit(node, this.createSwitchData(node));
    }

    protected void endVisit(SwitchStatement node, SwitchData data) {
        SwitchFlowInfo switchFlowInfo = this.createSwitch();
        this.setFlowInfo((ASTNode)node, switchFlowInfo);
        switchFlowInfo.mergeTest(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        FlowInfo[] cases = data.getInfos();
        int i = 0;
        while (i < cases.length) {
            switchFlowInfo.mergeCase(cases[i], this.fFlowContext);
            ++i;
        }
        switchFlowInfo.mergeDefault(data.hasDefaultCase(), this.fFlowContext);
        switchFlowInfo.removeLabel(null);
    }

    public void endVisit(ThrowStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        ThrowFlowInfo info = this.createThrow();
        this.setFlowInfo((ASTNode)node, info);
        Expression expression = node.getExpression();
        info.merge(this.getFlowInfo((ASTNode)expression), this.fFlowContext);
        info.mergeException(expression.resolveTypeBinding(), this.fFlowContext);
    }

    public void endVisit(TryStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        TryFlowInfo info = this.createTry();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeTry(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        info.removeExceptions(node);
        List catchClauses = node.catchClauses();
        for (CatchClause catchClause : catchClauses) {
            info.mergeCatch(this.getFlowInfo((ASTNode)catchClause), this.fFlowContext);
        }
    }

    public void endVisit(UnaryOperation node) {
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(Variable node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        IVariableBinding binding = node.resolveVariableBinding();
        if (binding != null && !binding.isField()) {
            this.setFlowInfo((ASTNode)node, new LocalFlowInfo(binding, 2, this.fFlowContext));
        }
    }

    public void endVisit(WhileStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        WhileFlowInfo info = this.createWhile();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getCondition()), this.fFlowContext);
        info.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        info.removeLabel(null);
    }

    private void endVisitMethodInvocation(ASTNode node, ASTNode receiver, List arguments, IFunctionBinding binding) {
        if (this.skipNode(node)) {
            return;
        }
        MessageSendFlowInfo info = this.createMessageSendFlowInfo();
        this.setFlowInfo(node, info);
        for (Expression arg : arguments) {
            info.mergeArgument(this.getFlowInfo((ASTNode)arg), this.fFlowContext);
        }
        info.mergeReceiver(this.getFlowInfo(receiver), this.fFlowContext);
    }

    private void endVisitFunctionInvocation(ASTNode node, List arguments, IFunctionBinding binding) {
        if (this.skipNode(node)) {
            return;
        }
        MessageSendFlowInfo info = this.createMessageSendFlowInfo();
        this.setFlowInfo(node, info);
        for (Expression arg : arguments) {
            info.mergeArgument(this.getFlowInfo((ASTNode)arg), this.fFlowContext);
        }
    }

    private void endVisitIncDecOperation(Expression node, Expression operand) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowInfo info = this.getFlowInfo((ASTNode)operand);
        if (info instanceof LocalFlowInfo) {
            GenericSequentialFlowInfo result = this.createSequential((ASTNode)node);
            result.merge(info, this.fFlowContext);
            result.merge(new LocalFlowInfo((LocalFlowInfo)info, 8, this.fFlowContext), this.fFlowContext);
        } else {
            this.setFlowInfo((ASTNode)node, info);
        }
    }

    private IFunctionBinding getMethodBinding(FunctionInvocation function) {
        if (function == null) {
            return null;
        }
        IFunctionBinding binding = function.resolveFunctionBinding();
        if (binding instanceof IFunctionBinding) {
            return (IMethodBinding)binding;
        }
        return null;
    }

    protected static class SwitchData {
        private boolean fHasDefaultCase;
        private List<IRegion> fRanges = new ArrayList<IRegion>(4);
        private List<FlowInfo> fInfos = new ArrayList<FlowInfo>(4);

        protected SwitchData() {
        }

        public void setHasDefaultCase() {
            this.fHasDefaultCase = true;
        }

        public boolean hasDefaultCase() {
            return this.fHasDefaultCase;
        }

        public void add(IRegion range, FlowInfo info) {
            this.fRanges.add(range);
            this.fInfos.add(info);
        }

        public IRegion[] getRanges() {
            return this.fRanges.toArray(new IRegion[this.fRanges.size()]);
        }

        public FlowInfo[] getInfos() {
            return this.fInfos.toArray(new FlowInfo[this.fInfos.size()]);
        }

        public FlowInfo getInfo(int index) {
            return this.fInfos.get(index);
        }
    }
}

