/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.logic.AbstractRename;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RenameIncludeFolder
extends AbstractRename {
    private boolean updateReference;
    private IPath folderPath;

    public RenameIncludeFolder(IFile file, String oldName, String newName, IPath folderPath, boolean searchTextual, boolean updateReference) {
        super(file, oldName, newName, searchTextual);
        this.updateReference = updateReference;
        this.folderPath = folderPath;
    }

    public boolean visit(Include include) {
        if (this.updateReference) {
            Expression object;
            Expression exp = include.getExpression();
            Scalar scalar = null;
            if (exp instanceof ParenthesisExpression && (object = ((ParenthesisExpression)exp).getExpression()) instanceof Scalar) {
                scalar = (Scalar)object;
            }
            if (exp instanceof Scalar) {
                scalar = (Scalar)exp;
            }
            if (scalar == null) {
                return super.visit(include);
            }
            if (this.isScalarNeedChange(scalar)) {
                String includeString = scalar.getStringValue();
                int len = 0;
                if (includeString.startsWith("\"") || includeString.startsWith("'")) {
                    includeString = includeString.substring(1, includeString.length() - 1);
                    len = 1;
                }
                if (includeString.startsWith(".")) {
                    Path path = new Path(includeString);
                    if (!path.isAbsolute()) {
                        path = this.changedFile.getParent().getFullPath().append((IPath)path);
                    }
                    String lastString = path.makeRelativeTo(this.folderPath).toString();
                    len = len + includeString.indexOf(lastString) - this.oldName.length() - 1;
                    this.addChange(scalar.getStart() + len, PhpRefactoringCoreMessages.getString("RenameIncludeAndClassName.1"));
                } else {
                    IPath path = this.getPath(includeString);
                    String lastString = path.makeRelativeTo(this.folderPath).toString();
                    if (!lastString.equalsIgnoreCase(includeString)) {
                        len = len + includeString.indexOf(lastString) - this.oldName.length() - 1;
                        this.addChange(scalar.getStart() + len, PhpRefactoringCoreMessages.getString("RenameIncludeAndClassName.1"));
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected void addChange(int start, String description) {
        TextEditGroup textEditGroup = new TextEditGroup(description);
        ReplaceEdit replaceEdit = new ReplaceEdit(start, this.oldName.length(), this.newName);
        textEditGroup.addTextEdit((TextEdit)replaceEdit);
        this.groups.add(textEditGroup);
    }

    private boolean isScalarNeedChange(Scalar scalar) {
        String includeString = scalar.getStringValue();
        boolean needChange = false;
        IPath path = this.getPath(includeString);
        if (path != null && this.changedFile.getWorkspace().getRoot().getFile(path).exists() && this.folderPath.isPrefixOf(path)) {
            if ((includeString.startsWith("'./") || includeString.startsWith("'../") || includeString.indexOf("/") == -1 && includeString.indexOf("\\") == -1) && this.folderPath.isPrefixOf(this.changedFile.getFullPath())) {
                needChange = false;
            } else {
                IPath relPath = path.makeRelativeTo(this.folderPath);
                String relativePath = relPath.toString();
                if (relativePath.length() != includeString.length()) {
                    needChange = true;
                }
            }
        }
        return scalar.getScalarType() == 2 && needChange;
    }

    private IPath getPath(String includeString) {
        if (includeString.startsWith("\"") || includeString.startsWith("'")) {
            includeString = includeString.substring(1, includeString.length() - 1);
        }
        Path path = null;
        if (includeString.startsWith(".")) {
            path = new Path(includeString);
            if (!path.isAbsolute()) {
                path = this.changedFile.getParent().getFullPath().append((IPath)path);
            }
        } else {
            ISourceModule findSourceModule = FileNetworkUtility.findSourceModule((ISourceModule)DLTKCore.createSourceModuleFrom((IFile)this.changedFile), (String)includeString);
            if (findSourceModule != null) {
                path = findSourceModule.getPath();
            }
        }
        return path;
    }

    @Override
    public String getRenameDescription() {
        return PhpRefactoringCoreMessages.getString("RenameIncludeFolder.4");
    }
}

