/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.document.partitioner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PHPPartitionerTests {
    private static final String PROJECT_NAME = "partitioner";
    private static final String[] phpLookUp = new String[]{"php", "echo", "PHP_Single_Comment", "PHP_Multi_Comment", "PHP_Doc", "Test quoted string partition", "1 F d, Y", "Running test", "$num"};
    protected static IProject project;
    protected static IFile testFile;

    public File getSourceWorkspacePath() {
        return new File(this.getPluginDirectoryPath(), "workspace");
    }

    protected File getPluginDirectoryPath() {
        try {
            URL platformURL = Platform.getBundle((String)"org.eclipse.php.core.tests").getEntry("/");
            return new File(FileLocator.toFileURL((URL)platformURL).getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return PHPPartitionerTests.getWorkspace().getRoot();
    }

    protected void copyDirectory(File source, File target) throws IOException {
        File[] files;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((files = source.listFiles()) == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File sourceChild = files[i];
            String name = sourceChild.getName();
            if (!name.equals("CVS") && !name.equals(".svn")) {
                File targetChild = new File(target, name);
                if (sourceChild.isDirectory()) {
                    this.copyDirectory(sourceChild, targetChild);
                } else {
                    PHPPartitionerTests.copy(sourceChild, targetChild);
                }
            }
            ++i;
        }
    }

    public static void copy(File src, File dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        byte[] buffer = new byte[12288];
        try {
            in = new FileInputStream(src);
            try {
                int read;
                out = new FileOutputStream(dest);
                while ((read = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        File sourceWorkspacePath = this.getSourceWorkspacePath();
        File targetWorkspacePath = PHPPartitionerTests.getWorkspaceRoot().getLocation().toFile();
        this.copyDirectory(new File(sourceWorkspacePath, PROJECT_NAME), new File(targetWorkspacePath, PROJECT_NAME));
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
    }

    @After
    public void tearDown() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    @Test
    public void partitionInHTML() throws Exception {
        ArrayList<String> matches = this.getPartitionType(phpLookUp, "phpPartitionerTestHTML.php");
        int i = 0;
        while (i < matches.size()) {
            Assert.assertSame((Object)"org.eclipse.php.PHP_DEFAULT", (Object)matches.get(i));
            ++i;
        }
    }

    @Test
    public void partitionStandalone() throws Exception {
        ArrayList<String> matches = this.getPartitionType(phpLookUp, "phpPartitionerTestPhp.php");
        int i = 0;
        while (i < matches.size()) {
            Assert.assertSame((Object)"org.eclipse.php.PHP_DEFAULT", (Object)matches.get(i));
            ++i;
        }
    }

    @Test
    public void partitionPhpAsHTMLAttributeKey() throws Exception {
        ArrayList<String> matches = this.getPartitionType(phpLookUp, "phpPartitionerTestPhpAsHTMLAttributeKey.php");
        int i = 0;
        while (i < matches.size()) {
            Assert.assertSame((Object)"org.eclipse.php.PHP_DEFAULT", (Object)matches.get(i));
            ++i;
        }
    }

    @Test
    public void partitionPhpAsHTMLAttributeValue() throws Exception {
        ArrayList<String> matches = this.getPartitionType(phpLookUp, "phpPartitionerTestPhpAsHTMLAttributeValue.php");
        int i = 0;
        while (i < matches.size()) {
            Assert.assertSame((Object)"org.eclipse.php.PHP_DEFAULT", (Object)matches.get(i));
            ++i;
        }
    }

    private ArrayList<String> getPartitionType(String[] markers, String testDataFile) throws Exception {
        int offset = 0;
        ArrayList<String> results = new ArrayList<String>();
        IFile inFile = project.getFile(testDataFile);
        InputStreamReader inStream = new InputStreamReader(inFile.getContents());
        BufferedReader reader = new BufferedReader(inStream);
        IStructuredModel modelForEdit = StructuredModelManager.getModelManager().getModelForEdit(inFile);
        try {
            IStructuredDocument structuredDocument = modelForEdit.getStructuredDocument();
            PHPStructuredTextPartitioner structuredTextPartitioner = new PHPStructuredTextPartitioner();
            structuredTextPartitioner.connect((IDocument)structuredDocument);
            String curLine = reader.readLine();
            int lineNumber = 0;
            while (curLine != null) {
                int i = 0;
                while (i < markers.length) {
                    int lineOffset = curLine.indexOf(markers[i]);
                    if (lineOffset != -1) {
                        ITypedRegion partition = structuredTextPartitioner.getPartition(offset + lineOffset);
                        results.add(partition.getType());
                    }
                    ++i;
                }
                String curLineDelimiter = structuredDocument.getLineDelimiter(lineNumber);
                offset += curLine.length() + (curLineDelimiter != null ? curLineDelimiter.length() : 0);
                curLine = reader.readLine();
                ++lineNumber;
            }
        }
        finally {
            reader.close();
            if (modelForEdit != null) {
                modelForEdit.releaseFromEdit();
            }
        }
        return results;
    }
}

