/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;

public class Bindings {
    public static final String ARRAY_LENGTH_FIELD_BINDING_STRING = "(array type):length";

    private Bindings() {
    }

    public static int hashCode(IBinding binding) {
        Assert.isNotNull((Object)binding);
        String key = binding.getKey();
        if (key == null) {
            return binding.hashCode();
        }
        return key.hashCode();
    }

    public static String asString(IBinding binding) {
        if (binding instanceof IMethodBinding) {
            return Bindings.asString((IMethodBinding)binding);
        }
        if (binding instanceof ITypeBinding) {
            return ((ITypeBinding)binding).getBinaryName();
        }
        if (binding instanceof IVariableBinding) {
            return Bindings.asString((IVariableBinding)binding);
        }
        return binding.toString();
    }

    private static String asString(IVariableBinding variableBinding) {
        if (!variableBinding.isField()) {
            return variableBinding.toString();
        }
        if (variableBinding.getDeclaringClass() == null) {
            Assert.isTrue((boolean)variableBinding.getName().equals("length"));
            return ARRAY_LENGTH_FIELD_BINDING_STRING;
        }
        StringBuffer result = new StringBuffer();
        result.append(variableBinding.getDeclaringClass().getName());
        result.append(':');
        result.append(variableBinding.getName());
        return result.toString();
    }

    private static String asString(IMethodBinding method) {
        StringBuffer result = new StringBuffer();
        result.append(method.getDeclaringClass().getName());
        result.append(':');
        result.append(method.getName());
        result.append('(');
        ITypeBinding[] parameters = method.getParameterTypes();
        int lastComma = parameters.length - 1;
        int i = 0;
        while (i < parameters.length) {
            ITypeBinding parameter = parameters[i];
            result.append(parameter.getName());
            if (i < lastComma) {
                result.append(", ");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    public static ITypeBinding getTopLevelType(ITypeBinding type) {
        ITypeBinding parent = type.getSuperclass();
        while (parent != null) {
            type = parent;
            parent = type.getSuperclass();
        }
        return type;
    }

    public static boolean isRuntimeException(ITypeBinding thrownException) {
        if (thrownException == null || thrownException.isPrimitive() || thrownException.isArray()) {
            return false;
        }
        return Bindings.findTypeInHierarchy(thrownException, "java.lang.RuntimeException") != null;
    }

    public static IVariableBinding findFieldInType(ITypeBinding type, String fieldName) {
        if (type.isPrimitive()) {
            return null;
        }
        IVariableBinding[] fields = type.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            IVariableBinding field = fields[i];
            if (field.getName().equals(fieldName)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static IVariableBinding findFieldInHierarchy(ITypeBinding type, String fieldName) {
        IVariableBinding field = Bindings.findFieldInType(type, fieldName);
        if (field != null) {
            return field;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (field = Bindings.findFieldInHierarchy(superClass, fieldName)) != null) {
            return field;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            field = Bindings.findFieldInHierarchy(interfaces[i], fieldName);
            if (field != null) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInType(ITypeBinding type, String methodName) {
        if (type.isPrimitive()) {
            return null;
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equalsIgnoreCase(methods[i].getName())) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding type, String methodName) {
        IMethodBinding method = Bindings.findMethodInType(type, methodName);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findMethodInHierarchy(superClass, methodName)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            method = Bindings.findMethodInHierarchy(interfaces[i], methodName);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding[] findAbstractMethodsInHierarchy(ITypeBinding type) {
        ArrayList<IMethodBinding> methodsToOVerride = new ArrayList<IMethodBinding>();
        HashSet<String> overridenMethodsNames = new HashSet<String>();
        Bindings.collectAbstractMethodsInHierarchy(type, methodsToOVerride, overridenMethodsNames);
        return methodsToOVerride.toArray(new IMethodBinding[methodsToOVerride.size()]);
    }

    private static void collectAbstractMethodsInHierarchy(ITypeBinding curr, List<IMethodBinding> methodsToOverride, Set<String> overridenMethodsNames) {
        if (curr != null) {
            IMethodBinding methodBinding;
            if (PHPFlags.isInterface((int)curr.getModifiers())) {
                IMethodBinding[] iMethodBindingArray = curr.getDeclaredMethods();
                int n = iMethodBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    methodBinding = iMethodBindingArray[n2];
                    if (!overridenMethodsNames.contains(methodBinding.getName())) {
                        methodsToOverride.add(methodBinding);
                        overridenMethodsNames.add(methodBinding.getName());
                    }
                    ++n2;
                }
            } else if (PHPFlags.isAbstract((int)curr.getModifiers())) {
                IMethodBinding[] iMethodBindingArray = curr.getDeclaredMethods();
                int n = iMethodBindingArray.length;
                int n3 = 0;
                while (n3 < n) {
                    methodBinding = iMethodBindingArray[n3];
                    if (!PHPFlags.isAbstract((int)methodBinding.getModifiers())) {
                        overridenMethodsNames.add(methodBinding.getName());
                    } else if (!overridenMethodsNames.contains(methodBinding.getName())) {
                        methodsToOverride.add(methodBinding);
                        overridenMethodsNames.add(methodBinding.getName());
                    }
                    ++n3;
                }
            } else {
                IMethodBinding[] iMethodBindingArray = curr.getDeclaredMethods();
                int n = iMethodBindingArray.length;
                int n4 = 0;
                while (n4 < n) {
                    methodBinding = iMethodBindingArray[n4];
                    if (!overridenMethodsNames.contains(methodBinding.getName())) {
                        overridenMethodsNames.add(methodBinding.getName());
                    }
                    ++n4;
                }
            }
            ITypeBinding superClassBinding = curr.getSuperclass();
            if (superClassBinding != null && superClassBinding.getName() != null) {
                Bindings.collectAbstractMethodsInHierarchy(superClassBinding, methodsToOverride, overridenMethodsNames);
            }
        }
    }

    public static IMethodBinding findOverriddenMethodInType(ITypeBinding type, IMethodBinding method) {
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (Bindings.isSubsignature(method, methods[i])) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInHierarchy(ITypeBinding type, IMethodBinding binding) {
        return Bindings.innerFindOverriddenMethodInHierarchy(type, binding, new HashSet<ITypeBinding>());
    }

    public static IMethodBinding innerFindOverriddenMethodInHierarchy(ITypeBinding type, IMethodBinding binding, Set<ITypeBinding> processedTypes) {
        if (!processedTypes.add(type)) {
            return null;
        }
        IMethodBinding method = Bindings.findOverriddenMethodInType(type, binding);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.innerFindOverriddenMethodInHierarchy(superClass, binding, processedTypes)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                method = Bindings.innerFindOverriddenMethodInHierarchy(interfaces[i], binding, processedTypes);
                if (method != null) {
                    return method;
                }
                ++i;
            }
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethod(IMethodBinding overriding, boolean testVisibility) {
        IMethodBinding res;
        int modifiers = overriding.getModifiers();
        if (testVisibility && PHPFlags.isPrivate((int)modifiers)) {
            return null;
        }
        ITypeBinding type = overriding.getDeclaringClass();
        if (type == null) {
            return null;
        }
        if (!(type.getSuperclass() == null || (res = Bindings.findOverriddenMethodInHierarchy(type.getSuperclass(), overriding)) == null || PHPFlags.isPrivate((int)res.getModifiers()) || testVisibility && !Bindings.isVisibleInHierarchy(res))) {
            return res;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            IMethodBinding res2 = Bindings.findOverriddenMethodInHierarchy(interfaces[i], overriding);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }

    public static boolean isVisibleInHierarchy(IMethodBinding member) {
        int otherflags = member.getModifiers();
        ITypeBinding declaringType = member.getDeclaringClass();
        if (PHPFlags.isPublic((int)otherflags) || PHPFlags.isProtected((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (PHPFlags.isPrivate((int)otherflags)) {
            return false;
        }
        return declaringType != null;
    }

    public static ITypeBinding[] getAllSuperTypes(ITypeBinding type) {
        HashSet result = new HashSet();
        Bindings.collectSuperTypes(type, result);
        result.remove(type);
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private static void collectSuperTypes(ITypeBinding curr, Set collection) {
        if (collection.add(curr)) {
            ITypeBinding[] interfaces = curr.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                Bindings.collectSuperTypes(interfaces[i], collection);
                ++i;
            }
            ITypeBinding superClass = curr.getSuperclass();
            if (superClass != null) {
                Bindings.collectSuperTypes(superClass, collection);
            }
        }
    }

    public static boolean isSubsignature(IMethodBinding overriding, IMethodBinding overridden) {
        return overriding.getName().equalsIgnoreCase(overridden.getName());
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding hierarchyType, String fullyQualifiedTypeName) {
        ITypeBinding res;
        if (hierarchyType.isArray() || hierarchyType.isPrimitive()) {
            return null;
        }
        if (fullyQualifiedTypeName.equals(hierarchyType.getBinaryName())) {
            return hierarchyType;
        }
        ITypeBinding superClass = hierarchyType.getSuperclass();
        if (superClass != null && (res = Bindings.findTypeInHierarchy(superClass, fullyQualifiedTypeName)) != null) {
            return res;
        }
        ITypeBinding[] superInterfaces = hierarchyType.getInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            ITypeBinding res2 = Bindings.findTypeInHierarchy(superInterfaces[i], fullyQualifiedTypeName);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }
}

