/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class LambdaFunctionDeclaration
extends Expression {
    private boolean isReference;
    private boolean isStatic;
    private int staticStart;
    private final ASTNode.NodeList<FormalParameter> formalParameters = new ASTNode.NodeList(FORMAL_PARAMETERS_PROPERTY);
    private final ASTNode.NodeList<Expression> lexicalVariables = new ASTNode.NodeList(LEXICAL_VARIABLES_PROPERTY);
    private Block body;
    private Identifier returnType;
    public static final SimplePropertyDescriptor IS_REFERENCE_PROPERTY = new SimplePropertyDescriptor(LambdaFunctionDeclaration.class, "isReference", Boolean.class, false);
    public static final SimplePropertyDescriptor IS_STATIC = new SimplePropertyDescriptor(LambdaFunctionDeclaration.class, "isStatic", Boolean.class, false);
    public static final ChildListPropertyDescriptor FORMAL_PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(LambdaFunctionDeclaration.class, "formalParameters", FormalParameter.class, false);
    public static final ChildListPropertyDescriptor LEXICAL_VARIABLES_PROPERTY = new ChildListPropertyDescriptor(LambdaFunctionDeclaration.class, "lexicalVariables", Expression.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(LambdaFunctionDeclaration.class, "body", Block.class, false, true);
    public static final ChildPropertyDescriptor RETURN_TYPE_PROPERTY = new ChildPropertyDescriptor(LambdaFunctionDeclaration.class, "returnType", Identifier.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(4);
        propertyList.add(IS_REFERENCE_PROPERTY);
        propertyList.add(IS_STATIC);
        propertyList.add(FORMAL_PARAMETERS_PROPERTY);
        propertyList.add(LEXICAL_VARIABLES_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        propertyList.add(RETURN_TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public LambdaFunctionDeclaration(int start, int end, AST ast, List formalParameters, List lexicalVars, Block body, boolean isReference) {
        this(start, end, ast, formalParameters, lexicalVars, body, isReference, false, -1);
    }

    public LambdaFunctionDeclaration(int start, int end, AST ast, List formalParameters, List lexicalVars, Block body, boolean isReference, boolean isStatic, int staticStart) {
        this(start, end, ast, formalParameters, lexicalVars, body, isReference, isStatic, staticStart, null);
    }

    public LambdaFunctionDeclaration(int start, int end, AST ast, List formalParameters, List lexicalVars, Block body, boolean isReference, boolean isStatic, int staticStart, Identifier returnType) {
        super(start, end, ast);
        if (formalParameters == null) {
            throw new IllegalArgumentException();
        }
        this.setIsReference(isReference);
        Iterator paramIt = formalParameters.iterator();
        while (paramIt.hasNext()) {
            this.formalParameters.add((FormalParameter)paramIt.next());
        }
        if (lexicalVars != null) {
            Iterator varsIt = lexicalVars.iterator();
            while (varsIt.hasNext()) {
                this.lexicalVariables.add((Expression)varsIt.next());
            }
        }
        if (body != null) {
            this.setBody(body);
        }
        this.setStatic(isStatic);
        this.staticStart = staticStart;
        this.returnType = returnType;
    }

    public LambdaFunctionDeclaration(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.formalParameters) {
            aSTNode.accept(visitor);
        }
        for (ASTNode aSTNode : this.lexicalVariables) {
            aSTNode.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.formalParameters) {
            aSTNode.traverseTopDown(visitor);
        }
        for (ASTNode aSTNode : this.lexicalVariables) {
            aSTNode.accept(visitor);
        }
        if (this.body != null) {
            this.body.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.formalParameters) {
            aSTNode.traverseBottomUp(visitor);
        }
        for (ASTNode aSTNode : this.lexicalVariables) {
            aSTNode.accept(visitor);
        }
        if (this.body != null) {
            this.body.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<LambdaFunctionDeclaration");
        this.appendInterval(buffer);
        buffer.append(" isReference='").append(this.isReference);
        if (this.isStatic) {
            buffer.append(" isStatic='").append(this.isStatic);
        }
        buffer.append("'>\n");
        buffer.append("\t").append(tab).append("<FormalParameters>\n");
        for (ASTNode aSTNode : this.formalParameters) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</FormalParameters>\n");
        buffer.append("\t").append(tab).append("<LexicalVariables>\n");
        for (ASTNode aSTNode : this.lexicalVariables) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</LexicalVariables>\n");
        if (this.getReturnType() != null) {
            buffer.append("\t").append(tab).append("<ReturnType>\n");
            this.getReturnType().toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            buffer.append("\t").append(tab).append("</ReturnType>\n");
        }
        buffer.append("\t").append(tab).append("<FunctionBody>\n");
        if (this.body != null) {
            this.body.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</FunctionBody>\n");
        buffer.append(tab).append("</LambdaFunctionDeclaration>");
    }

    @Override
    public int getType() {
        return 70;
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Block oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public List<FormalParameter> formalParameters() {
        return this.formalParameters;
    }

    public List<Expression> lexicalVariables() {
        return this.lexicalVariables;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public final void setIsReference(boolean value) {
        this.preValueChange(IS_REFERENCE_PROPERTY);
        this.isReference = value;
        this.postValueChange(IS_REFERENCE_PROPERTY);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.preValueChange(IS_STATIC);
        this.isStatic = isStatic;
        this.postValueChange(IS_STATIC);
    }

    public Identifier getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Identifier returnType) {
        Identifier oldChild = this.returnType;
        this.preReplaceChild(oldChild, returnType, RETURN_TYPE_PROPERTY);
        this.returnType = returnType;
        this.postReplaceChild(oldChild, returnType, RETURN_TYPE_PROPERTY);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == IS_REFERENCE_PROPERTY) {
            if (get) {
                return this.isReference();
            }
            this.setIsReference(value);
            return false;
        }
        if (property == IS_STATIC) {
            if (get) {
                return this.isStatic();
            }
            this.setStatic(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        if (property == RETURN_TYPE_PROPERTY) {
            if (get) {
                return this.getReturnType();
            }
            this.setReturnType((Identifier)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == FORMAL_PARAMETERS_PROPERTY) {
            return this.formalParameters();
        }
        if (property == LEXICAL_VARIABLES_PROPERTY) {
            return this.lexicalVariables();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Block body = ASTNode.copySubtree(target, this.getBody());
        List formalParams = ASTNode.copySubtrees(target, this.formalParameters());
        List lexicalVars = ASTNode.copySubtrees(target, this.lexicalVariables());
        boolean isRef = this.isReference();
        Identifier returnType = ASTNode.copySubtree(target, this.getReturnType());
        LambdaFunctionDeclaration result = new LambdaFunctionDeclaration(this.getStart(), this.getEnd(), target, formalParams, lexicalVars, body, isRef, this.isStatic(), this.staticStart, returnType);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

