/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;

public class PHPDocTagStrategy
extends AbstractCompletionStrategy {
    public PHPDocTagStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public PHPDocTagStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof PHPDocTagContext)) {
            return;
        }
        PHPDocTagContext tagContext = (PHPDocTagContext)context;
        String tagName = tagContext.getTagName();
        CompletionRequestor requestor = tagContext.getCompletionRequestor();
        ISourceRange replaceRange = this.getReplacementRange(tagContext);
        String suffix = "";
        PHPDocTag.TagKind[] tagKindArray = PHPDocTag.TagKind.values();
        int n = tagKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag.TagKind nextTag = tagKindArray[n2];
            String nextTagName = nextTag.getName();
            if (CodeAssistUtils.startsWithIgnoreCase(nextTagName, tagName) && (!requestor.isContextInformationMode() || nextTagName.length() == tagName.length())) {
                reporter.reportKeyword(nextTagName, suffix, replaceRange);
            }
            ++n2;
        }
    }
}

