/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ConditionalExpression
extends Expression {
    public static final int OP_TERNARY = 0;
    public static final int OP_COALESCE = 1;
    private final Expression condition;
    private final Expression ifTrue;
    private final Expression ifFalse;
    private final int operatorType;

    public ConditionalExpression(int start, int end, Expression condition, Expression ifTrue, Expression ifFalse) {
        super(start, end);
        assert (condition != null && ifFalse != null);
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.operatorType = 0;
    }

    public ConditionalExpression(int start, int end, Expression condition, Expression ifNull) {
        super(start, end);
        assert (condition != null && ifNull != null);
        this.condition = condition;
        this.ifTrue = ifNull;
        this.ifFalse = null;
        this.operatorType = 1;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            this.condition.traverse(visitor);
            if (this.ifTrue != null) {
                this.ifTrue.traverse(visitor);
            }
            if (this.ifFalse != null) {
                this.ifFalse.traverse(visitor);
            }
        }
        visitor.endvisit((Expression)this);
    }

    public int getKind() {
        return 17;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getIfFalse() {
        if (this.getOperatorType() == 1) {
            return this.condition;
        }
        return this.ifFalse;
    }

    public Expression getIfTrue() {
        return this.ifTrue;
    }

    public int getOperatorType() {
        return this.operatorType;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

