/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.preferences;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.osgi.service.prefs.BackingStoreException;

public class XMLPreferencesWriter {
    public static final char DELIMITER = '\u0005';

    public static String getEscaped(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            XMLPreferencesWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    protected static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = XMLPreferencesWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    protected static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    protected static void write(StringBuffer sb, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            sb.append("<");
            sb.append(key);
            sb.append(">");
            Object object = entry.getValue();
            if (object instanceof Map) {
                XMLPreferencesWriter.write(sb, (Map)object);
            } else if (object != null) {
                sb.append(XMLPreferencesWriter.getEscaped(object.toString()));
            } else {
                sb.append("");
            }
            sb.append("</");
            sb.append(key);
            sb.append(">");
        }
    }

    public static void write(IEclipsePreferences pluginPreferences, String prefsKey, List<IXMLPreferencesStorable> objects) {
        StringBuffer sb = new StringBuffer();
        XMLPreferencesWriter.appendDelimitedString(sb, objects.toArray(new IXMLPreferencesStorable[objects.size()]));
        pluginPreferences.put(prefsKey, sb.toString());
        try {
            pluginPreferences.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException("Could not write XML preferences.", e);
        }
    }

    public static void write(IEclipsePreferences pluginPreferences, String prefsKey, IXMLPreferencesStorable object) {
        StringBuffer sb = new StringBuffer();
        XMLPreferencesWriter.write(sb, object.storeToMap());
        pluginPreferences.put(prefsKey, sb.toString());
        try {
            pluginPreferences.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException("Could not write XML preferences.", e);
        }
    }

    protected static void appendDelimitedString(StringBuffer buffer, IXMLPreferencesStorable[] elements) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                XMLPreferencesWriter.write(buffer, elements[i].storeToMap());
                if (i < elements.length - 1) {
                    buffer.append('\u0005');
                }
                ++i;
            }
        }
    }

    public static String storableElementsToString(IXMLPreferencesStorable[] elements) {
        StringBuffer sb = new StringBuffer();
        XMLPreferencesWriter.appendDelimitedString(sb, elements);
        return sb.toString();
    }
}

