/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class PHPLaunchDelegateProxy
implements ILaunchConfigurationDelegate2 {
    protected ILaunchConfigurationDelegate2 launchConfigurationDelegate;

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getConfigurationDelegate(configuration).finalLaunchCheck(configuration, mode, monitor);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType exeType = lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");
        if (configuration.getType().equals(exeType)) {
            configuration = this.updatePHPExeAttributes(configuration, mode);
        }
        ILaunchConfigurationType serverType = lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.webPageLaunch");
        if (configuration.getType().equals(serverType)) {
            configuration = this.updatePHPServerAttributes(configuration, mode);
        }
        return this.getConfigurationDelegate(configuration).getLaunch(configuration, mode);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getConfigurationDelegate(configuration).preLaunchCheck(configuration, mode, monitor);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.getConfigurationDelegate(configuration).launch(configuration, mode, launch, monitor);
        }
        finally {
            this.launchConfigurationDelegate = null;
        }
    }

    protected ILaunchConfigurationDelegate2 getConfigurationDelegate(ILaunchConfiguration configuration) throws CoreException {
        String className = configuration.getAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, "");
        if (className.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.launchConfigurationDelegate == null || !this.launchConfigurationDelegate.getClass().getCanonicalName().equals(className)) {
            try {
                this.launchConfigurationDelegate = (ILaunchConfigurationDelegate2)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.core", 0, "Launch configuration delegate loading error.", t));
            }
        }
        return this.launchConfigurationDelegate;
    }

    private ILaunchConfiguration updatePHPExeAttributes(ILaunchConfiguration configuration, String mode) throws CoreException {
        PHPexeItem item = PHPLaunchUtilities.getPHPExe(configuration);
        if (item != null) {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute("ATTR_LOCATION", item.getExecutable().toString());
            String debuggerId = item.getDebuggerID();
            wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerId);
            AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerId);
            wc.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getScriptLaunchDelegateClass());
            if ((mode.equals("debug") || mode.equals("profile")) && debuggerConfiguration.getDebuggerId().equals("org.eclipse.php.debug.core.noneDebugger")) {
                wc.setAttribute("org.eclipse.debug.ui.private", true);
            }
            if (item.getINILocation() != null) {
                wc.setAttribute("ATTR_INI_LOCATION", item.getINILocation().toString());
            } else {
                wc.setAttribute("ATTR_INI_LOCATION", null);
            }
            configuration = wc.doSave();
        }
        return configuration;
    }

    private ILaunchConfiguration updatePHPServerAttributes(ILaunchConfiguration configuration, String mode) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        Server server = ServersManager.getServer((String)configuration.getAttribute("name", ""));
        if (server != null) {
            String debuggerId = server.getDebuggerId();
            wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerId);
            AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerId);
            wc.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getWebLaunchDelegateClass());
            if ((mode.equals("debug") || mode.equals("profile")) && debuggerConfiguration.getDebuggerId().equals("org.eclipse.php.debug.core.noneDebugger")) {
                wc.setAttribute("org.eclipse.debug.ui.private", true);
            }
            configuration = wc.doSave();
        }
        return configuration;
    }
}

