/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.model.VirtualPartition;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class PHPValue
extends PHPDebugElement
implements IValue,
IPHPDataType {
    private static final int ARRAY_PARTITION_BOUNDARY = 100;
    protected Expression fExpression;
    protected ExpressionValue fExpressionValue;
    protected IVariable[] fCurrentVariables = null;
    protected IVariable[] fPreviousVariables = null;
    protected IVariable[] fPartitions = new IVariable[0];

    public PHPValue(PHPDebugTarget target, Expression expression) {
        super(target);
        this.fExpressionValue = expression.getValue();
        this.fExpression = expression;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public boolean hasVariables() throws DebugException {
        switch (this.fExpressionValue.getDataType()) {
            case PHP_ARRAY: 
            case PHP_OBJECT: 
            case PHP_VIRTUAL_CLASS: {
                return this.fExpressionValue.getChildrenCount() > 0;
            }
        }
        return false;
    }

    @Override
    public IPHPDataType.DataType getDataType() {
        return this.fExpressionValue.getDataType();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getDataType().getText().toUpperCase();
    }

    public String getValueString() throws DebugException {
        return this.fExpressionValue.getValueAsString();
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.fCurrentVariables == null) {
            this.requestVariables();
            if (this.fCurrentVariables == null) {
                this.fCurrentVariables = new IVariable[0];
            }
            if (this.fExpressionValue.getDataType() == IPHPDataType.DataType.PHP_ARRAY && this.fCurrentVariables.length >= 100) {
                this.createPartitions();
            }
        }
        if (!this.hasPartitions()) {
            return this.fCurrentVariables;
        }
        return this.fPartitions;
    }

    public String getValue() throws DebugException {
        return String.valueOf(this.fExpressionValue.getValue());
    }

    public void updateValue(ExpressionValue value) {
        this.fExpressionValue = value;
        this.createVariables(this.fExpressionValue);
    }

    protected Expression getExpression() {
        return this.fExpression;
    }

    protected boolean hasPartitions() {
        return this.fPartitions.length > 0;
    }

    protected void update(Expression expression) {
        this.fPreviousVariables = this.fCurrentVariables;
        this.fCurrentVariables = null;
        this.fExpression = expression;
        this.fExpressionValue = this.fExpression.getValue();
    }

    protected IVariable merge(IVariable variable) {
        if (this.fPreviousVariables == null) {
            return variable;
        }
        if (!(variable instanceof PHPVariable)) {
            return variable;
        }
        PHPVariable incoming = (PHPVariable)variable;
        if (incoming.getFullName().isEmpty()) {
            return incoming;
        }
        IVariable[] iVariableArray = this.fPreviousVariables;
        int n = this.fPreviousVariables.length;
        int n2 = 0;
        while (n2 < n) {
            PHPVariable previous;
            IVariable stored = iVariableArray[n2];
            if (stored instanceof PHPVariable && (previous = (PHPVariable)stored).getFullName().equals(incoming.getFullName())) {
                ((PHPVariable)stored).update(incoming.getExpression());
                return stored;
            }
            ++n2;
        }
        return variable;
    }

    private void requestVariables() {
        PHPDebugTarget debugTarget = (PHPDebugTarget)this.getDebugTarget();
        DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
        Expression variable = this.fExpression;
        expressionManager.update(variable, 1);
        this.fExpressionValue = variable.getValue();
        this.createVariables(this.fExpressionValue);
    }

    private void createVariables(ExpressionValue value) {
        Expression[] children = value.getChildren();
        if (children != null) {
            this.fCurrentVariables = new PHPVariable[children.length];
            int i = 0;
            while (i < children.length) {
                PHPVariable incoming = new PHPVariable((PHPDebugTarget)this.getDebugTarget(), children[i]);
                this.fCurrentVariables[i] = this.merge(incoming);
                ++i;
            }
        }
    }

    private void createPartitions() {
        int numChild = this.fCurrentVariables.length;
        int partitions = (int)Math.ceil((double)numChild / 100.0);
        this.fPartitions = new IVariable[partitions];
        int i = 0;
        while (i < partitions) {
            int startIndex = i * 100;
            int endIndex = (i + 1) * 100 - 1;
            if (endIndex > numChild) {
                endIndex = numChild - 1;
            }
            final IVariable[] vars = Arrays.copyOfRange(this.fCurrentVariables, startIndex, endIndex + 1);
            VirtualPartition var = new VirtualPartition((IDebugElement)this, new VirtualPartition.IVariableProvider(){

                @Override
                public IVariable[] getVariables() throws DebugException {
                    return vars;
                }
            }, startIndex, endIndex);
            this.fPartitions[i] = var;
            ++i;
        }
    }
}

