/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.corext;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.ui.RefactoringUIPlugin;
import org.eclipse.php.ui.editor.SharedASTProvider;

public class RefactoringASTParser {
    private ASTParser fParser;

    public RefactoringASTParser(PHPVersion phpVersion, boolean useShortTags) {
        this.fParser = ASTParser.newParser((PHPVersion)phpVersion, (boolean)useShortTags);
    }

    public Program parse(ISourceModule typeRoot, boolean resolveBindings) throws Exception {
        return this.parse(typeRoot, resolveBindings, null);
    }

    public Program parse(ISourceModule typeRoot, boolean resolveBindings, IProgressMonitor pm) throws Exception {
        return this.parse(typeRoot, null, resolveBindings, pm);
    }

    public Program parse(ISourceModule typeRoot, WorkingCopyOwner owner, boolean resolveBindings, IProgressMonitor pm) throws Exception {
        return this.parse(typeRoot, owner, resolveBindings, false, false, pm);
    }

    public Program parse(ISourceModule typeRoot, WorkingCopyOwner owner, boolean resolveBindings, boolean statementsRecovery, boolean bindingsRecovery, IProgressMonitor pm) throws Exception {
        this.fParser.setSource(typeRoot.getSourceAsCharArray());
        Program result = this.fParser.createAST(pm);
        return result;
    }

    public Program parse(String newCuSource, ISourceModule originalCu, boolean resolveBindings, boolean statementsRecovery, IProgressMonitor pm) throws Exception {
        this.fParser.setSource(newCuSource.toCharArray());
        Program newCUNode = this.fParser.createAST(pm);
        return newCUNode;
    }

    public static Program parseWithASTProvider(ISourceModule typeRoot, boolean resolveBindings, IProgressMonitor pm) throws Exception {
        Program cuNode = null;
        try {
            cuNode = SharedASTProvider.getAST((ISourceModule)typeRoot, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)pm);
        }
        catch (ModelException e) {
            RefactoringUIPlugin.log((Exception)((Object)e));
        }
        catch (IOException e) {
            RefactoringUIPlugin.log(e);
        }
        if (cuNode != null) {
            return cuNode;
        }
        return new RefactoringASTParser(PHPVersion.getLatestVersion(), true).parse(typeRoot, null, resolveBindings, true, true, pm);
    }

    public static ISourceModule getCompilationUnit(ASTNode node) {
        ASTNode root = node.getRoot();
        if (root instanceof Program) {
            return ((Program)root).getSourceModule();
        }
        return null;
    }

    public static Map getCompilerOptions(IModelElement element) {
        IScriptProject project = element.getScriptProject();
        Map options = project.getOptions(true);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (!"error".equals(value) && !"warning".equals(value)) continue;
            options.put(key, "ignore");
        }
        return options;
    }
}

